/* Video Toolkit For OS/2 Installation Script.            */
/* Copyright (c) Abbotsbury Software Ltd. (UK), 1995-2000 */
echo off
parse arg drivedir


if drivedir = ''
then do
     say 'You must enter a drive letter and directory name.'
     say 'This directory will be the root directory for the toolkit.'
     say 'For example :-'
     say '    install C:\VIDTLKT'
     say ''
     Exit 0
end

say 'This is the 24th May 2000 release of the Video Capture Adapter SDK'
say 'If you have any comments or feedback please contact us on :'
say 'os2tv-support@os2tv.com'
say 'This latest release supports the 32 bit version APIs'
say 'Good Luck - tim@wdi.co.uk'


/* Load the REXX utility */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

rc = RXFUNCADD('mciRxInit','MCIAPI','mciRxInit')
InitRC = mciRxInit()

                                /* query number of celebrities, prisms, etc */
m = 2
celebs  = 0
prisms  = 0
highqs  = 0
encores = 0
wcasts  = 0
stubs   = 0
DO FOREVER
        cmd = 'info digitalvideo0'm 'product wait'
        rc = SendString(cmd, ret_str)

        if rc <> 0 then leave
        if ret_str = "Hauppauge Celebrity" then celebs = celebs + 1
        if ret_str = "Hauppauge Prism" then prisms = prisms + 1
        if ret_str = "Hauppauge HighQ" then highqs = highqs + 1
        if ret_str = "Hauppauge Encore" then encores = encores + 1
        if ret_str = "Hauppauge WinCast TV" then wcasts = wcasts + 1
        say "Driver found for - " ret_str
        m = m + 1
END
num_tvs = celebs + prisms + highqs + stubs + encores + wcasts

say "There are" celebs "Celebs Installed"
say "There are" prisms "Prisms Installed"
say "There are" highqs "Highqs Installed"
say "There are" encores "Encores Installed"
say "There are" wcasts "WinCasts Installed"

if num_tvs = 0
then do
    say ""
    say "Could not find any installed Video Capture Drivers"
    say "Install a Video Capture Driver before this toolkit"
    exit 0
end

fspec = SysSearchPath( 'MMBASE', 'MMPM2.INI')
if fspec = ''
then do
     say 'MMBASE Environment variable not found.'
     say 'Install Multimedia before installing the Video Toolkit For OS/2.'
     Exit 0
end

len = LENGTH(fspec)
l = len - 10
mmbase = SUBSTR(fspec, 1, l)

/* Make sure the proper directories have been created and copy   */
/* the required files to those directories.                      */
Call SysMkDir drivedir
Call SysMkDir drivedir'\BIN'
COPY 'BIN\*.*' drivedir'\BIN'
Call SysMkDir drivedir'\BOOK'
COPY 'BOOK\*.*' drivedir'\BOOK'
Call SysMkDir drivedir'\DLL'
COPY 'DLL\*.*' mmbase'\DLL'
COPY 'DLL\*.*' drivedir'\DLL'
Call SysMkDir drivedir'\HELP'
COPY 'HELP\*.*' mmbase'\HELP'
COPY 'HELP\*.*' drivedir'\HELP'
Call SysMkDir drivedir'\H'
COPY 'H\*.*' drivedir'\H'
Call SysMkDir drivedir'\LIB'
COPY 'LIB\*.*' drivedir'\LIB'
Call SysMkDir drivedir'\SAMPLES'
Call SysMkDir drivedir'\SAMPLES\DIAG'
Call SysMkDir drivedir'\SAMPLES\EX1'
Call SysMkDir drivedir'\SAMPLES\EX2'
Call SysMkDir drivedir'\SAMPLES\EX3'
Call SysMkDir drivedir'\SAMPLES\EX4'
Call SysMkDir drivedir'\SAMPLES\CAM'
COPY 'SAMPLES\DIAG\*.*' drivedir'\SAMPLES\DIAG'
COPY 'SAMPLES\EX1\*.*' drivedir'\SAMPLES\EX1'
COPY 'SAMPLES\EX2\*.*' drivedir'\SAMPLES\EX2'
COPY 'SAMPLES\EX3\*.*' drivedir'\SAMPLES\EX3'
COPY 'SAMPLES\EX4\*.*' drivedir'\SAMPLES\EX4'
COPY 'SAMPLES\CAM\*.*' drivedir'\SAMPLES\CAM'
if wcasts > 0 then do
    Call SysMkDir drivedir'\SAMPLES\DIVE'
    COPY 'SAMPLES\DIVE\*.*' drivedir'\SAMPLES\DIVE'
end
COPY '*.*' drivedir

if SysCreateObject( 'WPFolder', 'Video Toolkit For OS/2', '<WP_DESKTOP>',,
                    'OBJECTID=<ABBVIDFolder>;ICONFILE='drivedir'\BIN\WKLOGO.ICO')
then do
     say 'Video Toolkit For OS/2 Folder created sucessfully.'
end
else do
     say 'Error creating Video Toolkit For OS/2 Folder.'
/*     Exit 0 */
end

if SysCreateObject( 'WPFolder', 'Information', '<ABBVIDFolder>',,
                    'OBJECTID=<ABBINFFolder>;ICONFILE='drivedir'\BIN\ICONINFO.ICO')
then do
     say 'Information Folder created sucessfully.'
     if SysCreateObject( 'WPProgram', 'Video Toolkit For OS/2 Technical Reference', '<ABBINFFolder>',,
 'EXENAME=VIEW.EXE;PARAMETERS=VIDTLKT;STARTUPDIR='drivedir'\BOOK;OBJECTID=<ABBVIEWVIDTLKT>')
     then do
          say 'View created successfully'
     end
     else do
          say 'Error creating View'
          Exit 0
     end
end
else do
     say 'Error creating Information Folder.'
     Exit 0
end

if SysCreateObject( 'WPFolder', 'Samples', '<ABBVIDFolder>',,
                    'OBJECTID=<ABBSAMPFolder>')
then do
    say 'Samples Folder created sucessfully.'
    Instance = 1
    Video='CELEB'
    if celebs > 0 then
    do
    do until Instance = celebs + 1

        rc = InstallEx('DIAG')
        rc = InstallEx('EX1')
        rc = InstallEx('EX2')
        rc = InstallEx('EX3')
        rc = InstallEx('EX4')
        Instance = Instance + 1
    end
    end
    Instance = 1
    Video='PRISM'
    if prisms > 0 then
    do
    do until Instance = prisms + 1

        rc = InstallEx('DIAG')
        rc = InstallEx('EX1')
        rc = InstallEx('EX2')
        rc = InstallEx('EX3')
        rc = InstallEx('EX4')
        Instance = Instance + 1
    end
    end
    Instance = 1
    Video='HIGHQ'
    if highqs > 0 then
    do
    do until Instance = highqs + 1

        rc = InstallEx('DIAG')
        rc = InstallEx('EX1')
        rc = InstallEx('EX2')
        rc = InstallEx('EX3')
        rc = InstallEx('EX4')
        Instance = Instance + 1
    end
    end
    Instance = 1
    Video='WCAST'
    if wcasts > 0 then
    do
    do until Instance = wcasts + 1

        rc = InstallEx('DIAG')
        rc = InstallEx('EX1')
        rc = InstallEx('EX2')
        rc = InstallEx('EX3')
        rc = InstallEx('EX4')
        rc = InstallEx('DIVE')
        Instance = Instance + 1
    end
    end
    if SysCreateObject( 'WPProgram', 'Samples Directory', '<ABBSAMPFolder>',,
            'EXENAME=*;STARTUPDIR='drivedir'\SAMPLES;PROGTYPE=FULLSCREEN;OBJECTID=<ABBOS2>')
    then do
         say 'Samples Directory created successfully'
    end
    else do
         say 'Error creating Samples Directory'
         Exit 0
    end
end
else do
        say 'Error creating Samples Folder.'
end

if SysCreateObject( 'WPFolder', 'Utilities', '<ABBVIDFolder>',,
                    'OBJECTID=<ABBUTILFolder>')
then do
    say 'Utilities Folder created sucessfully.'
    n = 1
    if celebs > 0 then
    do
    do until n = celebs + 1
        if SysCreateObject( 'WPProgram', 'PMTV/2 Celeb 'n, '<ABBUTILFolder>',,
'EXENAME='drivedir'\BIN\PMTV2.EXE;PARAMETERS=CELEB 'n';OBJECTID=<ABBPMTV2CEL'n'>')
        then do
             say 'PMTV/2 Celeb 'n' created successfully'
             file1 = drivedir'\BIN\PMTV2.EXE'
             file2 = drivedir'\BIN\PMTV2.ICO'
             rc = SysSetIcon( file1, file2)
        end
        else do
             say 'Error creating PMTV/2 Celeb 'n
             Exit 0
        end
        if SysCreateObject( 'WPProgram', 'Celeb 'n' Config', '<ABBUTILFolder>',,
'EXENAME='drivedir'\BIN\TV2CFG.EXE;PARAMETERS=CELEB 'n';OBJECTID=<ABBCONFIGCEL'n'>')
        then do
             say 'TV2CFG Celeb 'n' created successfully'
             file1 = drivedir'\BIN\TV2CFG.EXE'
             file2 = drivedir'\BIN\TV2CFG.ICO'
             rc = SysSetIcon( file1, file2)
        end
        else do
             say 'Error creating TV2CFG Celeb 'n
             Exit 0
        end
        if SysCreateObject( 'WPProgram', 'Rocket Remote Celeb 'n, '<ABBUTILFolder>',,
'EXENAME='drivedir'\BIN\RCON.EXE;PARAMETERS=CELEB 'n';MINWIN=DESKTOP;OBJECTID=<ABBROCKETCEL'n'>')
        then do
             say 'RCON Celeb 'n' created successfully'
             file1 = drivedir'\BIN\RCON.EXE'
             file2 = drivedir'\BIN\RCON.ICO'
             rc = SysSetIcon( file1, file2)
        end
        else do
             say 'Error creating RCON Celeb 'n
             Exit 0
        end
        if SysCreateObject( 'WPProgram', 'Diagnostics Celeb 'n, '<ABBUTILFolder>',,
'EXENAME='drivedir'\BIN\PMDIAG.EXE;PARAMETERS=CELEB 'n';OBJECTID=<ABBDIAGCEL'n'>')
        then do
             say 'PMDIAG Celeb 'n' created successfully'
             file1 = drivedir'\BIN\PMDIAG.EXE'
             file2 = drivedir'\BIN\PMDIAG.ICO'
             rc = SysSetIcon( file1, file2)
        end
        else do
             say 'Error creating PMDIAG Celeb 'n
             Exit 0
        end
        n = n + 1
    end
    end
    n = 1
    if prisms > 0 then
    do
    do until n = prisms + 1
        if SysCreateObject( 'WPProgram', 'PMTV/2 Prism 'n, '<ABBUTILFolder>',,
'EXENAME='drivedir'\BIN\PMTV2.EXE;PARAMETERS=PRISM 'n';OBJECTID=<ABBPMTV2PRM'n'>')
        then do
             say 'PMTV/2 Prism 'n' created successfully'
             file1 = drivedir'\BIN\PMTV2.EXE'
             file2 = drivedir'\BIN\PMTV2.ICO'
             rc = SysSetIcon( file1, file2)
        end
        else do
             say 'Error creating PMTV/2 Prism 'n
             Exit 0
        end
        if SysCreateObject( 'WPProgram', 'Prism 'n' Config', '<ABBUTILFolder>',,
'EXENAME='drivedir'\BIN\TV2CFG.EXE;PARAMETERS=PRISM 'n';OBJECTID=<ABBCONFIGPRM'n'>')
        then do
             say 'TV2CFG Prism 'n' created successfully'
             file1 = drivedir'\BIN\TV2CFG.EXE'
             file2 = drivedir'\BIN\TV2CFG.ICO'
             rc = SysSetIcon( file1, file2)
        end
        else do
             say 'Error creating TV2CFG Prism 'n
             Exit 0
        end
        if SysCreateObject( 'WPProgram', 'Rocket Remote Prism 'n, '<ABBUTILFolder>',,
'EXENAME='drivedir'\BIN\RCON.EXE;PARAMETERS=PRISM 'n';MINWIN=DESKTOP;OBJECTID=<ABBROCKETPRM'n'>')
        then do
             say 'RCON Prism 'n' created successfully'
             file1 = drivedir'\BIN\RCON.EXE'
             file2 = drivedir'\BIN\RCON.ICO'
             rc = SysSetIcon( file1, file2)
        end
        else do
             say 'Error creating RCON Prism 'n
             Exit 0
        end
        if SysCreateObject( 'WPProgram', 'Diagnostics Prism 'n, '<ABBUTILFolder>',,
'EXENAME='drivedir'\BIN\PMDIAG.EXE;PARAMETERS=PRISM 'n';OBJECTID=<ABBDIAGPRM'n'>')
        then do
             say 'PMDIAG Prism 'n' created successfully'
             file1 = drivedir'\BIN\PMDIAG.EXE'
             file2 = drivedir'\BIN\PMDIAG.ICO'
             rc = SysSetIcon( file1, file2)
        end
        else do
             say 'Error creating PMDIAG Prism 'n
             Exit 0
        end
        n = n + 1
    end
    end
    n = 1
    if highqs > 0 then
    do
    do until n = highqs + 1
        if SysCreateObject( 'WPProgram', 'PMTV/2 HighQ 'n, '<ABBUTILFolder>',,
'EXENAME='drivedir'\BIN\PMTV2.EXE;PARAMETERS=HIGHQ 'n';OBJECTID=<ABBPMTV2HQ'n'>')
        then do
             say 'PMTV/2 HighQ 'n' created successfully'
             file1 = drivedir'\BIN\PMTV2.EXE'
             file2 = drivedir'\BIN\PMTV2.ICO'
             rc = SysSetIcon( file1, file2)
        end
        else do
             say 'Error creating PMTV/2 HighQ 'n
             Exit 0
        end
        if SysCreateObject( 'WPProgram', 'HighQ 'n' Config', '<ABBUTILFolder>',,
'EXENAME='drivedir'\BIN\TV2CFG.EXE;PARAMETERS=HIGHQ 'n';OBJECTID=<ABBCONFIGHQ'n'>')
        then do
             say 'TV2CFG HighQ 'n' created successfully'
             file1 = drivedir'\BIN\TV2CFG.EXE'
             file2 = drivedir'\BIN\TV2CFG.ICO'
             rc = SysSetIcon( file1, file2)
        end
        else do
             say 'Error creating TV2CFG HighQ 'n
             Exit 0
        end
        if SysCreateObject( 'WPProgram', 'Rocket Remote HighQ 'n, '<ABBUTILFolder>',,
'EXENAME='drivedir'\BIN\RCON.EXE;PARAMETERS=HIGHQ 'n';MINWIN=DESKTOP;OBJECTID=<ABBROCKETHQ'n'>')
        then do
             say 'RCON HighQ 'n' created successfully'
             file1 = drivedir'\BIN\RCON.EXE'
             file2 = drivedir'\BIN\RCON.ICO'
             rc = SysSetIcon( file1, file2)
        end
        else do
             say 'Error creating RCON HighQ 'n
             Exit 0
        end
        if SysCreateObject( 'WPProgram', 'Diagnostics HighQ 'n, '<ABBUTILFolder>',,
'EXENAME='drivedir'\BIN\PMDIAG.EXE;PARAMETERS=HIGHQ 'n';OBJECTID=<ABBDIAGHQ'n'>')
        then do
             say 'PMDIAG HighQ 'n' created successfully'
             file1 = drivedir'\BIN\PMDIAG.EXE'
             file2 = drivedir'\BIN\PMDIAG.ICO'
             rc = SysSetIcon( file1, file2)
        end
        else do
             say 'Error creating PMDIAG HighQ 'n
             Exit 0
        end
        n = n + 1
    end
    end
    n = 1
    if encores > 0 then
    do
    do until n = encores + 1
        if SysCreateObject( 'WPProgram', 'PMTV/2 Encore 'n, '<ABBUTILFolder>',,
'EXENAME='drivedir'\BIN\PMTV2.EXE;PARAMETERS=ENCOR 'n';OBJECTID=<ABBPMTV2ENC'n'>') then do
             say 'PMTV/2 Encore 'n' created successfully'
             file1 = drivedir'\BIN\PMTV2.EXE'
             file2 = drivedir'\BIN\PMTV2.ICO'
             rc = SysSetIcon( file1, file2)
        end
        else do
             say 'Error creating PMTV/2 Encore 'n
             Exit 0
        end
        if SysCreateObject( 'WPProgram', 'Encore 'n' Config', '<ABBUTILFolder>',,
'EXENAME='drivedir'\BIN\TV2CFG.EXE;PARAMETERS=ENCOR 'n';OBJECTID=<ABBCONFIGENC'n'>')
        then do
             say 'TV2CFG Encore 'n' created successfully'
             file1 = drivedir'\BIN\TV2CFG.EXE'
             file2 = drivedir'\BIN\TV2CFG.ICO'
             rc = SysSetIcon( file1, file2)
        end
        else do
             say 'Error creating TV2CFG Encore 'n
             Exit 0
        end
        if SysCreateObject( 'WPProgram', 'Rocket Remote Encore 'n, '<ABBUTILFolder>',,
'EXENAME='drivedir'\BIN\RCON.EXE;PARAMETERS=ENCOR 'n';MINWIN=DESKTOP;OBJECTID=<ABBROCKETHQ'n'>')
        then do
             say 'RCON Encore 'n' created successfully'
             file1 = drivedir'\BIN\RCON.EXE'
             file2 = drivedir'\BIN\RCON.ICO'
             rc = SysSetIcon( file1, file2)
        end
        else do
             say 'Error creating RCON Encore 'n
             Exit 0
        end
        if SysCreateObject( 'WPProgram', 'Diagnostics Encore 'n, '<ABBUTILFolder>',,
'EXENAME='drivedir'\BIN\PMDIAG.EXE;PARAMETERS=ENCOR 'n';OBJECTID=<ABBDIAGENC'n'>')
        then do
             say 'PMDIAG Encore 'n' created successfully'
             file1 = drivedir'\BIN\PMDIAG.EXE'
             file2 = drivedir'\BIN\PMDIAG.ICO'
             rc = SysSetIcon( file1, file2)
        end
        else do
             say 'Error creating PMDIAG Encore 'n
             Exit 0
        end
        n = n + 1
    end
    end
    n = 1
    if wcasts > 0 then
    do
    do until n = wcasts + 1
        if SysCreateObject( 'WPProgram', 'PMTV/2 WinCast 'n, '<ABBUTILFolder>',,
'EXENAME='drivedir'\BIN\PMTV2.EXE;PARAMETERS=WCAST 'n';OBJECTID=<ABBPMTV2WC'n'>')
        then do
             say 'PMTV/2 WinCast 'n' created successfully'
             file1 = drivedir'\BIN\PMTV2.EXE'
             file2 = drivedir'\BIN\PMTV2.ICO'
             rc = SysSetIcon( file1, file2)
        end
        else do
             say 'Error creating PMTV/2 WinCast 'n
             Exit 0
        end
        if SysCreateObject( 'WPProgram', 'WinCast 'n' Config', '<ABBUTILFolder>',,
'EXENAME='drivedir'\BIN\TV2CFG.EXE;PARAMETERS=WCAST 'n';OBJECTID=<ABBCONFIGWC'n'>')
        then do
             say 'TV2CFG WinCast 'n' created successfully'
             file1 = drivedir'\BIN\TV2CFG.EXE'
             file2 = drivedir'\BIN\TV2CFG.ICO'
             rc = SysSetIcon( file1, file2)
        end
        else do
             say 'Error creating TV2CFG WinCast 'n
             Exit 0
        end
        if SysCreateObject( 'WPProgram', 'Rocket Remote WinCast 'n, '<ABBUTILFolder>',,
'EXENAME='drivedir'\BIN\RCON.EXE;PARAMETERS=WCAST 'n';MINWIN=DESKTOP;OBJECTID=<ABBROCKETWC'n'>')
        then do
             say 'RCON WinCast 'n' created successfully'
             file1 = drivedir'\BIN\RCON.EXE'
             file2 = drivedir'\BIN\RCON.ICO'
             rc = SysSetIcon( file1, file2)
        end
        else do
             say 'Error creating RCON WinCast 'n
             Exit 0
        end
        if SysCreateObject( 'WPProgram', 'Diagnostics WinCast 'n, '<ABBUTILFolder>',,
'EXENAME='drivedir'\BIN\PMDIAG.EXE;PARAMETERS=WCAST 'n';OBJECTID=<ABBDIAGWC'n'>')
        then do
             say 'PMDIAG WinCast 'n' created successfully'
             file1 = drivedir'\BIN\PMDIAG.EXE'
             file2 = drivedir'\BIN\PMDIAG.ICO'
             rc = SysSetIcon( file1, file2)
        end
        else do
             say 'Error creating PMDIAG WinCast 'n
             Exit 0
        end
        n = n + 1
    end
    end
    if num_tvs > 0 then
    do
    if SysCreateObject( 'WPProgram', 'Picture In Picture', '<ABBUTILFolder>',,
'EXENAME='drivedir'\BIN\PIP.EXE;OBJECTID=<ABBPIP>;STARTUPDIR='drivedir'\BIN')
    then do
         say 'Picture In Picture created successfully'
         file1 = drivedir'\BIN\PIP.EXE'
         file2 = drivedir'\BIN\PIP.ICO'
         rc = SysSetIcon( file1, file2)

                                    /* create TVPOS.INI */
         File = drivedir'\BIN\TVPOS.INI'
         rc = stream(File, 'c', 'QUERY EXISTS')
         if rc <> '' then
         do
             'del' File
         end
         rc = stream(File, 'c', 'OPEN WRITE')
         m = 2
         n = 1
         celebs = 0
         prisms = 0
         highqs = 0
         stubs = 0
         txt = ''
         do forever
             cmd = 'info digitalvideo0'm 'product wait'
             rc = SendString(cmd, ret_str)
             if rc <> 0 then
             do
                 call lineout File, txt
                 leave
             end
             if ret_str = "Hauppauge Celebrity" then
             do
                 celebs = celebs + 1
                 txt = txt'celeb'celebs' '
             end
             if ret_str = "Hauppauge Prism" then
             do
                 prisms = prisms + 1
                 txt = txt'prism'prisms' '
             end
             if ret_str = "Hauppauge HighQ" then
             do
                 highqs = highqs + 1
                 txt = txt'highq'highqs' '
             end
             if ret_str = "Hauppauge Encore" then
             do
                 encores = encores + 1
                 txt = txt'encores'encores' '
             end
             if ret_str = "Hauppauge WinCast" then
             do
                 wcasts = wcasts + 1
                 txt = txt'wcasts'wcasts' '
             end
             if ((n // 4) = 0) then
             do
                 call lineout File, txt
                 txt = ''
             end
             n = n + 1
             m = m + 1
         end
         rc = stream(File, 'c', 'CLOSE')
    end
    else do
         say 'Error creating Picture In Picture'
         Exit 0
    end
    end
end
else do
        say 'Error creating Utilities Folder.'
end

ExitRC = mciRxExit()
Exit 0

InstallEx:
    arg Ex

        name = 'Example' Ex 'using' Video''Instance
        path = drivedir'\SAMPLES\'Ex'\'Ex
        objid = 'ABB'Ex'PROG'Video''Instance

        if SysCreateObject( 'WPProgram', name, '<ABBSAMPFolder>',,
'EXENAME='path'.EXE;PARAMETERS='Video' 'Instance';OBJECTID='objid'>')
        then do
             say name 'created successfully'
             file1 = path'.EXE'
             file2 = path'.ICO'
             rc = SysSetIcon( file1, file2)
        end
        else do
             say 'Error creating' name
             Exit 0
        end
        return 0

/*   --- SendString --
** Call DLL function.  Pass the command to process and the
** name of a REXX variable that will receive textual return
** return code.
*/
SendString:
    arg CmndTxt
    arg ret_str

        MacRC = mciRxSendString(CmndTxt, 'ret_str', '0', '0')
        return MacRC
