#include "includes.h"



APIRET EXPENTRY FS_ATTACH (
    USHORT	flag,
    PSZ		pDev,
    struct vpfsd *pvpfsd,
    struct cdfsd *pcdfsd,	/* not used */
    PCHAR	pParm,
    PUSHORT	pLen )
{
  int rc;
  BLOCK   blkRootDir;
  PVOLUME pVolume;

  UtilEnterRamfs();
  DEBUG_PRINTF2 ("FS_ATTACH  pDev='%s' flag=%d", pDev, flag);

  switch (flag)
  {
    case 0: /* Attach */
	    if (pDev[1] != ':')
	    {
	      /* only drives, please */
	      rc = ERROR_NOT_SUPPORTED;
	      break;
	    }

	    rc = NearAlloc ((PNEARBLOCK *) &pVolume, sizeof(VOLUME));
	    if (rc)
	      break;

	    rc = BlockMakeEmptyDir (&blkRootDir);
	    if (rc)
	    {
	      NearFree (pVolume);
	      break;
	    }

	    pvpfsd->pVolume = pVolume;
	    pVolume->blkRootDir.flatAddr = blkRootDir.flatAddr;
	    pVolume->blkRootDir.cbSize   = blkRootDir.cbSize;
	    pVolume->flatBlkRootDir = VMVirtToFlat (&pVolume->blkRootDir);
	    pVolume->pFirstOpenfile = 0;
	    pVolume->pFirstCurdir = 0;
	    pVolume->pFirstSearch = 0;
	    memset (pVolume->szLabel, 0, sizeof(pVolume->szLabel));
	    if (FP_SEG(pParm) > 3)
	      strncpy (pVolume->szLabel, pParm, 11);	/* volume label */
            pVolume->datiCreate = UtilGetDateTime();

	    rc = NO_ERROR;
	    break;


    case 1: /* Detach */
	    rc = ERROR_NOT_SUPPORTED;
	    break;


    case 2: /* Query */
	    if (*pLen >= 8)
	    {
	      /* set cbFSAData to 0 => we return 0 bytes in rgFSAData area */
	      *((USHORT *) pParm) = 6;
	      pParm[2] = 'H';
	      pParm[3] = 'e';
	      pParm[4] = 'l';
	      pParm[5] = 'l';
	      pParm[6] = 'o';
	      pParm[7] = '\0';
	      rc = NO_ERROR;
	    }
	    else
	    {
	      /* not enough room to tell that we wanted to return 0 bytes */
	      rc = ERROR_BUFFER_OVERFLOW;
	    }
	    *pLen = 8;
	    break;
  }

  DEBUG_PRINTF1 (" => %d\r\n", rc);
  UtilExitRamfs();
  return rc;
}
