/******************************************************************************/
/* File Name : OS2SETUP.CMD                                                   */
/*                                                                            */
/* Descriptive Name : ACECAD OS/2 tablet/pen driver installation procedure    */
/*                                                                            */
/* Version : 2.03                                                             */
/*                                                                            */
/* Copyright : Copyright (C) 1997 ACE CAD Enterprise Co., Ltd.                */
/*                                                                            */
/* Description : This procedure install and setup the ACECAD tablet/pen driver*/
/*               for OS/2                                                     */
/* Modification :                                                             */
/*      2.01 : Correct the filename of the document file                      */
/*      2.02 : Change the comment sequence in config.sys for acecad.sys       */
/*      2.03 : Change the document filename to .TXT                           */
/******************************************************************************/
'@echo off'; TRACE OFF
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
call SysCls
CurDir=DIRECTORY()
if right(CurDir, 1) <> '\' then DriverDir=CurDir'\OS2DRV'
else DriverDir=CurDir'OS2DRV'
NewDir=DIRECTORY(DriverDir)
if NewDir <> DriverDir then do
  say " Please change the working directory to the root directory"
  say " of the floppy drive you put the ACECAD Drivers/Utilities"
  say " disk in and run OS2SETUP.CMD again. "
  say
  say " Please hit any key to exit....."
  i = SysGetKey()
  exit
end

OS2Path = value('PATH',,'OS2ENVIRONMENT')       
parse upper var OS2Path PathEnv':\OS2;'.
BootDrive = right(PathEnv,1)
ConfigFile = BootDrive':\CONFIG.SYS'
Buffer1 = BootDrive':\TEMPCON.SYS'
OutputFile = stream(Buffer1,'c','query exist')
if OutputFile <> "" then ERASE OutputFile
OutputFile = Buffer1
say
say "  ۱  ۱ ۱ ۱  ۱  ۱    ACECAD OS/2 Tablet/Pen Driver"
say " ۱ ۱ ۱    ۱    ۱    ۱ ۱ ۱ ۱       Installation Progarm."
say " ۱ ۱ ۱    ۱  ۱    ۱ ۱ ۱ ۱             Ver. 2.03"
say " ۱ ۱    ۱    ۱    ۱ ۱ ۱         Copyright(C) 1998"
say " ۱ ۱ ۱ ۱ ۱ ۱ ۱ ۱    ACE CAD Enterprise Co., Ltd."
say
say " Welcome to install the ACECAD Tablet/Pen driver. This program will"
say " install the drivers listed below for your OS/2 system."
say
say "   1. Install Tablet Driver for OS/2"
say "   2. Install Tablet Driver for Pen for OS/2"
say "   3. Quit"
say
say " Please select which driver you want to install [1/2/3] : "
say
say "      *********************************************************"
say "      * Note : If you select to install the Tablet driver for *"
say "      *        Pen for OS/2, you must have installed the Pen  *"
say "      *        for OS/2 before.                               *"
say "      *********************************************************"
parse value SysCurPos() with row col
Nrow = row - 7; Ncol = 58;
do forever
  CursorPosi = SysCurPos(Nrow, Ncol)
  ItemNumber = SysGetKey()
  if ItemNumber = '1' | ItemNumber = '2' | ItemNumber = '3' then leave
end
CursorPosi = SysCurPos(row, col)
if ItemNumber = '1' then call InstTabDriver
else if ItemNumber = '2' then call InstPenDriver
i = DIRECTORY(CurDir)
'@echo on'
exit

InstTabDriver:
  DestDir = BootDrive':\OS2'
  say
  say "----------------------------------------------------------------------"
  say " Do you want to use the tablet as the secondary pointing device"
  say " with your OS/2 [Y/N]? "
  say
  say " Note : If you answer Yes, you must make sure that you already install"
  say "        another pointing device such as a mouse or trackball, and it is"
  say "        properly connected to your computer. In the furture, if you do"
  say "        not want to use the mouse or trackball, you must reinstall the"
  say "        tablet driver for your OS/2."
  parse value SysCurPos() with row col
  Qrow = row - 7; Qcol = 24
  do forever
    CursorPosi = SysCurPos(Qrow, Qcol)
    Answer = translate(SysGetKey())
    if Answer = 'Y' then do
      MultiFlag = 1; leave; end
    if Answer = 'N' then do
      MultiFlag = 0; leave; end
  end
  CursorPosi = SysCurPos(row, col)
  say
  say "----------------------------------------------------------------------"
  say " Checking system configuration file....."
  say
  LineNumber.0 = 0; j = 0; AppendString.0 = 4
  call CheckMouseExist
  if FoundMouse = 0 then do 
    call NoMouseExist
    return
  end
  call RemConfigString 'POINTDD.SYS'
  AppendString.3 = CommentString
  call RemConfigString 'VMOUSE.SYS'
  AppendString.2 = CommentString
  call RemConfigString 'ACECAD.SYS'
  call RemConfigString 'APENOS2.SYS'
  call QueryDriverSetting
  AppendString.1 = 'DEVICE='BootDrive':\OS2\ACECAD.SYS COM='ComPortNumber
  call SetConfigFile
  do i = 1 to 4
     j = lineout(OutputFile,AppendString.i)
  end
  say
  say "----------------------------------------------------------------------"
  call CopyFile 'ACECAD.SYS'
  call CopyFile 'ACPANEL.EXE'
  call CopyFile 'OS2DRV.TXT'
  say
  say " Create ACECAD Tablet Control Panel on DESKTOP..."
  classname = 'WPProgram'
  title = 'ACECAD Tablet Control Panel'
  location = '<WP_DESKTOP>'
  setup = 'EXENAME='BootDrive':\OS2\ACPANEL.EXE;'
  result = SysCreateObject(classname,title,location,setup,'R')
  call closefile
  call ShowReBoot
return

InstPenDriver:
  DestDir = BootDrive':\APENOS2'
  call SysMkDir DestDir
  PenDriverPath = BootDrive':\APENOS2'
  PenDevComment = 'SET PENDEV='PenDriverPath
  say "----------------------------------------------------------------------"
  say " Checking system configuration file....."
  say
  LineNumber.0 = 0; j = 0
  call CheckMouseExist
  if FoundMouse = 0 then do 
    call NoMouseExist
    return
  end
  call AppendPenPath 'SET PATH='
  call AppendPenPath 'SET DPATH='
  call RemConfigString 'ACECAD.SYS'
  call RemConfigString 'APENOS2.SYS'
  call SysFileSearch 'SET PENDEV=',ConfigFile,'buffer.','N'
  if buffer.0 <> 0 then do
    do i = 1 to buffer.0
       parse var buffer.i LineNum' 'Buffer1
       CheckText = translate(Buffer1)
       if abbrev(CheckText,'SET') then do
          j = j + 1; LineNumber.0 = j
          LineNumber.j = LineNum
          ConfigString.j = 'REM 'Buffer1
  end;end;end
  call QueryDriverSetting
  APenComment = 'DEVICE='BootDrive':\APENOS2\APENOS2.SYS COM='ComPortNumber
  call SetConfigFile
  i = lineout(OutputFile, PenDevComment)
  say
  say "----------------------------------------------------------------------"
  call CopyFile 'APENOS2.SYS'
  call CopyFile 'CAL.EXE'
  call CopyFile 'OS2DRV.TXT'
  classname = 'WPFolder'
  title = 'Devices'
  location = '<PPM_FOLDER>'
  setup = 'OBJECTID=<DEVICES_FOLDER>;HELPPANEL=40067;HELPLIBRARY=PSETUP.HLP;'
  result = SysCreateObject(classname,title,location,setup,'F')
  classname = 'PenLocatorPen'
  title = 'ACECAD Pen Device'
  location = '<DEVICES_FOLDER>'
  ProgramLocation = BootDrive':\APENOS2\CAL.EXE'
  setup = 'OBJECTID=<PENDD_STYLUS>;CALPROG='ProgramLocation';CALPARMS=TRUE;PEN_DRIVER=Digitizer Mod 3;PEN_DEVICE=Pen'
  result = SysCreateObject(classname,title,location,setup,'R')
  call SysDestroyObject "ACECAD Tablet Control Panel"
  call closefile
  call ShowReBoot
return

CheckMouseExist:
  FoundMouse = 0
  call SysFileSearch 'MOUSE.SYS',ConfigFile,'buffer.','N'
  if buffer.0 = 0 then return
  do i = 1 to buffer.0
     parse var buffer.i LineNum' 'Buffer1
     CheckText = translate(Buffer1)
     if pos('VMOUSE.SYS',CheckText) = 0 then do
        if abbrev(CheckText,'DEVICE') then do
           FoundMouse = 1
           j = j + 1; LineNumber.0 = j
           LineNumber.j = LineNum
           ConfigString.j = 'REM 'CheckText
           CheckPos = pos(' ',CheckText)
           if( CheckPos = 0) then Buffer1 = CheckText
           else parse var CheckText Buffer1' '.
           if ItemNumber = 1 then do
              if MultiFlag = 1 then AppendString.4 = Buffer1' STYPE=ACECAD$'
              else AppendString.4 = Buffer1' TYPE=ACECAD$'
           end
           else do
              MouseLineNumber = LineNum
              MouseComment = Buffer1
           end
           call CheckTypeName
  end;end;end
return

SetConfigFile:
  j = 0
  do while lines(ConfigFile) = 1
     Buffer1 = linein(ConfigFile); j = j + 1
     do i = 1 to LineNumber.0
        if j = LineNumber.i then Buffer1 = ConfigString.i
     end
     i = lineout(OutputFile,Buffer1)
     if ItemNumber = 2 then do
        if j = MouseLineNumber then do
           i = lineout(OutputFile, MouseComment)
           i = lineout(OutputFile, APenComment)
  end;end;end
return

AppendPenPath:
  arg PathString
  call SysFileSearch PathString,ConfigFile,'buffer.','N'
  if buffer.0 = 0 then return
  do i = 1 to buffer.0
    parse var buffer.i LineNum' 'Buffer1
    CheckText = translate(Buffer1)
    if abbrev(CheckText,PathString) then do
      if pos(PenDriverPath,CheckText) = 0 then do
        parse var CheckText PathString'='Path
        j = j + 1; LineNumber.0 = j
        LineNumber.j = LineNum
        ConfigString.j = PathString'='PenDriverPath';'path
  end;end;end
return

RemConfigString:
  arg KeyString
  call SysFileSearch KeyString,ConfigFile,'buffer.','N'
  if buffer.0 = 0 then return
  do i = 1 to buffer.0
     parse var buffer.i LineNum' 'Buffer1
     CheckText = translate(Buffer1)
     if abbrev(CheckText,'DEVICE') then do
        j = j + 1; LineNumber.0 = j
        LineNumber.j = LineNum
        ConfigString.j = 'REM 'Buffer1
        CommentString = CheckText
  end;end
return

CheckTypeName:
  TypeName = ""
  if (SpacePos=pos('STYPE=',CheckText)) <> 0 then
     parse var CheckText Buffer1'STYPE='TypeName'$'.
  else if (SpacePos=pos('TYPE=',CheckText)) <> 0 then
          parse var CheckText Buffer1'TYPE='TypeName'$'.
       else return
  call SysFileSearch TypeName,ConfigFile,'buffer.','N'
  if buffer.0 = 0 then retuen
  do i = 1 to buffer.0
     parse var buffer.i LineNum' 'Buffer1
     CheckText = translate(Buffer1)
     if pos('MOUSE.SYS',CheckText) = 0 then do
        if abbrev(CheckText,'DEVICE') then
           j = j + 1; LineNumber.0 = j
           LineNumber.j = LineNum
           ConfigString.j = 'REM 'CheckText
  end;end
return

CopyFile:
  arg FileName
  say 'Copy 'FileName' to 'DestDir
  COPY FileName' 'DestDir
return

QueryDriverSetting:
  do forever
    say "----------------------------------------------------------------------"
    say " Please input the COM port number (1 or 2) where your tablet will"
    say " be connected to : "
    parse value SysCurPos() with row col
    row = row - 1; col = 19;
    CursorPosi = SysCurPos(row, col)
    ComPortNumber = SysGetKey()
    say
    if ComPortNumber = '1' | ComPortNumber = '2' then leave
    say " This driver support only COM1 and COM2 "
    say
  end
return

closefile:
  i = lineout(ConfigFile); i = lineout(OutputFile)
  parse var ConfigFile FName'.'ExtName
  do ExtName = 0 to 999
    Buffer1 = FName'.'right(ExtName,3,'0')
    CheckText = stream( Buffer1 , 'c' , 'query exist' )
    if CheckText == "" then leave
  end
  Buffer1 = filespec("name",Buffer1)
  RENAME ConfigFile' 'Buffer1
  Buffer1 = filespec("name",ConfigFile)
  RENAME OutputFile' 'Buffer1
return

NoMouseExist:
  say
  say "*** Error ***"
  say "  Program can not find the 'MOUSE.SYS' setted in your OS/2 configuration"
  say "  file. To setup the Tablet properly for your OS/2, you need to setup"
  say "  the mouse driver first. Please refer to your OS/2 User's menu to"
  say "  setup a mouse driver, then run this program again."
  say
  say " Please hit any key to coutinue....."
  i = SysGetKey()
return

ShowReBoot:
  say
  say "*** Note: The system configuration file CONFIG.SYS is backup to "
  say "          "BackConfigFile", you have to restart the OS/2 system "
  say "          to activate the pen device driver."
  say
  say " Please hit any key to coutinue....."
  i = SysGetKey()
return
