.486p
model flat
ideal

; finger size
xMaxFinger=2786
yMaxFinger=1579

; stylus size
xMaxStylus=27648
yMaxStylus=15552

; tablet size
xMaxTablet=1919
yMaxTablet=1079

extrn DosClose:near
extrn DosCloseMutexSem:near
extrn DosCreateMutexSem:near
extrn DosCreateThread:near
extrn DosExit:near
extrn DosExitList:near
extrn DosOpen:near
extrn DosReleaseMutexSem:near
extrn DosRequestMutexSem:near
extrn DosSetPriority:near
extrn DosSleep:near
extrn DosSuspendThread:near
extrn DosWrite:near

stack 8192

dataseg
szFinger db '\DEV\$FINGER$',0
szStylus db '\DEV\$STYLUS$',0
szTablet db '\DEV\XSMOUSE$',0

dataseg
sGood0 db 'started.',13,10
sGood1 db 'stopped.',13,10
sGood2 db 'waiting...',13,10
sGood3 db 'awaiting...',13,10
sGood4 db 'quitting...',13,10
label sGood5 byte

dataseg
sInfo0 db ' opening finger',13,10
sInfo1 db ' finger configuration',13,10
sInfo2 db ' opening stylus',13,10
sInfo3 db ' stylus configuration',13,10
sInfo4 db ' opening tablet',13,10
sInfo5 db ' creating semaphore',13,10
sInfo6 db ' deleting semaphore',13,10
sInfo7 db ' closing tablet',13,10
sInfo8 db ' closing stylus',13,10
sInfo9 db ' closing finger',13,10
label sInfoA byte

udataseg
ActionTaken dd ?
BytesDone dd ?
fhFinger dd ?
fhStylus dd ?
fhTablet dd ?

dataseg
SetConfiguration db 00h,09h,01h,00h,00h,00h,00h,00h

dataseg
SetReportProtocol db 21h,0Bh,01h,00h,00h,00h,00h,00h ; stylus

dataseg
PutMouseEvent dw 1,yMaxTablet/2,xMaxTablet/2,yMaxTablet,xMaxTablet

dataseg
hMutexSem dd 0

dataseg
AllowFinger db 1
StateFinger db 0
StateStylus db 0

udataseg
tidFinger dd ?
tidStylus dd ?

codeseg
proc MainRoutine c near
arg @@Mod,@@Nul,@@Env,@@Arg
; determine begin of arguments
  cld ; operate foreward scan
  mov ecx,512 ; max scan length
  mov edi,[@@Arg] ; start address
  repne scasb ; find terminator
; process passed arguments
  call ProcessArguments
; show application started message
  call ShowInfo c,offset(sGood0),sGood1-sGood0
; open finger device driver
  call ShowInfo c,offset(sInfo0),sInfo1-sInfo0
  call DosOpen c,offset(szFinger),offset(fhFinger),offset(ActionTaken),0,0,1,0192h,0
  call ShowReturnCode
  jnz NotOpenFingerDriver
; open stylus device driver
  call ShowInfo c,offset(sInfo2),sInfo3-sInfo2
  call DosOpen c,offset(szStylus),offset(fhStylus),offset(ActionTaken),0,0,1,0192h,0
  call ShowReturnCode
  jnz NotOpenStylusDriver
; open tablet device driver
  call ShowInfo c,offset(sInfo4),sInfo5-sInfo4
  call DosOpen c,offset(szTablet),offset(fhTablet),offset(ActionTaken),0,0,1,0192h,0
  call ShowReturnCode
  jnz NotOpenTabletDriver
; register termination processing
  call DosExitList c,1,offset(ProcessComplete)
label AwaitFingerDevice near
; hang in here some minimum time
  call DosSleep c,50 ; milliseconds
; finger configuration request
  call ShowInfo c,offset(sInfo1),sInfo2-sInfo1
  call DosWrite c,[fhFinger],offset(SetConfiguration),8,offset(BytesDone)
  call ShowReturnCode
  jnz AwaitFingerDevice
label AwaitStylusDevice near
; hang in here some minimum time
  call DosSleep c,50 ; milliseconds
; stylus configuration request
  call ShowInfo c,offset(sInfo3),sInfo4-sInfo3
  call DosWrite c,[fhStylus],offset(SetConfiguration),8,offset(BytesDone)
  call ShowReturnCode
  jnz AwaitStylusDevice
; stylus set hid boot device protocol to report
  call ShowInfo c,offset(sInfo3),sInfo4-sInfo3
  call DosWrite c,[fhStylus],offset(SetReportProtocol),8,offset(BytesDone)
  call ShowReturnCode
  jnz AwaitStylusDevice
; move cursor to center of screen
  call DosWrite c,[fhTablet],offset(PutMouseEvent),10,offset(BytesDone)
; create private mutex semaphore
  call ShowInfo c,offset(sInfo5),sInfo6-sInfo5
  call DosCreateMutexSem c,0,offset(hMutexSem),0,0
  call ShowReturnCode
; start finger input thread
  call DosCreateThread c,offset(tidFinger),offset(FingerThread),0,2,8192
; start stylus input thread
  call DosCreateThread c,offset(tidStylus),offset(StylusThread),0,2,8192
; show application waiting message
  call ShowInfo c,offset(sGood2),sGood3-sGood2
; hang in here forever
  call DosSleep c,-1
label EndProcess near
; force process complete
  sub eax,eax ; success
  ret ; uses exit list
label NotOpenTabletDriver near
; close stylus device driver
  call ShowInfo c,offset(sInfo8),sInfo9-sInfo8
  call DosClose c,[fhStylus]
  call ShowReturnCode
label NotOpenStylusDriver near
; close finger device driver
  call ShowInfo c,offset(sInfo9),sInfoA-sInfo9
  call DosClose c,[fhFinger]
  call ShowReturnCode
label NotOpenFingerDriver near
; show application stopped message
  call ShowInfo c,offset(sGood1),sGood2-sGood1
; exit the process
  call DosExit c,1,0
endp MainRoutine

codeseg
proc ProcessComplete c near
arg @@ReasonCode
; show application quitting message
  call ShowInfo c,offset(sGood4),sGood5-sGood4
; suspend stylus input thread
  call DosSuspendThread c,[tidStylus]
; suspend finger input thread
  call DosSuspendThread c,[tidFinger]
; close private mutex semaphore
  call ShowInfo c,offset(sInfo6),sInfo7-sInfo6
  call DosCloseMutexSem c,[hMutexSem]
  call ShowReturnCode
; close tablet device driver
  call ShowInfo c,offset(sInfo7),sInfo8-sInfo7
  call DosClose c,[fhTablet]
  call ShowReturnCode
; close stylus device driver
  call ShowInfo c,offset(sInfo8),sInfo9-sInfo8
  call DosClose c,[fhStylus]
  call ShowReturnCode
; close finger device driver
  call ShowInfo c,offset(sInfo9),sInfoA-sInfo9
  call DosClose c,[fhFinger]
  call ShowReturnCode
; show application stopped message
  call ShowInfo c,offset(sGood1),sGood2-sGood1
; exit termination process
  call DosExitList c,3,0)
endp ProcessComplete

dataseg
xMaxPosTablet dd xMaxTablet
yMaxPosTablet dd yMaxTablet

dataseg
GetFingerInput db 0ECh,00h,0FFh,0FFh,81h,03h,22h,00h,34 dup(0EEh)

dataseg
xMaxPosFinger dd xMaxFinger
yMaxPosFinger dd yMaxFinger

dataseg
PutFingerEvent dw 0,0,0,yMaxTablet,xMaxTablet

udataseg
FingerDone dd ?

codeseg
proc FingerThread c near
arg @@parameter:dword
; set time critical priority
  call DosSetPriority c,2,3,31,0
; obtain finger input data
  mov esi,offset(GetFingerInput)
label AwaitFingerInputData near
; hang in here some minimum time
  call DosSleep c,50 ; milliseconds
label GetFingerEvent near
  mov [byte(esi+6)],22h ; reset
  call DosWrite c,[fhFinger],esi,8+22h,offset(FingerDone)
  test eax,eax ; success
  jnz AwaitFingerInputData
; ensure valid idreport
  mov ax,[esi+8] ; idreport
  cmp al,01h ; idreport
  jne NotFingerEvent
; ignore too many fingers
  mov al,[esi+41] ; count
  cmp al,04h ; too many
  jnb GetFingerEvent
; process finger events
  cmp ah,000h ; NoButMov
  je FingerToMouseEvent
  cmp ah,001h ; tipswitch
  jne GetFingerEvent
  cmp al,001h ; 1 finger
  mov ah,006h ; But1Down
  je FingerToMouseEvent
  cmp al,002h ; 2 finger
  mov ah,018h ; But2Down
  je FingerToMouseEvent
  cmp al,003h ; 3 finger
  mov ah,060h ; But3Down
  je FingerToMouseEvent
label NotFingerEvent near
; report unknown event
  mov eax,[esi+8] ; event
  bswap eax ; debugging
  call ShowReturnCode
  jmp GetFingerEvent
label FingerToMouseEvent near
; store emulated mouse event
  mov edi,offset(PutFingerEvent)
  mov [edi],ah ; mouse event
; store emulated mouse xpos
  movzx eax,[word(esi)+11]
  mul [xMaxPosTablet]
  div [xMaxPosFinger]
  mov [edi+4],ax ; xpos
; store emulated mouse ypos
  movzx eax,[word(esi)+13]
  mul [yMaxPosTablet]
  div [yMaxPosFinger]
  mov [edi+2],ax ; ypos
; request private mutex semaphore
  call DosRequestMutexSem c,[hMutexSem],-1
; write finger event as emulated mouse event
  cmp [AllowFinger],1 ; verify access
  jne EndWriteFingerEvent ; suppress
  call DosWrite c,[fhTablet],edi,10,offset(FingerDone)
label EndWriteFingerEvent near
; update current finger state
  mov al,[edi] ; current event
  mov [StateFinger],al ; save
label FingerAllowFinger near
; update current finger access
  cmp al,0 ; finger now idle
  jne EndFingerAllowFinger
  cmp [StateStylus],0 ; idle
  jne EndFingerAllowFinger
  mov [AllowFinger],1 ; allow
label EndFingerAllowFinger near
; release private mutex semaphore
  call DosReleaseMutexSem c,[hMutexSem]
  jmp GetFingerEvent
endp FingerThread

dataseg
GetStylusInput db 0ECh,00h,0FFh,0FFh,81h,03h,08h,00h,8 dup(0EEh)

dataseg
xMaxPosStylus dd xMaxStylus
yMaxPosStylus dd yMaxStylus

dataseg
PutStylusEvent dw 0,0,0,yMaxTablet,xMaxTablet

udataseg
StylusDone dd ?

codeseg
proc StylusThread c near
arg @@parameter:dword
; set time critical priority
  call DosSetPriority c,2,3,31,0
; obtain stylus input data
  mov esi,offset(GetStylusInput)
label AwaitStylusInputData near
; hang in here some minimum time
  call DosSleep c,50 ; milliseconds
label GetStylusEvent near
  mov [byte(esi+6)],08h ; reset
  call DosWrite c,[fhStylus],esi,8+08h,offset(StylusDone)
  test eax,eax ; success
  jnz AwaitStylusInputData
; ensure valid idreport
  mov al,[esi+8] ; idreport
  cmp al,02h ; idreport
  jne NotStylusEvent
; process stylus input
  mov al,[esi+9] ; event
  cmp al,000h ; remote
  mov ah,000h ; NoButMov
  je StylusToMouseEvent
  cmp al,020h ; nearby
  mov ah,001h ; MoveOnly
  je StylusToMouseEvent
  cmp al,021h ; pentip
  mov ah,006h ; But1Down
  je StylusToMouseEvent
  cmp al,022h ; button
  mov ah,018h ; But2Down
  je StylusToMouseEvent
  cmp al,023h ; together
  mov ah,01Eh ; ButsDown
  je StylusToMouseEvent
label NotStylusEvent near
; report unknown event
  mov eax,[dword(esi+8)]
  bswap eax ; debugging
  call ShowReturnCode
  jmp GetStylusEvent
label StylusToMouseEvent near
; store emulated mouse event
  mov edi,offset(PutStylusEvent)
  mov [edi],ah ; mouse event
; store emulated mouse xpos
  movzx eax,[word(esi)+10]
  mul [xMaxPosTablet]
  div [xMaxPosStylus]
  mov [edi+4],ax ; xpos
; store emulated mouse ypos
  movzx eax,[word(esi)+12]
  mul [yMaxPosTablet]
  div [yMaxPosStylus]
  mov [edi+2],ax ; ypos
; request private mutex semaphore
  call DosRequestMutexSem c,[hMutexSem],-1
; write stylus event as emulated mouse event
  call DosWrite c,[fhTablet],edi,10,offset(StylusDone)
label EndWriteStylusEvent near
  mov [AllowFinger],0 ; suppress
; update current stylus state
  mov al,[edi] ; current event
  mov [StateStylus],al ; save
label StylusAllowFinger near
; update current finger access
  cmp al,0 ; stylus now idle
  jne EndStylusAllowFinger
  cmp [StateFinger],0 ; idle
  jne EndStylusAllowFinger
  mov [AllowFinger],1 ; allow
label EndStylusAllowFinger near
; release private mutex semaphore
  call DosReleaseMutexSem c,[hMutexSem]
  jmp GetStylusEvent
endp StylusThread

codeseg
proc ProcessArguments near
; scan for forward slash
  mov al,[edi] ; character
  inc edi ; next position
  cmp al,00h ; terminator
  je EndScanString ; done
  cmp al,'/' ; parameter
  jne ProcessArguments
; verbose argument
  cmp [byte(edi)],'v'
  jne ProcessArguments
  mov [verbose],1 ; yes
  jmp ProcessArguments
label EndScanString near
; skip sanity checks
  ret ; return
endp ProcessArguments

dataseg
; verbose argument
verbose db 0 ; no

codeseg
proc ShowInfo c near
arg @@MsgOffset,@@MsgSize
; verify verbose activated
  cmp [verbose],1 ; yes
  jne EndShowInfo ; no
; show appropriate info message
  call DosWrite c,1,[@@MsgOffset],[@@MsgSize],offset(BytesDone)
label EndShowInfo near
  ret ; return
endp ShowInfo

dataseg
hex2ascii db '0123456789ABCDEF'

dataseg
szStatus db '[????????]',13,10

codeseg
proc ShowReturnCode near
; skip zero return code
  test eax,eax ; zero
  jz EndInfoShow ; done
; verify verbose activated
  cmp [verbose],1 ; yes
  jne NotInfoShow ; no
  push eax ; save register
; convert return code
  mov ecx,8 ; code length
label ConvertDigit near
  mov edx,eax ; error code
  and edx,0000000Fh ; digit
  mov dl,[hex2ascii+edx]
  mov [szStatus+ecx],dl
  shr eax,4 ; next one
  loop ConvertDigit
; show appropriate info message
  call DosWrite c,1,offset(szStatus),12,offset(BytesDone)
  pop eax ; restore register
label NotInfoShow near
  test eax,eax ; recheck
label EndInfoShow near
  ret ; return
endp ShowReturnCode

end MainRoutine
