;*************************************************************************
;*
;* SOURCE FILE NAME = DDDD.INC
;*
;* DESCRIPTIVE NAME = Device dependent DD include file.
;*
;* VERSION      V2.0
;* DATE         02/29/92
;*
;**************************************************************************


.xlist
       include iodelay.inc             ; IODELAY MACROS
.list

;**********************************************************************
;*  This section defines all the equates used.                        *
;**********************************************************************

;*
;*  The following equates define the DevStatus word.
;*

READENABLE       equ    0001h    ; device status - read enabled (report data)
ATTACHED         equ    0002h    ; device status - MOUSE$ attached
IRQENABLED       equ    0004h    ; device status - IRQ is enabled
DEINSTALLED      equ    0008h    ; device status - we've been deinstalled
DEVICEENABLED    equ    0010h    ; device status - we are enabled

UNKNOWNCMD       EQU      8003H     ; Unknown Command OS/2 RB Error Code
GENERALFAILURE   EQU      800CH     ; General Failure   "    "    "    "
CHARINT          EQU      8011H     ; Char Call Interrupted    "    "
MNS              EQU      8012H     ; Mon Not Sup'd  "    "    "    "
INVALIDPARMS     EQU      8013H     ; Invalid Parms  "    "    "    "
INITBAD          EQU      802FH     ; Fatal Init Error = ABORT DD Load
CRT_Data_Seg     EQU        40H     ; ROM BIOS CRT Data Segment Address
TAB              EQU          9     ; ASCII code for TAB
LF               EQU         10     ; ASCII code for Line Feed
CR               EQU         13     ; ASCII code for Carriage Return
WSP              equ         bl     ; register to hold white space status
EOL              equ         bh     ; reg to hold End of line status
Ack_Port         EQU        20H     ; Interrupt controller's acking port


;*
;*  The following equates define the intstatus word.
;*

OURINT           equ        01h     ; used by interrupt handlers
EOINEEDED        equ        02h     ; used by int handler for EOI issuing

Req_Blk_Size     EQU        100     ; Size of request block
IData_Size       EQU          5     ; Size of interrupt data buffer
CFGDATLEN        EQU          9     ; size on configuration data
ABIOS_COMPLETE   EQU      0000H     ; ABIOS Function Complete
SOI              EQU      0001H     ; ABIOS Stage On Interrupt
WOT              EQU      0002H     ; ABIOS Wait On Time
NOT_MINE         EQU      0005H     ; ABIOS SOI + Not My Interrupt
SOI_ATTN         EQU      0009H     ; ABIOS SOI + Attention
DEVBUSY          EQU      8000H     ; Retry Request, Device is Busy
ASYNC_ERRS       equ      0520h     ; async error
TXB              EQU          0     ; Transmit buffer
RXB              EQU          0     ; Receive buffer
LATLSB           EQU          0     ; Divisor latch least sig bits
LATMSB           EQU          1     ; Divisor latch most sig bits
IER              EQU          1     ; Interrupt enable register
IIR              EQU          2     ; Interrupt indentification register
LCR              EQU          3     ; Line control register
MCR              EQU          4     ; Modem control register
LSR              EQU          5     ; Line status register
MSR              EQU          6     ; Modem status register
IRQ9MASK         EQU  00000010B     ; 8259 Mask for IRQ9
IRQ3MASK         EQU  00001000B     ; 8259 Mask for IRQ3
IRQ4MASK         EQU  00010000B     ; 8259 Mask for IRQ4
IRQ5MASK         EQU  00100000B     ; 8259 Mask for IRQ5
COM1MASK         EQU   IRQ4MASK     ; Mask for COM1
COM2MASK         EQU   IRQ3MASK     ; Mask for COM2
COM1IRQ          EQU          4     ; COM1 IRQ Level
COM2IRQ          EQU          3     ; COM2 IRQ Level
COMPORT1         EQU      03F8H     ; 1st Aysnc Com port base
COMPORT2         EQU      02F8H     ; 2nd Aysnc Com port base

PACKETSIZE       equ   7
SYNCBIT          equ   80h
OURINT           equ   01h
EOINEEDED        equ   02h

;*
;* Modem control registers
;*

IIRMASK          EQU 11111000B     ; Interrupt ID Register permanent Mask bits
MCRMASK          EQU 00001011B     ; Modem Control Register Mask
IERMASK          EQU 00000001B     ; Interrupt Enable Register Mask
LCRMASK          EQU 00000011B     ; Line Control Reg Mask, 8 data bits 1 stop bit

;*
;*  This section defines all the structures used.
;*


Attach_DD     Struc
              RealEntry     dd     ?     ; Real mode entry point
              RealDS        dw     ?     ; Real mode data segment
              ProtEntry     dd     ?     ; Protect mode entry point
              ProtDS        dw     ?     ; Protect mode data selector
Attach_DD     Ends

;Event_Packet  Struc
;              Event         dw     ?     ; mouse event
;              Col_Mov       dw     ?     ; column movement
;              Row_Mov       dw     ?     ; row movement
;Event_Packet  EndS

ABSEvent_Packet  Struc
              Event         dw     ?     ; mouse event
              Row_Pos       dw     ?     ; row movement
              Col_Pos       dw     ?     ; column movement
              Row_Size      dw     ?     ; row size
              Col_Size      dw     ?     ; col size
ABSEvent_Packet  EndS

Dev_Data      Struc
              CfgDataLen    dw     ?     ; length of data (9)
              NumMics       db     ?     ; number mickeys/cm
              NumButt       db     ?     ; number of buttons
              IRQ           db     ?     ; IRQ level
              MouseType     db     ?     ; !! mouse type attached           (KD)
              ComPortNum    db     ?     ;
              ComPort       dw     ?     ; Com port address
Dev_Data      EndS


;*
;* This section defines all the macros used.
;*
DebugMSG MACRO msg
       pusha
       mov  ax, 55              ; major code
       mov  cx, 0               ; minor code
       mov  bx, 45              ; length
       mov  si, offset msg      ; message
       mov  dl, DevHlp_RAS
       call Device_Help
       popa
ENDM


;*
;*  MyIODelay - Perform an IO delay using kernel provided macro
;*              This macro give the proper amount of delay regardless
;*              of processor speed.
;*

MyIOdelay MACRO

        push ax
        DevIODelay <ax>              ; Trashes AX reg
        pop  ax

        ENDM

;*
;* Process_ABSPacket - macro to call mouse$ to process ABS packet.  On entry
;*                  cx = mouse event, bh= col movement, bl = row movement.
;*

Process_ABSPacket  Macro           ; macro to call MOUSE$ to process int data

       test DevStatus, READENABLE  ; see if data reporting enabled
       .if <nz>                    ; if so then send data to mouse$
          and  DevStatus, NOT READENABLE ; one event at a time
          push ds                  ; save our ds on stack for restore
          push es                  ; same for es
          push ds                  ; put ds on stack for switch to es

          mov  dx, YSIZE
          mov  di, XSIZE

          mov  si, IntPacketOff    ; get offset for data move
          mov  ds, MseDD.ProtDS    ; get protect mode ds value
          mov  [si].Event, cx      ; move the mouse event
          mov  [si].Row_Pos, bx
          mov  [si].Col_Pos, ax
          mov  [si].Row_Size, dx
          mov  [si].Col_Size, di

          pop  es                  ; put our ds (on stack) in es
          mov  ax, 3               ; Process ABS Packet function
          sti                      ; allow interrupts
          call es:MseDD.ProtEntry  ; protect mode call
          cli                      ; hold ints until we are completely done
          pop  es                  ; restore our es
          pop  ds                  ; restore our ds
          or   DevStatus, READENABLE ; we can process another event
       .endif                        ; end report data test
                EndM

;*
;* Process_Packet - macro to call mouse$ to process packet.  On entry
;*                  cx = mouse event, bh= col movement, bl = row movement.
;*

Process_Packet  Macro           ; macro to call MOUSE$ to process int data

       test DevStatus, READENABLE  ; see if data reporting enabled
       .if <nz>                    ; if so then send data to mouse$
          and  DevStatus, NOT READENABLE ; one event at a time
          push ds                  ; save our ds on stack for restore
          push es                  ; same for es
          push ds                  ; put ds on stack for switch to es
          mov  si, IntPacketOff    ; get offset for data move
          mov  ds, MseDD.ProtDS    ; get protect mode ds value
          mov  [si].Event, cx      ; move the mouse event
          mov  al, bh              ; get column movement (byte value)
          cbw                      ; convert to word
          mov  [si].Col_Mov, ax    ; move colument movement value (word)
          mov  al, bl              ; get row movement (byte value)
          cbw                      ; convert to word
          mov  [si].Row_Mov, ax    ; move row movement value (word)
          pop  es                  ; put our ds (on stack) in es
          mov  ax, 1
          sti                      ; allow interrupts
          call es:MseDD.ProtEntry  ; protect mode call
          cli                      ; hold ints until we are completely done
          pop  es                  ; restore our es
          pop  ds                  ; restore our ds
          or   DevStatus, READENABLE ; we can process another event
       .endif                        ; end report data test
                EndM


BADINIT          Macro
       mov  es, TempES                     ; LocalVar = Req Blk Selector
       mov  bx, TempBX                     ; LocalVar = Req Blk Offset
       or   es:[bx].PktStatus, INITBAD     ; Flag Hard Init Err = ABORT
                 EndM
;*
;*  This macro is used to read serial devices. (serial mice)
;*
ReadAsync  MACRO
local      RXBLOOP

       MOV  DX, First_Port              ; Setup Mouse Input Port Number
       IN   AL, DX                      ; Read incoming Interrupt data Byte

       PUSH AX                          ; Save Data Byte

       ADD  DX, LSR                     ; Check Line Status Reg
       IN   AL, DX                      ; Read Line Status Data
       MOV  BL, AL                      ; Get Error Code in BL

       POP AX                           ; Restore Data Byte

       .IF < BL gt 60H >                ; If an Error occured then
                                        ; Reset DLAB
          MOV  DX, First_Port           ; Get Base Port
          ADD  DX, LCR                  ; Get Line Control Reg
          MOV  AL, 80H                  ; Set DLAB access bit in the LCR
          OUT  DX, AL                   ; to Access div latch regs
          MyIODelay                     ; I/O Delay for Port Access
          SUB  AL, AL                   ; Set 1200 Baud
          ADD  DX, -LCR+LATMSB          ; Get div latch MSB
          OUT  DX, AL                   ; Set div latch MSB to 0
          MyIODelay                     ; I/O Delay for Port Access
          MOV  AL, 0CH                  ;
          ADD  DX, -LATMSB+LATLSB       ; Get div latch LSB
          OUT  DX, AL                   ; Set divisor for 1200 bauds
          MyIODelay                     ; I/O Delay for Port Access

;*
;* Reset DLAB, set NO Parity, 1 Stop Bit, 7 Data Bits
;*
          ADD  DX, -LATLSB+LCR          ; Get Line Control Reg
          MOV  AL, LCRMASK              ; Set 7 data bits, etc. in LCR
          OUT  DX, AL                   ;
          MyIODelay                     ; I/O Delay for Port Access

;*
;* Set OUT2, RQS, DTR in Modem Control Reg
;*
          ADD  DX, -LCR+MCR             ; Get MCR
          MOV  AL, MCRMASK              ;
          OUT  DX, AL                   ;
          MyIODelay                     ; I/O Delay for Port Access

;*
;* Set Data avail in INT Enable Reg
;*
          ADD  DX, -MCR+IER             ; Indicate Interrupts Enabled
          MOV  AL, IERMASK              ;
          OUT  DX, AL                   ;
          MyIODelay                     ; I/O Delay for Port Access

          XOR  AX, AX                   ; Discard Bad Data Byte
          MOV  ByteCount, ax            ; Discard any Packet Data
       .ENDIF                           ; Data Error Tests
   ENDM
