/* check for NIC ids and drivers */

Trace 'N'

/* get our directory */
Parse Source . . our_cmd .
our_dir = Left(our_cmd,Lastpos('\',our_cmd) - 1)
Call Directory(our_dir)
nic_lst = our_dir||'\nicdrv.lst'
nicpak_web = 'http://www.os2warp.be/nicpak/files/'

/* Load RexxUtil.DLL */
Call Rxfuncadd 'SysLoadFuncs','Rexxutil','SysLoadFuncs'
Call SysLoadFuncs
/* Load RexxIni.DLL */
Call Rxfuncadd 'IniLoadFuncs','RexxIni','IniLoadFuncs'
Call IniLoadFuncs

Parse Upper Arg run_parm .

If run_parm <> 'RUN' Then Do
 pmrexx = SysSearchPath('path','pmrexx.exe')
 If SysCreateObject('WPProgram','NicPak','<WP_DESKTOP>','OBJECTID=<NICPAK_CMD>;' ,
  ||'EXENAME='||pmrexx||';STARTUPDIR='||our_dir||';' ,
  ||'PARAMETERS='||our_cmd 'RUN;','R') Then Do
  If SysOpenObject('<NICPAK_CMD>','RUNNING','TRUE') Then Return 0
  Else Do
   Say 'Unable to open Nicpak object'
   Return 0
  End
 End
 Else Do
  Say 'Unable to create Nicpak object'
  Return 0
 End
End

/* locate \IBMCOM\MACS */
ibm_com = SysSearchPath('path','mpts.exe')
If ibm_com <> '' Then Do
 ibm_com = Left(ibm_com,Lastpos('\',ibm_com) - 1)
 ibm_macs = ibm_com||'\MACS'
End
Else Do
 Say 'Networking support does not appear to be installed on this system'
 Say 'Press enter to exit'
 Parse Pull .
 Call SysDestroyObject '<NICPAK_CMD>'
 Return 0
End

run_mpts = 0
macs_path = Value('MACS_PATH',ibm_macs||';','os2environment')
copy_path = Value('COPY_PATH',ibm_com||';'||ibm_macs||';','os2environment')
Call Build_device_list /* build device id list */

/* select a NIC */
If mfg_no.0 <> 0 Then Do
 Say 'The following NIC(s) have been detected.  Note that more NICs'
 Say 'may be shown than you have installed because various vendors have'
 Say 'used the same chipset in their products.'
 nic_select = Select_nic('D') /* select a NIC driver */
 If Datatype(nic_select,'w') & mfg_no.0 >= nic_select & nic_select >= 1 Then Do
  Call Update_driver nic_select /* update NIC driver */
 End
End
Else Do
 Say 'Sorry, I was not able to identify any of your network'
 Say 'cards.  Would you like to install a driver from the list'
 Say 'of available drivers?  Yes or No'
 Parse Upper Pull ans .
 If Abbrev(ans,'Y') Then Do
  Call Load_nic_table 'unknown isa pcmcia'
  Do i = 1 To nic_list.0
   Call Nic_load nic_list.i
  End
  Say 'Drivers for the following NIC(s) are available'
  Say 'or can be downloaded from the web'
  nic_select = Select_nic() /* select a NIC driver */
  If Datatype(nic_select,'w') & mfg_no.0 >= nic_select & nic_select >= 1 Then Do
   Call Update_driver nic_select /* update NIC driver */
  End
  Else Say 'Nothing selected'
 End
 Else Say 'Installation bypassed'
End
If run_mpts Then Do
 Say 'Would you like to run Network Adapters and Protocol Services'
 Say 'to update your adapter configuration now?  Yes or No'
 Parse Upper Pull ans .
 If Abbrev(ans,'Y') Then Do
  If Pos('-',nic_title.nic_select) <> 0 Then Parse Var nic_title.nic_select . '- ' nic_card_name
  Else nic_card_name = nic_title.nic_select
  Say 'The driver you selected is titled'
  Say nic_card_name
  Say 'Press enter to continue'
  Parse Pull .
  Call Run_mpts nic_macs_nif
 End
End
Else Do
 Say 'You have not selected any updates, and Network Adapters and Protocol'
 Say 'Services will not be invoked.  Would you like to check the values in'
 Say '\IBMCOM\PROTOCOL.INI against the values in \IBMLAN\IBMLAN.INI?  Yes or No'
 Parse Upper Pull ans .
 If Abbrev(ans,'Y') Then Call Check_protocol
End

macs_path = Value('MACS_PATH','','os2environment')
copy_path = Value('COPY_PATH','','os2environment')
Say 'Press enter to exit'
Parse Pull .
Call SysDestroyObject '<NICPAK_CMD>'
Return 0


Build_device_list:
bus_device. = ''
bus_device.0 = 0
oem_device. = ''
oem_device.0 = 0
pci_view = Stream(our_dir||'\pci.exe','c','query exists')
pci_arg = '/i /h'
If pci_view <> '' Then Call Query_devices pci_view,pci_arg
pci_view = SysSearchPath('path','rmview.exe')
pci_arg = '/dc'
If pci_view <> '' Then Call Query_devices pci_view,pci_arg
Call Check_devices /* check for NIC devices */
Return

/* query devices */
Query_devices:
Parse Arg pci_view,pci_arg,.
pci_prog = Translate(Filespec('name',pci_view))
dev_queue = Rxqueue('create')
old_queue = Rxqueue('set',dev_queue)
Address cmd '@'||pci_view pci_arg '| rxqueue' dev_queue
/* get device ids */
found_device = 0
Do i = 1 Until Queued() = 0
 mfg_no = ''
 bus_rev_id = ''
 Parse Pull line
 line = Space(line)
 Select
  When Abbrev(pci_prog,'PCI') Then Do
   /* handle output from PCIxxx */
   /* V:10EC D:8139 S:813910EC B:0 E:14 F:0 I:10 N:A C:02 U:00 P:00 R:10 */
   /* V:10EC D:8139 S:813910EC B:0 E:14 F:0 I:10 N:A C:02 U:00 P:00 */
   Parse Value '.' line With . 'C:' dev_class .
   If Abbrev(dev_class,'02') Then Do
    Parse Value '.' line With 'V:' bus_vendor_id 'D:' bus_device_id 'S:' bus_subvendor_id . 'R:' bus_rev_id .
    found_device = 1
   End
  End
  When Abbrev(pci_prog,'RMV') Then Do
   /* handle output from RMVIEW */
   If Abbrev(line,'Detected Hardware Function') Then Do
    Parse Var line . 'PCI Device' dev_class .
    If Abbrev(dev_class,'02') Then Do Until Abbrev(line,'IRQ Level') | Queued() = 0
     Parse Pull line
     line = Space(line)
     If Abbrev(line,'PCI Device ID:') Then Do
      Parse Var line . ': ' bus_device_id
      bus_vendor_id = Substr(bus_device_id,1,4)
      bus_device_id = Substr(bus_device_id,5)
      found_device = 1
     End
     If Abbrev(line,'PnP Device ID:') Then Do
      Parse Var line . ':' bus_device_id
      Call Add_bus_device bus_device_id
     End
    End
   End
  End
  Otherwise Nop
 End
 If found_device Then Do
  bus_vendor_id = Right(Translate(Strip(bus_vendor_id)),4,'0')
  bus_device_id = Right(Translate(Strip(bus_device_id)),4,'0')
  bus_rev_id = Right(Translate(Strip(bus_rev_id)),2,'0')
  If bus_rev_id = 0 Then bus_rev_id = ''
  oem_device_id = Right(Translate(Strip(bus_subvendor_id)),8,'0')
  Call Add_bus_device Strip(bus_vendor_id||bus_device_id||bus_rev_id)
  If bus_subvendor_id <> Copies('0',8) Then Call Add_oem_device Strip(bus_subvendor_id||bus_rev_id)
  found_device = 0
 End
End
Call Rxqueue 'set',old_queue
Call Rxqueue 'delete',new_queue
Return

/* add non-duplicate bus device ids */
Add_bus_device: Procedure Expose bus_device.
Parse Arg bus_device_id .
Do i = 1 To bus_device.0
 If bus_device_id = bus_device.i Then Return
End
i = bus_device.0 + 1
bus_device.i = bus_device_id
bus_device.0 = i
Return

/* add non-duplicate oem device ids */
Add_oem_device: Procedure Expose oem_device.
Parse Arg oem_device_id .
Do i = 1 To oem_device.0
 If oem_device_id = oem_device.i Then Return
End
i = oem_device.0 + 1
oem_device.i = oem_device_id
oem_device.0 = i
Return

/* check the ids found */
Check_devices:
Call Clear_nic_table /* clear NIC table */
/* scan for NIC cards */
/* search for oem devices first */
Do i = 1 To oem_device.0
 test = oem_device.i
 rc = SysFileSearch(test,nic_lst,'nic_found.')
 If rc = 0 & nic_found.0 <> 0 Then Do j = 1 To nic_found.0
  If test = Word(nic_found.j,3) Then Call Nic_load 2,nic_found.j /* get NIC table info */
 End
 Else Do
  test = Left(oem_device.i,8)
  rc = SysFileSearch(test,nic_lst,'nic_found.')
  If rc = 0 & nic_found.0 <> 0 Then Do j = 1 To nic_found.0
   If test = Word(nic_found.j,3) Then Call Nic_load 2,nic_found.j /* get NIC table info */
  End
 End
End
If nic_found.0 > 0 Then Return

Do i = 1 To bus_device.0
 test = bus_device.i
 rc = SysFileSearch(test,nic_lst,'nic_found.')
 If rc = 0 & nic_found.0 <> 0 Then Do j = 1 To nic_found.0
  If test = Word(nic_found.j,1) Then Call Nic_load 1,nic_found.j /* get NIC table info */
 End
 Else Do
  test = Left(bus_device.i,8)
  rc = SysFileSearch(test,nic_lst,'nic_found.')
  If rc = 0 & nic_found.0 <> 0 Then Do j = 1 To nic_found.0
   If test = Word(nic_found.j,1) Then Call Nic_load 1,nic_found.j /* get NIC table info */
  End
 End
End
Return

/* clear NIC table */
Clear_nic_table:
no_type. = ''
no_type.0 = 0
max_col_2 = 0
mfg_no. = ''
mfg_no.0 = 0
oem_no. = ''
oem_no.0 = 0
nic_title. = ''
nic_title.0 = 0
max_title = 0
nic_dir. = ''
nic_dir.0 = 0
max_dir = 0
nic_nif. = ''
nic_nif.0 = 0
Return

/* get NIC table info */
Nic_load:
Parse Arg no_type,nic_found
If \Abbrev(nic_found,';') Then Do
 Parse Var nic_found mfg_no '|' oem_no '|' nic_nif '|' nic_title
 nic_dir = Left(nic_nif,Lastpos('\',nic_nif) - 1)
 nic_nif = Substr(nic_nif,Lastpos('\',nic_nif) + 1)
 Call SysStemInsert 'no_type.',no_type.0 + 1,Strip(no_type)
 max_col_2 = Max(Length('Chipset ID'),max_col_2)
 Call SysStemInsert 'mfg_no.',mfg_no.0 + 1,mfg_no
 max_col_2 = Max(Length(Strip(mfg_no)),max_col_2)
 Call SysStemInsert 'oem_no.',oem_no.0 + 1,oem_no
 max_col_2 = Max(Length(Strip(oem_no)),max_col_2)
 Call SysStemInsert 'nic_title.',nic_title.0 + 1,Space(nic_title)
 max_title = Max(Length(Strip(nic_title)),max_title)
 Call SysStemInsert 'nic_dir.',nic_dir.0 + 1,Space(nic_dir)
 max_dir = Max(Length(Strip(nic_dir)),max_dir)
 Call SysStemInsert 'nic_nif.',nic_nif.0 + 1,Space(nic_nif)
 max_col_2 = Max(Length(Strip(nic_nif)),max_col_2)
End
Return

/* select a NIC driver */
Select_nic:
Parse Arg detail .
detail = Abbrev(detail,'D')
max_no = Length(no_type.0)
screen_list. = ''
screen_list.0 = 0
found_in_nic_macs = 0
Do i = 1 To no_type.0
 If detail | i = 1 Then Call SysStemInsert 'screen_list.',screen_list.0 + 1,Copies(' ',max_no + 2) Left('Chipset ID',max_col_2 + 1) 'Chip Mfg - Card Title'
 If no_type.i = 1 Then Call SysStemInsert 'screen_list.',screen_list.0 + 1,Right(i,max_no) '-' Left(Strip(mfg_no.i),max_col_2 + 1) Left(nic_title.i,max_title)
 Else Call SysStemInsert 'screen_list.',screen_list.0 + 1,Right(i,max_no) '-' Left(Strip(oem_no.i),max_col_2 + 1) Left(nic_title.i,max_title)
 If Length('NIF File') > max_nif Then max_nif = Length('NIF File')
 Parse Value Find_nif(ibm_macs,nic_nif.i) With in_ibm_macs ibm_macs_nif
 Call SysStemCopy 'driver.','ibm_macs_driver.'
 Call SysStemCopy 'copyfile.','ibm_copyfile.'
 Parse Value Find_nif(our_dir||'\'||nic_dir.i,nic_nif.i) With in_nic_macs nic_macs_nif
 found_in_nic_macs = in_nic_macs | found_in_nic_macs
 If driver.0 > 0 Then Call SysStemCopy 'driver.','nic_macs_driver.'
 Call SysStemCopy 'copyfile.','nic_copyfile.'
 Call SysStemInsert 'screen_list.',screen_list.0 + 1,Copies(' ',max_no + 2) Left('NIF File',max_col_2 + 1) 'NIF & Driver Information'
 If in_ibm_macs Then Do
  Call SysStemInsert 'screen_list.',screen_list.0 + 1,Copies(' ',max_no + 2) Left(nic_nif.i,max_col_2 + 1) ibm_macs_nif
  Do y = 1 To ibm_macs_driver.0
   Call SysStemInsert 'screen_list.',screen_list.0 + 1,Copies(' ',max_no + 2) Copies(' ',max_col_2 + 1) ibm_macs_driver.y
  End
  Do y = 1 To ibm_copyfile.0
   Call SysStemInsert 'screen_list.',screen_list.0 + 1,Copies(' ',max_no + 2) Copies(' ',max_col_2 + 1) ibm_copyfile.y
  End
  Call SysStemInsert 'screen_list.',screen_list.0 + 1,Copies(' ',max_no + 2) Copies(' ',max_col_2 + 1) nic_macs_nif
  Do y = 1 To nic_macs_driver.0
   Call SysStemInsert 'screen_list.',screen_list.0 + 1,Copies(' ',max_no + 2) Copies(' ',max_col_2 + 1) nic_macs_driver.y
  End
  Do y = 1 To nic_copyfile.0
   Call SysStemInsert 'screen_list.',screen_list.0 + 1,Copies(' ',max_no + 2) Copies(' ',max_col_2 + 1) nic_copyfile.y
  End
  Call SysStemInsert 'screen_list.',screen_list.0 + 1,' '
 End
 Else Do
  Call SysStemInsert 'screen_list.',screen_list.0 + 1,Copies(' ',max_no + 2) Left(nic_nif.i,max_col_2 + 1) nic_macs_nif
  Do y = 1 To nic_macs_driver.0
   Call SysStemInsert 'screen_list.',screen_list.0 + 1,Copies(' ',max_no + 2) Copies(' ',max_col_2 + 1) nic_macs_driver.y
  End
  Do y = 1 To nic_copyfile.0
   Call SysStemInsert 'screen_list.',screen_list.0 + 1,Copies(' ',max_no + 2) Copies(' ',max_col_2 + 1) nic_copyfile.y
  End
  Call SysStemInsert 'screen_list.',screen_list.0 + 1,' '
 End
End
Do i = 1 To screen_list.0
 Say screen_list.i
End
If found_in_nic_macs Then Do
 Say 'Enter the number of the NIC you want to process, or press enter to bypass'
 Parse Upper Pull ans .
End
Else Do
 Say 'None of the above NIC(s) had drivers stored under'
 Say '  the' our_dir 'directory'
 ans = ''
End
Return ans

/* update NIC driver */
Update_driver:
save_trace = Trace('N')
Parse Arg nic_select .
nif = nic_nif.nic_select
nif_dir = nic_dir.nic_select
ibm_macs_driver. = ''
ibm_macs_driver.0 = 0
ibm_copyfile. = ''
ibm_copyfile.0 = 0
Parse Value Find_nif(ibm_macs,nif) With in_ibm_macs ibm_macs_nif '|' ibm_macs_driver '|' ibm_copyfile
Call SysStemCopy 'driver.','ibm_macs_driver.'
Call SysStemCopy 'copyfile.','ibm_copyfile.'
ibm_macs_nif = Space(Word(ibm_macs_nif,1))
Do x = 1 To ibm_macs_driver.0
 Parse Var ibm_macs_driver.x . '=' ibm_macs_driver.x
 ibm_macs_driver.x = Space(Word(ibm_macs_driver.x,1))
End
Do x = 1 To ibm_copyfile.0
 Parse Var ibm_copyfile.x . '=' ibm_copyfile.x
 ibm_copyfile.x = Space(Word(ibm_copyfile.x,1))
End
nic_macs_driver. = ''
nic_macs_driver.0 = 0
nic_copyfile. = ''
nic_copyfile.0 = 0
Parse Value Find_nif(our_dir||'\'||nif_dir,nif) With in_nic_macs nic_macs_nif '|' nic_macs_driver '|' nic_copyfile
Call SysStemCopy 'driver.','nic_macs_driver.'
Call SysStemCopy 'copyfile.','nic_copyfile.'
nic_macs_nif = Space(Word(nic_macs_nif,1))
Do x = 1 To nic_macs_driver.0
 Parse Var nic_macs_driver.x . '=' nic_macs_driver.x
 nic_macs_driver.x = Space(Word(nic_macs_driver.x,1))
End
Do x = 1 To nic_copyfile.0
 Parse Var nic_copyfile.x . '=' nic_copyfile.x
 nic_copyfile.x = Space(Word(nic_copyfile.x,1))
End
Select
 When \in_ibm_macs & in_nic_macs Then Do
  Do x = 1 To nic_macs_driver.0
   Say 'Copy' nic_macs_nif 'and' nic_macs_driver.x 'to' ibm_macs||'?'
  End
  Do x = 1 To nic_copyfile.0
   If nic_copyfile <> 'none' Then Say 'Copy' nic_copyfile.x 'to' ibm_macs||'?'
  End
  Say 'Enter "Yes" to proceed'
  Parse Upper Pull ans .
  If Abbrev(ans,'Y') Then Call Copy_nic
  Else Say 'Update bypassed'
 End
 When in_ibm_macs & in_nic_macs Then Do
  Do x = 1 To nic_macs_driver.0
   Say 'Replace' ibm_macs_nif 'and' ibm_macs_driver.x
   Say 'with' nic_macs_nif 'and' nic_macs_driver.x||'?'
  End
  Say 'Enter "Yes" to proceed'
  Parse Upper Pull ans .
  If Abbrev(ans,'Y') Then Do
   If Back_macs() Then Call Copy_nic
  End
  Else Say 'Update bypassed'
 End
 When in_ibm_macs & \in_nic_macs Then Do
  Say 'No alternatives were found for'
  Say ibm_macs_nif 'and' ibm_macs_driver
 End
 When \in_ibm_macs & \in_nic_macs Then Do
  Say 'There are no NIFs or drivers found for' nif
 End
 Otherwise
  Nop
End
Trace(save_trace)
Return

/* load the NIC device table */
Load_nic_table:
save_trace = Trace('N')
Parse Arg entry_types
Call Clear_nic_table
nic_list. = ''
nic_list.0 = 0
Do i = 1 While Lines(nic_lst)
 nic_info = Linein(nic_lst)
 If Wordpos(Word(nic_info,1),entry_types) <> 0 Then Do
  j = nic_list.0 + 1
  nic_list.j = nic_info
  nic_list.0 = j
 End
End
Trace(save_trace)
Return

/* get info from NIF file */
Find_nif: Procedure Expose nicpak_web driver. copyfile. in_ibm_macs in_nic_macs
save_trace = Trace('N')
Parse Arg dir,nif
version = ''
nif_stamp = ''
driver. = ''
driver.0 = 0
copyfile. = ''
copyfile.0 = 0
rc = SysFileTree(dir||'\'||nif,'nif_loc.','fo')
If rc = 0 & nif_loc.0 > 0 Then Do
 located = 1
 nif_loc = Space(nif_loc.1)
 nif_path = Strip(Filespec('d',nif_loc)||Filespec('p',nif_loc),'t','\')
 Call Value 'NIF_PATH',nif_path,'os2environment'
End
Else Do
 located = 0
 Select
  When Substr(dir,Lastpos('\',dir) + 1) = 'current' Then Do
   nif_loc = 'The current driver is installed'
   driver.1 = ''
   driver.0 = 1
   copyfile.1 = ''
   copyfile.0 = 1
  End
  When Substr(dir,Lastpos('\',dir) + 1) = 'nothere' Then Do
   nif_loc = 'No OS/2 driver for this chipset has been found'
   driver.1 = ''
   driver.0 = 1
   copyfile.1 = ''
   copyfile.0 = 1
  End
  Otherwise Do
   nif_loc = 'This NIF and driver can be downloaded from'
   nic_zip = Substr(dir,Lastpos('\',dir) + 1)||'.zip'
   driver.1 = nicpak_web||nic_zip
   driver.0 = 1
   copyfile.1 = ''
   copyfile.0 = 1
  End
 End
End
If located Then Do
 If IniEnumSections('hdr.',nif_loc) > 0 Then Do
  nif_hdr = hdr.1
  /* locate version */
  handle = IniOpen(nif_hdr,nif_loc)
  If handle > 0 Then version = IniGet('version',handle)
  Else version = ''
  If verison <> '' Then version = 'Version =' Space(version)
  Else version = 'Version = unknown'
  /* locate copyfile */
  If handle > 0 Then copyfile = IniGet('copyfile',handle)
  Else copyfile = ''
  If copyfile <> '' Then Do
   copyfile_list = copyfile
   Parse Var copyfile_list copyfile ',' copyfile_list
   copyfile = Space(copyfile)
   Do While copyfile <> ''
    If Pos('\',copyfile) <> 0 Then copyfile = Substr(copyfile,Lastpos('\',copyfile) + 1)
    test_copyfile = SysSearchPath('nif_path',copyfile)
    If test_copyfile <> '' Then Do
     copyfile = test_copyfile
     copyfile_stamp = SysGetFileDateTime(copyfile,'w')
     j = copyfile.0 + 1
     copyfile.j = 'Copyfile =' copyfile Stream(copyfile,'c','query size') copyfile_stamp
     copyfile.0 = j
    End
    Else Do
     j = copyfile.0 + 1
     copyfile.j = 'Copyfile =' copyfile '(not found in' Value('nif_path',,'os2environment')||')'
     copyfile.0 = j
    End
    Parse Var copyfile_list copyfile ',' copyfile_list
    copyfile = Space(copyfile)
   End
  End
  Else Do
   copyfile.1 = 'Copyfile = none'
   copyfile.0 = 1
  End
  /* locate driver name */
  handle = IniOpen('file' ,nif_loc)
  If handle > 0 Then driver = IniGet('name',handle)
  Else driver = ''
  If driver <> '' Then Do
   driver_list = driver
   Parse Var driver_list driver ',' driver_list
   driver = Space(driver)
   Do While driver <> ''
    If Pos('\',driver) <> 0 Then driver = Substr(driver,Lastpos('\',driver) + 1)
    test_driver = SysSearchPath('nif_path',driver)
    If test_driver <> '' Then Do
     driver = test_driver
     driver_stamp = SysGetFileDateTime(driver,'w')
     j = driver.0 + 1
     driver.j = 'Driver =' driver Stream(driver,'c','query size') driver_stamp
     driver.0 = j
    End
    Else Do
     j = driver.0 + 1
     driver.j = 'driver =' driver '(not found in' Value('nif_path',,'os2environment')||')'
     driver.0 = j
    End
    Parse Var driver_list driver ',' driver_list
    driver = Space(driver)
   End
  End
  Else Do
   driver.1 = 'Driver = none'
   driver.0 = 1
  End
  nif_stamp = Stream(nif_loc,'c','query size') SysGetFileDateTime(nif_loc,'w')
 End
 Call IniClose handle
End
Trace(save_trace)
Return located nif_loc version nif_stamp

/* copy from nicpak to ibmcom\macs */
Copy_nic: Procedure Expose run_mpts nic_macs_nif ibm_macs nic_macs_driver. nic_copyfile.
save_trace = Trace('N')
maxrc = 0
Address cmd '@copy' nic_macs_nif ibm_macs '> nul'
maxrc = Max(maxrc,Abs(rc))
If maxrc = 0 Then Do
 Say 'Copied' nic_macs_nif 'to' ibm_macs
 Do x = 1 To nic_macs_driver.0 While maxrc = 0
  Address cmd '@copy' nic_macs_driver.x ibm_macs '> nul'
  maxrc = Max(maxrc,Abs(rc))
  If maxrc = 0 Then Say 'Copied' nic_macs_driver.x 'to' ibm_macs
  Else Say 'Copy of' nic_macs_driver.x 'failed'
 End
 If maxrc = 0 Then Do x = 1 To nic_copyfile.0 While maxrc = 0
  If nic_copyfile.x <> 'none' Then Do
   Address cmd '@copy' nic_copyfile.x ibm_macs '> nul'
   maxrc = Max(maxrc,Abs(rc))
   If maxrc = 0 Then Say 'Copied' nic_copyfile.x 'to' ibm_macs
   Else Say 'Copy of' nic_copyfile.x 'failed'
  End
 End
 If maxrc = 0 Then run_mpts = 1
 Else run_mpts = 0
End
Else Do
 Say 'Copy of' nic_macs_nif 'failed'
 run_mpts = 0
End
Trace(save_trace)
Return maxrc

/* backup files in ibmcom\macs */
Back_macs: Procedure Expose ibm_macs_nif ibm_macs_driver. ibm_copyfile.
save_trace = Trace('N')
back_rc = 0
nif_bak = Left(ibm_macs_nif,Lastpos('.',ibm_macs_nif) - 1)||'.BAK'

If Stream(nif_bak,'c','query exists') <> '' Then Do
 Say nif_bak 'already exists'
 Say 'Enter Yes to delete the current file and proceed'
 Parse Upper Pull ans .
 If \Abbrev(ans,'Y') Then Return 0
End
Call SysFileDelete nif_bak
Address cmd '@zip -9joq' nif_bak ibm_macs_nif
back_rc = Max(back_rc,Abs(rc))
If back_rc = 0 Then Do
 Say 'Zipped' ibm_macs_nif 'to' nif_bak
 Do x = 1 To ibm_macs_driver.0 While back_rc = 0
  Address cmd '@zip -9joq' nif_bak ibm_macs_driver.x
  back_rc = Max(back_rc,Abs(rc))
  If back_rc = 0 Then Say 'Zipped' ibm_macs_driver.x 'to' nif_bak
  Else Say 'Backup of' ibm_macs_driver.x 'failed'
 End
 If back_rc = 0 Then Do x = 1 To ibm_copyfile.0 While back_rc = 0
  If ibm_copyfile.x <> 'none' Then Do
   If Stream(ibm_copyfile.x,'c','query exists') <> '' Then Do
    Address cmd '@zip -9joq' nif_bak ibm_copyfile.x
    back_rc = Max(back_rc,Abs(rc))
    If back_rc = 0 Then Say 'Zipped' ibm_copyfile.x 'to' nif_bak
    Else Say 'Backup of' ibm_copyfile.x 'failed'
   End
   Else Say ibm_copyfile.x 'does not exist'
  End
 End
End
Else Say 'Backup of' ibm_macs_nif 'failed'
Trace(save_trace)
Return (back_rc = 0)

/* invoke MPTS for selected NIF */
Run_mpts: Procedure Expose our_dir ibm_macs
save_trace = Trace('N')
Parse Arg nic_macs_nif
ibm_macs_nif = ibm_macs||'\'||Filespec('name',nic_macs_nif)
/* make sure mpts is available */
mpts = SysSearchPath('path','mpts.exe')
If mpts = '' Then Do
 Say 'MPTS.EXE was not found in your current path'
 xrc = 0
End
Else Do
 /* invoke mpts */
 Say 'Ready to start Network Adapters and Protocol Services'
 Say 'Press enter to continue or any other response to exit'
 Parse Upper Pull ans .
 If ans <> '' Then xrc = 1
 Else Do
  Address cmd mpts
  xrc = (rc = 0)
  xrc = (Check_protocol() = 0)
 End
End
Trace(save_trace)
Return xrc

Check_protocol:
Procedure
save_trace = Trace('N')
xrc = Protochk()
Trace(save_trace)
Return xrc

Rx_sayout:
Parse Arg temp_msg,.
Say temp_msg
Return
