/* check for protocol.ini against ibmlan.ini */
Trace 'N'
Parse Source . . our_cmd .
our_path = Filespec('d',our_cmd)||Filespec('p',our_cmd)
If Length(our_path) > 3 Then our_dir = Strip(our_path,'t','\')
Else our_dir = our_path
save_dir = Directory(our_dir)
/* Load RexxUtil.DLL */
Call Rxfuncadd 'SysLoadFuncs','Rexxutil','SysLoadFuncs'
Call SysLoadFuncs
/* Load RexxIni.DLL */
Call Rxfuncadd 'IniLoadFuncs','RexxIni','IniLoadFuncs'
Call IniLoadFuncs
Parse Arg log_name proto_name lan_name .
retcode = Check_protocol(log_name,proto_name,lan_name)
Call Directory save_dir
Return retcode

Check_protocol: Procedure
Parse Arg log_name,proto_name,lan_name,.
/* now see if protocol.ini is present */
If proto_name = '' Then protocol = SysSearchPath('dpath','protocol.ini')
Else protocol = Stream(proto_name,'c','query exists')
If protocol = '' Then Do
 Call Msg_out log_name,'PROTOCOL.INI was not found in your current data path'
 Return 0
End

/* now see if ibmlan.ini is present */
If lan_name = '' Then ibmlan = SysSearchPath('dpath','ibmlan.ini')
Else lan_name = Stream(lan_name,'c','query exists')
If ibmlan = '' Then Do
 Call Msg_out log_name,'IBMLAN.INI was not found in your current data path'
 Return 0
End

/* do we have netbeui or tcpbeui */
netbios_driver = IniGet('drivername','netbios',protocol)

/* now get the netbios information */
adapter. = '';adapter.0 = 0;sessions. = '';ncbs. = '';names. = '';
If netbios_driver <> '' Then Do
 frc = IniEnum('netbios.','netbios',protocol)
 If frc > 0 Then Do x = 1 To netbios.0
  If Abbrev(Translate(netbios.x),'ADAPTER') Then Do
   Call SysStemInsert 'adapter.',adapter.0 + 1,netbios.x '=' IniGet(netbios.x,'netbios',protocol)
   y = adapter.0
   Parse Var adapter.y . '=' nif_name '$' .
   nif_name = Strip(nif_name)||'_nif'
   sessions.y = IniGet('sessions',nif_name,protocol)
   ncbs.y = IniGet('ncbs',nif_name,protocol)
   names.y = IniGet('names',nif_name,protocol)
  End
 End

 /* now get the networks information */
 frc = IniEnum('nets.','networks',ibmlan)
 net. = '';net.0 = 0
 If frc > 0 Then Do x = 1 To nets.0
  If Abbrev(Translate(nets.x),'NET') Then Call SysStemInsert 'net.',net.0 + 1,nets.x '=' IniGet(nets.x,'networks',ibmlan)
 End

 /* get the requester and peer entries in ibmlan.ini */
 c_wrknets = IniGet('wrknets','requester',ibmlan)
 c_srvnets = IniGet('srvnets','peer',ibmlan)

 /* build an updated networks section */
 tcpbeui = 0
 new_net. = '';new_net.0 = 0
 net_info = ''
 Do x = 1 To adapter.0
  Parse Var adapter.x . '=' net_driver ',' net_number .
  net_name = 'net'||x
  net_driver = Translate(Strip(net_driver))
  If Abbrev(net_driver,'TCP') Then
   tcpbeui = tcpbeui + 1
  net_number = Strip(net_number)
  /* get parameter values for this network from ibmlan.ini */
  c_net = IniGet(net_name,'networks',ibmlan)
  If c_net <> '' Then
   Parse Var c_net . ',' . ',' . ',' c_sessions ',' c_ncbs ',' c_names .
  Else Do
   /* set to defaults */
   c_sessions = 34
   c_ncbs = 70
   c_names = 14
  End
  /* check against values in protocol.ini */
  If Datatype(sessions.x,'W') Then c_sessions = Min(c_sessions,sessions.x)
  If Datatype(ncbs.x,'W') Then c_ncbs = Min(c_ncbs,ncbs.x)
  If Datatype(names.x,'W') Then c_names = Min(c_names,names.x)
  Call SysStemInsert 'new_net.',new_net.0 + 1,net_name '=' net_driver||','||net_number||',LM10,'||c_sessions||','||c_ncbs||','||c_names
  net_info = Strip(net_info||net_name||',')
 End
 net_info = Strip(net_info,'t',',')

 /* network section */
 n_update = 0
 If new_net.0 <> nets.0 Then n_update = 1
 Else
  Do x = 1 To new_net.0
   Do y = 1 To net.0
    If Translate(Word(new_net.x,1)) = Translate(Word(net.y,1)) Then Do
     If Space(Translate(new_net.x)) <> Space(Translate(net.y)) Then Do
      If \n_update Then n_update = 1
     End
    End
   End
  End

 /* requester section */
 r_update = 0
 If c_wrknets <> '' Then Do
  If \r_update Then
   r_update = (Translate(net_info) <> Translate(c_wrknets))
 End

 /* peer section */
 p_update = 0
 If c_srvnets <> '' Then Do
  If \p_update Then
   p_update = (Translate(net_info) <> Translate(c_srvnets))
 End

 /* do the update if necessary */
 If n_update | r_update | p_update Then
  Call Msg_out log_name,'Updating' ibmlan
 Else
  Call Msg_out log_name,'No updates to' ibmlan 'were necessary'
 If n_update Then Do
  /* save the old ibmlan.ini */
  save_ibmlan = SysTempFileName(Filespec('d',ibmlan)||Filespec('p',ibmlan)||'IBMLAN.???')
  Call Msg_out log_name,'Saving' ibmlan 'as' save_ibmlan
  Address cmd '@copy' ibmlan save_ibmlan '> nul'
  /* delete all of the current networks entries */
  handle = IniOpen('networks',ibmlan)
  Do x = 1 To net.0
   frc = IniDel('net'||x,handle)
  End
  Do x = 1 To new_net.0
   Parse Var new_net.x new_name '=' new_info
   frc = IniSet(new_name,new_info,handle)
  End
  frc = IniSave(handle)
  frc = IniClose(handle)
 End
 If r_update Then Do
  handle = IniOpen('requester',ibmlan)
  If handle > 0 Then Do
   frc = IniSet('wrknets',net_info,handle)
   frc = IniSave(handle)
   frc = IniClose(handle)
  End
 End
 If p_update Then Do
  handle = IniOpen('peer',ibmlan)
  If handle > 0 Then Do
   frc = IniSet('srvnets',net_info,handle)
   frc = IniSave(handle)
   frc = IniClose(handle)
  End
 End
End
Return 0

Msg_out: Procedure
Parse Arg log,msg,.
If log <> '' Then Do
 log = Stream(log,'c','query exists')
 If log <> '' Then Call Lineout log,msg
 Else Say msg
End
Else Say msg
Return
