@echo off
cls
setlocal
echo  DigiBoard Inc. LAN Distance Installation



rem ------ Test for valid LAN Distance MAC directory ---------


if "%1" == "" goto BOGUSDRIVE

if NOT EXIST %1\IBMCOM\MACS goto BADMACS




rem ------ Copy file to \ibmcom\macs -------------------------


echo    Copying files

copy dgafgp.os2   %1\ibmcom\macs > NULL
copy dgpoller.exe %1\ibmcom\macs > NULL
copy *.BIN        %1\ibmcom\macs > NULL
copy *.SYM        %1\ibmcom\macs > NULL


echo    Files copied


rem ------ Test for config.sys file --------------------------

set DRV=%2
if "%2" == "" set DRV=%1
if NOT EXIST %DRV%\CONFIG.SYS  goto BADCFG



rem ------ Add a config line choices -------------------------


echo    Updating %DRV%\config.sys
echo  rem *------------------------------------------------------------------*  >> %DRV%\config.sys
echo  rem DigiBoard PC/16e, PC and MC/8e, 4e, 2e, and PC/Xi  >> %DRV%\config.sys
echo  rem DEVICE=%1\IBMCOM\MACS\DGAFGP.OS2 /M:D0000 /P:320  >> %DRV%\config.sys
echo  rem *------------------------------------------------------------------*  >> %DRV%\config.sys
echo  rem DigiBoard MC/16i, MC/8i, MC/4i  >> %DRV%\config.sys
echo  rem DEVICE=%1\IBMCOM\MACS\DGAFGP.OS2 /M:D0000 /P:F1F0  >> %DRV%\config.sys
echo  rem *------------------------------------------------------------------*  >> %DRV%\config.sys
echo  rem DigiBoard PC/Xem, MC/Xem  >> %DRV%\config.sys
echo  rem DEVICE=%1\IBMCOM\MACS\DGAFGP.OS2 /M:D0000 /P:324 /T:P  >> %DRV%\config.sys
echo  rem *------------------------------------------------------------------*  >> %DRV%\config.sys
echo  rem DigiBoard EISA Xem, slot 3  >> %DRV%\config.sys
echo  rem DEVICE=%1\IBMCOM\MACS\DGAFGP.OS2 /M:D0000 /P:3005 /T:P  >> %DRV%\config.sys
echo  rem *------------------------------------------------------------------*  >> %DRV%\config.sys
echo  rem DigiBoard ISA C/X 1 concentrator  >> %DRV%\config.sys
echo  rem DEVICE=%1\IBMCOM\MACS\DGAFGP.OS2 /M:D0000 /P:328 /T:I10  >> %DRV%\config.sys
echo  rem *------------------------------------------------------------------*  >> %DRV%\config.sys
echo  rem DigiBoard EISA C/X 1 concentrator, slot 3  >> %DRV%\config.sys
echo  rem DEVICE=%1\IBMCOM\MACS\DGAFGP.OS2 /M:D0000 /P:3005 /T:E10  >> %DRV%\config.sys
echo  rem *------------------------------------------------------------------*  >> %DRV%\config.sys
echo  rem DigiBoard Micro Channel C/X 1 concentrator  >> %DRV%\config.sys
echo  rem DEVICE=%1\IBMCOM\MACS\DGAFGP.OS2 /M:D0000 /P:328 /T:M10  >> %DRV%\config.sys
echo  rem *------------------------------------------------------------------*  >> %DRV%\config.sys

echo  RUN=%1\IBMCOM\MACS\DGPOLLER.EXE  >> %DRV%\config.sys
rem   echo  DEVICE=%1\IBMCOM\MACS\DGANDIS.OS2  >> %DRV%\config.sys


rem ------ Run LAPS ------------------------------------------

if NOT EXIST %1\ibmcom\laps.exe  goto BADLAPS
echo    Running LAPS to Install DigiBoard Network Support.
echo        Select "Install" from the LAPS main screen.
echo        Press any Key to run LAPS.
pause > NULL

%1\ibmcom\laps

:CFGMSG

echo    Run LAN Distance "Settings" to configure for the DigiBoard Adapter(s)
echo    and edit your new CONFIG.SYS to reflect the DigiBoard(s) installed.
echo        Refer to the INSTALL.DOC file on this diskette.
goto EXIT


rem ------ ERROR HANDLERS ------------------------------------

:BOGUSDRIVE
echo    *Error* - Invalid Driver Letter Specified
echo    USAGE :  install <drive:>

goto EXIT

:BADMACS
echo    *Error* - %1\IBMCOM\MACS directory not found.
goto USAGE


:BADCFG
echo    *Error* - CONFIG.SYS not on specified drive "%DRV%"
:USAGE
echo    USAGE : install  LAN Distance Drive:  [CONFIG.SYS Drive:]
goto EXIT


:BADLAPS
echo    *Error* - %1\ibmcom\laps.exe was not found.
echo               Run LAPS manually to install DigiBoard Network Support.
goto CFGMSG


rem ------ EXIT ----------------------------------------------


:EXIT
endlocal
