#define INCL_DOS
#define INCL_KBD
#define INCL_DOSERRORS
#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <conio.h>
#include <math.h>

#include "uniaud.h"
#include "unidef.h"
#include "errno.h"


int pcms_num[MAX_CARDS] = {0}; // number of pcm instances
int cards_num = 0; // number of cards

POSS32_DEVCAPS pcmcaps[MAX_CARDS] = {0}; // pointer to pcm caps

UniaudCardInfo *CardInfo[MAX_CARDS] = {0};

snd_pcm_status_t status;

int read_key(void)
{
    static ULONG time = 0;
    KBDKEYINFO Char;

    KbdCharIn(&Char, IO_NOWAIT, 0);

    if (time == Char.time)
        return 0;

    time = Char.time;

    return Char.chChar;
}

int main (int argc, char *argv[])
{
    int ArgNum;
    int ver, err, ret;
    int channels,i, bytesread, count;
    int card_id = 2;
    uniaud_pcm *pcm = NULL;
    char *Buffer;
    char *Buf;
    int readed, written, state, fsize;
    snd_pcm_uframes_t number_of_frames;
    FILE *input_handle;
    int key;


    printf("PCM read tool for UNIAUD. Version 0.01\n");
    printf("Copyright 2004 by Vlad Stelmahosky aka Vladest\n");

    ver = uniaud_get_version();

    switch (ver)
    {
    case -2:
        printf("Error: uniaud not detected\n");
        return 1;
        break;
    case -1:
        printf("Error: uniaud error\n");
        return 1;
        break;
    default:
        if (ver < 111 )
        {
            printf("Error: unsupported version of uniaud\n");
            return 1;
        } else
            printf("Detected UNIAUD version %1d.%02d\n", ver / 100, ver % 100 );
    }

    cards_num = uniaud_get_cards();
    if (!cards_num)
    {
        printf("No audio cards detected\n");
        return 1;
    }

    printf("Detected %i audio adapter(s)\n", cards_num);
#if 0
    // set capture to ON
    if (uniaud_mixer_put_value_by_name(card_id,"Capture Switch",1, 0, 0) < 0)
    {
        printf("Error in mixer\n");
    }
#endif
    if (uniaud_mixer_put_value_by_name(card_id,"Capture Volume",10, 0, 0) < 0)
    {
        printf("Error in mixer\n");
    }
    if (uniaud_mixer_put_value_by_name(card_id,"Capture Volume",10, 1, 0) < 0)
    {
        printf("Error in mixer\n");
    }
    // set source to LINE IN fo chan 1
    if (uniaud_mixer_put_value_by_name(card_id,"Capture Source",1, 0, 0) < 0)
    {
        printf("Error in mixer\n");
    }
#if 0
    // set source to LINE IN fo chan 2
    if (uniaud_mixer_put_value_by_name(card_id,"Capture Source",0, 1, 0) < 0)
    {
        printf("Error in mixer\n");
    }
#endif
    readed = 0;
    err = uniaud_pcm_open(card_id, PCM_TYPE_READ, 0, 0, 32000, 2,
                          SNDRV_PCM_FORMAT_S16_LE, &pcm);
    if (pcm && err == 0)
    {
        printf("opened. pcm = %x\n", pcm);
        err = uniaud_pcm_prepare(pcm);
        printf("prepare err = %i\n", err);
        err = uniaud_pcm_start(pcm);
        printf("start err = %i\n", err);
        if (argc > 1)
            input_handle = fopen(argv[1], "wb");
        else
            input_handle = fopen("in.wav", "wb");
        if (!input_handle) printf("Error opening file\n");

        //        count = pcm->bufsize;
        count = pcm->period_size;

        Buffer = malloc(count);
        //        memset(Buffer,0, count);

//        DosSetPriority(PRTYS_THREAD, PRTYC_TIMECRITICAL,0,0);

        while (1)
        {
#if 1
            ret = uniaud_pcm_wait(pcm, 100);
            if (ret < 0)
            {
                printf("error waiting pcm interrupt %i\n", ret);
                DosSleep(1);
            }
#endif
//            else
            {
                state = uniaud_pcm_state(pcm);

                err = uniaud_pcm_read(pcm, Buffer, count*2);

                if (err > 0) // write something
                {
                    readed=readed+err;
                    bytesread = fwrite (Buffer, 1, err, input_handle);
                    printf("readed=%i with state %i\r",readed, state);
                }

#if 1
                if (err == -EAGAIN) //
                {
                    printf("eagain\n");
                    continue;
                }
#endif
                if (err < 0) {
                    state = uniaud_pcm_state(pcm);
                    printf("state after read: %i, err = %i\n",state, err);
                    if ( (state != SND_PCM_STATE_PREPARED) &&
                        (state != SND_PCM_STATE_RUNNING) &&
                        (state != SND_PCM_STATE_DRAINING) || err == -11) {
                        printf("read:BAD STATE2, state = %d, going to try XRUN\n",state);
                        if ((ret = uniaud_pcm_prepare(pcm))<0) {
                            printf("xrun: prepare error: %i", err);
                            //return 0;
                        }
                    }
                }
            }
            //            DosSleep(300);
            key = read_key();
            //        printf("%i\n",key);
            if (key == 27)
                break;

        }
        free(Buffer);
        err = uniaud_pcm_close(pcm);
        fclose(input_handle);
        DosSetPriority(PRTYS_THREAD, PRTYC_REGULAR,0,0);
    }
    else
    {
        printf("open err: %i, pcm %x\n", err, pcm);
        if (err == 5)
            err = uniaud_pcm_close(pcm);
        printf("close err: %i\n", err);
    }

    return 0;
}
