/* UniLog.CMD version 1.0 06-Jun-2010 Written by David Azarewicz www.88watts.net */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
PARSE ARG TestId
Host=VALUE('HOSTNAME',,'OS2ENVIRONMENT');
if (Host = '') then Host = "Unknown";
MyDate=DATE('S');
HostDate=Host||'-'||MyDate;
BreakLine='----- Output of: ';
HeaderLine='File created '||DATE('N')||' '||TIME('N')||' by UNILOG.CMD V1.0';
BootDrive=left(value('GLOSSARY',,'OS2ENVIRONMENT'),2);
TmpDir = STRIP(value('TMP',,'OS2ENVIRONMENT'),'T','\') || '\';
/* find PCI.EXE */
PCIEXE=SysSearchPath('PATH', 'PCI.EXE');
if (PCIEXE='') then do;
  PCIEXE=BootDrive||'ecs\install\DETECTEI\PCI.EXE';
  if (stream(PCIEXE,'c','query exists')='') then do;
    say "PCI.EXE not found";
    exit;
  end;
end;
'@echo off'
do while (QUEUED() <> 0); PULL; end;

say "Please type a short description of the test result or problem (1 line):";
PARSE PULL TestResult;
MMBase = STRIP(value('MMBASE',,'OS2ENVIRONMENT'),'T',';');
PkgVer = PkgVersion(MMBase||'\uniaud32.sys');
if (TestId <> "") then PkgVer = PkgVer || "-" || TestId;
LogFile = TmpDir || HostDate || '-uniaud-' || PkgVer || '.log';
ZipFile = TmpDir || HostDate || '-uniaud-' || PkgVer || '.zip';
rc=SysFileDelete(LogFile);
rc=LINEOUT(LogFile, HeaderLine);
rc=LINEOUT(LogFile, "Test result: " || TestResult);
rc=LINEOUT(LogFile);
rc = DoCommand('bldlevel '||BootDrive||'\os2krnl');
rc = DoCommand('bldlevel '||MMBase||'\uniaud32.sys');
rc = DoCommand('bldlevel '||MMBase||'\uniaud16.sys');
rc = DoCommand('unimix -card');
rc = DoCommand('unimix -list');
rc = DoCommand('unimix -pcms');
rc = DoCommand('unimix -powerget');
rc = DoCommand('type alsahlp$');
rc = DoCommand(PCIEXE);
rc = DoCommand('rmview -irq');
say LogFile||" has been created.";
exit;

DoCommand:
  Cmd = ARG(1);
  Line = OVERLAY(Cmd, BreakLine, 18, 80, '-');
  rc=LINEOUT(LogFile, Line); rc=LINEOUT(LogFile);
  address CMD Cmd||' 1>>'||LogFile||' 2>&1';
  RETURN(0);

PkgVersion:
  File = ARG(1);
  address CMD '@bldlevel '||File||' 2>&1 | rxqueue';
  do while (QUEUED() > 0)
    PARSE PULL Line1':'Line2
    if (Line1 = "File Version") then leave;
    Line2 = "";
  end
  Return(STRIP(Line2,'B'));

