/* $Id: ac97diag.c,v 1.7 2002/10/08 22:59:10 root Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <time.h>

#define INCL_BASE
#define INCL_MCIOS2
#define INCL_OS2MM
#include <os2.h>
#include <os2me.h>

#include "../../contrib/ibm_pci.h"
#include "../../contrib/iopl32.h"
#include "../../8233diag.h"

#pragma pack(1)

#pragma pack()

static char iopl_blurb[]="IOPL switch failed\n";
static int via_codec=0;
static char pdd_name[256];

/* IOCTL descs */

struct fn_desc
{
 int fn;
 char *desc;
};

static struct fn_desc ioctl80[]=
{
 {0x40, "AUDIO_INIT"},
 {0x41, "AUDIO_STATUS"},
 {0x42, "AUDIO_CONTROL"},
 {0x43, "AUDIO_BUFFER"},
 {0x44, "AUDIO_LOAD"},
 {0x45, "AUDIO_WAIT"},
 {0x46, "AUDIO_HPI"},
 {0x48, "AUDIO_CAPABILITY"},
 {0x60, "MIX_GETCONNECTIONS"},     
 {0x61, "MIX_SETCONNECTIONS"},      
 {0x62, "MIX_GETLINEINFO"},         
 {0x63, "MIX_GETCONTROL"},          
 {0x64, "MIX_SETCONTROL"},          
 {-1, NULL}
};

static struct fn_desc ioctl90[]=
{
 {0x40, "MONOINSET"},
 {0x41, "PHONESET"},       
 {0x42, "MICSET"},          
 {0x43, "LINESET"},         
 {0x44, "CDSET"},           
 {0x45, "VIDEOSET"},        
 {0x46, "AUXSET"},          
 {0x4B, "BASSTREBLESET"},   
 {0x4C, "THREEDSET"},       
 {0x4D, "STREAMVOLSET"},    
 {0x4E, "RECORDSRCSET"},    
 {0x4F, "RECORDGAINSET"},   
 {0x60, "MONOINQUERY"},     
 {0x61, "PHONEQUERY"},      
 {0x62, "MICQUERY"},        
 {0x63, "LINEQUERY"},       
 {0x64, "CDQUERY"},         
 {0x65, "VIDEOQUERY"},      
 {0x66, "AUXQUERY"},        
 {0x6B, "BASSTREBLEQUERY"}, 
 {0x6C, "THREEDQUERY"},     
 {0x6D, "STREAMVOLQUERY"},  
 {0x6E, "RECORDSRCQUERY"},  
 {0x6F, "RECORDGAINQUERY"}, 
 {0x80, "APILEVELQUERY"},   
 {0x81, "GETAPIMAP"},       
 {0x82, "CALLBACKREG"},     
 {0x83, "MSGBUF"},
 {0x9F, "Debug communication"},
 {-1, NULL}
};

static struct fn_desc ddcmds[]=
{
 {0, "DDCMD_SETUP"},
 {1, "DDCMD_READ"},          
 {2, "DDCMD_WRITE"},         
 {3, "DDCMD_STATUS"},        
 {4, "DDCMD_CONTROL"},       
 {5, "DDCMD_REG_STREAM"},    
 {6, "DDCMD_DEREG_STREAM"},  
 {-1, NULL}
};

/* Translates a function number to plain-text description */

static char *resolve_desc(int fn, struct fn_desc *ref)
{
 static char rc[256];
 int i;

 for(i=0; ref[i].fn!=-1&&ref[i].fn!=fn; i++)
  ;
 if(ref[i].fn==-1)
  sprintf(rc, "0x%04x:", fn);
 else
  sprintf(rc, "%s:", ref[i].desc);
 return(rc);
}

/* Perform a PCI IOCTL with necessary checks */

static void do_ioctl(HFILE hDevice, PCI_PARM *pciparm, PCI_DATA *pcidata)
{
 USHORT rc;
 ULONG pcbParmLen=sizeof(PCI_PARM), pcbDataLen=sizeof(PCI_DATA);
 
 if(rc=DosDevIOCtl2(hDevice, OEM_CAT, PCI_FUNC, pciparm, sizeof(PCI_PARM),
                    &pcbParmLen, pcidata, sizeof(PCI_DATA), &pcbDataLen))
 {
  switch(rc)
  {
   case 0x86:
    printf("Device not found\n");
    break;
   default:
    printf("IOCtl failed, rc=0x%04x\n", rc);
  }
  DosClose(hDevice);
  exit(1);
 }
}

/* Write a PCI register */

static void write_pci_reg(HFILE hf, PCI_PARM *pparm, unsigned int reg, unsigned char b)
{
 PCI_DATA pd;

 pparm->PCISubFunc=PCI_WRITE_CONFIG;
 pparm->Parm_Write_Config.ConfigReg=reg;
 pparm->Parm_Write_Config.Size=1;
 pparm->Parm_Write_Config.Data=b;
 do_ioctl(hf, pparm, &pd);
}

/* Read a PCI register */

static unsigned char read_pci_reg(HFILE hf, PCI_PARM *pparm, unsigned int reg)
{
 PCI_DATA pd;

 pparm->PCISubFunc=PCI_READ_CONFIG;
 pparm->Parm_Read_Config.ConfigReg=reg;
 pparm->Parm_Read_Config.Size=1;
 do_ioctl(hf, pparm, &pd);
 return(pd.Data_Read_Config.Data&0xFF);
}

/* Read a byte from port */

static unsigned char inpb(unsigned int port)
{
 unsigned char rc;

 enterIOPL32();
 if(getCurrentRing()==3)
 {
  printf(iopl_blurb);
  exit(1);
 }
 __asm{
  mov dx, word ptr port
  in al, dx
  mov rc, al
 }
 leaveIOPL32();
 return(rc);
}

/* Read a word from port */

static unsigned short inpw(unsigned int port)
{
 unsigned short rc;

 enterIOPL32();
 if(getCurrentRing()==3)
 {
  printf(iopl_blurb);
  exit(1);
 }
 __asm{
  mov dx, word ptr port
  in ax, dx
  mov rc, ax
 }
 leaveIOPL32();
 return(rc);
}

/* Read a dword from port */

static unsigned long inpd(unsigned int port)
{
 unsigned long rc;

 enterIOPL32();
 if(getCurrentRing()==3)
 {
  printf(iopl_blurb);
  exit(1);
 }
 __asm{
  mov dx, word ptr port
  in eax, dx
  mov rc, eax
 }
 leaveIOPL32();
 return(rc);
}

/* Write a byte to port */

static void outpb(unsigned int port, unsigned char value)
{
 enterIOPL32();
 if(getCurrentRing()==3)
 {
  printf(iopl_blurb);
  exit(1);
 }
 __asm{
  mov dx, word ptr port
  mov al, value
  out dx, al
 }
 leaveIOPL32();
}

/* Write a word to port */

static void outpw(unsigned int port, unsigned short value)
{
 enterIOPL32();
 if(getCurrentRing()==3)
 {
  printf(iopl_blurb);
  exit(1);
 }
 __asm{
  mov dx, word ptr port
  mov ax, value
  out dx, ax
 }
 leaveIOPL32();
}

/* Write a dword to port */

static void outpd(unsigned int port, unsigned long value)
{
 enterIOPL32();
 if(getCurrentRing()==3)
 {
  printf(iopl_blurb);
  exit(1);
 }
 __asm{
  mov dx, word ptr port
  mov eax, value
  out dx, eax
 }
 leaveIOPL32();
}

/* Read an AC'97 register */

static unsigned short read_ac97(unsigned int base, unsigned int reg)
{
 int j;
 unsigned long t;

 if(inpb(base+0x83)&0xC0)
 {
  outpd(base+0x80, inpd(base+0x80)&0x3FFFFFFF); /* Select primary codec */
  DosSleep(32);
 }
 /* Wait for codec to become accessible */
 t=time(NULL);
 while(inpd(base+0x80)&0x1000000)
 {
  if((time(NULL)-t)>3)
  {
   fprintf(stderr, "AC'97 time-out on bit 24 (preparing to read).\n");
   printf("R-TIMEOUT/");
   break;
  }
 }
 for(j=0; j<5; j++)
 {
  /* Send a command */
  outpd(base+0x80, ((reg)<<16)|0x2800000);
  t=time(NULL);
  /* Wait for validation */
  while((inpd(base+0x80)&(1L<<24))||!(inpd(base+0x80)&(1L<<25)))
  {
   if((time(NULL)-t)>2)
    goto retry;
  }
  return(inpw(base+0x80)); 
  retry:;
 }
 printf("TIMEOUT/");
 return(0xFFFF);
}

/* Write an AC'97 register */

static unsigned short write_ac97(unsigned int base, unsigned int reg, unsigned short data)
{
 int j;
 unsigned long t;

 /* VT1612 deceases at this point, which is obviously a weird behavior */
 if(via_codec&&reg==0x5A)
  return(0);
 if(inpb(base+0x83)&0xC0)
 {
  outpd(base+0x80, inpd(base+0x80)&0x3FFFFFFF); /* Select primary codec */
  DosSleep(32);
 }
 /* Wait for codec to become accessible */
 t=time(NULL);
 while(inpd(base+0x80)&0x1000000)
 {
  if((time(NULL)-t)>3)
  {
   fprintf(stderr, "AC'97 time-out on bit 24 (preparing to write).\n");
   printf("W-TIMEOUT/");
   break;
  }
 }
 for(j=0; j<5; j++)
 {
  /* Send a command */
  outpd(base+0x80, ((reg)<<16)|0x2000000|data);
  t=time(NULL);
  /* Wait for validation */
  while((inpd(base+0x80)&(1L<<24)))
  {
   if((time(NULL)-t)>2)
    goto retry;
  }
  return(0);
  retry:;
 }
 printf("(TIMEOUT)");
 return(1);
}

/* Physical driver name lookup. Derived from LBMix. */

static ULONG get_pdd_name()
{
 ULONG ulRC;
 char szAmpMix[9] = "AMPMIX01";
 MCI_SYSINFO_PARMS SysInfo;
 MCI_SYSINFO_LOGDEVICE SysInfoParm;
 MCI_SYSINFO_QUERY_NAME QueryNameParm;

 strcpy(pdd_name, "VIAUD1$");           /* default */
 memset(&SysInfo, '\0', sizeof(SysInfo));
 memset(&SysInfoParm, '\0', sizeof(SysInfoParm));
 memset(&QueryNameParm, '\0', sizeof(QueryNameParm));
 
 SysInfo.ulItem = MCI_SYSINFO_QUERY_NAMES;
 SysInfo.usDeviceType = MCI_DEVTYPE_WAVEFORM_AUDIO;
 SysInfo.pSysInfoParm = &QueryNameParm;
 
 strcpy(QueryNameParm.szLogicalName, szAmpMix);
 
 ulRC=mciSendCommand(0, MCI_SYSINFO, MCI_SYSINFO_ITEM|MCI_WAIT,
                     (PVOID)&SysInfo, 0);
 if(ulRC!=0)
  return(ulRC);
 
 /* Get PDD associated with our AmpMixer.
    Device name is in pSysInfoParm->szPDDName */
 
 SysInfo.ulItem = MCI_SYSINFO_QUERY_DRIVER;
 SysInfo.usDeviceType = MCI_DEVTYPE_WAVEFORM_AUDIO;
 SysInfo.pSysInfoParm = &SysInfoParm;
 
 strcpy(SysInfoParm.szInstallName, QueryNameParm.szInstallName);
 
 ulRC=mciSendCommand(0, MCI_SYSINFO, MCI_SYSINFO_ITEM|MCI_WAIT,
                     (PVOID) &SysInfo, 0);
 if(ulRC!=0)
  return(ulRC);
 strcpy(pdd_name, SysInfoParm.szPDDName);
 return(ulRC);
}


/* Full diagnostics for the given DD name */

static int dd_diags()
{
 ULONG action;
 HFILE hf;
 USHORT rc;
 ULONG lrc;
 int i;
 struct ac97diag_data d;
 ULONG pcbParmLen=0, pcbDataLen=sizeof(d);

 if(lrc=get_pdd_name())
  printf("MMPM/2 error code: 0x%08lx\n", lrc);
 if(DosOpen(pdd_name, &hf, &action, 0L, FILE_NORMAL,
            OPEN_ACTION_FAIL_IF_NEW|OPEN_ACTION_OPEN_IF_EXISTS,
            OPEN_ACCESS_READONLY|OPEN_SHARE_DENYNONE, 0L))
 {
  printf("Can't open the device driver <%s>!\n", pdd_name);
  return(1);
 }
 rc=DosDevIOCtl2(hf, 0x90, IOCTL90DIAG, NULL, 0, &pcbParmLen, &d, sizeof(d), &pcbDataLen);
 DosClose(hf);
 if(rc)
 {
  switch(rc)
  {
   case 0x86:
    printf("%s: Device not found\n", pdd_name);
    break;
   default:
    printf("%s: IOCtl failed, rc=0x%04x\n", pdd_name, rc);
  }
  return(1);
 }
 printf("Diagnostics structure for device %s\n", pdd_name);
 printf("\n"
        "Initialization\n"
        "==============\n"
        "  Time-out events:         %8lu\n"
        "  Not-ready events:        %8lu\n", d.init_timeouts, d.init_notready);
 printf("\n"
        "IRQ handling\n"
        "============\n"
        "  Hits into IRQ handler:   %8lu\n"
        "  - Routed to playback:    %8lu\n"
        "  - Routed to recording:   %8lu\n"
        "  - Passthrough:           %8lu\n", d.int_hits, d.int_play_hits, d.int_rec_hits,
        d.int_hits-d.int_play_hits-d.int_rec_hits);
 printf("\n"
        "IOCTL handling\n"
        "==============\n");
 printf("** IOCTL80\n");
 for(i=0x40; i<=0x7F; i++)
 {
  if(d.ioctl80[i-0x40])
   printf("   %-22s  %8lu\n", resolve_desc(i, ioctl80), d.ioctl80[i-0x40]);
 }
 printf("\n** IOCTL90\n");
 for(i=0x40; i<=0x9F; i++)
 {
  if(d.ioctl90[i-0x40])
   printf("   %-22s  %8lu\n", resolve_desc(i, ioctl90), d.ioctl90[i-0x40]);
 }
 printf("\n** DDCMD\n");
 for(i=0; i<=0x0F; i++)
 {
  if(d.ddcmd[i])
   printf("   %-22s  %8lu\n", resolve_desc(i, ddcmds), d.ddcmd[i]);
 }
 printf("\n"
        "PCM playback\n"
        "============\n"
        "  Playback events:         %8lu\n"
        "  Total bytes played:      %8lu\n"
        "  Size of last chunk:      %8lu\n"
        "  Bits per sample:         %8u\n"
        "  Channels:                %8u\n"
        "\n"
        "  IOCTL90 app semaphore:     0x%04x\n",
        d.play_events, d.play_total_bytes, d.play_last_bytes, d.play_last_bits,
        d.play_last_chan, d.ioctl90_app_sem);
 printf("\n"
        "Audio codec hardware\n"
        "====================\n");
 for(i=0; i<64; i++)
 {
  if(d.read_timeouts[i]!=0)
   printf("  - %lu READ timeout(s) at register 0x%04x\n", d.read_timeouts[i], i<<1);
  if(d.write_timeouts[i]!=0)
   printf("  - %lu WRITE timeout(s) at register 0x%04x\n", d.write_timeouts[i], i<<1);
 }
 return(0);
}

#define wpci(r, v) write_pci_reg(hf, &pciparm, r, v)
#define rpci(r) read_pci_reg(hf, &pciparm, r)

/* Main routine */

int phys_diags()
{
 ULONG action;
 HFILE hf;
 PCI_PARM pciparm;
 PCI_DATA pcidata;
 int i, j, a;
 unsigned int ioaddr;
 unsigned short v, v1, v2;
 unsigned char c;
 int reset_ok;
 int valid_ac97;

 setbuf(stdout, NULL);
 if(DosOpen(OEMHLP, &hf, &action, 0L, FILE_NORMAL,
            OPEN_ACTION_FAIL_IF_NEW|OPEN_ACTION_OPEN_IF_EXISTS,
            OPEN_ACCESS_READONLY|OPEN_SHARE_DENYNONE, 0L))
 {
  printf("Can't open the Resource Manager!\n");
  return(1);
 }
 pciparm.PCISubFunc=PCI_FIND_DEVICE;
 pciparm.Parm_Find_Dev.DeviceID=0x3059;
 pciparm.Parm_Find_Dev.VendorID=0x1106;
 pciparm.Parm_Find_Dev.Index=0;
 do_ioctl(hf, &pciparm, &pcidata);
 printf("Bus number %u, device number %u, function number %u\n\n", pcidata.Data_Find_Dev.BusNum,
        (pcidata.Data_Find_Dev.DevFunc)>>3, pcidata.Data_Find_Dev.DevFunc&0x07);
 /* Prepare for manipulating the PCI cfg. space */
 pciparm.Parm_Read_Config.BusNum=pcidata.Data_Find_Dev.BusNum;
 pciparm.Parm_Read_Config.DevFunc=pcidata.Data_Find_Dev.DevFunc;
 /* Reset the card */
 if(rpci(0x40)&0x1)
  reset_ok=1;
 else
 {
  wpci(0x41, rpci(0x41)|0xC0);
  DosSleep(32);
  printf("Reset %s\n", (reset_ok=(rpci(0x40)&1))?"OK":"failed");
 }
 if(!reset_ok)
 {
  /* Don't give up. Try various bits to unlock the AC-Link. */
  if(((c=rpci(0x41))&0xC0)!=0xC0)
  {
   c&=0x0C;
   wpci(0x41, c);
   DosSleep(5);
   c|=0xCC;
  }
  else
   c=(c&0xFC)|0x0C;
  wpci(0x41, c);
  for(i=0; i<5; i++)
  {
   if(rpci(0x40)&0x01)
   {
    printf("Heartbeat #1\n");
    reset_ok=1;
    break;
   }
   DosSleep(32);
  }
  if(!reset_ok)
  {
   c=rpci(0x41)&0x0F;
   wpci(0x41, c);
   c|=0xCC;
   wpci(0x41, c);
   for(i=0; i<10; i++)
   {
    if(rpci(0x40)&0x01)
    {
     printf("Heartbeat #2\n");
     reset_ok=1;
     break;
    }
    DosSleep(32);
   }
  }
  if(reset_ok)
   printf("Final reset status: 0x%02x\n", rpci(0x40));
 }
 /* Dump the initial PCI configuration table */
 printf("PCI configuration:\n\n");
 for(i=0; i<16; i++)
 {
  printf("0x%04x: ", i*16);
  for(j=0; j<16; j++)
  {
   if(j>0&&(j%4)==0)
    printf(" -");
   printf(" %02x", rpci(i*16+j));
  }
  printf("\n");
 }
 /* Dump the I/O space */
 ioaddr=(unsigned int)rpci(0x11)<<8;
 printf("\nI/O space at 0x%04x:\n\n", ioaddr);
 for(i=0; i<16; i++)
 {
  printf("0x%04x: ", i*16);
  for(j=0; j<16; j++)
  {
   if(j>0&&(j%4)==0)
    printf(" -");
   printf(" %02x", inpb(ioaddr+i*16+j));
  }
  printf("\n");
 }
 if(!reset_ok)
 {
  printf("AC'97 test cancelled - codec is inaccessible\n");
  DosClose(hf);
  return(1);
 }
 /* Dump the AC'97 registers - 0x22 shows the 3D caps. */
 if(read_ac97(ioaddr, 0x7C)==0x5649&&(read_ac97(ioaddr, 0x7E)&0xFF00)==0x4100)
  via_codec=1;
 printf("\nAC'97 register space:\n\n", ioaddr);
 for(i=0; i<8; i++)
 {
  printf("0x%04x: ", i*16);
  for(j=0; j<16; j+=2)
  {
   if(j>0&&(j%4)==0)
    printf(" -");
   printf(" %04x", read_ac97(ioaddr, i*16+j));
  }
  printf("\n");
 }
 /* Show the bitmap */
 v=read_ac97(ioaddr, 0x20);
 write_ac97(ioaddr, 0x20, 0xFFFF); v1=read_ac97(ioaddr, 0x20);
 write_ac97(ioaddr, 0x20, 0); v2=read_ac97(ioaddr, 0x20);
 write_ac97(ioaddr, 0x20, v);
 printf("\nAC'97 3D enhancement capabilities bitmap/sticky bits: 0x%04x/0x%04x\n", v1^v2, v2);
 v=read_ac97(ioaddr, 0x22);
 write_ac97(ioaddr, 0x22, 0xFFFF); v1=read_ac97(ioaddr, 0x22);
 write_ac97(ioaddr, 0x22, 0); v2=read_ac97(ioaddr, 0x22);
 write_ac97(ioaddr, 0x22, v);
 printf("AC'97 3D enhancement control bitmap/sticky bits: 0x%04x/0x%04x\n", v1^v2, v2);
 /* Try pokeing into the vendor-specific registers */
 printf("\nAC'97 writeable vendor-specific registers\n\n", ioaddr);
 for(i=4; i<8; i++)
 {
  printf("0x%04x: ", i*16);
  for(j=0; j<16; j+=2)
  {
   if(j>0&&(j%4)==0)
    printf(" -");
   a=i*16+j;
   v=read_ac97(ioaddr, a);
   write_ac97(ioaddr, a, 0xFFFF); v1=read_ac97(ioaddr, a);
   write_ac97(ioaddr, a, 0x0000); v2=read_ac97(ioaddr, a);
   write_ac97(ioaddr, a, v);
   printf(" %04x", v1^v2);
  }
  printf("\n");
 }
 /* Finally, screw the PCI configuration space */
 printf("\nPCI space writeable registers\n\n", ioaddr);
 for(i=0; i<16; i++)
 {
  printf("0x%04x: ", i*16);
  for(j=0; j<16; j++)
  {
   if(j>0&&(j%4)==0)
    printf(" -");
   a=i*16+j;
   c=rpci(a);
   wpci(a, 0xFF); v1=rpci(a);
   wpci(a, 0x00); v2=rpci(a);
   printf(" %02x", v1^v2);
   wpci(a, c);
  }
  printf("\n");
 }
 /* Done - reset the soundcard and AC'97 */
 wpci(0x41, rpci(0x41)|0xC0);
 write_ac97(ioaddr, 0, 0);
 fprintf(stderr, "\nDone. Remember that the soundcard is now choked - reboot to\n"
         "unmute the channels.\n");
 DosClose(hf);
 return(0);
}

/* Main routine */

int main()
{
 printf("AC'97 diagnostics facility, built " __DATE__ ", " __TIME__ "\n");
 printf("\n"
        "*********************************\n"
        "*** Device driver diagnostics ***\n"
        "*********************************\n");
 dd_diags();
 printf("\n"
        "***********************************\n"
        "*** Direct hardware diagnostics ***\n"
        "***********************************\n");
 phys_diags();
}
