/*MGA OS/2 PM drivers installation batch file*/

'@ECHO OFF'

Srcdrv = 'A:'
Dstdrv = 'C:'
Windrv = 'C:'
WinExt= 'WOS'	   /* assumes regular WinOS2 */
CurDir=directory()

/********************************************************************/
/* Seach for Installation disk					    */
/********************************************************************/

FileName='A:\OS2\MGA8.DSC'
Ret = stream(FileName, 'C', 'query exists')
if Ret = "" then do
    FileName='B:\OS2\MGA8.DSC'
    Ret = stream(FileName, 'C', 'query exists')
    if Ret = "" then nop
    else Srcdrv = 'B:'
end

/********************************************************************/
/* Seach for OS2 system files and Windows path in PATH environement */
/********************************************************************/

env = 'OS2ENVIRONMENT'
Path = value('PATH',,env)
if Path = '' then signal ENDSEARCH

ntmp = pos(':\OS2;', Path)
if ntmp = 0 then signal ENDSEARCH

Dstdrv=substr(Path, ntmp-1,2)
Windrv=Dstdrv
WinDir=Windrv'\OS2\MDOS\WINOS2'     /* default value */

ntmp = pos(':\OS2\MDOS\WINOS2', Path)
if ntmp > 0 then do
    Windrv=substr(Path, ntmp-1,2)
    WinDir=substr(Path, ntmp-1,18)
    signal ENDSEARCH
end

ntmp = pos(':\WINDOWS', Path)
if ntmp > 0 then do
    Windrv=substr(Path, ntmp-1,2)
    WinDir=substr(Path, ntmp-1,10)
    signal ENDSEARCH
end

ntmp = pos(':\WIN31', Path)
if ntmp > 0 then do
    Windrv=substr(Path, ntmp-1,2)
    WinDir=substr(Path, ntmp-1,8)
    signal ENDSEARCH
end

ENDSEARCH:

/*************/


Parse Arg all
If words(all) < 2 then
    signal resume
else do
    Srcdrv = translate(word(all,1))
    Dstdrv = translate(word(all,2))
    select
	when Srcdrv = 'A:' then nop
	when Srcdrv = 'B:' then nop
	otherwise signal usage
    end
    signal resume
end

RESUME:
cls
say ''
say ''
say 'Source drive will be:' Srcdrv
say 'Destination drive will be:' Dstdrv
say 'Win/OS2 or Windows Directory is:' WinDir
say 'Is the above information correct? (Y/N): Y'
pull answer
if answer = 'N' then signal askdrives

FileName=Srcdrv'\OS2\MGA8.DSC'
Ret = stream(FileName, 'C', 'query exists')
if Ret = "" then signal usage0

FileName=Dstdrv'\OS2KRNL'
'attrib -r -s -h 'FileName
Ret = stream(FileName, 'C', 'query exists')
if Ret = "" then signal usage0
'attrib +h +s +r 'FileName

NewDir=directory(WinDir)

if NewDir=WinDir then do
    test='ok'
    FileName=WinDir'\SYSTEM.INI'
    Ret = stream(FileName, 'C', 'query exists')
    if Ret = "" then test='fail'
    FileName=WinDir'\WIN.COM'
    Ret = stream(FileName, 'C', 'query exists')
    if Ret = "" then test='fail'
end

if test='ok' then signal OK

askagain:

say 'Do you have OS/2 for Windows? (Y/N): N'
pull answer
if answer = 'Y' then do
    say 'Enter directory of Windows 3.1 ('Windrv'\WINDOWS)'
    pull answer
    if answer = '' then WinDir=Windrv'\WINDOWS'
    else WinDir=answer
    if directory(WinDir) = '' then do
	say WinDir ' does not exist'
	say 'Do you want to exit and check again? (Y/N): N'
	pull answer
	if answer = 'Y' then signal end
	else signal askagain
    end
    else WinExt='WIN'	   /* OS2 for Windows*/
end
else do /*(WINOS2)*/
    say 'Did you install WINOS2 on a different drive? (Y/N): Y'
    pull answer
    if answer='N' then do
	say WinDir ' not found but we will install WinOS2 drivers to 'WinDir ' anyway.'
    end
    else do
	say 'Enter drive where WinOS2 was installed ('Windrv')'
	pull answer
	if answer = '' then WinDir=Windrv'\OS2\MDOS\WINOS2'
	else WinDir=answer'\OS2\MDOS\WINOS2'
	if directory(WinDir) = '' then do
	    say WinDir ' does not exist'
	    say 'Do you want to exit and check again? (Y/N): N'
	    pull answer
	    if answer = 'Y' then signal end
	    else signal askagain
	end
    end
end
signal resume

OK:

say 'Source Directory will be 'Srcdrv'\OS2'
say 'Win/OS2 drivers will be installed on 'Windir'\SYSTEM'
say 'Ready to install? (Y/N): Y'
pull answer
if answer = '' then signal OK1
if answer = 'Y' then signal OK1
say 'INSTALLATION ABORT'
signal end

OK1:
say 'PLEASE WAIT ...'

NewDir=directory(Dstdrv'\')             /* go to root off OS/2 drive */

/********************************************/
/* remove any MGA statement from CONFIG.SYS */
/********************************************/

InnF=Dstdrv'\CONFIG.MGA'
OutF=Dstdrv'\CONFIG.SYS'
'copy 'OutF' 'InnF' >nul'
'del 'OutF

do until lines(InnF) = 0
    InStr = linein(InnF)
    select
	when pos('MGAKRNL.SYS', InStr) > 0  then nop
	when pos('VVGA.SYS', InStr) > 0  then nop
	when pos('VSVGA.SYS', InStr) > 0  then nop
	when pos('MGA=', InStr) > 0	    then nop
	when pos('MGARES=', InStr) > 0	    then nop
	when pos('VIO_MGA', InStr) > 0	    then nop
	when pos('RAMBIOS.SYS', InStr) > 0  then nop
	when pos('VMGA.SYS', InStr) > 0     then nop
	otherwise
	do
	    if pos('LIBPATH=', InStr) > 0   then	do
		itmp = pos(':\MGA\OS2', InStr)
		if itmp > 0 then stmp=delstr(InStr, itmp-1, 11)
		else stmp=InStr
		call lineout OutF, stmp
	    end
	    else do
		itmp = pos(':\MGA\OS2', InStr)
		if itmp = 0 then  call lineout OutF, InStr
                end
	end
    end
end

call stream OutF, 'c', 'close'
call stream InnF, 'c', 'close'

/**********************************/
/* add fixvga.exe to AUTOEXEC.BAT */
/**********************************/

InnF=Dstdrv'\AUTOEXEC.MGA'
OutF=Dstdrv'\AUTOEXEC.BAT'
'copy 'OutF' 'InnF' >nul'
'del 'OutF

call lineout OutF, '@ECHO OFF'
call lineout OutF, Dstdrv'\MGA\OS2\FIXVGA.EXE'
call lineout OutF, Dstdrv'\OS2\MODE CO80'
do until lines(InnF) = 0
    InStr = linein(InnF)
    select
	when pos('ECHO OFF', InStr) > 0 	    then nop
	when pos('FIXVGA.EXE', InStr) > 0 then nop
	when pos(':\OS2\MODE CO80', InStr) > 0	    then nop
	otherwise call lineout OutF, InStr
    end
end

call stream OutF, 'c', 'close'
call stream InnF, 'c', 'close'


/**********************************/
/* Call OS/2 Installation process */
/**********************************/

NewDir=directory(Dstdrv'\OS2\INSTALL')
'unpack 'Srcdrv'\OS2\MGAINSTL.DL@ .>nul'
'copy 'Srcdrv'\OS2\MGA8.DSC .>nul'

if WinExt='WOS' then OthExt='WIN'
else                             OthExt='WOS'

'SET WINMGA='WinDir
NewDir=directory(WinDir'\SYSTEM')
'call 'Srcdrv'\OS2\DRVPMI.CMD 'Dstdrv' 'WinDir' 'WinExt' 'OthExt
'SET WINMGA='

signal end

ASKDRIVES:
say 'Enter source drive ('Srcdrv')'
pull answer
if   answer = "" then nop
else Srcdrv = answer
say 'Enter destination drive ('Dstdrv')'
pull answer
if   answer = "" then nop
else Dstdrv = answer
signal askagain

USAGE0:
say 'File' FileName ' does not exist'
USAGE:
say ''
say 'Usage:'
say '   install src: dst:'
say '   Where src is the drive from which you are installing the driver'
say '   and dst is your OS/2 boot drive.'
say 'Example:'
say '   b:install b: d:'
say '   a:install'

end:
call directory CurDir
exit




