/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.comm;

import com.ibm.comm.OS2SerialInputStream;
import com.ibm.comm.OS2SerialNotifyThread;
import com.ibm.comm.OS2SerialOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

public class OS2SerialPort
extends SerialPort {
    private int handle;
    private String Portname = "";
    private int BaudRate;
    private int Parity;
    private int StopBits;
    private int DataBits;
    private int FlowControl = -1;
    private boolean DTR = false;
    private boolean RTS = false;
    private boolean CTS = false;
    private boolean DSR = false;
    private boolean RI = false;
    private boolean CD = false;
    private SerialPortEventListener listener;
    private boolean ReadTimeoutEnabled = false;
    private OS2SerialInputStream is;
    private OS2SerialOutputStream os;
    private OS2SerialNotifyThread notifyThread;
    private boolean bNewData = true;
    public static final int DATA_AVAIL = 1;
    public static final int OUT_EMPTY = 2;
    public static final int ON_CTS = 3;
    public static final int ON_DSR = 4;
    public static final int ON_RI = 5;
    public static final int ON_CD = 6;
    public static final int ON_OVERRUN = 7;
    public static final int PAR_ERROR = 8;
    public static final int FRAME_ERROR = 9;
    public static final int BREAK_INT = 10;

    public OS2SerialPort(String string) {
        super(string);
        this.handle = this._OpenSerialPort(string);
        if (this.handle != 0) {
            this.Portname = string;
            switch (this.DataBits) {
                case 5: {
                    this.DataBits = 5;
                    break;
                }
                case 6: {
                    this.DataBits = 6;
                    break;
                }
                case 7: {
                    this.DataBits = 7;
                    break;
                }
                case 8: {
                    this.DataBits = 8;
                    break;
                }
            }
            switch (this.StopBits) {
                case 0: {
                    this.StopBits = 1;
                    break;
                }
                case 1: {
                    this.StopBits = 3;
                    break;
                }
                case 2: {
                    this.StopBits = 2;
                    break;
                }
            }
            switch (this.Parity) {
                case 0: {
                    this.Parity = 0;
                    return;
                }
                case 1: {
                    this.Parity = 1;
                    return;
                }
                case 2: {
                    this.Parity = 2;
                    return;
                }
                case 3: {
                    this.Parity = 3;
                    return;
                }
                case 4: {
                    this.StopBits = 4;
                    return;
                }
            }
        }
    }

    public int getBaudRate() {
        return this.BaudRate;
    }

    public int getDataBits() {
        return this.DataBits;
    }

    public int getStopBits() {
        return this.StopBits;
    }

    public int getParity() {
        return this.Parity;
    }

    public void sendBreak(int n) {
        this._sendBreak(this.handle, n);
    }

    public void setFlowControlMode(int n) throws UnsupportedCommOperationException {
        int n2 = 0;
        n2 = this._setFlowControlMode(this.handle, n);
        if (n2 == 0) {
            this.FlowControl = n;
            return;
        }
        throw new UnsupportedCommOperationException();
    }

    public int getFlowControlMode() {
        if (this.FlowControl != -1) {
            return this.FlowControl;
        }
        return this._getFlowControlMode(this.handle);
    }

    public void setSerialPortParams(int n, int n2, int n3, int n4) throws UnsupportedCommOperationException {
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        switch (n2) {
            case 5: {
                n6 = 5;
                break;
            }
            case 6: {
                n6 = 6;
                break;
            }
            case 7: {
                n6 = 7;
                break;
            }
            case 8: {
                n6 = 8;
                break;
            }
            default: {
                n6 = 99;
            }
        }
        switch (n3) {
            case 1: {
                n7 = 0;
                break;
            }
            case 3: {
                n7 = 1;
                break;
            }
            case 2: {
                n7 = 2;
                break;
            }
            default: {
                n7 = 99;
            }
        }
        switch (n4) {
            case 0: {
                n8 = 0;
                break;
            }
            case 1: {
                n8 = 1;
                break;
            }
            case 2: {
                n8 = 2;
                break;
            }
            case 3: {
                n8 = 3;
                break;
            }
            case 4: {
                n8 = 4;
                break;
            }
            default: {
                n8 = 99;
            }
        }
        n5 = this._setPortParams(this.handle, n, n6, n7, n8);
        if (n5 != 0) {
            throw new UnsupportedCommOperationException();
        }
        this.BaudRate = n;
        this.Parity = n4;
        this.StopBits = n3;
        this.DataBits = n2;
    }

    public void setDTR(boolean bl) {
        this._setDTR(this.handle, bl);
    }

    public void setRTS(boolean bl) {
        this._setRTS(this.handle, bl);
    }

    public boolean isRTS() {
        this._setPortValues(this.handle);
        return this.RTS;
    }

    public boolean isCTS() {
        this._setPortValues(this.handle);
        return this.CTS;
    }

    public boolean isDSR() {
        this._setPortValues(this.handle);
        return this.DSR;
    }

    public boolean isRI() {
        this._setPortValues(this.handle);
        return this.RI;
    }

    public boolean isCD() {
        this._setPortValues(this.handle);
        return this.CD;
    }

    public boolean isDTR() {
        this._setPortValues(this.handle);
        return this.DTR;
    }

    public void addEventListener(SerialPortEventListener serialPortEventListener) throws TooManyListenersException {
        if (this.listener == null) {
            this.listener = serialPortEventListener;
            this.notifyThread = new OS2SerialNotifyThread(this, this.handle, serialPortEventListener);
            this.notifyThread.setPriority(1);
            this.notifyThread.start();
            return;
        }
        if (this.listener != serialPortEventListener) {
            throw new TooManyListenersException();
        }
    }

    public void removeEventListener() {
        this.listener = null;
        if (this.notifyThread != null) {
            this.notifyThread.setStopFlag();
            this.notifyThread.stop();
            this.notifyThread = null;
        }
    }

    public void notifyOnDataAvailable(boolean bl) {
        if (this.listener != null) {
            this.notifyThread.AddNotify(1, bl);
        }
    }

    public void notifyOnOutputEmpty(boolean bl) {
        if (this.listener != null) {
            this.notifyThread.AddNotify(2, bl);
        }
    }

    public void notifyOnCTS(boolean bl) {
        if (this.listener != null) {
            this.notifyThread.AddNotify(3, bl);
        }
    }

    public void notifyOnDSR(boolean bl) {
        if (this.listener != null) {
            this.notifyThread.AddNotify(4, bl);
        }
    }

    public void notifyOnRingIndicator(boolean bl) {
        if (this.listener != null) {
            this.notifyThread.AddNotify(5, bl);
        }
    }

    public void notifyOnCarrierDetect(boolean bl) {
        if (this.listener != null) {
            this.notifyThread.AddNotify(6, bl);
        }
    }

    public void notifyOnOverrunError(boolean bl) {
        if (this.listener != null) {
            this.notifyThread.AddNotify(7, bl);
        }
    }

    public void notifyOnParityError(boolean bl) {
        if (this.listener != null) {
            this.notifyThread.AddNotify(8, bl);
        }
    }

    public void notifyOnFramingError(boolean bl) {
        if (this.listener != null) {
            this.notifyThread.AddNotify(9, bl);
        }
    }

    public void notifyOnBreakInterrupt(boolean bl) {
        if (this.listener != null) {
            this.notifyThread.AddNotify(10, bl);
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.is == null) {
            this.is = new OS2SerialInputStream(this, this.handle);
        }
        return this.is;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.os == null) {
            this.os = new OS2SerialOutputStream(this.handle);
        }
        return this.os;
    }

    public void enableReceiveTimeout(int n) throws UnsupportedCommOperationException {
        this._enableReceiveTimeout(n, this.handle);
    }

    public void disableReceiveTimeout() {
        this._disableReceiveTimeout(this.handle);
    }

    public boolean isReceiveTimeoutEnabled() {
        return this.ReadTimeoutEnabled;
    }

    public int getReceiveTimeout() {
        return this._getReceiveTimeout(this.handle);
    }

    public int getInputBufferSize() {
        return this._getInputBufferSize(this.handle);
    }

    public int getOutputBufferSize() {
        return this._getOutputBufferSize(this.handle);
    }

    public void close() {
        this._close(this.handle);
        if (this.os != null) {
            try {
                this.os.close();
                this.os = null;
            }
            catch (IOException iOException) {}
        }
        if (this.is != null) {
            try {
                this.is.close();
                this.is = null;
            }
            catch (IOException iOException) {}
        }
        if (this.notifyThread != null) {
            this.notifyThread.setStopFlag();
            this.notifyThread.stop();
        }
        super.close();
    }

    public boolean QueryNewData() {
        return this.bNewData;
    }

    public void SetNewData(boolean bl) {
        this.bNewData = bl;
    }

    public void setPortValues() {
        this._setPortValues(this.handle);
    }

    public void setRcvFifoTrigger(int n) {
    }

    public void enableReceiveThreshold(int n) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException();
    }

    public void disableReceiveThreshold() {
    }

    public boolean isReceiveThresholdEnabled() {
        return false;
    }

    public void enableReceiveFraming(int n) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException();
    }

    public void disableReceiveFraming() {
    }

    public boolean isReceiveFramingEnabled() {
        return false;
    }

    public int getReceiveFramingByte() {
        return 0;
    }

    public int getReceiveThreshold() {
        return 0;
    }

    public void setOutputBufferSize(int n) {
    }

    public void setInputBufferSize(int n) {
    }

    private native int _OpenSerialPort(String var1);

    private native int _setFlowControlMode(int var1, int var2);

    private native int _getFlowControlMode(int var1);

    private native int _setPortParams(int var1, int var2, int var3, int var4, int var5);

    private native void _sendBreak(int var1, int var2);

    private native int _setDTR(int var1, boolean var2);

    private native int _setRTS(int var1, boolean var2);

    private native int _enableReceiveTimeout(int var1, int var2);

    private native int _disableReceiveTimeout(int var1);

    private native int _getReceiveTimeout(int var1);

    private native int _getInputBufferSize(int var1);

    private native int _getOutputBufferSize(int var1);

    private native void _close(int var1);

    private native void _setPortValues(int var1);
}

