/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.java.io;

import com.ibm.security12.java.io.FilePermissionCollection;
import com.ibm.security12.java.security.AccessController;
import com.ibm.security12.java.security.Permission;
import com.ibm.security12.java.security.PermissionCollection;
import com.ibm.security12.java.security.PrivilegedAction;
import com.ibm.security12.sun.security.action.GetPropertyAction;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class FilePermission
extends Permission
implements Serializable {
    static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private static final int EXECUTE = 1;
    private static final int WRITE = 2;
    private static final int READ = 4;
    private static final int DELETE = 8;
    private static final int ALL = 15;
    private static final int NONE = 0;
    private transient int mask;
    private transient boolean directory;
    private transient boolean recursive;
    private String actions;
    private transient String cpath;
    private static final String RECURSIVE = "-";
    private static final String WILD = "*";
    private static final String SEP_RECURSIVE = String.valueOf(File.separator) + "-";
    private static final String SEP_WILD = String.valueOf(File.separator) + "*";

    private void init(int n) {
        if ((n & 0xF) != n) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        if (n == 0) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        if (this.getName() == null) {
            throw new IllegalArgumentException("name can't be null");
        }
        this.mask = n;
        this.cpath = this.getName();
        if (this.cpath.equals("<<ALL FILES>>")) {
            this.directory = true;
            this.recursive = true;
            this.cpath = "";
            return;
        }
        if (this.cpath.endsWith(SEP_RECURSIVE) || this.cpath.equals(RECURSIVE)) {
            this.directory = true;
            this.recursive = true;
            this.cpath = this.cpath.substring(0, this.cpath.length() - 1);
        } else if (this.cpath.endsWith(SEP_WILD) || this.cpath.equals(WILD)) {
            this.directory = true;
            this.cpath = this.cpath.substring(0, this.cpath.length() - 1);
        }
        if (this.cpath.equals("")) {
            this.cpath = (String)AccessController.doPrivileged(new GetPropertyAction("user.dir"));
        }
        this.cpath = (String)AccessController.doPrivileged(new 1());
    }

    public FilePermission(String string, String string2) {
        super(string);
        this.init(FilePermission.getMask(string2));
    }

    FilePermission(String string, int n) {
        super(string);
        this.init(n);
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof FilePermission)) {
            return false;
        }
        FilePermission filePermission = (FilePermission)permission;
        return (this.mask & filePermission.mask) == filePermission.mask && this.impliesIgnoreMask(filePermission);
    }

    boolean impliesIgnoreMask(FilePermission filePermission) {
        if (this.directory) {
            if (this.recursive) {
                if (filePermission.directory) {
                    return filePermission.cpath.length() >= this.cpath.length() && filePermission.cpath.startsWith(this.cpath);
                }
                return filePermission.cpath.length() > this.cpath.length() && filePermission.cpath.startsWith(this.cpath);
            }
            if (filePermission.directory) {
                if (filePermission.recursive) {
                    return false;
                }
                return this.cpath.equals(filePermission.cpath);
            }
            int n = filePermission.cpath.lastIndexOf(File.separatorChar);
            if (n == -1) {
                return false;
            }
            String string = filePermission.cpath.substring(0, n + 1);
            return this.cpath.equals(string);
        }
        return this.cpath.equals(filePermission.cpath);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FilePermission)) {
            return false;
        }
        FilePermission filePermission = (FilePermission)object;
        return this.mask == filePermission.mask && this.cpath.equals(filePermission.cpath) && this.directory == filePermission.directory && this.recursive == filePermission.recursive;
    }

    public int hashCode() {
        return this.cpath.hashCode();
    }

    /*
     * Unable to fully structure code
     */
    private static int getMask(String var0) {
        var1_1 = 0;
        if (var0 == null) {
            return var1_1;
        }
        var2_2 = var0.toCharArray();
        var3_3 = var2_2.length - 1;
        if (var3_3 >= 0) ** GOTO lbl40
        return var1_1;
        {
            --var3_3;
            do {
                if (var3_3 != -1 && ((var4_4 = var2_2[var3_3]) == ' ' || var4_4 == '\r' || var4_4 == '\n' || var4_4 == '\f' || var4_4 == '\t')) continue block4;
                if (!(var3_3 < 3 || var2_2[var3_3 - 3] != 'r' && var2_2[var3_3 - 3] != 'R' || var2_2[var3_3 - 2] != 'e' && var2_2[var3_3 - 2] != 'E' || var2_2[var3_3 - 1] != 'a' && var2_2[var3_3 - 1] != 'A' || var2_2[var3_3] != 'd' && var2_2[var3_3] != 'D')) {
                    var5_5 = 4;
                    var1_1 |= 4;
                } else if (!(var3_3 < 4 || var2_2[var3_3 - 4] != 'w' && var2_2[var3_3 - 4] != 'W' || var2_2[var3_3 - 3] != 'r' && var2_2[var3_3 - 3] != 'R' || var2_2[var3_3 - 2] != 'i' && var2_2[var3_3 - 2] != 'I' || var2_2[var3_3 - 1] != 't' && var2_2[var3_3 - 1] != 'T' || var2_2[var3_3] != 'e' && var2_2[var3_3] != 'E')) {
                    var5_5 = 5;
                    var1_1 |= 2;
                } else if (!(var3_3 < 6 || var2_2[var3_3 - 6] != 'e' && var2_2[var3_3 - 6] != 'E' || var2_2[var3_3 - 5] != 'x' && var2_2[var3_3 - 5] != 'X' || var2_2[var3_3 - 4] != 'e' && var2_2[var3_3 - 4] != 'E' || var2_2[var3_3 - 3] != 'c' && var2_2[var3_3 - 3] != 'C' || var2_2[var3_3 - 2] != 'u' && var2_2[var3_3 - 2] != 'U' || var2_2[var3_3 - 1] != 't' && var2_2[var3_3 - 1] != 'T' || var2_2[var3_3] != 'e' && var2_2[var3_3] != 'E')) {
                    var5_5 = 7;
                    var1_1 |= 1;
                } else if (!(var3_3 < 5 || var2_2[var3_3 - 5] != 'd' && var2_2[var3_3 - 5] != 'D' || var2_2[var3_3 - 4] != 'e' && var2_2[var3_3 - 4] != 'E' || var2_2[var3_3 - 3] != 'l' && var2_2[var3_3 - 3] != 'L' || var2_2[var3_3 - 2] != 'e' && var2_2[var3_3 - 2] != 'E' || var2_2[var3_3 - 1] != 't' && var2_2[var3_3 - 1] != 'T' || var2_2[var3_3] != 'e' && var2_2[var3_3] != 'E')) {
                    var5_5 = 6;
                    var1_1 |= 8;
                } else {
                    throw new IllegalArgumentException("invalid permission: " + var0);
                }
                var6_6 = false;
                while (var3_3 >= var5_5 && !var6_6) {
                    switch (var2_2[var3_3 - var5_5]) {
                        case ',': {
                            var6_6 = true;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid permission: " + var0);
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': 
                    }
                    --var3_3;
                }
                var3_3 -= var5_5;
lbl40:
                // 2 sources

            } while (var3_3 != -1);
        }
        return var1_1;
    }

    int getMask() {
        return this.mask;
    }

    private static String getActions(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if ((n & 4) == 4) {
            bl = true;
            stringBuffer.append("read");
        }
        if ((n & 2) == 2) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = true;
            }
            stringBuffer.append("write");
        }
        if ((n & 1) == 1) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = true;
            }
            stringBuffer.append("execute");
        }
        if ((n & 8) == 8) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = true;
            }
            stringBuffer.append("delete");
        }
        return stringBuffer.toString();
    }

    public String getActions() {
        if (this.actions == null) {
            this.actions = FilePermission.getActions(this.mask);
        }
        return this.actions;
    }

    public PermissionCollection newPermissionCollection() {
        return new FilePermissionCollection();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(FilePermission.getMask(this.actions));
    }

    private final class 1
    implements PrivilegedAction {
        public Object run() {
            try {
                File file = new File(FilePermission.this.cpath);
                String string = file.getCanonicalPath();
                if (FilePermission.this.directory && !string.endsWith(File.separator)) {
                    return String.valueOf(string) + File.separator;
                }
                return string;
            }
            catch (IOException iOException) {
                return FilePermission.this.cpath;
            }
        }

        /* synthetic */ 1() {
        }
    }
}

