/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.java.lang;

import com.ibm.security12.java.lang.ClassLoader12;
import com.ibm.security12.java.security.AccessController;
import com.ibm.security12.java.security.PrivilegedAction;
import com.ibm.security12.java.util.HashMap;
import com.ibm.security12.java.util.Iterator;
import com.ibm.security12.java.util.Map;
import com.ibm.security12.java.util.jar.Attributes;
import com.ibm.security12.java.util.jar.Manifest;
import com.ibm.security12.sun.misc.Resource;
import com.ibm.security12.sun.misc.URLClassPath;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class Package {
    private static Map systemPackageMap;
    private String pkgName;
    private String specTitle;
    private String specVersion;
    private String specVendor;
    private String implTitle;
    private String implVersion;
    private String implVendor;
    private URL sealBase;

    public String getName() {
        return this.pkgName;
    }

    public String getSpecificationTitle() {
        return this.specTitle;
    }

    public String getSpecificationVersion() {
        return this.specVersion;
    }

    public String getSpecificationVendor() {
        return this.specVendor;
    }

    public String getImplementationTitle() {
        return this.implTitle;
    }

    public String getImplementationVersion() {
        return this.implVersion;
    }

    public String getImplementationVendor() {
        return this.implVendor;
    }

    public boolean isSealed() {
        return this.sealBase != null;
    }

    public boolean isSealed(URL uRL) {
        return uRL.equals(this.sealBase);
    }

    public boolean isCompatibleWith(String string) throws NumberFormatException {
        if (this.specVersion == null || this.specVersion.length() < 1) {
            throw new NumberFormatException("Empty version string");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        StringTokenizer stringTokenizer2 = new StringTokenizer(this.specVersion, ".", true);
        while (stringTokenizer.hasMoreTokens() || stringTokenizer2.hasMoreTokens()) {
            int n = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 0;
            int n2 = stringTokenizer2.hasMoreTokens() ? Integer.parseInt(stringTokenizer2.nextToken()) : 0;
            if (n2 < n) {
                return false;
            }
            if (n2 > n) {
                return true;
            }
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
            if (!stringTokenizer2.hasMoreTokens()) continue;
            stringTokenizer2.nextToken();
        }
        return true;
    }

    public static Package getPackage(String string) {
        ClassLoader12 classLoader12 = ClassLoader12.getCallerClassLoader();
        if (classLoader12 != null) {
            return classLoader12.getPackage(string);
        }
        return Package.getSystemPackage(string);
    }

    public static Package[] getPackages() {
        ClassLoader12 classLoader12 = ClassLoader12.getCallerClassLoader();
        if (classLoader12 != null) {
            return classLoader12.getPackages();
        }
        return Package.getSystemPackages();
    }

    static Package getPackage(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(0, n);
            ClassLoader12 classLoader12 = (ClassLoader12)clazz.getClassLoader();
            if (classLoader12 != null) {
                return classLoader12.getPackage(string);
            }
            return Package.getSystemPackage(string);
        }
        return null;
    }

    public int hashCode() {
        return this.pkgName.hashCode();
    }

    public String toString() {
        String string = this.specTitle;
        String string2 = this.specVersion;
        string = string != null && string.length() > 0 ? ", " + string : "";
        string2 = string2 != null && string2.length() > 0 ? ", version " + string2 : "";
        return "package " + this.pkgName + string + string2;
    }

    Package(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) {
        this.pkgName = string;
        this.implTitle = string5;
        this.implVersion = string6;
        this.implVendor = string7;
        this.specTitle = string2;
        this.specVersion = string3;
        this.specVendor = string4;
        this.sealBase = uRL;
    }

    private Package(String string, Manifest manifest, URL uRL) {
        String string2 = string.replace('.', '/').concat("/");
        String string3 = null;
        Attributes attributes = manifest.getAttributes(string2);
        if (attributes != null) {
            this.specTitle = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            this.specVersion = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            this.specVendor = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            this.implTitle = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            this.implVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            this.implVendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        if ((attributes = manifest.getMainAttributes()) != null) {
            if (this.specTitle == null) {
                this.specTitle = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (this.specVersion == null) {
                this.specVersion = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (this.specVendor == null) {
                this.specVendor = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (this.implTitle == null) {
                this.implTitle = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (this.implVersion == null) {
                this.implVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (this.implVendor == null) {
                this.implVendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (string3 == null) {
                string3 = attributes.getValue(Attributes.Name.SEALED);
            }
        }
        if ("true".equalsIgnoreCase(string3)) {
            this.sealBase = uRL;
        }
        this.pkgName = string;
    }

    static Package getSystemPackage(String string) {
        return (Package)Package.getSystemPackageMap().get(string);
    }

    static Package[] getSystemPackages() {
        Map map = Package.getSystemPackageMap();
        return (Package[])map.values().toArray(new Package[map.size()]);
    }

    static synchronized Map getSystemPackageMap() {
        if (systemPackageMap == null) {
            systemPackageMap = (Map)AccessController.doPrivileged(new 1());
        }
        return systemPackageMap;
    }

    private static void definePackages(Resource resource, Map map) {
        URL uRL = null;
        Manifest manifest = null;
        try {
            manifest = resource.getManifest();
        }
        catch (IOException iOException) {}
        String string = null;
        Attributes attributes = manifest.getMainAttributes();
        String string2 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
        String string3 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
        String string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
        String string5 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
        String string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        String string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
        String string8 = attributes.getValue(Attributes.Name.SEALED);
        Map map2 = manifest.getEntries();
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            String string9 = null;
            String string10 = null;
            String string11 = null;
            String string12 = null;
            String string13 = null;
            String string14 = null;
            string = null;
            Map.Entry entry = (Map.Entry)iterator.next();
            String string15 = (String)entry.getKey();
            if (string15 == null || !string15.endsWith("/")) continue;
            if (map.get(string15 = string15.substring(0, string15.length() - 1).replace('/', '.')) == null) {
                Attributes attributes2 = (Attributes)entry.getValue();
                string9 = attributes2.getValue(Attributes.Name.SPECIFICATION_TITLE);
                string10 = attributes2.getValue(Attributes.Name.SPECIFICATION_VERSION);
                string11 = attributes2.getValue(Attributes.Name.SPECIFICATION_VENDOR);
                string12 = attributes2.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                string13 = attributes2.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                string14 = attributes2.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                string = attributes2.getValue(Attributes.Name.SEALED);
                if (string9 == null) {
                    string9 = string2;
                }
                if (string10 == null) {
                    string10 = string3;
                }
                if (string11 == null) {
                    string11 = string4;
                }
                if (string12 == null) {
                    string12 = string5;
                }
                if (string13 == null) {
                    string13 = string6;
                }
                if (string14 == null) {
                    string14 = string7;
                }
                if (string == null) {
                    string = string8;
                }
            }
            map.put(string15, new Package(string15, string9, string10, string11, string12, string13, string14, uRL));
        }
    }

    private final class 1
    implements PrivilegedAction {
        public Object run() {
            HashMap hashMap = new HashMap(31);
            URLClassPath uRLClassPath = ClassLoader12.getBootstrapClassPath();
            Enumeration enumeration = uRLClassPath.getResources(null, false);
            while (enumeration.hasMoreElements()) {
                Resource resource = (Resource)enumeration.nextElement();
                Package.definePackages(resource, hashMap);
            }
            return hashMap;
        }

        /* synthetic */ 1() {
        }
    }
}

