/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.java.security;

import com.ibm.security12.java.security.MessageDigestSpi;
import com.ibm.security12.java.security.Provider;
import com.ibm.security12.java.security.Security;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.security.DigestException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public abstract class MessageDigest
extends MessageDigestSpi {
    private String algorithm;
    private static final int INITIAL = 0;
    private static final int IN_PROGRESS = 1;
    private int state = 0;
    Provider provider;

    protected MessageDigest(String string) {
        this.algorithm = string;
    }

    public static MessageDigest getInstance(String string) throws NoSuchAlgorithmException {
        try {
            Object[] objectArray = Security.getImpl(string, "MessageDigest", null);
            if (objectArray[0] instanceof MessageDigest) {
                MessageDigest messageDigest = (MessageDigest)objectArray[0];
                messageDigest.provider = (Provider)objectArray[1];
                return messageDigest;
            }
            Delegate delegate = new Delegate((MessageDigestSpi)objectArray[0], string);
            delegate.provider = (Provider)objectArray[1];
            return delegate;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(String.valueOf(string) + " not found");
        }
    }

    public static MessageDigest getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objectArray = Security.getImpl(string, "MessageDigest", string2);
        if (objectArray[0] instanceof MessageDigest) {
            MessageDigest messageDigest = (MessageDigest)objectArray[0];
            messageDigest.provider = (Provider)objectArray[1];
            return messageDigest;
        }
        Delegate delegate = new Delegate((MessageDigestSpi)objectArray[0], string);
        delegate.provider = (Provider)objectArray[1];
        return delegate;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void update(byte by) {
        this.engineUpdate(by);
        this.state = 1;
    }

    public void update(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new IllegalArgumentException("No input buffer given");
        }
        if (byArray.length - n < n2) {
            throw new IllegalArgumentException("Input buffer too short");
        }
        this.engineUpdate(byArray, n, n2);
        this.state = 1;
    }

    public void update(byte[] byArray) {
        this.engineUpdate(byArray, 0, byArray.length);
        this.state = 1;
    }

    public byte[] digest() {
        byte[] byArray = this.engineDigest();
        this.state = 0;
        return byArray;
    }

    public int digest(byte[] byArray, int n, int n2) throws DigestException {
        if (byArray == null) {
            throw new IllegalArgumentException("No output buffer given");
        }
        if (byArray.length - n < n2) {
            throw new IllegalArgumentException("Output buffer too small for specified offset and length");
        }
        int n3 = this.engineDigest(byArray, n, n2);
        this.state = 0;
        return n3;
    }

    public byte[] digest(byte[] byArray) {
        this.update(byArray);
        return this.digest();
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        printStream.print(String.valueOf(this.algorithm) + " Message Digest from " + this.provider.getName() + ", ");
        switch (this.state) {
            case 0: {
                printStream.print("<initialized>");
                break;
            }
            case 1: {
                printStream.print("<in progress>");
                break;
            }
        }
        printStream.println();
        return byteArrayOutputStream.toString();
    }

    public static boolean isEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void reset() {
        this.engineReset();
        this.state = 0;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final int getDigestLength() {
        int n = this.engineGetDigestLength();
        if (n == 0) {
            try {
                MessageDigest messageDigest = (MessageDigest)this.clone();
                byte[] byArray = messageDigest.digest();
                return byArray.length;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return n;
            }
        }
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }

    static class Delegate
    extends MessageDigest {
        private MessageDigestSpi digestSpi;

        public Delegate(MessageDigestSpi messageDigestSpi, String string) {
            super(string);
            this.digestSpi = messageDigestSpi;
        }

        public Object clone() throws CloneNotSupportedException {
            if (this.digestSpi instanceof Cloneable) {
                MessageDigestSpi messageDigestSpi = (MessageDigestSpi)this.digestSpi.clone();
                Delegate delegate = new Delegate(messageDigestSpi, ((MessageDigest)this).algorithm);
                delegate.provider = this.provider;
                ((MessageDigest)delegate).state = ((MessageDigest)this).state;
                return delegate;
            }
            throw new CloneNotSupportedException();
        }

        protected int engineGetDigestLength() {
            return this.digestSpi.engineGetDigestLength();
        }

        protected void engineUpdate(byte by) {
            this.digestSpi.engineUpdate(by);
        }

        protected void engineUpdate(byte[] byArray, int n, int n2) {
            this.digestSpi.engineUpdate(byArray, n, n2);
        }

        protected byte[] engineDigest() {
            return this.digestSpi.engineDigest();
        }

        protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
            return this.digestSpi.engineDigest(byArray, n, n2);
        }

        protected void engineReset() {
            this.digestSpi.engineReset();
        }
    }
}

