/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.java.security;

import com.ibm.security12.java.security.AllPermission;
import com.ibm.security12.java.security.Permission;
import com.ibm.security12.java.security.PermissionCollection;
import com.ibm.security12.java.security.PermissionsEnumerator;
import com.ibm.security12.java.security.PermissionsHash;
import com.ibm.security12.java.security.UnresolvedPermission;
import com.ibm.security12.java.security.UnresolvedPermissionCollection;
import com.ibm.security12.java.security.cert.Certificate;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class Permissions
extends PermissionCollection
implements Serializable {
    static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private Hashtable perms = new Hashtable(11);
    private PermissionCollection allPermission = null;
    static /* synthetic */ Class class$com$ibm$security12$java$security$UnresolvedPermission;

    public void add(Permission permission) {
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly Permissions object");
        }
        PermissionCollection permissionCollection = this.getPermissionCollection(permission);
        permissionCollection.add(permission);
        if (permission instanceof AllPermission) {
            this.allPermission = permissionCollection;
        }
    }

    public boolean implies(Permission permission) {
        PermissionCollection permissionCollection = this.getPermissionCollection(permission);
        if (this.allPermission != null && this.allPermission.implies(permission)) {
            return true;
        }
        return permissionCollection.implies(permission);
    }

    public Enumeration elements() {
        return new PermissionsEnumerator(this.perms.elements());
    }

    private Enumeration elements(Permission permission) {
        PermissionCollection permissionCollection = this.getPermissionCollection(permission);
        return permissionCollection.elements();
    }

    private PermissionCollection getPermissionCollection(Permission permission) {
        Class<?> clazz = permission.getClass();
        PermissionCollection permissionCollection = (PermissionCollection)this.perms.get(clazz);
        if (permissionCollection == null) {
            Hashtable hashtable = this.perms;
            synchronized (hashtable) {
                permissionCollection = (PermissionCollection)this.perms.get(clazz);
                if (permissionCollection == null && (permissionCollection = this.getUnresolvedPermissions(permission)) == null && (permissionCollection = permission.newPermissionCollection()) == null) {
                    permissionCollection = new PermissionsHash();
                }
                this.perms.put(clazz, permissionCollection);
            }
        }
        return permissionCollection;
    }

    private PermissionCollection getUnresolvedPermissions(Permission permission) {
        UnresolvedPermissionCollection unresolvedPermissionCollection = (UnresolvedPermissionCollection)this.perms.get(class$com$ibm$security12$java$security$UnresolvedPermission != null ? class$com$ibm$security12$java$security$UnresolvedPermission : (class$com$ibm$security12$java$security$UnresolvedPermission = Permissions.class$("com.ibm.security12.java.security.UnresolvedPermission")));
        if (unresolvedPermissionCollection == null) {
            return null;
        }
        Vector vector = unresolvedPermissionCollection.getUnresolvedPermissions(permission);
        if (vector == null) {
            return null;
        }
        Certificate[] certificateArray = null;
        Object[] objectArray = permission.getClass().getSigners();
        int n = 0;
        if (objectArray != null) {
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (objectArray[n2] instanceof Certificate) {
                    ++n;
                }
                ++n2;
            }
            certificateArray = new Certificate[n];
            n = 0;
            int n3 = 0;
            while (n3 < objectArray.length) {
                if (objectArray[n3] instanceof Certificate) {
                    certificateArray[n] = (Certificate)objectArray[n3];
                }
                ++n3;
            }
        }
        PermissionCollection permissionCollection = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UnresolvedPermission unresolvedPermission = (UnresolvedPermission)enumeration.nextElement();
            Permission permission2 = unresolvedPermission.resolve(permission, certificateArray);
            if (permission2 == null) continue;
            if (permissionCollection == null && (permissionCollection = permission.newPermissionCollection()) == null) {
                permissionCollection = new PermissionsHash();
            }
            permissionCollection.add(permission2);
        }
        return permissionCollection;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

