/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.java.security;

import com.ibm.security12.java.lang.SecurityManager12;
import com.ibm.security12.java.security.AccessController;
import com.ibm.security12.java.security.PrivilegedAction;
import com.ibm.security12.java.security.Provider;
import com.ibm.security12.java.security.SecurityPermission;
import com.ibm.security12.sun.misc.Launcher;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public final class Security {
    private static boolean reloadProviders;
    static final boolean debug = false;
    static final boolean error = true;
    private static Properties props;
    private static Vector providers;
    private static Hashtable providerPropertiesCache;
    private static Hashtable engineCache;

    private static void initialize() {
        props = new Properties();
        providers = new Vector();
        providerPropertiesCache = new Hashtable();
        engineCache = new Hashtable();
        File file = Security.securityPropFile("java.sec");
        if (!file.exists()) {
            System.err.println("security properties not found. using defaults.");
            Security.initializeStatic();
        } else {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                props.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
            }
            catch (IOException iOException) {
                Security.error("could not load security properties file from " + file + ". using defaults.");
                Security.initializeStatic();
            }
        }
        Security.loadProviders();
    }

    private static void initializeStatic() {
        ((Hashtable)props).put("security.provider.1", "sun.security.provider.Sun");
        ((Hashtable)props).put("security.provider.2", "com.ibm.security12.sun.security.provider.Sun");
    }

    private Security() {
    }

    private static synchronized void loadProviders() {
        int n = 1;
        Launcher launcher = Launcher.getLauncher();
        String string;
        while ((string = props.getProperty("security.provider." + n++)) != null) {
            Provider provider = Provider.loadProvider(string);
            if (provider != null) {
                providers.addElement(provider);
                continue;
            }
            if (launcher != null) continue;
            reloadProviders = true;
        }
        return;
    }

    private static synchronized void reloadProviders() {
        Launcher launcher;
        if (reloadProviders && (launcher = Launcher.getLauncher()) != null) {
            String string;
            reloadProviders = false;
            providers.removeAllElements();
            int n = 1;
            while ((string = props.getProperty("security.provider." + n++)) != null) {
                Provider provider = (Provider)AccessController.doPrivileged(new 2(string));
                if (provider == null) continue;
                providers.addElement(provider);
            }
            providerPropertiesCache.clear();
            engineCache.clear();
        }
    }

    private static File securityPropFile(String string) {
        String string2 = File.separator;
        return new File(String.valueOf(System.getProperty("java.home")) + string2 + "lib" + string2 + "security" + string2 + string);
    }

    private static ProviderProperty getProviderProperty(String string) {
        ProviderProperty providerProperty = (ProviderProperty)providerPropertiesCache.get(string);
        if (providerProperty != null) {
            return providerProperty;
        }
        int n = 0;
        while (n < providers.size()) {
            Object object;
            String string2 = null;
            Provider provider = (Provider)providers.elementAt(n);
            String string3 = provider.getProperty(string);
            if (string3 == null) {
                object = ((Hashtable)provider).keys();
                while (object.hasMoreElements() && string3 == null) {
                    string2 = (String)object.nextElement();
                    if (!string.equalsIgnoreCase(string2)) continue;
                    string3 = provider.getProperty(string2);
                    break;
                }
            }
            if (string3 != null) {
                object = new ProviderProperty();
                ((ProviderProperty)object).className = string3;
                ((ProviderProperty)object).provider = provider;
                providerPropertiesCache.put(string, object);
                if (string2 != null) {
                    providerPropertiesCache.put(string2, object);
                }
                return object;
            }
            ++n;
        }
        return providerProperty;
    }

    private static String getProviderProperty(String string, Provider provider) {
        String string2 = provider.getProperty(string);
        if (string2 == null) {
            Enumeration enumeration = ((Hashtable)provider).keys();
            while (enumeration.hasMoreElements() && string2 == null) {
                String string3 = (String)enumeration.nextElement();
                if (!string.equalsIgnoreCase(string3)) continue;
                string2 = provider.getProperty(string3);
                break;
            }
        }
        return string2;
    }

    private static String getStandardName(String string, String string2, Provider provider) {
        return Security.getProviderProperty("Alg.Alias." + string2 + "." + string, provider);
    }

    public static String getAlgorithmProperty(String string, String string2) {
        Security.reloadProviders();
        ProviderProperty providerProperty = Security.getProviderProperty("Alg." + string2 + "." + string);
        if (providerProperty != null) {
            return providerProperty.className;
        }
        return null;
    }

    private static ProviderProperty getEngineClassName(String string, String string2) throws NoSuchAlgorithmException {
        ProviderProperty providerProperty;
        String string3 = string2;
        if (string != null) {
            string3 = String.valueOf(string3) + "." + string;
        }
        if ((providerProperty = (ProviderProperty)engineCache.get(string3)) != null) {
            return providerProperty;
        }
        int n = 0;
        while (n < providers.size()) {
            block6: {
                Provider provider = (Provider)providers.elementAt(n);
                try {
                    providerProperty = Security.getEngineClassName(string, provider.getName(), string2);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    break block6;
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    break block6;
                }
                engineCache.put(string3, providerProperty);
                return providerProperty;
            }
            ++n;
        }
        throw new NoSuchAlgorithmException(String.valueOf(string2) + " not available");
    }

    private static ProviderProperty getEngineClassName(String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        Object object;
        if (string2 == null) {
            return Security.getEngineClassName(string, string3);
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException("no such provider: " + string2);
        }
        String string4 = string3.equalsIgnoreCase("SecureRandom") && string == null ? string3 : String.valueOf(string3) + "." + string;
        String string5 = Security.getProviderProperty(string4, provider);
        if (string5 == null) {
            if (string3.equalsIgnoreCase("SecureRandom") && string == null) {
                throw new NoSuchAlgorithmException("SecureRandom not available for provider " + string2);
            }
            object = Security.getStandardName(string, string3, provider);
            if (object != null) {
                string4 = String.valueOf(string3) + "." + (String)object;
            }
            if (object == null || (string5 = Security.getProviderProperty(string4, provider)) == null) {
                throw new NoSuchAlgorithmException("no such algorithm: " + string + " for provider " + string2);
            }
        }
        object = new ProviderProperty();
        ((ProviderProperty)object).className = string5;
        ((ProviderProperty)object).provider = provider;
        return object;
    }

    public static int insertProviderAt(Provider provider, int n) {
        Security.reloadProviders();
        Security.check("insertProvider." + provider.getName());
        Provider provider2 = Security.getProvider(provider.getName());
        if (provider2 != null) {
            return -1;
        }
        int n2 = providers.size();
        if (n > n2 || n <= 0) {
            n = n2 + 1;
        }
        providers.insertElementAt(provider, n - 1);
        providerPropertiesCache.clear();
        engineCache.clear();
        return n;
    }

    public static int addProvider(Provider provider) {
        return Security.insertProviderAt(provider, providers.size() + 1);
    }

    public static void removeProvider(String string) {
        Security.reloadProviders();
        Security.check("removeProvider." + string);
        Provider provider = Security.getProvider(string);
        if (provider != null) {
            providers.removeElement(provider);
            providerPropertiesCache.clear();
            engineCache.clear();
        }
    }

    public static Provider[] getProviders() {
        Security.reloadProviders();
        Object[] objectArray = new Provider[providers.size()];
        providers.copyInto(objectArray);
        return objectArray;
    }

    public static Provider getProvider(String string) {
        Enumeration enumeration = providers.elements();
        while (enumeration.hasMoreElements()) {
            Provider provider = (Provider)enumeration.nextElement();
            if (!provider.getName().equals(string)) continue;
            return provider;
        }
        if (reloadProviders) {
            int n = providers.size();
            Security.reloadProviders();
            if (providers.size() > n) {
                enumeration = providers.elements();
                while (enumeration.hasMoreElements()) {
                    Provider provider = (Provider)enumeration.nextElement();
                    if (!provider.getName().equals(string)) continue;
                    return provider;
                }
            }
        }
        return null;
    }

    private static boolean checkSuperclass(Class clazz, Class clazz2) {
        while (!clazz.equals(clazz2)) {
            if ((clazz = clazz.getSuperclass()) != null) continue;
            return false;
        }
        return true;
    }

    static Object[] getImpl(String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        Security.reloadProviders();
        ProviderProperty providerProperty = Security.getEngineClassName(string, string3, string2);
        String string4 = providerProperty.className;
        try {
            Class<?> clazz = string2.equals("CertificateFactory") ? Class.forName("com.ibm.security12.java.security.cert." + string2 + "Spi") : Class.forName("com.ibm.security12.java.security." + string2 + "Spi");
            ClassLoader classLoader = providerProperty.provider.getClass().getClassLoader();
            Class<?> clazz2 = classLoader != null ? classLoader.loadClass(string4) : Class.forName(string4);
            if (Security.checkSuperclass(clazz2, clazz)) {
                Object obj = clazz2.newInstance();
                return new Object[]{obj, providerProperty.provider};
            }
            throw new NoSuchAlgorithmException("class configured for " + string2 + ": " + string4 + " not a " + string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoSuchAlgorithmException("class configured for " + string2 + "(provider: " + string3 + ")" + "cannot be found.\n" + classNotFoundException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new NoSuchAlgorithmException("class " + string4 + " configured for " + string2 + "(provider: " + string3 + ") cannot be instantiated.\n" + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NoSuchAlgorithmException("class " + string4 + " configured for " + string2 + "(provider: " + string3 + ") cannot be accessed.\n" + illegalAccessException.getMessage());
        }
        catch (SecurityException securityException) {
            throw new NoSuchAlgorithmException("class " + string4 + " configured for " + string2 + "(provider: " + string3 + ") cannot be accessed.\n" + securityException.getMessage());
        }
    }

    public static String getProperty(String string) {
        SecurityManager12 securityManager12 = (SecurityManager12)System.getSecurityManager();
        if (securityManager12 != null) {
            securityManager12.checkPermission(new SecurityPermission("getProperty." + string));
        }
        return props.getProperty(string);
    }

    public static void setProperty(String string, String string2) {
        Security.check("setProperty." + string);
        ((Hashtable)props).put(string, string2);
    }

    private static void check(String string) {
        SecurityManager12 securityManager12 = (SecurityManager12)System.getSecurityManager();
        if (securityManager12 != null) {
            securityManager12.checkSecurityAccess(string);
        }
    }

    static void error(String string) {
    }

    static void error(String string, Throwable throwable) {
        Security.error(string);
    }

    static void debug(String string) {
    }

    static void debug(String string, Throwable throwable) {
    }

    static {
        AccessController.doPrivileged(new 1());
    }

    private static class ProviderProperty {
        String className;
        Provider provider;

        ProviderProperty() {
        }
    }

    private final class 1
    implements PrivilegedAction {
        public Object run() {
            Security.initialize();
            return null;
        }

        /* synthetic */ 1() {
        }
    }

    private static final class 2
    implements PrivilegedAction {
        private final /* synthetic */ String val$name;

        public Object run() {
            return Provider.loadProvider(this.val$name);
        }

        /* synthetic */ 2(String string) {
            this.val$name = string;
        }
    }
}

