/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.java.util;

import com.ibm.security12.java.security.BasicPermission;
import com.ibm.security12.java.security.Permission;
import com.ibm.security12.java.security.PermissionCollection;
import com.ibm.security12.java.util.PropertyPermissionCollection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class PropertyPermission
extends BasicPermission {
    static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private static final int READ = 1;
    private static final int WRITE = 2;
    private static final int ALL = 3;
    private static final int NONE = 0;
    private transient int mask;
    private String actions;

    private void init(int n) {
        if ((n & 3) != n) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        if (n == 0) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        if (this.getName() == null) {
            throw new IllegalArgumentException("name can't be null");
        }
        this.mask = n;
    }

    public PropertyPermission(String string, String string2) {
        super(string, string2);
        this.init(PropertyPermission.getMask(string2));
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof PropertyPermission)) {
            return false;
        }
        PropertyPermission propertyPermission = (PropertyPermission)permission;
        return (this.mask & propertyPermission.mask) == propertyPermission.mask && super.implies(propertyPermission);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PropertyPermission)) {
            return false;
        }
        PropertyPermission propertyPermission = (PropertyPermission)object;
        return this.mask == propertyPermission.mask && this.getName().equals(propertyPermission.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    /*
     * Unable to fully structure code
     */
    private static int getMask(String var0) {
        var1_1 = 0;
        if (var0 == null) {
            return var1_1;
        }
        var2_2 = var0.toCharArray();
        var3_3 = var2_2.length - 1;
        if (var3_3 >= 0) ** GOTO lbl32
        return var1_1;
        {
            --var3_3;
            do {
                if (var3_3 != -1 && ((var4_4 = var2_2[var3_3]) == ' ' || var4_4 == '\r' || var4_4 == '\n' || var4_4 == '\f' || var4_4 == '\t')) continue block4;
                if (!(var3_3 < 3 || var2_2[var3_3 - 3] != 'r' && var2_2[var3_3 - 3] != 'R' || var2_2[var3_3 - 2] != 'e' && var2_2[var3_3 - 2] != 'E' || var2_2[var3_3 - 1] != 'a' && var2_2[var3_3 - 1] != 'A' || var2_2[var3_3] != 'd' && var2_2[var3_3] != 'D')) {
                    var5_5 = 4;
                    var1_1 |= 1;
                } else if (!(var3_3 < 4 || var2_2[var3_3 - 4] != 'w' && var2_2[var3_3 - 4] != 'W' || var2_2[var3_3 - 3] != 'r' && var2_2[var3_3 - 3] != 'R' || var2_2[var3_3 - 2] != 'i' && var2_2[var3_3 - 2] != 'I' || var2_2[var3_3 - 1] != 't' && var2_2[var3_3 - 1] != 'T' || var2_2[var3_3] != 'e' && var2_2[var3_3] != 'E')) {
                    var5_5 = 5;
                    var1_1 |= 2;
                } else {
                    throw new IllegalArgumentException("invalid permission: " + var0);
                }
                var6_6 = false;
                while (var3_3 >= var5_5 && !var6_6) {
                    switch (var2_2[var3_3 - var5_5]) {
                        case ',': {
                            var6_6 = true;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid permission: " + var0);
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': 
                    }
                    --var3_3;
                }
                var3_3 -= var5_5;
lbl32:
                // 2 sources

            } while (var3_3 != -1);
        }
        return var1_1;
    }

    static String getActions(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if ((n & 1) == 1) {
            bl = true;
            stringBuffer.append("read");
        }
        if ((n & 2) == 2) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = true;
            }
            stringBuffer.append("write");
        }
        return stringBuffer.toString();
    }

    public String getActions() {
        if (this.actions == null) {
            this.actions = PropertyPermission.getActions(this.mask);
        }
        return this.actions;
    }

    int getMask() {
        return this.mask;
    }

    public PermissionCollection newPermissionCollection() {
        return new PropertyPermissionCollection();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(PropertyPermission.getMask(this.actions));
    }
}

