/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.java.util;

import com.ibm.security12.java.util.AbstractList;
import com.ibm.security12.java.util.Collection;
import com.ibm.security12.java.util.ConcurrentModificationException;
import com.ibm.security12.java.util.Iterator;
import com.ibm.security12.java.util.List;
import com.ibm.security12.java.util.ListIterator;
import java.util.NoSuchElementException;

class SubList
extends AbstractList {
    private AbstractList l;
    private int offset;
    private int size;
    private int expectedModCount;

    SubList(AbstractList abstractList, int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n2 > abstractList.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
        this.l = abstractList;
        this.offset = n;
        this.size = n2 - n;
        this.expectedModCount = this.l.modCount;
    }

    public Object set(int n, Object object) {
        this.rangeCheck(n);
        this.checkForComodification();
        return this.l.set(n + this.offset, object);
    }

    public Object get(int n) {
        this.rangeCheck(n);
        this.checkForComodification();
        return this.l.get(n + this.offset);
    }

    public int size() {
        this.checkForComodification();
        return this.size;
    }

    public void add(int n, Object object) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.checkForComodification();
        this.l.add(n + this.offset, object);
        this.expectedModCount = this.l.modCount;
        ++this.size;
        ++this.modCount;
    }

    public Object remove(int n) {
        this.rangeCheck(n);
        this.checkForComodification();
        Object object = this.l.remove(n + this.offset);
        this.expectedModCount = this.l.modCount;
        --this.size;
        ++this.modCount;
        return object;
    }

    protected void removeRange(int n, int n2) {
        this.checkForComodification();
        this.l.removeRange(n + this.offset, n2 + this.offset);
        this.expectedModCount = this.l.modCount;
        this.size -= n2 - n;
        ++this.modCount;
    }

    public boolean addAll(Collection collection) {
        return this.addAll(this.size, collection);
    }

    public boolean addAll(int n, Collection collection) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        int n2 = collection.size();
        if (n2 == 0) {
            return false;
        }
        this.checkForComodification();
        this.l.addAll(this.offset + n, collection);
        this.expectedModCount = this.l.modCount;
        this.size += n2;
        ++this.modCount;
        return true;
    }

    public Iterator iterator() {
        return this.listIterator();
    }

    public ListIterator listIterator(int n) {
        this.checkForComodification();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return new 1(n, this);
    }

    public List subList(int n, int n2) {
        return new SubList(this, n, n2);
    }

    private void rangeCheck(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ",Size: " + this.size);
        }
    }

    private void checkForComodification() {
        if (this.l.modCount != this.expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }

    static /* synthetic */ int access$3(SubList subList) {
        return subList.expectedModCount;
    }

    private final class 1
    implements ListIterator {
        private final /* synthetic */ SubList this$0;
        private ListIterator i;

        public boolean hasNext() {
            return this.nextIndex() < this.this$0.size;
        }

        public Object next() {
            if (this.hasNext()) {
                return this.i.next();
            }
            throw new NoSuchElementException();
        }

        public boolean hasPrevious() {
            return this.previousIndex() >= 0;
        }

        public Object previous() {
            if (this.hasPrevious()) {
                return this.i.previous();
            }
            throw new NoSuchElementException();
        }

        public int nextIndex() {
            return this.i.nextIndex() - this.this$0.offset;
        }

        public int previousIndex() {
            return this.i.previousIndex() - this.this$0.offset;
        }

        public void remove() {
            this.i.remove();
            this.this$0.expectedModCount = ((SubList)this.this$0).l.modCount;
            SubList subList = this.this$0;
            subList.size = subList.size - 1;
            ++this.this$0.modCount;
        }

        public void set(Object object) {
            this.i.set(object);
        }

        public void add(Object object) {
            this.i.add(object);
            this.this$0.expectedModCount = ((SubList)this.this$0).l.modCount;
            SubList subList = this.this$0;
            subList.size = subList.size + 1;
            ++this.this$0.modCount;
        }

        /* synthetic */ 1(int n, SubList subList) {
            this.this$0 = subList;
            this.i = subList.l.listIterator(n + subList.offset);
        }
    }
}

