/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.misc;

import com.ibm.security12.java.io.File12;
import com.ibm.security12.java.io.FilePermission;
import com.ibm.security12.java.lang.SecurityManager12;
import com.ibm.security12.java.net.JarURLConnection;
import com.ibm.security12.java.net.NetPermission;
import com.ibm.security12.java.net.SocketPermission;
import com.ibm.security12.java.security.AccessControlException;
import com.ibm.security12.java.security.AccessController;
import com.ibm.security12.java.security.Permission;
import com.ibm.security12.java.security.PrivilegedActionException;
import com.ibm.security12.java.security.PrivilegedExceptionAction;
import com.ibm.security12.java.util.ArrayList;
import com.ibm.security12.java.util.HashMap;
import com.ibm.security12.java.util.jar.Attributes;
import com.ibm.security12.java.util.jar.JarEntry;
import com.ibm.security12.java.util.jar.JarFile;
import com.ibm.security12.java.util.jar.Manifest;
import com.ibm.security12.sun.misc.Resource;
import com.ibm.security12.sun.misc.URLClassPath;
import com.ibm.security12.sun.net.www.URLConnection12;
import com.ibm.security12.sun.security.action.GetPropertyAction;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.StringTokenizer;

public class URLClassPath {
    static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    static final String USER_AGENT_JAVA_VERSION = "UA-Java-Version";
    private static String JAVA_VERSION = (String)AccessController.doPrivileged(new GetPropertyAction("java.version"));
    private ArrayList path = new ArrayList();
    private Stack urls = new Stack();
    private ArrayList loaders = new ArrayList();
    private HashMap lmap = new HashMap();
    private URLStreamHandler jarHandler;

    public URLClassPath(URL[] uRLArray, URLStreamHandlerFactory uRLStreamHandlerFactory) {
        int n = 0;
        while (n < uRLArray.length) {
            this.path.add(uRLArray[n]);
            ++n;
        }
        this.push(uRLArray);
        if (uRLStreamHandlerFactory != null) {
            this.jarHandler = uRLStreamHandlerFactory.createURLStreamHandler("jar");
        }
    }

    public URLClassPath(URL[] uRLArray) {
        this(uRLArray, null);
    }

    public void addURL(URL uRL) {
        Stack stack = this.urls;
        synchronized (stack) {
            this.urls.insertElementAt(uRL, 0);
            this.path.add(uRL);
            return;
        }
    }

    public URL[] getURLs() {
        Stack stack = this.urls;
        synchronized (stack) {
            URL[] uRLArray = (URL[])this.path.toArray(new URL[this.path.size()]);
            Object var3_3 = null;
            return uRLArray;
        }
    }

    public Resource getResource(String string, boolean bl) {
        Loader loader;
        int n = 0;
        while ((loader = this.getLoader(n)) != null) {
            Resource resource = loader.getResource(string, bl);
            if (resource != null) {
                return resource;
            }
            ++n;
        }
        return null;
    }

    public Resource getResource(String string) {
        return this.getResource(string, true);
    }

    public Enumeration getResources(String string, boolean bl) {
        return new 1(bl, string, this);
    }

    public Enumeration getResources(String string) {
        return this.getResources(string, true);
    }

    private Loader getLoader(int n) {
        while (this.loaders.size() < n + 1) {
            URL uRL;
            Object object;
            block9: {
                try {
                    object = this.urls;
                    synchronized (object) {
                        uRL = (URL)this.urls.pop();
                    }
                }
                catch (EmptyStackException emptyStackException) {
                    return null;
                }
                if (this.lmap.containsKey(uRL)) continue;
                try {
                    object = this.getLoader(uRL);
                    URL[] uRLArray = ((Loader)object).getClassPath();
                    if (uRLArray == null) break block9;
                    this.push(uRLArray);
                }
                catch (IOException iOException) {
                    continue;
                }
            }
            this.loaders.add(object);
            this.lmap.put(uRL, object);
        }
        return (Loader)this.loaders.get(n);
    }

    private Loader getLoader(URL uRL) throws IOException {
        try {
            return (Loader)AccessController.doPrivileged(new 2(uRL));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private void push(URL[] uRLArray) {
        Stack stack = this.urls;
        synchronized (stack) {
            int n = uRLArray.length - 1;
            while (n >= 0) {
                this.urls.push(uRLArray[n]);
                --n;
            }
            return;
        }
    }

    public static URL[] pathToURLs(String string) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        Object object2 = new URL[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            try {
                object = new File12(stringTokenizer.nextToken());
                object2[n++] = ((File12)object).toURL();
                object2[n - 1] = new File12(((File)object).getCanonicalPath()).toURL();
            }
            catch (IOException iOException) {}
        }
        if (((URL[])object2).length != n) {
            object = new URL[n];
            System.arraycopy(object2, 0, object, 0, n);
            object2 = object;
        }
        return object2;
    }

    static /* synthetic */ Loader access$0(URLClassPath uRLClassPath, int n) {
        return uRLClassPath.getLoader(n);
    }

    private static final class 1
    implements Enumeration {
        private final /* synthetic */ boolean val$check;
        private final /* synthetic */ String val$name;
        private final /* synthetic */ URLClassPath this$0;
        private int index;
        private Resource res;

        /*
         * Unable to fully structure code
         */
        private boolean next() {
            if (this.res == null) ** GOTO lbl10
            return true;
lbl-1000:
            // 1 sources

            {
                if (this.val$name == null) {
                    if (var1_1 instanceof JarLoader) {
                        this.res = ((JarLoader)var1_1).getResource(null, false);
                    }
                } else {
                    this.res = var1_1.getResource(this.val$name, this.val$check);
                }
                if (this.res == null) continue;
                return true;
lbl10:
                // 2 sources

                ** while ((var1_1 = URLClassPath.access$0((URLClassPath)this.this$0, (int)this.index++)) != null)
            }
lbl11:
            // 1 sources

            return false;
        }

        public boolean hasMoreElements() {
            return this.next();
        }

        public Object nextElement() {
            if (!this.next()) {
                throw new NoSuchElementException();
            }
            Resource resource = this.res;
            this.res = null;
            return resource;
        }

        /* synthetic */ 1(boolean bl, String string, URLClassPath uRLClassPath) {
            this.val$check = bl;
            this.val$name = string;
            this.this$0 = uRLClassPath;
        }
    }

    private final class 2
    implements PrivilegedExceptionAction {
        private final /* synthetic */ URL val$url;

        public Object run() throws IOException {
            String string = this.val$url.getFile();
            if (string != null && string.endsWith("/")) {
                if ("file".equals(this.val$url.getProtocol())) {
                    return new FileLoader(this.val$url);
                }
                return new Loader(this.val$url);
            }
            return new JarLoader(this.val$url, URLClassPath.this.jarHandler);
        }

        /* synthetic */ 2(URL uRL) {
            this.val$url = uRL;
        }
    }

    private static class Loader {
        private final URL base;

        Loader(URL uRL) {
            this.base = uRL;
        }

        URL getBaseURL() {
            return this.base;
        }

        Resource getResource(String string, boolean bl) {
            URLConnection uRLConnection;
            URL uRL;
            try {
                uRL = new URL(this.base, string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException("name");
            }
            try {
                if (bl) {
                    this.check(uRL);
                }
                if ((uRLConnection = uRL.openConnection()) instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    int n = httpURLConnection.getResponseCode();
                    if (n >= 400) {
                        return null;
                    }
                } else {
                    InputStream inputStream = uRL.openStream();
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                return null;
            }
            return new 3(string, this, uRLConnection, uRL);
        }

        Resource getResource(String string) {
            return this.getResource(string, true);
        }

        URL[] getClassPath() throws IOException {
            return null;
        }

        void check(URL uRL) throws IOException {
            Permission permission;
            SecurityManager12 securityManager12 = (SecurityManager12)System.getSecurityManager();
            if (securityManager12 != null && (permission = URLConnection12.getPermission(uRL, uRL.openConnection())) != null) {
                try {
                    securityManager12.checkPermission(permission);
                    return;
                }
                catch (SecurityException securityException) {
                    if (permission instanceof FilePermission && permission.getActions().indexOf("read") != -1) {
                        securityManager12.checkRead(permission.getName());
                        return;
                    }
                    if (permission instanceof SocketPermission && permission.getActions().indexOf("connect") != -1) {
                        securityManager12.checkConnect(uRL.getHost(), uRL.getPort());
                        return;
                    }
                    throw securityException;
                }
            }
        }

        static /* synthetic */ URL access$0(Loader loader) {
            return loader.base;
        }
    }

    private static class JarLoader
    extends Loader {
        private JarFile jar;
        private URL csu;

        JarLoader(URL uRL, URLStreamHandler uRLStreamHandler) throws IOException {
            super(new URL("jar", "", -1, String.valueOf(uRL) + "!/"));
            SecurityManager12 securityManager12;
            if (uRLStreamHandler != null && (securityManager12 = (SecurityManager12)System.getSecurityManager()) != null) {
                securityManager12.checkPermission(new NetPermission("specifyStreamHandler"));
            }
            this.jar = this.getJarFile(uRL);
            this.csu = uRL;
        }

        private JarFile getJarFile(URL uRL) throws IOException {
            if ("file".equals(uRL.getProtocol())) {
                String string = uRL.getFile().replace('/', File.separatorChar);
                File file = new File(string);
                if (!file.exists()) {
                    throw new FileNotFoundException(string);
                }
                return new JarFile(string);
            }
            URLConnection uRLConnection = this.getBaseURL().openConnection();
            uRLConnection.setRequestProperty(URLClassPath.USER_AGENT_JAVA_VERSION, JAVA_VERSION);
            return ((JarURLConnection)uRLConnection).getJarFile();
        }

        Resource getResource(String string, boolean bl) {
            JarEntry jarEntry = string == null ? this.jar.getManifestEntry() : this.jar.getJarEntry(string);
            if (jarEntry != null) {
                URL uRL;
                try {
                    uRL = new URL(this.getBaseURL(), string);
                    if (bl) {
                        this.check(uRL);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
                catch (AccessControlException accessControlException) {
                    return null;
                }
                return new 4(jarEntry, string, this, uRL);
            }
            return null;
        }

        URL[] getClassPath() throws IOException {
            String string;
            Attributes attributes;
            Manifest manifest = this.jar.getManifest();
            if (manifest != null && (attributes = manifest.getMainAttributes()) != null && (string = attributes.getValue(Attributes.Name.CLASS_PATH)) != null) {
                return this.parseClassPath(this.csu, string);
            }
            return null;
        }

        private URL[] parseClassPath(URL uRL, String string) throws MalformedURLException {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            URL[] uRLArray = new URL[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                uRLArray[n] = new URL(uRL, string2);
                ++n;
            }
            return uRLArray;
        }

        static /* synthetic */ URL access$0(JarLoader jarLoader) {
            return jarLoader.csu;
        }

        static /* synthetic */ JarFile access$1(JarLoader jarLoader) {
            return jarLoader.jar;
        }
    }

    private static class FileLoader
    extends Loader {
        private File dir;

        FileLoader(URL uRL) throws IOException {
            super(uRL);
            if (!"file".equals(uRL.getProtocol())) {
                throw new IllegalArgumentException("url");
            }
            this.dir = new File(uRL.getFile().replace('/', File.separatorChar));
        }

        Resource getResource(String string, boolean bl) {
            try {
                File file;
                URL uRL = new URL(this.getBaseURL(), string);
                if (!uRL.getFile().startsWith(this.getBaseURL().getFile())) {
                    return null;
                }
                if (bl) {
                    this.check(uRL);
                }
                if ((file = new File(this.dir, string.replace('/', File.separatorChar))).exists()) {
                    return new 5(file, string, this, uRL);
                }
            }
            catch (Exception exception) {
                return null;
            }
            return null;
        }
    }
}

