/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.x509;

import com.ibm.security12.sun.security.util.DerOutputStream;
import com.ibm.security12.sun.security.util.DerValue;
import com.ibm.security12.sun.security.util.ObjectIdentifier;
import com.ibm.security12.sun.security.x509.AttributeNameEnumeration;
import com.ibm.security12.sun.security.x509.CertAttrSet;
import com.ibm.security12.sun.security.x509.Extension;
import com.ibm.security12.sun.security.x509.GeneralNames;
import com.ibm.security12.sun.security.x509.GeneralNamesException;
import com.ibm.security12.sun.security.x509.KeyIdentifier;
import com.ibm.security12.sun.security.x509.SerialNumber;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;

public class AuthorityKeyIdentifierExtension
extends Extension
implements CertAttrSet {
    static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private static final int[] AuthorityKey_data = new int[]{2, 5, 29, 35};
    public static final String IDENT = "x509.info.extensions.AuthorityKeyIdentifier";
    public static final String NAME = "AuthorityKeyIdentifier";
    public static final String KEY_ID = "key_id";
    public static final String AUTH_NAME = "auth_name";
    public static final String SERIAL_NUMBER = "serial_number";
    private static final byte TAG_ID = 0;
    private static final byte TAG_NAMES = 1;
    private static final byte TAG_SERIAL_NUM = 2;
    private KeyIdentifier id;
    private GeneralNames names;
    private SerialNumber serialNum;

    private void encodeThis() throws IOException {
        DerOutputStream derOutputStream;
        if (this.id == null && this.names == null && this.serialNum == null) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.id != null) {
            derOutputStream = new DerOutputStream();
            this.id.encode(derOutputStream);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), derOutputStream);
        }
        try {
            if (this.names != null) {
                derOutputStream = new DerOutputStream();
                this.names.encode(derOutputStream);
                derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream);
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
        if (this.serialNum != null) {
            derOutputStream = new DerOutputStream();
            this.serialNum.encode(derOutputStream);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, false, (byte)2), derOutputStream);
        }
        derOutputStream2.write((byte)48, derOutputStream3);
        this.extensionValue = derOutputStream2.toByteArray();
    }

    public AuthorityKeyIdentifierExtension(KeyIdentifier keyIdentifier, GeneralNames generalNames, SerialNumber serialNumber) throws IOException {
        this.id = keyIdentifier;
        this.names = generalNames;
        this.serialNum = serialNumber;
        this.extensionId = new ObjectIdentifier(AuthorityKey_data);
        this.critical = false;
        this.encodeThis();
    }

    /*
     * Unable to fully structure code
     */
    public AuthorityKeyIdentifierExtension(Boolean var1_1, Object var2_2) throws IOException {
        super();
        this.extensionId = new ObjectIdentifier(AuthorityKeyIdentifierExtension.AuthorityKey_data);
        this.critical = var1_1;
        if (!(var2_2 instanceof byte[])) {
            throw new IOException("Illegal argument type");
        }
        var3_3 = Array.getLength(var2_2);
        var4_4 = new byte[var3_3];
        System.arraycopy(var2_2, 0, var4_4, 0, var3_3);
        this.extensionValue = var4_4;
        var5_5 = new DerValue(var4_4);
        if (var5_5.tag == 48) ** GOTO lbl36
        throw new IOException("Invalid encoding for AuthorityKeyIdentifierExtension.");
lbl-1000:
        // 1 sources

        {
            var6_6 = var5_5.data.getDerValue();
            if (var6_6.isContextSpecific((byte)0) && !var6_6.isConstructed()) {
                if (this.id != null) {
                    throw new IOException("Duplicate KeyIdentifier in AuthorityKeyIdentifier.");
                }
                var6_6.resetTag((byte)4);
                this.id = new KeyIdentifier(var6_6);
                continue;
            }
            if (var6_6.isContextSpecific((byte)1) && var6_6.isConstructed()) {
                if (this.names != null) {
                    throw new IOException("Duplicate GeneralNames in AuthorityKeyIdentifier.");
                }
                try {
                    var6_6.resetTag((byte)48);
                    this.names = new GeneralNames(var6_6);
                }
                catch (GeneralNamesException var7_7) {
                    throw new IOException(var7_7.toString());
                }
            } else {
                if (var6_6.isContextSpecific((byte)2) && !var6_6.isConstructed()) {
                    if (this.serialNum != null) {
                        throw new IOException("Duplicate SerialNumber in AuthorityKeyIdentifier.");
                    }
                    var6_6.resetTag((byte)2);
                    this.serialNum = new SerialNumber(var6_6);
                    continue;
                }
                throw new IOException("Invalid encoding of AuthorityKeyIdentifierExtension.");
            }
lbl36:
            // 4 sources

            ** while (var5_5.data.available() != 0)
        }
lbl37:
        // 1 sources

    }

    public String toString() {
        String string = String.valueOf(super.toString()) + "AuthorityKeyIdentifier [\n";
        if (this.id != null) {
            string = String.valueOf(string) + this.id.toString() + "\n";
        }
        if (this.names != null) {
            string = String.valueOf(string) + this.names.toString() + "\n";
        }
        if (this.serialNum != null) {
            string = String.valueOf(string) + this.serialNum.toString() + "\n";
        }
        return String.valueOf(string) + "]\n";
    }

    public void decode(InputStream inputStream) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = new ObjectIdentifier(AuthorityKey_data);
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(KEY_ID)) {
            if (!(object instanceof KeyIdentifier)) {
                throw new IOException("Attribute value should be of type KeyIdentifier.");
            }
            this.id = (KeyIdentifier)object;
        } else if (string.equalsIgnoreCase(AUTH_NAME)) {
            if (!(object instanceof GeneralNames)) {
                throw new IOException("Attribute value should be of type GeneralNames.");
            }
            this.names = (GeneralNames)object;
        } else if (string.equalsIgnoreCase(SERIAL_NUMBER)) {
            if (!(object instanceof SerialNumber)) {
                throw new IOException("Attribute value should be of type SerialNumber.");
            }
            this.serialNum = (SerialNumber)object;
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:AuthorityKeyIdentifier.");
        }
        this.encodeThis();
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(KEY_ID)) {
            return this.id;
        }
        if (string.equalsIgnoreCase(AUTH_NAME)) {
            return this.names;
        }
        if (string.equalsIgnoreCase(SERIAL_NUMBER)) {
            return this.serialNum;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:AuthorityKeyIdentifier.");
    }

    public void delete(String string) throws IOException {
        if (string.equalsIgnoreCase(KEY_ID)) {
            this.id = null;
        } else if (string.equalsIgnoreCase(AUTH_NAME)) {
            this.names = null;
        } else if (string.equalsIgnoreCase(SERIAL_NUMBER)) {
            this.serialNum = null;
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:AuthorityKeyIdentifier.");
        }
        this.encodeThis();
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(KEY_ID);
        attributeNameEnumeration.addElement(AUTH_NAME);
        attributeNameEnumeration.addElement(SERIAL_NUMBER);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }
}

