/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.x509;

import com.ibm.security12.sun.security.util.BigInt;
import com.ibm.security12.sun.security.util.DerOutputStream;
import com.ibm.security12.sun.security.util.DerValue;
import com.ibm.security12.sun.security.util.ObjectIdentifier;
import com.ibm.security12.sun.security.x509.AttributeNameEnumeration;
import com.ibm.security12.sun.security.x509.CertAttrSet;
import com.ibm.security12.sun.security.x509.Extension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;

public class BasicConstraintsExtension
extends Extension
implements CertAttrSet {
    static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    public static final String IDENT = "x509.info.extensions.BasicConstraints";
    public static final String NAME = "BasicConstraints";
    public static final String IS_CA = "is_ca";
    public static final String PATH_LEN = "path_len";
    private boolean ca = false;
    private int pathLen = -1;
    private static final int[] BasicConstraints_data = new int[]{2, 5, 29, 19};

    private void encodeThis() throws IOException {
        if (!this.ca && this.pathLen < 0) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.ca) {
            derOutputStream2.putBoolean(this.ca);
        }
        if (this.pathLen >= 0) {
            derOutputStream2.putInteger(new BigInt(this.pathLen));
        }
        derOutputStream.write((byte)48, derOutputStream2);
        this.extensionValue = derOutputStream.toByteArray();
    }

    public BasicConstraintsExtension(boolean bl, int n) throws IOException {
        this.ca = bl;
        this.pathLen = n;
        this.extensionId = new ObjectIdentifier(BasicConstraints_data);
        this.critical = bl;
        this.encodeThis();
    }

    public BasicConstraintsExtension(Boolean bl, Object object) throws IOException {
        this.extensionId = new ObjectIdentifier(BasicConstraints_data);
        this.critical = bl;
        if (object instanceof byte[]) {
            int n = Array.getLength(object);
            byte[] byArray = new byte[n];
            System.arraycopy(object, 0, byArray, 0, n);
            this.extensionValue = byArray;
            DerValue derValue = new DerValue(byArray);
            if (derValue.tag != 48) {
                throw new IOException("Invalid encoding of BasicConstraints");
            }
            if (derValue.data == null) {
                this.ca = false;
                this.pathLen = -2;
                return;
            }
            DerValue derValue2 = derValue.data.getDerValue();
            if (derValue2.tag != 1) {
                this.ca = false;
            } else {
                this.ca = true;
                if (derValue.data.available() != 0) {
                    derValue2 = derValue.data.getDerValue();
                } else {
                    this.pathLen = -2;
                    return;
                }
            }
            if (derValue2.tag != 2) {
                throw new IOException("Invalid encoding of BasicConstraints");
            }
            this.pathLen = derValue2.getInteger().toInt();
            return;
        }
        throw new IOException("Invalid argument type");
    }

    public String toString() {
        String string = String.valueOf(super.toString()) + "BasicConstraints:[\n";
        string = String.valueOf(string) + (this.ca ? "CA:true" : "CA:false") + "\n";
        string = this.pathLen >= 0 ? String.valueOf(string) + "PathLen:" + this.pathLen + "\n" : String.valueOf(string) + "PathLen: undefined\n";
        return String.valueOf(string) + "]\n";
    }

    public void decode(InputStream inputStream) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = new ObjectIdentifier(BasicConstraints_data);
            this.critical = this.ca;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(IS_CA)) {
            if (!(object instanceof Boolean)) {
                throw new IOException("Attribute value should be of type Boolean.");
            }
            this.ca = (Boolean)object;
        } else if (string.equalsIgnoreCase(PATH_LEN)) {
            if (!(object instanceof Integer)) {
                throw new IOException("Attribute value should be of type Integer.");
            }
            this.pathLen = (Integer)object;
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:BasicConstraints.");
        }
        this.encodeThis();
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(IS_CA)) {
            return new Boolean(this.ca);
        }
        if (string.equalsIgnoreCase(PATH_LEN)) {
            return new Integer(this.pathLen);
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:BasicConstraints.");
    }

    public void delete(String string) throws IOException {
        if (string.equalsIgnoreCase(IS_CA)) {
            this.ca = false;
        } else if (string.equalsIgnoreCase(PATH_LEN)) {
            this.pathLen = -1;
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:BasicConstraints.");
        }
        this.encodeThis();
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(IS_CA);
        attributeNameEnumeration.addElement(PATH_LEN);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }
}

