/*
 * Decompiled with CFR 0.152.
 */
package com.sun.CosNaming;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

final class BootstrapServiceProperties {
    private File propFile;
    private long fileModified;
    private Properties savedProps;
    private Properties allProps;

    public BootstrapServiceProperties(File file, Properties properties) {
        this.propFile = file;
        this.savedProps = properties;
        this.allProps = new Properties(this.savedProps);
    }

    public synchronized String get(String string) {
        this.check();
        return this.allProps.getProperty(string);
    }

    public synchronized String put(String string, String string2, boolean bl) {
        String string3;
        block4: {
            if (!bl) {
                return ((Hashtable)this.allProps).put(string, string2);
            }
            string3 = ((Hashtable)this.savedProps).put(string, string2);
            if (this.propFile == null) break block4;
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.propFile);
                this.savedProps.save(fileOutputStream, null);
                fileOutputStream.close();
                this.fileModified = this.propFile.lastModified();
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("BootstrapServer: could not open \"" + this.propFile.getAbsolutePath() + "\" for writing: file not found!");
            }
            catch (IOException iOException) {
                System.err.println("BootstrapServer: caught exception while saving Properties to file \"" + this.propFile.getAbsolutePath() + "\": " + iOException);
            }
        }
        return string3;
    }

    public synchronized String[] keys() {
        this.check();
        String[] stringArray = null;
        int n = ((Hashtable)this.allProps).size() + ((Hashtable)this.savedProps).size();
        if (n > 0) {
            stringArray = new String[n];
            Enumeration<?> enumeration = this.allProps.propertyNames();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                stringArray[n2] = (String)enumeration.nextElement();
                ++n2;
            }
        }
        return stringArray;
    }

    protected void check() {
        if (this.propFile == null) {
            return;
        }
        long l = this.propFile.lastModified();
        if (l > this.fileModified) {
            try {
                FileInputStream fileInputStream = new FileInputStream(this.propFile);
                ((Hashtable)this.savedProps).clear();
                this.savedProps.load(fileInputStream);
                fileInputStream.close();
                this.fileModified = l;
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("BootstrapServer: could not open \"" + this.propFile.getAbsolutePath() + "\" for reading: file not found!");
                return;
            }
            catch (IOException iOException) {
                System.err.println("BootstrapServer: caught exception while loading Properties from file \"" + this.propFile.getAbsolutePath() + "\": " + iOException);
                return;
            }
        }
    }
}

