/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rmi.iiop;

import com.sun.rmi.iiop.CDRInputStream;
import com.sun.rmi.iiop.Connection;
import com.sun.rmi.iiop.Message;
import com.sun.rmi.iiop.ORB;
import java.io.IOException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;

public class IIOPInputStream
extends CDRInputStream {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    protected Connection conn;
    protected Message msg;

    public IIOPInputStream() {
    }

    public IIOPInputStream(ORB oRB, Connection connection) {
        super(oRB, null, 0);
        this.conn = connection;
    }

    public IIOPInputStream(ORB oRB, byte[] byArray, int n, boolean bl, Message message) {
        super(oRB, byArray, n, bl);
        this.msg = message;
    }

    public IIOPInputStream(Connection connection, byte[] byArray, Message message) throws IOException {
        this(connection.getORB(), connection);
        this.buf = byArray;
        this.msg = message;
        this.index = 12;
        this.littleEndian = this.msg.isLittleEndian();
        this.size = this.msg.getSize();
        if (this.size > this.buf.length) {
            byte[] byArray2 = this.buf;
            this.buf = new byte[this.size];
            System.arraycopy(byArray2, 0, this.buf, 0, byArray2.length);
        }
        Message.readFully(connection.getInputStream(), this.buf, this.index, this.size - this.index);
        this.msg.read(this);
        connection.stampTime();
    }

    public final Connection getConnection() {
        return this.conn;
    }

    public final void setConnection(Connection connection) {
        this.conn = connection;
        this.orb = connection.getORB();
    }

    public final Message getMessage() {
        return this.msg;
    }

    protected void grow(int n, int n2) {
        throw new MARSHAL(8, CompletionStatus.COMPLETED_MAYBE);
    }
}

