/*
 * Decompiled with CFR 0.152.
 */
package javax.rmi.CORBA;

import com.sun.rmi.util.Utility;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import javax.rmi.CORBA.StubDelegate;
import javax.rmi.CORBA.Tie;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA_2_3.portable.ObjectImpl;

public abstract class Stub
extends ObjectImpl
implements Serializable {
    private transient StubDelegate stubDelegate;
    private static Class stubDelegateClass = null;
    private static final String StubClassKey = "javax.rmi.CORBA.StubClass";
    private transient int hashCode;
    private transient int typeLength;
    private transient byte[] typeData;
    private transient int numProfiles;
    private transient int[] profileTags;
    private transient byte[][] profileData;

    protected Stub() {
        if (stubDelegateClass != null) {
            try {
                this.stubDelegate = (StubDelegate)stubDelegateClass.newInstance();
                return;
            }
            catch (Exception exception) {
                throw new INITIALIZE("cannot instantiate " + stubDelegateClass);
            }
        }
    }

    private void init() {
        if (this.numProfiles == 0) {
            try {
                OutputStream outputStream = this._orb().create_output_stream();
                outputStream.write_Object(this);
                InputStream inputStream = outputStream.create_input_stream();
                this.typeLength = inputStream.read_long();
                this.typeData = new byte[this.typeLength];
                inputStream.read_octet_array(this.typeData, 0, this.typeLength);
                this.numProfiles = inputStream.read_long();
                this.profileTags = new int[this.numProfiles];
                this.profileData = new byte[this.numProfiles][];
                int n = 0;
                while (n < this.numProfiles) {
                    this.profileTags[n] = inputStream.read_long();
                    this.profileData[n] = new byte[inputStream.read_long()];
                    inputStream.read_octet_array(this.profileData[n], 0, this.profileData[n].length);
                    ++n;
                }
                return;
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                return;
            }
        }
    }

    public int hashCode() {
        if (this.stubDelegate != null) {
            return this.stubDelegate.hashCode(this);
        }
        this.init();
        if (this.hashCode == 0) {
            int n = 0;
            while (n < this.typeLength) {
                this.hashCode = this.hashCode * 37 + this.typeData[n];
                ++n;
            }
            int n2 = 0;
            while (n2 < this.numProfiles) {
                this.hashCode = this.hashCode * 37 + this.profileTags[n2];
                int n3 = 0;
                while (n3 < this.profileData[n2].length) {
                    this.hashCode = this.hashCode * 37 + this.profileData[n2][n3];
                    ++n3;
                }
                ++n2;
            }
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this.stubDelegate != null) {
            return this.stubDelegate.equals(this, object);
        }
        if (object instanceof Stub) {
            Stub stub = (Stub)object;
            if (stub.hashCode() != this.hashCode()) {
                return false;
            }
            if (stub.typeLength != this.typeLength) {
                return false;
            }
            int n = 0;
            while (n < this.typeLength) {
                if (this.typeData[n] != stub.typeData[n]) {
                    return false;
                }
                ++n;
            }
            if (stub.numProfiles != this.numProfiles) {
                return false;
            }
            int n2 = 0;
            while (n2 < this.numProfiles) {
                if (stub.profileTags[n2] != this.profileTags[n2]) {
                    return false;
                }
                if (stub.profileData[n2].length != this.profileData[n2].length) {
                    return false;
                }
                int n3 = 0;
                while (n3 < this.profileData[n2].length) {
                    if (stub.profileData[n2][n3] != this.profileData[n2][n3]) {
                        return false;
                    }
                    ++n3;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.stubDelegate != null) {
            return this.stubDelegate.toString(this);
        }
        try {
            return this._orb().object_to_string(this);
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            return super.toString();
        }
    }

    public void connect(ORB oRB) throws RemoteException {
        if (this.stubDelegate != null) {
            this.stubDelegate.connect(this, oRB);
            return;
        }
        boolean bl = false;
        try {
            Delegate delegate = this._get_delegate();
            if (delegate.orb(this) != oRB) {
                bl = true;
            }
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            if (this.numProfiles == 0) {
                Tie tie = Utility.getAndForgetTie(this);
                if (tie == null) {
                    bl = true;
                }
                try {
                    ORB oRB2 = tie.orb();
                    if (oRB2 != oRB) {
                        bl = true;
                    }
                }
                catch (BAD_OPERATION bAD_OPERATION2) {
                    tie.orb(oRB);
                    this._set_delegate(((ObjectImpl)((Object)tie))._get_delegate());
                }
            }
            try {
                OutputStream outputStream = oRB.create_output_stream();
                outputStream.write_long(this.typeLength);
                outputStream.write_octet_array(this.typeData, 0, this.typeLength);
                outputStream.write_long(this.numProfiles);
                int n = 0;
                while (n < this.numProfiles) {
                    outputStream.write_long(this.profileTags[n]);
                    outputStream.write_long(this.profileData[n].length);
                    outputStream.write_octet_array(this.profileData[n], 0, this.profileData[n].length);
                    ++n;
                }
                ObjectImpl objectImpl = (ObjectImpl)outputStream.create_input_stream().read_Object();
                this._set_delegate(objectImpl._get_delegate());
            }
            catch (Exception exception) {
                bl = true;
            }
        }
        if (bl) {
            throw new RemoteException("CORBA BAD_OPERATION 0");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (this.stubDelegate != null) {
            this.stubDelegate.readObject(this, objectInputStream);
            return;
        }
        this.typeLength = objectInputStream.readInt();
        this.typeData = new byte[this.typeLength];
        objectInputStream.readFully(this.typeData);
        this.numProfiles = objectInputStream.readInt();
        this.profileTags = new int[this.numProfiles];
        this.profileData = new byte[this.numProfiles][];
        int n = 0;
        while (n < this.numProfiles) {
            this.profileTags[n] = objectInputStream.readInt();
            this.profileData[n] = new byte[objectInputStream.readInt()];
            objectInputStream.readFully(this.profileData[n]);
            ++n;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.stubDelegate != null) {
            this.stubDelegate.writeObject(this, objectOutputStream);
            return;
        }
        this.init();
        objectOutputStream.writeInt(this.typeLength);
        objectOutputStream.write(this.typeData);
        objectOutputStream.writeInt(this.numProfiles);
        int n = 0;
        while (n < this.numProfiles) {
            objectOutputStream.writeInt(this.profileTags[n]);
            objectOutputStream.writeInt(this.profileData[n].length);
            objectOutputStream.write(this.profileData[n]);
            ++n;
        }
    }

    static {
        Object object = Utility.createDelegateIfSpecified(StubClassKey);
        if (object != null) {
            stubDelegateClass = object.getClass();
        }
    }
}

