/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.java.lang;

import com.ibm.security12.java.awt.AWTPermission;
import com.ibm.security12.java.io.FilePermission;
import com.ibm.security12.java.lang.RuntimePermission;
import com.ibm.security12.java.net.SocketPermission;
import com.ibm.security12.java.security.AccessControlContext;
import com.ibm.security12.java.security.AccessController;
import com.ibm.security12.java.security.AllPermission;
import com.ibm.security12.java.security.Permission;
import com.ibm.security12.java.security.Security;
import com.ibm.security12.java.security.SecurityPermission;
import com.ibm.security12.java.util.PropertyPermission;
import java.io.File;
import java.io.FileDescriptor;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class SecurityManager12
extends SecurityManager {
    static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    protected boolean inCheck;
    private boolean initialized = false;
    private static RuntimePermission createClassLoaderPermission;
    private static AWTPermission topLevelWindowPermission;
    private static AWTPermission accessClipboardPermission;
    private static AWTPermission checkAwtEventQueuePermission;
    private static RuntimePermission checkMemberAccessPermission;
    private static AllPermission allPermission;
    private static RuntimePermission threadPermission;
    private static RuntimePermission threadGroupPermission;
    private static final String jnIA = "java.net.InetAddress";
    private static final String cisjnSP = "com.ibm.security12.java.net.SocketPermission";
    private static ThreadGroup rootGroup;
    private static SocketPermission localListenPermission;
    private static String[] packageAccess;
    private static String[] packageDefinition;
    static /* synthetic */ Class class$com$ibm$security12$java$lang$SecurityManager12;

    private boolean hasAllPermission() {
        if (allPermission == null) {
            allPermission = new AllPermission();
        }
        try {
            this.checkPermission(allPermission);
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public SecurityManager12() {
        Class clazz = class$com$ibm$security12$java$lang$SecurityManager12 != null ? class$com$ibm$security12$java$lang$SecurityManager12 : (class$com$ibm$security12$java$lang$SecurityManager12 = SecurityManager12.class$("com.ibm.security12.java.lang.SecurityManager12"));
        synchronized (clazz) {
            SecurityManager12 securityManager12 = (SecurityManager12)System.getSecurityManager();
            if (securityManager12 != null) {
                securityManager12.checkPermission(new RuntimePermission("createSecurityManager"));
            }
            this.initialized = true;
            return;
        }
    }

    public Object getSecurityContext() {
        return AccessController.getContext();
    }

    public void checkPermission(Permission permission) {
        AccessController.checkPermission(permission);
    }

    public void checkPermission(Permission permission, Object object) {
        if (object instanceof AccessControlContext) {
            ((AccessControlContext)object).checkPermission(permission);
            return;
        }
        throw new SecurityException();
    }

    public void checkCreateClassLoader() {
        if (createClassLoaderPermission == null) {
            createClassLoaderPermission = new RuntimePermission("createClassLoader");
        }
        this.checkPermission(createClassLoaderPermission);
    }

    private static ThreadGroup getRootGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    public void checkAccess(Thread thread) {
        if (thread.getThreadGroup() == rootGroup) {
            if (threadPermission == null) {
                threadPermission = new RuntimePermission("modifyThread");
            }
            this.checkPermission(threadPermission);
        }
    }

    public void checkAccess(ThreadGroup threadGroup) {
        if (threadGroup == rootGroup) {
            if (threadGroupPermission == null) {
                threadGroupPermission = new RuntimePermission("modifyThreadGroup");
            }
            this.checkPermission(threadGroupPermission);
        }
    }

    public void checkExit(int n) {
        this.checkPermission(new RuntimePermission("exitVM"));
    }

    public void checkExec(String string) {
        File file = new File(string);
        if (file.isAbsolute()) {
            this.checkPermission(new FilePermission(string, "execute"));
            return;
        }
        this.checkPermission(new FilePermission("<<ALL FILES>>", "execute"));
    }

    public void checkLink(String string) {
        this.checkPermission(new RuntimePermission("loadLibrary." + string));
    }

    public void checkRead(FileDescriptor fileDescriptor) {
        this.checkPermission(new RuntimePermission("readFileDescriptor"));
    }

    public void checkRead(String string) {
        this.checkPermission(new FilePermission(string, "read"));
    }

    public void checkRead(String string, Object object) {
        if (object instanceof AccessControlContext) {
            ((AccessControlContext)object).checkPermission(new FilePermission(string, "read"));
            return;
        }
        throw new SecurityException();
    }

    public void checkWrite(FileDescriptor fileDescriptor) {
        this.checkPermission(new RuntimePermission("writeFileDescriptor"));
    }

    public void checkWrite(String string) {
        this.checkPermission(new FilePermission(string, "write"));
    }

    public void checkDelete(String string) {
        this.checkPermission(new FilePermission(string, "delete"));
    }

    public void checkConnect(String string, int n) {
        Class<?>[] classArray = this.getClassContext();
        if (classArray.length > 4 && classArray[1].getName().equals(jnIA) && (classArray[2].getName().equals(cisjnSP) || classArray[2].getName().equals(jnIA) && classArray[3].getName().equals(cisjnSP))) {
            return;
        }
        if (n == -1) {
            this.checkPermission(new SocketPermission(string, "resolve"));
            return;
        }
        this.checkPermission(new SocketPermission(String.valueOf(string) + ":" + n, "connect"));
    }

    public void checkConnect(String string, int n, Object object) {
        if (object instanceof AccessControlContext) {
            if (n == -1) {
                ((AccessControlContext)object).checkPermission(new SocketPermission(string, "resolve"));
                return;
            }
            ((AccessControlContext)object).checkPermission(new SocketPermission(String.valueOf(string) + ":" + n, "connect"));
            return;
        }
        throw new SecurityException();
    }

    public void checkListen(int n) {
        if (n == 0) {
            if (localListenPermission == null) {
                localListenPermission = new SocketPermission("localhost:1024-", "listen");
            }
            this.checkPermission(localListenPermission);
            return;
        }
        this.checkPermission(new SocketPermission("localhost:" + n, "listen"));
    }

    public void checkAccept(String string, int n) {
        this.checkPermission(new SocketPermission(String.valueOf(string) + ":" + n, "accept"));
    }

    public void checkMulticast(InetAddress inetAddress) {
        this.checkPermission(new SocketPermission(inetAddress.getHostAddress(), "accept,connect"));
    }

    public void checkMulticast(InetAddress inetAddress, byte by) {
        this.checkPermission(new SocketPermission(inetAddress.getHostAddress(), "accept,connect"));
    }

    public void checkPropertiesAccess() {
        this.checkPermission(new PropertyPermission("*", "read,write"));
    }

    public void checkPropertyAccess(String string) {
        this.checkPermission(new PropertyPermission(string, "read"));
    }

    public boolean checkTopLevelWindow(Object object) {
        try {
            if (topLevelWindowPermission == null) {
                topLevelWindowPermission = new AWTPermission("showWindowWithoutWarningBanner");
            }
            this.checkPermission(topLevelWindowPermission);
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public void checkPrintJobAccess() {
        this.checkPermission(new RuntimePermission("queuePrintJob"));
    }

    public void checkSystemClipboardAccess() {
        if (accessClipboardPermission == null) {
            accessClipboardPermission = new AWTPermission("accessClipboard");
        }
        this.checkPermission(accessClipboardPermission);
    }

    public void checkAwtEventQueueAccess() {
        if (checkAwtEventQueuePermission == null) {
            checkAwtEventQueuePermission = new AWTPermission("accessEventQueue");
        }
        this.checkPermission(checkAwtEventQueuePermission);
    }

    private static String[] getPackages(String string) {
        StringTokenizer stringTokenizer;
        int n;
        String[] stringArray = null;
        String string2 = Security.getProperty(string);
        if (string2 != null && !string2.equals("") && (n = (stringTokenizer = new StringTokenizer(string2, ",")).countTokens()) > 0) {
            stringArray = new String[n];
            int n2 = 0;
            while (stringTokenizer.hasMoreElements()) {
                String string3 = stringTokenizer.nextToken();
                stringArray[n2++] = string3;
            }
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public void checkPackageAccess(String string) {
        int n = 0;
        while (n < packageAccess.length) {
            if (string.startsWith(packageAccess[n]) || string.equals(packageAccess[n])) {
                this.checkPermission(new RuntimePermission("accessClassInPackage." + string));
            }
            ++n;
        }
    }

    public void checkPackageDefinition(String string) {
        int n = 0;
        while (n < packageDefinition.length) {
            if (string.startsWith(packageDefinition[n]) || string.equals(packageDefinition[n])) {
                this.checkPermission(new RuntimePermission("defineClassInPackage." + string));
            }
            ++n;
        }
    }

    public void checkSetFactory() {
        this.checkPermission(new RuntimePermission("setFactory"));
    }

    public void checkMemberAccess(Class clazz, int n) {
        Class<?>[] classArray;
        if (n != 0 && ((classArray = this.getClassContext()).length < 4 || classArray[3].getClassLoader() != clazz.getClassLoader())) {
            if (checkMemberAccessPermission == null) {
                checkMemberAccessPermission = new RuntimePermission("accessDeclaredMembers");
            }
            this.checkPermission(checkMemberAccessPermission);
        }
    }

    public void checkSecurityAccess(String string) {
        this.checkPermission(new SecurityPermission(string));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        rootGroup = SecurityManager12.getRootGroup();
        packageAccess = SecurityManager12.getPackages("package.access");
        packageDefinition = SecurityManager12.getPackages("package.definition");
        Properties properties = new Properties(System.getProperties());
        String string = properties.getProperty("java.protocol.handler.pkgs");
        string = string == null ? "com.ibm.security12.sun.net.www.protocol" : String.valueOf(string) + "| com.ibm.security12.sun.net.www.protocol";
        ((Hashtable)properties).put("java.protocol.handler.pkgs", string);
        System.setProperties(properties);
    }
}

