/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.java.security;

import com.ibm.security12.java.lang.SecurityManager12;
import com.ibm.security12.java.security.AccessController;
import com.ibm.security12.java.security.Identity;
import com.ibm.security12.java.security.PrivilegedAction;
import com.ibm.security12.java.security.Security;
import java.security.KeyManagementException;
import java.security.Principal;
import java.security.PublicKey;
import java.util.Enumeration;

public abstract class IdentityScope
extends Identity {
    private static IdentityScope scope;

    private static void initializeSystemScope() {
        String string = (String)AccessController.doPrivileged(new 1());
        if (string == null) {
            return;
        }
        try {
            Class.forName(string);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Security.error("unable to establish a system scope from " + string);
            classNotFoundException.printStackTrace();
            return;
        }
    }

    protected IdentityScope() {
        this("restoring...");
    }

    public IdentityScope(String string) {
        super(string);
    }

    public IdentityScope(String string, IdentityScope identityScope) throws KeyManagementException {
        super(string, identityScope);
    }

    public static IdentityScope getSystemScope() {
        if (scope == null) {
            IdentityScope.initializeSystemScope();
        }
        return scope;
    }

    protected static void setSystemScope(IdentityScope identityScope) {
        IdentityScope.check("setSystemScope");
        scope = identityScope;
    }

    public abstract int size();

    public abstract Identity getIdentity(String var1);

    public Identity getIdentity(Principal principal) {
        return this.getIdentity(principal.getName());
    }

    public abstract Identity getIdentity(PublicKey var1);

    public abstract void addIdentity(Identity var1) throws KeyManagementException;

    public abstract void removeIdentity(Identity var1) throws KeyManagementException;

    public abstract Enumeration identities();

    public String toString() {
        return String.valueOf(super.toString()) + "[" + this.size() + "]";
    }

    private static void check(String string) {
        SecurityManager12 securityManager12 = (SecurityManager12)System.getSecurityManager();
        if (securityManager12 != null) {
            securityManager12.checkSecurityAccess(string);
        }
    }

    private final class 1
    implements PrivilegedAction {
        public Object run() {
            return Security.getProperty("system.scope");
        }

        /* synthetic */ 1() {
        }
    }
}

