/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.provider;

import com.ibm.security12.java.security.AlgorithmParameterGeneratorSpi;
import com.ibm.security12.java.security.AlgorithmParameters;
import com.ibm.security12.java.security.InvalidAlgorithmParameterException;
import com.ibm.security12.java.security.SecureRandom;
import com.ibm.security12.java.security.spec.AlgorithmParameterSpec;
import com.ibm.security12.java.security.spec.DSAParameterSpec;
import com.ibm.security12.java.security.spec.InvalidParameterSpecException;
import com.ibm.security12.sun.security.provider.SHA;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public class DSAParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private int modLen = 1024;
    private SecureRandom random;
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private SHA sha = new SHA();

    protected void engineInit(int n, SecureRandom secureRandom) {
        if (n < 512 || n > 1024 || n % 64 != 0) {
            throw new InvalidParameterException("Prime size must range from 512 to 1024 and be a multiple of 64");
        }
        this.modLen = n;
        this.random = secureRandom;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("Invalid parameter");
    }

    protected AlgorithmParameters engineGenerateParameters() {
        AlgorithmParameters algorithmParameters = null;
        try {
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            BigInteger[] bigIntegerArray = this.generatePandQ(this.random, this.modLen);
            BigInteger bigInteger = bigIntegerArray[0];
            BigInteger bigInteger2 = bigIntegerArray[1];
            BigInteger bigInteger3 = this.generateG(bigInteger, bigInteger2);
            DSAParameterSpec dSAParameterSpec = new DSAParameterSpec(bigInteger, bigInteger2, bigInteger3);
            algorithmParameters = AlgorithmParameters.getInstance("DSA", "SUN");
            algorithmParameters.init(dSAParameterSpec);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException(invalidParameterSpecException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException.getMessage());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException(noSuchProviderException.getMessage());
        }
        return algorithmParameters;
    }

    BigInteger[] generatePandQ(SecureRandom secureRandom, int n) {
        BigInteger[] bigIntegerArray = null;
        byte[] byArray = new byte[20];
        while (bigIntegerArray == null) {
            int n2 = 0;
            while (n2 < 20) {
                byArray[n2] = (byte)secureRandom.nextInt();
                ++n2;
            }
            bigIntegerArray = this.generatePandQ(byArray, n);
        }
        return bigIntegerArray;
    }

    BigInteger[] generatePandQ(byte[] byArray, int n) {
        int n2 = byArray.length * 8;
        int n3 = (n - 1) / 160;
        int n4 = (n - 1) % 160;
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = TWO.pow(2 * n2);
        byte[] byArray2 = this.SHA(byArray);
        byte[] byArray3 = this.SHA(this.toByteArray(bigInteger.add(ONE).mod(bigInteger2)));
        this.xor(byArray2, byArray3);
        byte[] byArray4 = byArray2;
        byArray4[0] = (byte)(byArray4[0] | 0x80);
        byArray4[19] = (byte)(byArray4[19] | 1);
        BigInteger bigInteger3 = new BigInteger(1, byArray4);
        if (!bigInteger3.isProbablePrime(40)) {
            return null;
        }
        BigInteger[] bigIntegerArray = new BigInteger[n3 + 1];
        BigInteger bigInteger4 = TWO;
        int n5 = 0;
        while (n5 < 4096) {
            BigInteger bigInteger5;
            BigInteger bigInteger6;
            BigInteger bigInteger7;
            int n6 = 0;
            while (n6 <= n3) {
                bigInteger7 = BigInteger.valueOf(n6);
                BigInteger bigInteger8 = bigInteger.add(bigInteger4).add(bigInteger7).mod(bigInteger2);
                bigIntegerArray[n6] = new BigInteger(1, this.SHA(this.toByteArray(bigInteger8)));
                ++n6;
            }
            bigInteger7 = bigIntegerArray[0];
            int n7 = 1;
            while (n7 < n3) {
                bigInteger7 = bigInteger7.add(bigIntegerArray[n7].multiply(TWO.pow(n7 * 160)));
                ++n7;
            }
            BigInteger bigInteger9 = (bigInteger7 = bigInteger7.add(bigIntegerArray[n3].mod(TWO.pow(n4)).multiply(TWO.pow(n3 * 160)))).add(bigInteger6 = TWO.pow(n - 1));
            BigInteger bigInteger10 = bigInteger9.subtract((bigInteger5 = bigInteger9.mod(bigInteger3.multiply(TWO))).subtract(ONE));
            if (bigInteger10.compareTo(bigInteger6) > -1 && bigInteger10.isProbablePrime(15)) {
                BigInteger[] bigIntegerArray2 = new BigInteger[]{bigInteger10, bigInteger3, bigInteger, BigInteger.valueOf(n5)};
                return bigIntegerArray2;
            }
            bigInteger4 = bigInteger4.add(BigInteger.valueOf(n3)).add(ONE);
            ++n5;
        }
        return null;
    }

    BigInteger generateG(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = ONE;
        BigInteger bigInteger4 = bigInteger.subtract(ONE).divide(bigInteger2);
        BigInteger bigInteger5 = ONE;
        while (bigInteger5.compareTo(TWO) < 0) {
            bigInteger5 = bigInteger3.modPow(bigInteger4, bigInteger);
            bigInteger3 = bigInteger3.add(ONE);
        }
        return bigInteger5;
    }

    private byte[] SHA(byte[] byArray) {
        this.sha.engineReset();
        this.sha.engineUpdate(byArray, 0, byArray.length);
        return this.sha.engineDigest();
    }

    private byte[] toByteArray(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            byArray = byArray2;
        }
        return byArray;
    }

    private void xor(byte[] byArray, byte[] byArray2) {
        int n = 0;
        while (n < byArray.length) {
            int n2 = n;
            byArray[n2] = (byte)(byArray[n2] ^ byArray2[n]);
            ++n;
        }
    }
}

