/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.x509;

import com.ibm.security12.sun.security.util.DerInputStream;
import com.ibm.security12.sun.security.util.DerOutputStream;
import com.ibm.security12.sun.security.util.DerValue;
import com.ibm.security12.sun.security.x509.AttributeNameEnumeration;
import com.ibm.security12.sun.security.x509.CertAttrSet;
import com.ibm.security12.sun.security.x509.UniqueIdentity;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;

public class CertificateSubjectUniqueIdentity
implements CertAttrSet {
    static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    public static final String IDENT = "x509.info.subjectID";
    public static final String NAME = "subjectID";
    public static final String ID = "id";
    private UniqueIdentity id;

    public CertificateSubjectUniqueIdentity(UniqueIdentity uniqueIdentity) {
        this.id = uniqueIdentity;
    }

    public CertificateSubjectUniqueIdentity(DerInputStream derInputStream) throws IOException {
        this.id = new UniqueIdentity(derInputStream);
    }

    public CertificateSubjectUniqueIdentity(InputStream inputStream) throws IOException {
        DerValue derValue = new DerValue(inputStream);
        this.id = new UniqueIdentity(derValue);
    }

    public CertificateSubjectUniqueIdentity(DerValue derValue) throws IOException {
        this.id = new UniqueIdentity(derValue);
    }

    public String toString() {
        if (this.id == null) {
            return "";
        }
        return this.id.toString();
    }

    public void decode(InputStream inputStream) throws IOException {
        DerValue derValue = new DerValue(inputStream);
        this.id = new UniqueIdentity(derValue);
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.id.encode(derOutputStream, DerValue.createTag((byte)-128, false, (byte)2));
        outputStream.write(derOutputStream.toByteArray());
    }

    public void set(String string, Object object) throws IOException {
        if (!(object instanceof UniqueIdentity)) {
            throw new IOException("Attribute must be of type UniqueIdentity.");
        }
        if (string.equalsIgnoreCase(ID)) {
            this.id = (UniqueIdentity)object;
            return;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet: CertificateSubjectUniqueIdentity.");
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(ID)) {
            return this.id;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet: CertificateSubjectUniqueIdentity.");
    }

    public void delete(String string) throws IOException {
        if (string.equalsIgnoreCase(ID)) {
            this.id = null;
            return;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet: CertificateSubjectUniqueIdentity.");
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(ID);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }
}

