/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.x509;

import com.ibm.security12.sun.security.util.DerOutputStream;
import com.ibm.security12.sun.security.util.DerValue;
import com.ibm.security12.sun.security.x509.DNSName;
import com.ibm.security12.sun.security.x509.EDIPartyName;
import com.ibm.security12.sun.security.x509.GeneralNameInterface;
import com.ibm.security12.sun.security.x509.IPAddressName;
import com.ibm.security12.sun.security.x509.OIDName;
import com.ibm.security12.sun.security.x509.OtherName;
import com.ibm.security12.sun.security.x509.RFC822Name;
import com.ibm.security12.sun.security.x509.URIName;
import com.ibm.security12.sun.security.x509.X500Name;
import java.io.IOException;

public class GeneralName {
    static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private GeneralNameInterface name;

    public GeneralName(GeneralNameInterface generalNameInterface) {
        this.name = generalNameInterface;
    }

    public GeneralName(DerValue derValue) throws IOException {
        short s = (byte)(derValue.tag & 0x1F);
        switch (s) {
            case 0: {
                if (derValue.isContextSpecific() && derValue.isConstructed()) {
                    derValue.resetTag((byte)48);
                    this.name = new OtherName(derValue);
                    return;
                }
                throw new IOException("Invalid encoding of Other-Name");
            }
            case 1: {
                if (derValue.isContextSpecific() && !derValue.isConstructed()) {
                    derValue.resetTag((byte)22);
                    this.name = new RFC822Name(derValue);
                    return;
                }
                throw new IOException("Invalid encoding of RFC822 name");
            }
            case 2: {
                if (derValue.isContextSpecific() && !derValue.isConstructed()) {
                    derValue.resetTag((byte)22);
                    this.name = new DNSName(derValue);
                    return;
                }
                throw new IOException("Invalid encoding of DNS name");
            }
            case 6: {
                if (derValue.isContextSpecific() && !derValue.isConstructed()) {
                    derValue.resetTag((byte)22);
                    this.name = new URIName(derValue);
                    return;
                }
                throw new IOException("Invalid encoding of URI");
            }
            case 7: {
                if (derValue.isContextSpecific() && !derValue.isConstructed()) {
                    derValue.resetTag((byte)4);
                    this.name = new IPAddressName(derValue);
                    return;
                }
                throw new IOException("Invalid encoding of IP address");
            }
            case 8: {
                if (derValue.isContextSpecific() && !derValue.isConstructed()) {
                    derValue.resetTag((byte)6);
                    this.name = new OIDName(derValue);
                    return;
                }
                throw new IOException("Invalid encoding of OID name");
            }
            case 4: {
                if (derValue.isContextSpecific() && derValue.isConstructed()) {
                    derValue.resetTag((byte)48);
                    this.name = new X500Name(derValue);
                    return;
                }
                throw new IOException("Invalid encoding of Directory name");
            }
            case 5: {
                if (derValue.isContextSpecific() && derValue.isConstructed()) {
                    derValue.resetTag((byte)48);
                    this.name = new EDIPartyName(derValue);
                    return;
                }
                throw new IOException("Invalid encoding of EDI name");
            }
        }
        throw new IOException("Unrecognized GeneralName tag, (" + s + ")");
    }

    public int getType() {
        return this.name.getType();
    }

    public String toString() {
        return this.name.toString();
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        this.name.encode(derOutputStream2);
        int n = this.name.getType();
        if (n == 0 || n == 3 || n == 4 || n == 5) {
            derOutputStream.writeImplicit(DerValue.createTag((byte)-128, true, (byte)n), derOutputStream2);
            return;
        }
        derOutputStream.writeImplicit(DerValue.createTag((byte)-128, false, (byte)n), derOutputStream2);
    }
}

