/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.x509;

import com.ibm.security12.java.security.Signature;
import com.ibm.security12.java.security.cert.CRLException;
import com.ibm.security12.java.security.cert.Certificate;
import com.ibm.security12.java.security.cert.X509CRL;
import com.ibm.security12.java.security.cert.X509CRLEntry;
import com.ibm.security12.java.security.cert.X509Certificate;
import com.ibm.security12.java.util.Collection;
import com.ibm.security12.java.util.HashSet;
import com.ibm.security12.java.util.Hashtable;
import com.ibm.security12.java.util.Set;
import com.ibm.security12.sun.security.util.BigInt;
import com.ibm.security12.sun.security.util.DerInputStream;
import com.ibm.security12.sun.security.util.DerOutputStream;
import com.ibm.security12.sun.security.util.DerValue;
import com.ibm.security12.sun.security.util.ObjectIdentifier;
import com.ibm.security12.sun.security.x509.AlgorithmId;
import com.ibm.security12.sun.security.x509.CRLExtensions;
import com.ibm.security12.sun.security.x509.Extension;
import com.ibm.security12.sun.security.x509.OIDMap;
import com.ibm.security12.sun.security.x509.X500Name;
import com.ibm.security12.sun.security.x509.X509CRLEntryImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.Date;
import java.util.Enumeration;
import sun.misc.HexDumpEncoder;

public class X509CRLImpl
extends X509CRL {
    static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private byte[] signedCRL;
    private byte[] signature;
    private byte[] tbsCertList;
    private AlgorithmId sigAlgId;
    private int version;
    private AlgorithmId infoSigAlgId;
    private X500Name issuer;
    private Date thisUpdate;
    private Date nextUpdate;
    private Hashtable revokedCerts = new Hashtable(11);
    private CRLExtensions extensions;
    private static final boolean isExplicit = true;
    private static final long YR_2050 = 2524636800000L;
    private boolean readOnly = false;

    private X509CRLImpl() {
    }

    public X509CRLImpl(byte[] byArray) throws CRLException {
        try {
            this.parse(new DerValue(byArray));
            return;
        }
        catch (IOException iOException) {
            this.signedCRL = null;
            throw new CRLException("Parsing error: " + iOException.getMessage());
        }
    }

    public X509CRLImpl(DerValue derValue) throws CRLException {
        try {
            this.parse(derValue);
            return;
        }
        catch (IOException iOException) {
            this.signedCRL = null;
            throw new CRLException("Parsing error: " + iOException.getMessage());
        }
    }

    public X509CRLImpl(InputStream inputStream) throws CRLException {
        try {
            this.parse(new DerValue(inputStream));
            return;
        }
        catch (IOException iOException) {
            this.signedCRL = null;
            throw new CRLException("Parsing error: " + iOException.getMessage());
        }
    }

    public X509CRLImpl(X500Name x500Name, Date date, Date date2) {
        this.issuer = x500Name;
        this.thisUpdate = date;
        this.nextUpdate = date2;
    }

    public X509CRLImpl(X500Name x500Name, Date date, Date date2, X509CRLEntry[] x509CRLEntryArray) throws CRLException {
        this.issuer = x500Name;
        this.thisUpdate = date;
        this.nextUpdate = date2;
        if (x509CRLEntryArray != null) {
            int n = 0;
            while (n < x509CRLEntryArray.length) {
                this.revokedCerts.put(x509CRLEntryArray[n].getSerialNumber(), x509CRLEntryArray[n]);
                ++n;
            }
        }
    }

    public X509CRLImpl(X500Name x500Name, Date date, Date date2, X509CRLEntry[] x509CRLEntryArray, CRLExtensions cRLExtensions) throws CRLException {
        this.issuer = x500Name;
        this.thisUpdate = date;
        this.nextUpdate = date2;
        if (x509CRLEntryArray != null) {
            int n = 0;
            while (n < x509CRLEntryArray.length) {
                if (x509CRLEntryArray[n] != null) {
                    this.revokedCerts.put(x509CRLEntryArray[n].getSerialNumber(), x509CRLEntryArray[n]);
                    if (x509CRLEntryArray[n].hasExtensions()) {
                        this.version = 1;
                    }
                }
                ++n;
            }
        }
        if (cRLExtensions != null) {
            this.extensions = cRLExtensions;
            this.version = 1;
        }
    }

    public byte[] getEncoded() throws CRLException {
        if (this.signedCRL == null) {
            throw new CRLException("Null CRL to encode");
        }
        byte[] byArray = new byte[this.signedCRL.length];
        System.arraycopy(this.signedCRL, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public void encodeInfo(OutputStream outputStream) throws CRLException {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            DerOutputStream derOutputStream3 = new DerOutputStream();
            if (this.version != 0) {
                derOutputStream.putInteger(new BigInt(this.version));
            }
            this.infoSigAlgId.encode(derOutputStream);
            if (this.version == 0 && this.issuer.toString() == null) {
                throw new CRLException("Null Issuer DN not allowed in v1 CRL");
            }
            this.issuer.encode(derOutputStream);
            if (this.thisUpdate.getTime() < 2524636800000L) {
                derOutputStream.putUTCTime(this.thisUpdate);
            } else {
                derOutputStream.putGeneralizedTime(this.thisUpdate);
            }
            if (this.nextUpdate != null) {
                if (this.nextUpdate.getTime() < 2524636800000L) {
                    derOutputStream.putUTCTime(this.nextUpdate);
                } else {
                    derOutputStream.putGeneralizedTime(this.nextUpdate);
                }
            }
            if (!this.revokedCerts.isEmpty()) {
                Enumeration enumeration = this.revokedCerts.elements();
                while (enumeration.hasMoreElements()) {
                    ((X509CRLEntryImpl)enumeration.nextElement()).encode(derOutputStream2);
                }
                derOutputStream.write((byte)48, derOutputStream2);
            }
            if (this.extensions != null) {
                this.extensions.encode(derOutputStream, true);
            }
            derOutputStream3.write((byte)48, derOutputStream);
            this.tbsCertList = derOutputStream3.toByteArray();
            outputStream.write(this.tbsCertList);
            return;
        }
        catch (IOException iOException) {
            throw new CRLException("Encoding error: " + iOException.getMessage());
        }
    }

    public void verify(PublicKey publicKey) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(publicKey, null);
    }

    public void verify(PublicKey publicKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (this.signedCRL == null) {
            throw new CRLException("Uninitialized CRL");
        }
        Signature signature = null;
        signature = string == null || string.length() == 0 ? Signature.getInstance(this.sigAlgId.getName()) : Signature.getInstance(this.sigAlgId.getName(), string);
        signature.initVerify(publicKey);
        if (this.tbsCertList == null) {
            throw new CRLException("Uninitialized CRL");
        }
        signature.update(this.tbsCertList, 0, this.tbsCertList.length);
        if (!signature.verify(this.signature)) {
            throw new SignatureException("Signature does not match.");
        }
    }

    public void sign(PrivateKey privateKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.sign(privateKey, string, null);
    }

    public void sign(PrivateKey privateKey, String string, String string2) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        try {
            if (this.readOnly) {
                throw new CRLException("cannot over-write existing CRL");
            }
            Signature signature = null;
            signature = string2 == null || string2.length() == 0 ? Signature.getInstance(string) : Signature.getInstance(string, string2);
            signature.initSign(privateKey);
            this.infoSigAlgId = this.sigAlgId = AlgorithmId.get(signature.getAlgorithm());
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encodeInfo(derOutputStream2);
            this.sigAlgId.encode(derOutputStream2);
            signature.update(this.tbsCertList, 0, this.tbsCertList.length);
            this.signature = signature.sign();
            derOutputStream2.putBitString(this.signature);
            derOutputStream.write((byte)48, derOutputStream2);
            this.signedCRL = derOutputStream.toByteArray();
            this.readOnly = true;
            return;
        }
        catch (IOException iOException) {
            throw new CRLException("Error while encoding data: " + iOException.getMessage());
        }
    }

    public String toString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("X.509 CRL v" + (this.version + 1) + "\n");
        if (this.sigAlgId != null) {
            stringBuffer.append("Signature Algorithm: " + this.sigAlgId.toString() + ", OID=" + this.sigAlgId.getOID().toString() + "\n");
        }
        if (this.issuer != null) {
            stringBuffer.append("Issuer: " + this.issuer.toString() + "\n");
        }
        if (this.thisUpdate != null) {
            stringBuffer.append("\nThis Update: " + this.thisUpdate.toString() + "\n");
        }
        if (this.nextUpdate != null) {
            stringBuffer.append("Next Update: " + this.nextUpdate.toString() + "\n");
        }
        if (this.revokedCerts.isEmpty()) {
            stringBuffer.append("\nNO certificates have been revoked\n");
        } else {
            stringBuffer.append("\nRevoked Certificates: " + this.revokedCerts.size());
            int n = 1;
            object = this.revokedCerts.elements();
            while (object.hasMoreElements()) {
                stringBuffer.append("\n[" + n + "] " + ((X509CRLEntry)object.nextElement()).toString());
                ++n;
            }
        }
        if (this.extensions != null) {
            Collection collection = this.extensions.getAllExtensions();
            object = collection.toArray();
            stringBuffer.append("\nCRL Extensions: " + ((Object)object).length);
            int n = 0;
            while (n < ((Object)object).length) {
                stringBuffer.append("\n[" + (n + 1) + "]: ");
                Extension extension = (Extension)object[n];
                try {
                    if (OIDMap.getClass(extension.getExtensionId()) == null) {
                        stringBuffer.append(extension.toString());
                        byte[] byArray = extension.getExtensionValue();
                        if (byArray != null) {
                            DerOutputStream derOutputStream = new DerOutputStream();
                            derOutputStream.putOctetString(byArray);
                            byArray = derOutputStream.toByteArray();
                            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                            stringBuffer.append("Extension unknown: DER encoded OCTET string =\n" + hexDumpEncoder.encodeBuffer(byArray) + "\n");
                        }
                    } else {
                        stringBuffer.append(extension.toString());
                    }
                }
                catch (Exception exception) {
                    stringBuffer.append(", Error parsing this extension");
                }
                ++n;
            }
        }
        if (this.signature != null) {
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            stringBuffer.append("\nSignature:\n" + hexDumpEncoder.encodeBuffer(this.signature) + "\n");
        } else {
            stringBuffer.append("NOT signed yet\n");
        }
        return stringBuffer.toString();
    }

    public boolean isRevoked(Certificate certificate) {
        if (this.revokedCerts == null || this.revokedCerts.isEmpty()) {
            return false;
        }
        if (!(certificate instanceof X509Certificate)) {
            return false;
        }
        BigInteger bigInteger = ((X509Certificate)certificate).getSerialNumber();
        return this.revokedCerts.containsKey(bigInteger);
    }

    public int getVersion() {
        return this.version + 1;
    }

    public Principal getIssuerDN() {
        return this.issuer;
    }

    public Date getThisUpdate() {
        return new Date(this.thisUpdate.getTime());
    }

    public Date getNextUpdate() {
        if (this.nextUpdate == null) {
            return null;
        }
        return new Date(this.nextUpdate.getTime());
    }

    public X509CRLEntry getRevokedCertificate(BigInteger bigInteger) {
        if (this.revokedCerts == null || this.revokedCerts.isEmpty()) {
            return null;
        }
        return (X509CRLEntry)this.revokedCerts.get(bigInteger);
    }

    public Set getRevokedCertificates() {
        if (this.revokedCerts == null || this.revokedCerts.isEmpty()) {
            return null;
        }
        HashSet hashSet = new HashSet(11);
        Collection collection = this.revokedCerts.values();
        Object[] objectArray = collection.toArray();
        int n = 0;
        while (n < objectArray.length) {
            hashSet.add(objectArray[n]);
            ++n;
        }
        return hashSet;
    }

    public byte[] getTBSCertList() throws CRLException {
        if (this.tbsCertList == null) {
            throw new CRLException("Uninitialized CRL");
        }
        byte[] byArray = new byte[this.tbsCertList.length];
        System.arraycopy(this.tbsCertList, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public byte[] getSignature() {
        if (this.signature == null) {
            return null;
        }
        byte[] byArray = new byte[this.signature.length];
        System.arraycopy(this.signature, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public String getSigAlgName() {
        if (this.sigAlgId == null) {
            return null;
        }
        return this.sigAlgId.getName();
    }

    public String getSigAlgOID() {
        if (this.sigAlgId == null) {
            return null;
        }
        ObjectIdentifier objectIdentifier = this.sigAlgId.getOID();
        return objectIdentifier.toString();
    }

    public byte[] getSigAlgParams() {
        if (this.sigAlgId == null) {
            return null;
        }
        try {
            return this.sigAlgId.getEncodedParams();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean hasUnsupportedCriticalExtension() {
        if (this.extensions == null) {
            return false;
        }
        return this.extensions.hasUnsupportedCriticalExtension();
    }

    public Set getCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        HashSet hashSet = new HashSet(11);
        Enumeration enumeration = this.extensions.getElements();
        while (enumeration.hasMoreElements()) {
            Extension extension = (Extension)enumeration.nextElement();
            if (!extension.isCritical()) continue;
            hashSet.add(extension.getExtensionId().toString());
        }
        return hashSet;
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        HashSet hashSet = new HashSet(11);
        Enumeration enumeration = this.extensions.getElements();
        while (enumeration.hasMoreElements()) {
            Extension extension = (Extension)enumeration.nextElement();
            if (extension.isCritical()) continue;
            hashSet.add(extension.getExtensionId().toString());
        }
        return hashSet;
    }

    public byte[] getExtensionValue(String string) {
        if (this.extensions == null) {
            return null;
        }
        try {
            Object object;
            Object object2;
            String string2 = OIDMap.getName(new ObjectIdentifier(string));
            Object object3 = null;
            if (string2 == null) {
                object2 = new ObjectIdentifier(string);
                object = null;
                Enumeration enumeration = this.extensions.getElements();
                while (enumeration.hasMoreElements()) {
                    object = (Extension)enumeration.nextElement();
                    ObjectIdentifier objectIdentifier = ((Extension)object).getExtensionId();
                    if (!objectIdentifier.equals((ObjectIdentifier)object2)) continue;
                    object3 = object;
                    break;
                }
            } else {
                object3 = this.extensions.get(string2);
            }
            if (object3 == null) {
                return null;
            }
            object2 = ((Extension)object3).getExtensionValue();
            if (object2 == null) {
                return null;
            }
            object = new DerOutputStream();
            ((DerOutputStream)object).putOctetString((byte[])object2);
            return ((ByteArrayOutputStream)object).toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void parse(DerValue derValue) throws CRLException, IOException {
        DerValue derValue2;
        AlgorithmId algorithmId;
        if (this.readOnly) {
            throw new CRLException("cannot over-write existing CRL");
        }
        this.signedCRL = derValue.toByteArray();
        DerValue[] derValueArray = new DerValue[]{derValue.data.getDerValue(), derValue.data.getDerValue(), derValue.data.getDerValue()};
        if (derValue.data.available() != 0) {
            throw new CRLException("signed overrun, bytes = " + derValue.data.available());
        }
        if (derValueArray[0].tag != 48) {
            throw new CRLException("signed CRL fields invalid");
        }
        this.sigAlgId = AlgorithmId.parse(derValueArray[1]);
        this.signature = derValueArray[2].getBitString();
        if (derValueArray[1].data.available() != 0) {
            throw new CRLException("AlgorithmId field overrun");
        }
        if (derValueArray[2].data.available() != 0) {
            throw new CRLException("Signature field overrun");
        }
        this.tbsCertList = derValueArray[0].toByteArray();
        DerInputStream derInputStream = derValueArray[0].data;
        this.version = 0;
        byte by = (byte)derInputStream.peekByte();
        if (by == 2) {
            this.version = derInputStream.getInteger().toInt();
            if (this.version != 1) {
                throw new CRLException("Invalid version");
            }
        }
        if (!(algorithmId = AlgorithmId.parse(derValue2 = derInputStream.getDerValue())).equals(this.sigAlgId)) {
            throw new CRLException("Signature algorithm mismatch");
        }
        this.infoSigAlgId = algorithmId;
        this.issuer = new X500Name(derInputStream);
        if (this.issuer.toString() == null && this.version == 0) {
            throw new CRLException("Null Issuer DN allowed only in v2 CRL");
        }
        by = (byte)derInputStream.peekByte();
        if (by == 23) {
            this.thisUpdate = derInputStream.getUTCTime();
        } else if (by == 24) {
            this.thisUpdate = derInputStream.getGeneralizedTime();
        } else {
            throw new CRLException("Invalid encoding for thisUpdate (tag=" + by + ")");
        }
        by = (byte)derInputStream.peekByte();
        if (by == 23) {
            this.nextUpdate = derInputStream.getUTCTime();
        } else if (by == 24) {
            this.nextUpdate = derInputStream.getGeneralizedTime();
        }
        if (derInputStream.available() == 0) {
            return;
        }
        by = (byte)derInputStream.peekByte();
        if (by == 48 && (by & 0xC0) != 128) {
            DerValue[] derValueArray2 = derInputStream.getSequence(4);
            int n = 0;
            while (n < derValueArray2.length) {
                X509CRLEntryImpl x509CRLEntryImpl = new X509CRLEntryImpl(derValueArray2[n]);
                if (x509CRLEntryImpl.hasExtensions() && this.version == 0) {
                    throw new CRLException("Invalid encoding, extensions not supported in CRL v1 entries.");
                }
                this.revokedCerts.put(x509CRLEntryImpl.getSerialNumber(), x509CRLEntryImpl);
                ++n;
            }
        }
        if (derInputStream.available() == 0) {
            return;
        }
        derValue2 = derInputStream.getDerValue();
        if (derValue2.isConstructed() && derValue2.isContextSpecific((byte)0)) {
            if (this.version == 0) {
                throw new CRLException("Invalid encoding, extensions not supported in CRL v1.");
            }
            this.extensions = new CRLExtensions(derValue2.data);
        }
        this.readOnly = true;
    }
}

