/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rmi.corba;

import com.sun.rmi.corba.AnyInputStream;
import com.sun.rmi.corba.AnyOutputStream;
import com.sun.rmi.corba.TCUtility;
import com.sun.rmi.corba.TypeCodeImpl;
import com.sun.rmi.iiop.CDRInputStream;
import com.sun.rmi.util.RepositoryId;
import java.io.Serializable;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.Streamable;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class AnyImpl
extends Any {
    private TypeCodeImpl typeCode;
    protected ORB orb;
    private CDRInputStream stream;
    private long value;
    private java.lang.Object object;
    private static final int DEFAULT_BUFFER_SIZE = 32;
    static boolean[] isStreamed;
    static /* synthetic */ Class class$java$lang$String;

    public AnyImpl(ORB oRB) {
        this.orb = oRB;
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_null);
        this.stream = null;
        this.object = null;
        this.value = 0L;
    }

    AnyImpl(ORB oRB, Any any) {
        this(oRB);
        if (any instanceof AnyImpl) {
            AnyImpl anyImpl = (AnyImpl)any;
            this.typeCode = anyImpl.typeCode;
            this.value = anyImpl.value;
            this.object = anyImpl.object;
            if (anyImpl.stream != null) {
                this.stream = anyImpl.stream.dup();
                return;
            }
        } else {
            this.read_value(any.create_input_stream(), any.type());
        }
    }

    public TypeCode type() {
        return this.typeCode;
    }

    public void type(TypeCode typeCode) {
        this.typeCode = TypeCodeImpl.convertToNative(this.orb, typeCode);
        this.stream = null;
        this.value = 0L;
        this.object = null;
    }

    public boolean equal(Any any) {
        if (!this.typeCode.equal(any.type())) {
            return false;
        }
        switch (this.typeCode.kind().value()) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return this.extract_short() == any.extract_short();
            }
            case 3: {
                return this.extract_long() == any.extract_long();
            }
            case 4: {
                return this.extract_ushort() == any.extract_ushort();
            }
            case 5: {
                return this.extract_ulong() == any.extract_ulong();
            }
            case 6: {
                return this.extract_float() == any.extract_float();
            }
            case 7: {
                return this.extract_double() == any.extract_double();
            }
            case 8: {
                return this.extract_boolean() == any.extract_boolean();
            }
            case 9: {
                return this.extract_char() == any.extract_char();
            }
            case 10: {
                return this.extract_octet() == any.extract_octet();
            }
            case 11: {
                return this.extract_any().equal(any.extract_any());
            }
            case 12: {
                return this.extract_TypeCode().equal(any.extract_TypeCode());
            }
            case 18: {
                return this.extract_string().equals(any.extract_string());
            }
            case 23: {
                return this.extract_longlong() == any.extract_longlong();
            }
            case 24: {
                return this.extract_ulonglong() == any.extract_ulonglong();
            }
            case 17: {
                return this.create_input_stream().read_long() == any.create_input_stream().read_long();
            }
            case 25: 
            case 26: 
            case 27: {
                throw new NO_IMPLEMENT();
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                throw new NO_IMPLEMENT();
            }
            case 29: 
            case 30: {
                throw new NO_IMPLEMENT();
            }
        }
        return false;
    }

    public org.omg.CORBA.portable.OutputStream create_output_stream() {
        return new AnyOutputStream(this.orb, 32);
    }

    public org.omg.CORBA.portable.InputStream create_input_stream() {
        if (this.stream != null) {
            return this.stream.dup();
        }
        OutputStream outputStream = (OutputStream)this.orb.create_output_stream();
        TCUtility.marshalIn(outputStream, this.typeCode.kind().value(), this.value, this.object);
        return outputStream.create_input_stream();
    }

    public void read_value(org.omg.CORBA.portable.InputStream inputStream, TypeCode typeCode) {
        this.typeCode = TypeCodeImpl.convertToNative(this.orb, typeCode);
        int n = this.typeCode.kind().value();
        if (isStreamed[n]) {
            if (inputStream instanceof AnyInputStream) {
                this.stream = (CDRInputStream)inputStream;
                return;
            }
            OutputStream outputStream = (OutputStream)this.orb.create_output_stream();
            this.typeCode.copy((InputStream)inputStream, outputStream);
            this.stream = (CDRInputStream)outputStream.create_input_stream();
            return;
        }
        java.lang.Object[] objectArray = new java.lang.Object[]{this.object};
        long[] lArray = new long[1];
        TCUtility.unmarshalIn(inputStream, n, lArray, objectArray);
        this.value = lArray[0];
        this.object = objectArray[0];
        this.stream = null;
    }

    public void write_value(org.omg.CORBA.portable.OutputStream outputStream) {
        if (this.stream != null) {
            this.typeCode.copy(this.stream.dup(), (OutputStream)outputStream);
            return;
        }
        TCUtility.marshalIn(outputStream, this.typeCode.kind().value(), this.value, this.object);
    }

    public void insert_Streamable(Streamable streamable) {
        this.typeCode = TypeCodeImpl.convertToNative(this.orb, streamable._type());
        this.object = streamable;
    }

    public void insert_short(short s) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_short);
        this.value = s;
    }

    public short extract_short() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_short))) {
            throw new BAD_OPERATION();
        }
        return (short)this.value;
    }

    public void insert_long(int n) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_long);
        this.value = n;
    }

    public int extract_long() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_long))) {
            throw new BAD_OPERATION();
        }
        return (int)this.value;
    }

    public void insert_ushort(short s) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_ushort);
        this.value = s;
    }

    public short extract_ushort() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_ushort))) {
            throw new BAD_OPERATION();
        }
        return (short)this.value;
    }

    public void insert_ulong(int n) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_ulong);
        this.value = n;
    }

    public int extract_ulong() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_ulong))) {
            throw new BAD_OPERATION();
        }
        return (int)this.value;
    }

    public void insert_float(float f) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_float);
        this.value = Float.floatToIntBits(f);
    }

    public float extract_float() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_float))) {
            throw new BAD_OPERATION();
        }
        return Float.intBitsToFloat((int)this.value);
    }

    public void insert_double(double d) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_double);
        this.value = Double.doubleToLongBits(d);
    }

    public double extract_double() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_double))) {
            throw new BAD_OPERATION();
        }
        return Double.longBitsToDouble(this.value);
    }

    public void insert_longlong(long l) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_longlong);
        this.value = l;
    }

    public long extract_longlong() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_longlong))) {
            throw new BAD_OPERATION();
        }
        return this.value;
    }

    public void insert_ulonglong(long l) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_ulonglong);
        this.value = l;
    }

    public long extract_ulonglong() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_ulonglong))) {
            throw new BAD_OPERATION();
        }
        return this.value;
    }

    public void insert_boolean(boolean bl) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_boolean);
        this.value = bl ? 1 : 0;
    }

    public boolean extract_boolean() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_boolean))) {
            throw new BAD_OPERATION();
        }
        return this.value != 0L;
    }

    public void insert_char(char c) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_char);
        this.value = c;
    }

    public char extract_char() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_char))) {
            throw new BAD_OPERATION();
        }
        return (char)this.value;
    }

    public void insert_wchar(char c) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_wchar);
        this.value = c;
    }

    public char extract_wchar() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_wchar))) {
            throw new BAD_OPERATION();
        }
        return (char)this.value;
    }

    public void insert_octet(byte by) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_octet);
        this.value = by;
    }

    public byte extract_octet() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_octet))) {
            throw new BAD_OPERATION();
        }
        return (byte)this.value;
    }

    public void insert_string(String string) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_string);
        this.object = string;
    }

    public String extract_string() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_string))) {
            throw new BAD_OPERATION();
        }
        return (String)this.object;
    }

    public void insert_wstring(String string) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_wstring);
        this.object = string;
    }

    public String extract_wstring() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_wstring))) {
            throw new BAD_OPERATION();
        }
        return (String)this.object;
    }

    public void insert_any(Any any) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_any);
        this.object = any;
        this.stream = null;
    }

    public Any extract_any() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_any))) {
            throw new BAD_OPERATION();
        }
        return (Any)this.object;
    }

    public void insert_Object(Object object) {
        if (object == null) {
            this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_objref);
        } else {
            ObjectImpl objectImpl = (ObjectImpl)object;
            String[] stringArray = objectImpl._ids();
            this.typeCode = new TypeCodeImpl(this.orb, 14, stringArray[0], "");
        }
        this.object = object;
    }

    public void insert_Object(Object object, TypeCode typeCode) {
        try {
            if (typeCode.id().equals("IDL:omg.org/CORBA/Object:1.0") || object._is_a(typeCode.id())) {
                this.typeCode = TypeCodeImpl.convertToNative(this.orb, typeCode);
                this.object = object;
                return;
            }
            throw new BAD_OPERATION();
        }
        catch (Exception exception) {
            throw new BAD_OPERATION();
        }
    }

    public Object extract_Object() {
        Object object = null;
        try {
            object = (Object)this.object;
            if (this.typeCode.id().equals("IDL:omg.org/CORBA/Object:1.0") || object._is_a(this.typeCode.id())) {
                return object;
            }
            throw new BAD_OPERATION();
        }
        catch (Exception exception) {
            throw new BAD_OPERATION();
        }
    }

    public void insert_TypeCode(TypeCode typeCode) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_TypeCode);
        this.object = typeCode;
    }

    public TypeCode extract_TypeCode() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_TypeCode))) {
            throw new BAD_OPERATION();
        }
        return (TypeCode)this.object;
    }

    public void insert_Principal(Principal principal) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_Principal);
        this.object = principal;
    }

    public Principal extract_Principal() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_Principal))) {
            throw new BAD_OPERATION();
        }
        return (Principal)this.object;
    }

    public Serializable extract_Value() throws BAD_OPERATION {
        int n = this.typeCode.kind().value();
        if (n != 29 && n != 30) {
            throw new BAD_OPERATION();
        }
        return (Serializable)this.object;
    }

    public void insert_Value(Serializable serializable) {
        this.object = serializable;
        TypeCode typeCode = serializable == null ? this.orb.get_primitive_tc(TCKind.tk_value) : this.createTypeCodeForClass(serializable.getClass());
        this.typeCode = TypeCodeImpl.convertToNative(this.orb, typeCode);
    }

    public void insert_Value(Serializable serializable, TypeCode typeCode) throws MARSHAL {
        this.object = serializable;
        this.typeCode = TypeCodeImpl.convertToNative(this.orb, typeCode);
    }

    private TypeCode createTypeCodeForClass(Class clazz) {
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            TypeCode typeCode = clazz2.isPrimitive() ? this.getPrimitiveTypeCodeForClass(clazz2) : this.createTypeCodeForClass(clazz2);
            TypeCode typeCode2 = this.orb.create_sequence_tc(0, typeCode);
            String string = RepositoryId.createForJavaType(clazz);
            return this.orb.create_value_box_tc(string, "Sequence", typeCode2);
        }
        if (clazz == (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = AnyImpl.class$("java.lang.String")))) {
            TypeCode typeCode = this.orb.create_string_tc(0);
            String string = RepositoryId.createForJavaType(clazz);
            return this.orb.create_value_box_tc(string, "StringValue", typeCode);
        }
        return this.orb.get_primitive_tc(TCKind.tk_value);
    }

    private TypeCode getPrimitiveTypeCodeForClass(Class clazz) {
        if (clazz == Integer.TYPE) {
            return this.orb.get_primitive_tc(TCKind.tk_long);
        }
        if (clazz == Byte.TYPE) {
            return this.orb.get_primitive_tc(TCKind.tk_octet);
        }
        if (clazz == Long.TYPE) {
            return this.orb.get_primitive_tc(TCKind.tk_longlong);
        }
        if (clazz == Float.TYPE) {
            return this.orb.get_primitive_tc(TCKind.tk_float);
        }
        if (clazz == Double.TYPE) {
            return this.orb.get_primitive_tc(TCKind.tk_double);
        }
        if (clazz == Short.TYPE) {
            return this.orb.get_primitive_tc(TCKind.tk_short);
        }
        if (clazz == Character.TYPE) {
            return this.orb.get_primitive_tc(TCKind.tk_char);
        }
        if (clazz == Boolean.TYPE) {
            return this.orb.get_primitive_tc(TCKind.tk_boolean);
        }
        return this.orb.get_primitive_tc(TCKind.tk_any);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        boolean[] blArray = new boolean[31];
        blArray[13] = true;
        blArray[15] = true;
        blArray[16] = true;
        blArray[17] = true;
        blArray[19] = true;
        blArray[20] = true;
        blArray[21] = true;
        blArray[22] = true;
        isStreamed = blArray;
    }
}

