/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rmi.io;

import com.sun.rmi.util.JDKBridge;

public class LibraryManager {
    private static boolean attempted;
    private static int majorVersion;
    private static int minorVersion;

    private static native int getMajorVersion();

    private static native int getMinorVersion();

    public static boolean load() {
        try {
            String string = "ioser";
            if (JDKBridge.is12VM()) {
                string = "ioser12";
            }
            try {
                JDKBridge.loadLibrary(string);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if (!attempted) {
                    System.out.println("ERROR! Shared library " + string + " could not be found.");
                }
                throw unsatisfiedLinkError;
            }
            if (!(attempted || LibraryManager.getMajorVersion() == majorVersion && LibraryManager.getMinorVersion() == minorVersion)) {
                System.out.println("WARNING : The " + string + " library is not the correct version.");
                System.out.println("          Expected v" + majorVersion + "." + minorVersion + " but loaded v" + LibraryManager.getMajorVersion() + "." + LibraryManager.getMinorVersion() + "\n");
                System.out.println("          *** YOU ARE ADVISED TO USE EXPECTED VERSION ***");
            }
            attempted = true;
            return true;
        }
        catch (Error error) {
            attempted = true;
            return false;
        }
    }

    protected static void enableOverride(String string, Object object) {
        if (JDKBridge.is12VM()) {
            try {
                LibraryManager.setEnableOverride(Class.forName(string), object);
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                return;
            }
        }
    }

    private static native boolean setEnableOverride(Class var0, Object var1);

    static {
        majorVersion = 1;
        minorVersion = 9;
    }
}

