/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rmi.util;

import com.sun.rmi.util.Collision;

class FastCacheTable {
    static final int kGrowthRate = 101;
    static final int kMaxCacheSize = 30;
    static final int kKeysPos = 0;
    static final int kValsPos = 1;
    static final int kHashCodesPos = 2;
    static final int kCollisionsPos = 3;
    static final Object[][] cache = new Object[31][4];
    static int cacheIndex = -1;
    Object[] keys;
    int[] vals;
    int[] hashCodes;
    Collision[] collisions;
    int count;
    int threshold;

    public final void put(Object object, int n) {
        this.checkForGrowth();
        int n2 = System.identityHashCode(object);
        int n3 = (n2 & Integer.MAX_VALUE) % this.keys.length;
        if (this.keys[n3] == null) {
            this.keys[n3] = object;
            this.vals[n3] = n;
            this.hashCodes[n3] = n2;
            if (this.collisions != null) {
                this.collisions[n3] = null;
            }
        } else {
            Collision collision = new Collision();
            collision.key = object;
            collision.val = n;
            collision.hash = n2;
            if (this.collisions == null) {
                this.collisions = new Collision[this.keys.length];
            }
            collision.next = this.collisions[n3];
            this.collisions[n3] = collision;
        }
        ++this.count;
    }

    public final boolean containsKey(Object object) {
        Collision collision;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % this.keys.length;
        if (this.keys[n2] == null) {
            return false;
        }
        if (this.keys[n2] == object) {
            return true;
        }
        Collision collision2 = collision = this.collisions == null ? null : this.collisions[n2];
        if (collision == null) {
            return false;
        }
        do {
            if (collision.key != object) continue;
            return true;
        } while ((collision = collision.next) != null);
        return false;
    }

    public final int getVal(Object object) {
        Collision collision;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % this.keys.length;
        if (this.keys[n2] == null) {
            return -1;
        }
        if (this.keys[n2] == object) {
            return this.vals[n2];
        }
        Collision collision2 = collision = this.collisions == null ? null : this.collisions[n2];
        if (collision == null) {
            return -1;
        }
        do {
            if (collision.key != object) continue;
            return collision.val;
        } while ((collision = collision.next) != null);
        return -1;
    }

    public void done() {
        Object[][] objectArray = cache;
        synchronized (objectArray) {
            if (cacheIndex < 30) {
                FastCacheTable.cache[++FastCacheTable.cacheIndex][0] = this.keys;
                FastCacheTable.cache[FastCacheTable.cacheIndex][1] = this.vals;
                FastCacheTable.cache[FastCacheTable.cacheIndex][2] = this.hashCodes;
                FastCacheTable.cache[FastCacheTable.cacheIndex][3] = this.collisions;
            }
        }
        this.keys = null;
        this.vals = null;
        this.hashCodes = null;
        this.collisions = null;
    }

    private final void checkForGrowth() {
        if (this.keys == null) {
            this.count = 0;
            Object[][] objectArray = cache;
            synchronized (objectArray) {
                if (cacheIndex > -1) {
                    this.keys = (Object[])cache[cacheIndex][0];
                    this.vals = (int[])cache[cacheIndex][1];
                    this.hashCodes = (int[])cache[cacheIndex][2];
                    this.collisions = (Collision[])cache[cacheIndex][3];
                    int n = this.keys.length;
                    while (n > 0) {
                        this.keys[n - 1] = null;
                        --n;
                    }
                    --cacheIndex;
                    this.threshold = 3 * this.keys.length / 4;
                    Object var2_5 = null;
                    return;
                }
            }
            this.keys = new Object[101];
            this.vals = new int[101];
            this.hashCodes = new int[101];
            this.collisions = null;
            this.threshold = 3 * this.keys.length / 4;
            return;
        }
        if (this.threshold == this.count) {
            int n = this.keys.length;
            int n2 = n + 101;
            Object[] objectArray = new Object[n2];
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            Collision[] collisionArray = null;
            int n3 = 0;
            while (n3 < n) {
                if (this.keys[n3] != null) {
                    Collision collision;
                    int n4 = this.hashCodes[n3];
                    int n5 = (n4 & Integer.MAX_VALUE) % n2;
                    if (objectArray[n5] == null) {
                        objectArray[n5] = this.keys[n3];
                        nArray[n5] = this.vals[n3];
                        nArray2[n5] = n4;
                        if (collisionArray != null) {
                            collisionArray[n5] = null;
                        }
                    } else {
                        collision = new Collision();
                        collision.key = this.keys[n3];
                        collision.val = this.vals[n3];
                        collision.hash = n4;
                        if (collisionArray == null) {
                            collisionArray = new Collision[n2];
                        }
                        collision.next = collisionArray[n5];
                        collisionArray[n5] = collision;
                    }
                    if (this.collisions != null) {
                        collision = this.collisions[n3];
                        while (collision != null) {
                            n4 = collision.hash;
                            n5 = (n4 & Integer.MAX_VALUE) % n2;
                            if (objectArray[n5] == null) {
                                objectArray[n5] = collision.key;
                                nArray[n5] = collision.val;
                                nArray2[n5] = n4;
                                if (collisionArray != null) {
                                    collisionArray[n5] = null;
                                }
                            } else {
                                Collision collision2 = new Collision();
                                collision2.key = collision.key;
                                collision2.val = collision.val;
                                collision2.hash = n4;
                                if (collisionArray == null) {
                                    collisionArray = new Collision[n2];
                                }
                                collision2.next = collisionArray[n5];
                                collisionArray[n5] = collision2;
                            }
                            collision = collision.next;
                        }
                    }
                }
                ++n3;
            }
            Object[][] objectArray2 = cache;
            synchronized (objectArray2) {
                if (cacheIndex < 30) {
                    FastCacheTable.cache[++FastCacheTable.cacheIndex][0] = this.keys;
                    FastCacheTable.cache[FastCacheTable.cacheIndex][1] = this.vals;
                    FastCacheTable.cache[FastCacheTable.cacheIndex][2] = this.hashCodes;
                    FastCacheTable.cache[FastCacheTable.cacheIndex][3] = this.collisions;
                }
            }
            this.keys = objectArray;
            this.vals = nArray;
            this.hashCodes = nArray2;
            this.collisions = collisionArray;
            this.threshold = 3 * this.keys.length / 4;
        }
    }
}

