/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.cosnaming;

import com.sun.jndi.cosnaming.CNBindingEnumeration;
import com.sun.jndi.cosnaming.CNNameParser;
import com.sun.jndi.cosnaming.ExceptionMapper;
import com.sun.jndi.toolkit.VersionHelper;
import java.applet.Applet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.CannotProceedException;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ResolveResult;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;

public class CNCtx
implements Context {
    private static VersionHelper helper = VersionHelper.getVersionHelper();
    ORB _orb;
    NamingContext _nc;
    private NameComponent[] _name = null;
    Hashtable _env;
    private static CNNameParser parser = new CNNameParser();
    private static final String FED_PROP = "com.sun.jndi.cosnaming.federation";
    boolean federation = false;
    private static Method toStubMethod = null;
    private static Method connectMethod = null;
    private static Class corbaStubClass = null;
    static /* synthetic */ Class class$org$omg$CORBA$ORB;
    static /* synthetic */ Class class$java$rmi$Remote;

    private CNCtx() {
    }

    CNCtx(Hashtable hashtable) throws NamingException {
        this._env = hashtable;
        this.federation = "true".equals(hashtable != null ? hashtable.get(FED_PROP) : null);
        this.initNameService(hashtable);
    }

    CNCtx(ORB oRB, NamingContext namingContext, Hashtable hashtable, NameComponent[] nameComponentArray) throws NamingException {
        if (oRB == null || namingContext == null) {
            throw new ConfigurationException("Must supply ORB or NamingContext");
        }
        this._orb = oRB;
        this._nc = namingContext;
        this._env = hashtable;
        this._name = nameComponentArray;
        this.federation = "true".equals(hashtable != null ? hashtable.get(FED_PROP) : null);
    }

    public java.lang.Object addToEnvironment(String string, java.lang.Object object) throws NamingException {
        this._env = this._env == null ? new Hashtable(7, 0.75f) : (Hashtable)this._env.clone();
        return this._env.put(string, object);
    }

    public void bind(String string, java.lang.Object object) throws NamingException {
        if (string.length() == 0) {
            throw new InvalidNameException("Name is empty");
        }
        NameComponent[] nameComponentArray = this.createNamePath(string);
        CompositeName compositeName = new CompositeName();
        compositeName.add(string);
        try {
            this.callBindOrRebind(nameComponentArray, compositeName, object, false);
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = CNCtx.getContinuationContext(cannotProceedException);
            context.bind(cannotProceedException.getRemainingName(), object);
        }
    }

    public void bind(Name name, java.lang.Object object) throws NamingException {
        if (name.size() == 0) {
            throw new InvalidNameException("Name is empty");
        }
        NameComponent[] nameComponentArray = this.createNamePath(name);
        try {
            this.callBindOrRebind(nameComponentArray, name, object, false);
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = CNCtx.getContinuationContext(cannotProceedException);
            context.bind(cannotProceedException.getRemainingName(), object);
        }
    }

    private Context callBindNewContext(NameComponent[] nameComponentArray) throws NamingException {
        if (this._nc == null) {
            throw new ConfigurationException("Context does not have a corresponding NamingContext");
        }
        try {
            NamingContext namingContext = this._nc.bind_new_context(nameComponentArray);
            return new CNCtx(this._orb, namingContext, this._env, this.makeFullName(nameComponentArray));
        }
        catch (Exception exception) {
            throw ExceptionMapper.mapException(exception, this, nameComponentArray);
        }
    }

    private void callBindOrRebind(NameComponent[] nameComponentArray, Name name, java.lang.Object object, boolean bl) throws NamingException {
        block16: {
            if (this._nc == null) {
                throw new ConfigurationException("Context does not have a corresponding NamingContext");
            }
            try {
                block15: {
                    if (object instanceof Remote) {
                        try {
                            object = CNCtx.remoteToCorba((Remote)object, this._orb);
                            if (object == null) {
                                throw new IllegalArgumentException("Cannot bind Remote objects with JRMP implementations or stubs");
                            }
                            break block15;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new ConfigurationException("javax.rmi packages not available");
                        }
                    }
                    if (object instanceof CNCtx) {
                        object = ((CNCtx)object)._nc;
                    }
                }
                if (object instanceof NamingContext) {
                    NamingContext namingContext = NamingContextHelper.narrow((Object)((Object)object));
                    if (bl) {
                        this._nc.rebind_context(nameComponentArray, namingContext);
                    } else {
                        this._nc.bind_context(nameComponentArray, namingContext);
                    }
                    break block16;
                }
                if (object instanceof Object) {
                    if (bl) {
                        this._nc.rebind(nameComponentArray, (Object)object);
                    } else {
                        this._nc.bind(nameComponentArray, (Object)object);
                    }
                    break block16;
                }
                throw new IllegalArgumentException("Only instances of org.omg.CORBA.Object can be bound");
            }
            catch (BAD_PARAM bAD_PARAM) {
                NotContextException notContextException = new NotContextException(CNNameParser.cosNameToString(nameComponentArray));
                notContextException.setRootCause(bAD_PARAM);
                throw notContextException;
            }
            catch (Exception exception) {
                throw ExceptionMapper.mapException(exception, this, nameComponentArray);
            }
        }
    }

    private void callDestroy(NamingContext namingContext) throws NamingException {
        if (this._nc == null) {
            throw new ConfigurationException("Context does not have a corresponding NamingContext");
        }
        try {
            namingContext.destroy();
        }
        catch (Exception exception) {
            throw ExceptionMapper.mapException(exception, this, null);
        }
    }

    java.lang.Object callResolve(NameComponent[] nameComponentArray) throws NamingException {
        try {
            Object object = this._nc.resolve(nameComponentArray);
            try {
                NamingContext namingContext = NamingContextHelper.narrow((Object)object);
                if (namingContext != null) {
                    return new CNCtx(this._orb, namingContext, this._env, this.makeFullName(nameComponentArray));
                }
                return object;
            }
            catch (BAD_PARAM bAD_PARAM) {
                return object;
            }
        }
        catch (Exception exception) {
            throw ExceptionMapper.mapException(exception, this, nameComponentArray);
        }
    }

    private void callUnbind(NameComponent[] nameComponentArray) throws NamingException {
        if (this._nc == null) {
            throw new ConfigurationException("Context does not have a corresponding NamingContext");
        }
        try {
            this._nc.unbind(nameComponentArray);
        }
        catch (Exception exception) {
            throw ExceptionMapper.mapException(exception, this, nameComponentArray);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void close() throws NamingException {
    }

    public String composeName(String string, String string2) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        throw new OperationNotSupportedException();
    }

    private NameComponent[] createNamePath(String string) throws NamingException {
        if (string == null) {
            throw new IllegalArgumentException("Null value invalid for name");
        }
        return CNNameParser.stringToCosName(string);
    }

    private NameComponent[] createNamePath(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Null value invalid for name");
        }
        return CNNameParser.nameToCosName(name);
    }

    public Context createSubcontext(String string) throws NamingException {
        if (string.length() == 0) {
            throw new InvalidNameException("Name is empty");
        }
        NameComponent[] nameComponentArray = this.createNamePath(string);
        try {
            return this.callBindNewContext(nameComponentArray);
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = CNCtx.getContinuationContext(cannotProceedException);
            return context.createSubcontext(cannotProceedException.getRemainingName());
        }
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (name.size() == 0) {
            throw new InvalidNameException("Name is empty");
        }
        NameComponent[] nameComponentArray = this.createNamePath(name);
        try {
            return this.callBindNewContext(nameComponentArray);
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = CNCtx.getContinuationContext(cannotProceedException);
            return context.createSubcontext(cannotProceedException.getRemainingName());
        }
    }

    public static ResolveResult createUsingURL(String string, Hashtable hashtable) throws NamingException {
        CNCtx cNCtx = new CNCtx();
        cNCtx._env = hashtable;
        String string2 = cNCtx.initNameServiceFromURL(string, hashtable);
        return new ResolveResult((java.lang.Object)cNCtx, string2);
    }

    public void destroySubcontext(String string) throws NamingException {
        if (this._nc == null) {
            throw new ConfigurationException("Context does not have a corresponding NamingContext");
        }
        NamingContext namingContext = this._nc;
        NameComponent[] nameComponentArray = this.createNamePath(string);
        if (string.length() > 0) {
            try {
                Context context = (Context)this.callResolve(nameComponentArray);
                CNCtx cNCtx = (CNCtx)context;
                namingContext = cNCtx._nc;
            }
            catch (ClassCastException classCastException) {
                throw new NotContextException(string);
            }
            catch (CannotProceedException cannotProceedException) {
                Context context = CNCtx.getContinuationContext(cannotProceedException);
                context.destroySubcontext(cannotProceedException.getRemainingName());
                return;
            }
            catch (NamingException namingException) {
                throw namingException;
            }
        }
        this.callDestroy(namingContext);
        this.callUnbind(nameComponentArray);
    }

    public void destroySubcontext(Name name) throws NamingException {
        if (this._nc == null) {
            throw new ConfigurationException("Context does not have a corresponding NamingContext");
        }
        NamingContext namingContext = this._nc;
        NameComponent[] nameComponentArray = this.createNamePath(name);
        if (name.size() > 0) {
            try {
                Context context = (Context)this.callResolve(nameComponentArray);
                CNCtx cNCtx = (CNCtx)context;
                namingContext = cNCtx._nc;
            }
            catch (ClassCastException classCastException) {
                throw new NotContextException(name.toString());
            }
            catch (CannotProceedException cannotProceedException) {
                Context context = CNCtx.getContinuationContext(cannotProceedException);
                context.destroySubcontext(cannotProceedException.getRemainingName());
                return;
            }
            catch (NamingException namingException) {
                throw namingException;
            }
        }
        this.callDestroy(namingContext);
        this.callUnbind(nameComponentArray);
    }

    private static Context getContinuationContext(CannotProceedException cannotProceedException) throws NamingException {
        try {
            return NamingManager.getContinuationContext(cannotProceedException);
        }
        catch (CannotProceedException cannotProceedException2) {
            Reference reference;
            RefAddr refAddr;
            java.lang.Object object = cannotProceedException2.getResolvedObj();
            if (object instanceof Reference && (refAddr = (reference = (Reference)object).get("nns")).getContent() instanceof Context) {
                NameNotFoundException nameNotFoundException = new NameNotFoundException("No object reference bound for specified name");
                nameNotFoundException.setRootCause(cannotProceedException.getRootCause());
                nameNotFoundException.setRemainingName(cannotProceedException.getRemainingName());
                throw nameNotFoundException;
            }
            throw cannotProceedException2;
        }
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this._env == null) {
            this._env = new Hashtable(5, 0.75f);
        }
        return this._env;
    }

    public NameParser getNameParser(String string) throws NamingException {
        return parser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return parser;
    }

    private static void initMethodHandles() throws ClassNotFoundException {
        corbaStubClass = Class.forName("javax.rmi.CORBA.Stub");
        try {
            connectMethod = corbaStubClass.getMethod("connect", class$org$omg$CORBA$ORB != null ? class$org$omg$CORBA$ORB : (class$org$omg$CORBA$ORB = CNCtx.class$("org.omg.CORBA.ORB")));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException("No method definition for javax.rmi.CORBA.Stub.connect(org.omg.CORBA.ORB)");
        }
        Class<?> clazz = Class.forName("javax.rmi.PortableRemoteObject");
        try {
            toStubMethod = clazz.getMethod("toStub", class$java$rmi$Remote != null ? class$java$rmi$Remote : (class$java$rmi$Remote = CNCtx.class$("java.rmi.Remote")));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException("No method definition for javax.rmi.PortableRemoteObject.toStub(java.rmi.Remote)");
        }
    }

    private void initNameService(Hashtable hashtable) throws NamingException {
        java.lang.Object var2_2 = null;
        if (hashtable != null) {
            var2_2 = hashtable.get("java.naming.corba.orb");
        }
        if (var2_2 != null) {
            if (!(var2_2 instanceof ORB)) {
                throw new ConfigurationException("The java.naming.corba.orb environment property be an instance of org.omg.CORBA.ORB");
            }
            this.initORB(var2_2);
        } else {
            Applet applet;
            String string = null;
            if (hashtable != null) {
                string = (String)hashtable.get("java.naming.provider.url");
            }
            if (string == null) {
                try {
                    string = helper.getJndiProperty(0);
                }
                catch (SecurityException securityException) {}
            }
            if (string == null && hashtable != null && (applet = (Applet)hashtable.get("java.naming.applet")) != null) {
                string = applet.getParameter("java.naming.provider.url");
            }
            if (string != null) {
                this.initNameServiceFromURL(string, hashtable);
            } else {
                this.initORB(null, -1, hashtable);
            }
        }
    }

    private String initNameServiceFromURL(String string, Hashtable hashtable) throws NamingException {
        String string2;
        if (!string.startsWith("iiop://")) {
            throw new ConfigurationException("Invalid iiop url '" + string + "'");
        }
        int n = 7;
        int n2 = string.indexOf(58, n);
        int n3 = string.indexOf(47, n);
        String string3 = n3 < 0 ? "" : string.substring(n3 + 1);
        int n4 = 900;
        if (n2 >= 0 && (n2 < n3 || n3 < 0)) {
            string2 = string.substring(n, n2);
            int n5 = n3 < 0 ? string.length() : n3;
            try {
                n4 = Integer.parseInt(string.substring(n2 + 1, n5));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConfigurationException("Invalid iiop url '" + string + "'; port must be a number");
            }
        } else {
            string2 = n3 < 0 ? string.substring(n) : string.substring(n, n3);
        }
        this.initORB(string2, n4, hashtable);
        return string3;
    }

    private void initORB(String string, int n, Hashtable hashtable) throws NamingException {
        java.lang.Object object;
        Properties properties = new Properties();
        if (hashtable != null) {
            object = hashtable.keys();
            while (object.hasMoreElements()) {
                String string2 = (String)object.nextElement();
                if (!string2.startsWith("org.omg.CORBA.")) continue;
                ((Hashtable)properties).put(string2, hashtable.get(string2));
            }
        }
        if (string != null) {
            ((Hashtable)properties).put("org.omg.CORBA.ORBInitialHost", string);
        }
        if (n >= 0) {
            ((Hashtable)properties).put("org.omg.CORBA.ORBInitialPort", String.valueOf(n));
        }
        object = null;
        if (hashtable != null) {
            object = (Applet)hashtable.get("java.naming.applet");
        }
        if (object != null) {
            this.initORB(ORB.init(object, (Properties)properties));
        } else {
            this.initORB(ORB.init((String[])new String[0], (Properties)properties));
        }
    }

    private void initORB(ORB oRB) throws NamingException {
        this._orb = oRB;
        try {
            Object object = this._orb.resolve_initial_references("NameService");
            this._nc = NamingContextHelper.narrow((Object)object);
        }
        catch (InvalidName invalidName) {
            ConfigurationException configurationException = new ConfigurationException("COS Name Service not registered with ORB under the name 'NameService'");
            configurationException.setRootCause(invalidName);
            throw configurationException;
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            CommunicationException communicationException = new CommunicationException("Cannot connect to ORB");
            communicationException.setRootCause(cOMM_FAILURE);
            throw communicationException;
        }
    }

    public NamingEnumeration list(String string) throws NamingException {
        return this.listBindings(string);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.listBindings(name);
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        if (this._nc == null) {
            throw new ConfigurationException("Context does not have a corresponding NamingContext");
        }
        if (string.length() > 0) {
            try {
                java.lang.Object object = this.lookup(string);
                if (object instanceof CNCtx) {
                    return new CNBindingEnumeration((CNCtx)object, this._env);
                }
                throw new NotContextException(string);
            }
            catch (NamingException namingException) {
                throw namingException;
            }
            catch (BAD_PARAM bAD_PARAM) {
                NotContextException notContextException = new NotContextException(string);
                notContextException.setRootCause(bAD_PARAM);
                throw notContextException;
            }
        }
        return new CNBindingEnumeration(this, this._env);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (this._nc == null) {
            throw new ConfigurationException("Context does not have a corresponding NamingContext");
        }
        if (name.size() > 0) {
            try {
                java.lang.Object object = this.lookup(name);
                if (object instanceof CNCtx) {
                    return new CNBindingEnumeration((CNCtx)object, this._env);
                }
                throw new NotContextException(name.toString());
            }
            catch (NamingException namingException) {
                throw namingException;
            }
            catch (BAD_PARAM bAD_PARAM) {
                NotContextException notContextException = new NotContextException(name.toString());
                notContextException.setRootCause(bAD_PARAM);
                throw notContextException;
            }
        }
        return new CNBindingEnumeration(this, this._env);
    }

    public java.lang.Object lookup(String string) throws NamingException {
        if (this._nc == null) {
            throw new ConfigurationException("Context does not have a corresponding NamingContext");
        }
        if (string.length() == 0) {
            return this;
        }
        NameComponent[] nameComponentArray = this.createNamePath(string);
        try {
            java.lang.Object object = this.callResolve(nameComponentArray);
            CompositeName compositeName = new CompositeName();
            compositeName.add(string);
            try {
                return NamingManager.getObjectInstance(object, compositeName, this, this._env);
            }
            catch (NamingException namingException) {
                throw namingException;
            }
            catch (Exception exception) {
                NamingException namingException = new NamingException("problem generating object using object factory");
                namingException.setRootCause(exception);
                throw namingException;
            }
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = CNCtx.getContinuationContext(cannotProceedException);
            return context.lookup(cannotProceedException.getRemainingName());
        }
    }

    public java.lang.Object lookup(Name name) throws NamingException {
        if (this._nc == null) {
            throw new ConfigurationException("Context does not have a corresponding NamingContext");
        }
        if (name.size() == 0) {
            return this;
        }
        NameComponent[] nameComponentArray = this.createNamePath(name);
        try {
            java.lang.Object object = this.callResolve(nameComponentArray);
            try {
                return NamingManager.getObjectInstance(object, name, this, this._env);
            }
            catch (NamingException namingException) {
                throw namingException;
            }
            catch (Exception exception) {
                NamingException namingException = new NamingException("problem generating object using object factory");
                namingException.setRootCause(exception);
                throw namingException;
            }
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = CNCtx.getContinuationContext(cannotProceedException);
            return context.lookup(cannotProceedException.getRemainingName());
        }
    }

    public java.lang.Object lookupLink(String string) throws NamingException {
        return this.lookup(string);
    }

    public java.lang.Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    NameComponent[] makeFullName(NameComponent[] nameComponentArray) {
        if (this._name == null || this._name.length == 0) {
            return nameComponentArray;
        }
        NameComponent[] nameComponentArray2 = new NameComponent[this._name.length + nameComponentArray.length];
        System.arraycopy(this._name, 0, nameComponentArray2, 0, this._name.length);
        System.arraycopy(nameComponentArray, 0, nameComponentArray2, this._name.length, nameComponentArray.length);
        return nameComponentArray2;
    }

    public void rebind(String string, java.lang.Object object) throws NamingException {
        if (string.length() == 0) {
            throw new InvalidNameException("Name is empty");
        }
        NameComponent[] nameComponentArray = this.createNamePath(string);
        CompositeName compositeName = new CompositeName();
        compositeName.add(string);
        try {
            this.callBindOrRebind(nameComponentArray, compositeName, object, true);
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = CNCtx.getContinuationContext(cannotProceedException);
            context.rebind(cannotProceedException.getRemainingName(), object);
        }
    }

    public void rebind(Name name, java.lang.Object object) throws NamingException {
        if (name.size() == 0) {
            throw new InvalidNameException("Name is empty");
        }
        NameComponent[] nameComponentArray = this.createNamePath(name);
        try {
            this.callBindOrRebind(nameComponentArray, name, object, true);
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = CNCtx.getContinuationContext(cannotProceedException);
            context.rebind(cannotProceedException.getRemainingName(), object);
        }
    }

    private static Object remoteToCorba(Remote remote, ORB oRB) throws ClassNotFoundException, ConfigurationException {
        java.lang.Object object;
        if (toStubMethod == null) {
            CNCtx.initMethodHandles();
        }
        try {
            object = toStubMethod.invoke(null, remote);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            ConfigurationException configurationException = new ConfigurationException("Problem with PortableRemoteObject.toStub(); object not exported or stub not found");
            configurationException.setRootCause(throwable);
            throw configurationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            ConfigurationException configurationException = new ConfigurationException("Cannot invoke javax.rmi.PortableRemoteObject.toStub(java.rmi.Remote)");
            configurationException.setRootCause(illegalAccessException);
            throw configurationException;
        }
        if (!corbaStubClass.isInstance(object)) {
            return null;
        }
        try {
            connectMethod.invoke(object, oRB);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (!(throwable instanceof RemoteException)) {
                ConfigurationException configurationException = new ConfigurationException("Problem invoking javax.rmi.CORBA.Stub.connect()");
                configurationException.setRootCause(throwable);
                throw configurationException;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            ConfigurationException configurationException = new ConfigurationException("Cannot invoke javax.rmi.CORBA.Stub.connect()");
            configurationException.setRootCause(illegalAccessException);
            throw configurationException;
        }
        return (Object)object;
    }

    public java.lang.Object removeFromEnvironment(String string) throws NamingException {
        if (this._env != null && this._env.get(string) != null) {
            this._env = (Hashtable)this._env.clone();
            return this._env.remove(string);
        }
        return null;
    }

    public void rename(String string, String string2) throws NamingException {
        if (this._nc == null) {
            throw new ConfigurationException("Context does not have a corresponding NamingContext");
        }
        if (string.length() == 0 || string2.length() == 0) {
            throw new InvalidNameException("One or both names empty");
        }
        java.lang.Object object = this.lookup(string);
        this.bind(string2, object);
        this.unbind(string);
    }

    public void rename(Name name, Name name2) throws NamingException {
        if (this._nc == null) {
            throw new ConfigurationException("Context does not have a corresponding NamingContext");
        }
        if (name.size() == 0 || name2.size() == 0) {
            throw new InvalidNameException("One or both names empty");
        }
        java.lang.Object object = this.lookup(name);
        this.bind(name2, object);
        this.unbind(name);
    }

    public void unbind(String string) throws NamingException {
        if (string.length() == 0) {
            throw new InvalidNameException("Name is empty");
        }
        NameComponent[] nameComponentArray = this.createNamePath(string);
        try {
            this.callUnbind(nameComponentArray);
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = CNCtx.getContinuationContext(cannotProceedException);
            context.unbind(cannotProceedException.getRemainingName());
        }
    }

    public void unbind(Name name) throws NamingException {
        if (name.size() == 0) {
            throw new InvalidNameException("Name is empty");
        }
        NameComponent[] nameComponentArray = this.createNamePath(name);
        try {
            this.callUnbind(nameComponentArray);
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = CNCtx.getContinuationContext(cannotProceedException);
            context.unbind(cannotProceedException.getRemainingName());
        }
    }
}

