/* check prereqs                                                        */
parse arg hFeature bootdrive where
file = bootdrive'\kmcrpc10'

/*  These two messages are the only translatable items in the file:              */
message1="Unicode Font is not present in install package.  Please refer to the Readme for information on downloading the font package."
message2="This system is not at the correct Fix Pack level to utilize the unicode font.  Unicode font will not be installed.  Refer to the Readme for more information about Fix Pack prerequisites."
message3="The version of OS/2 on your system does not meet the prerequisites for installing Java, installation will terminate.  Please refer to the Readme for more details."



call RxFuncAdd 'RexxInstDeselect', 'WPINSTAL', 'RexxInstDeselect'
call RxFuncAdd 'RexxInstResolveVariables', 'WPINSTAL', 'RexxInstResolveVariables'
call RxFuncAdd 'RexxInstSetVariable', 'WPINSTAL', 'RexxInstSetVariable'


continue = RexxInstResolveVariables( hFeature, "{Continue}", 1)
path = RexxInstResolveVariables( hFeature, "{UserExitPath}", 1)
say path
if (where == PREREQ) then CALL PREREQ

/* check for font in install package */
path = RexxInstResolveVariables( hFeature, "{UserExitPath}", 1)
font = path"\..\package\tnrmt30.ttf"
rc = stream( font, 'c', 'open read')
empty = LINES( font )
rc = stream( font, 'c', 'close' )
if (empty == "0" ) then
        DO
        rc = RexxInstDeselect( hFeature, "" )
        if continue <> "UNATTENDED" then
        DO
          keep = RexxInstResolveVariables( hFeature, "{Java11:MB_VAR}", 1)
          zero = 0
          rc = RexxInstSetVariable( hFeature,"Java11", "MB_VAR", zero );
          new = RexxInstResolveVariables( hFeature, "{Java11:MB_VAR}", 1)
          path'\..\message ' bootdrive hFeature message1
          rc = RexxInstSetVariable( hFeature, "Java11", "MB_VAR", 4 );
        END
        EXIT
        END



PREREQ:

/* check for FixPack 30 or higher    */

tmpfile = bootdrive'\j11servc.tmp'
'bldlevel 'bootdrive'\os2krnl >'  tmpfile
line = LINEIN( tmpfile)
ret = STREAM( tmpfile, 'c', 'close')
'@erase' tmpfile

'bldlevel 'bootdrive'\os2krnl >'  file
line = LINEIN( file)
say line
PARSE VAR line temp '#@';
temp = REVERSE( temp)
PARSE VAR temp temp ':MBI';
level = REVERSE( temp)

if (where == PREREQ) then CALL CHECKBASE

if level < 8.254
then
DO
rc = RexxInstDeselect( hFeature, "" )
if continue <> "UNATTENDED" then
DO
  keep = RexxInstResolveVariables( hFeature, "{MB_VAR}", 1)
  rc = RexxInstSetVariable( hFeature, "Java11", "MB_VAR", 0 );
  path'\..\message ' bootdrive hFeature message2
  rc = RexxInstSetVariable( hFeature, "Java11", "MB_VAR", keep );
END
END

ret = STREAM( file, 'c', 'close')
'@erase' file
EXIT

CHECKBASE:
if level < 9.23 then x = RexxInstSetVariable( hFeature, "Java11", "MERLIN", "NO")
if level < 8.162
then
DO
if level = 7.029 then CALL BYE
if continue <> "UNATTENDED" then
DO
  rc = RexxInstSetVariable( hFeature, "Java11", "MB_VAR", 0 );
  path'\..\message ' bootdrive hFeature message3
END
rc = RexxInstDeselect( hFeature, "Java11" )
END


BYE:
ret = STREAM( file, 'c', 'close')
'@erase' file
EXIT


