/* rexx */

/* Load external FI API
*/

call RxFuncAdd 'RexxInstSetVariable', 'WPINSTAL', 'RexxInstSetVariable'
/* Get the objectid (feature handle), and the current package from the arguments
*/
parse arg objectid userexitpath

nlv=right(userexitpath,2)

/* change the NLVdest variable to be the corresponding language */
call RexxInstSetVariable objectid,"Java11","NLVDest",nlv

/* Set package path and TD files path to {userExitpath}\..\package
   If nlv == "JP", set TD package path to {UserExitPath}\td
*/
call RexxInstSetVariable objectid,"Java11", "Package", "..\package"
call RexxInstSetVariable objectid,"Java11", "MPath", ".."

if (nlv == "JP" | nlv == "jp") then do
    call RexxInstSetVariable objectid,"Java11", "TDPath", "td"
    end
else do
    call RexxInstSetVariable objectid,"Java11", "TDPath", "..\package"
    end

