______________________________________________________________________

SECURITY CONSIDERATIONS 
README
______________________________________________________________________

The Security considerations are supported on the following OS/2 
products:

  OS/2 Warp 4 with FixPak 5 or higher or DBCS equivalent
  OS/2 Warp Server Version 4 with FixPak 32 or higher or 
    DBCS equivalent
  OS/2 Warp Server Advanced Version 4 with FixPak 32 or higher or 
    DBCS equivalent
  OS/2 Warp Server Advanced Version 4 SMP Feature with FixPak 32 
    or higher or DBCS equivalent
  OS/2 Warp Server for e-business    
  WorkSpace On-Demand clients and servers
  OS/2 Warp 3 with FixPak 32 or higher or DBCS equivalent
  OS/2 Warp Connect with FixPak 32 or higher or DBCS equivalent

  Note:  For information on the Double Byte Character Set (DBCS)
         FixPak equivalents, see the "FixPaks" section.
______________________________________________________________________

CONTENTS

  1.0  OVERVIEW
  1.1  FixPaks  
  
  2.0  CONTENTS OF THIS RELEASE

  3.0  ENABLING SECURITY
  3.1  Updating the Property files
  
  4.0  USING SECURITY 
  
  5.0  ADDITIONAL INFORMATION
  
  6.0  TRADEMARKS

1.0  OVERVIEW
______________________________________________________________________

The Security considerations (Security) are based on enhancements from 
the Java 2 security model. Security is shipped with the IBM OS/2 Warp 
Developer Kit, Java(TM) Technology Edition, Version 1.1.8 (Developer 
Kit). Security is integrated into the Runtime package and is 
disabled by default. 

Note:  Security is only supported on systems with the IBM OS/2 Warp 
       Developer Kit, Java(TM) Technology Edition, Version 1.1.8.

1.1  FixPaks
______________________________________________________________________

Required FixPak level for DBCS (Japanese, Traditional Chinese, 
Simplified Chinese, or Korean) Languages:

  o  OS/2 Warp 3       WX03006
  o  OS/2 Warp 4       FX00505          

For information about downloading a particular FixPak, visit the IBM 
FixPak Web site at: 
  
  http://ps.software.ibm.com/pbin-usa-ps/getobj.pl?/pdocs-usa
  /otherservices.html

Or see the Developer Kit README located in the [x:\JAVA11] directory. 

   [x:\JAVA11] is the drive and directory where you installed the 
   Developer Kit. By default, JAVA11 is the name of the directory.

2.0  CONTENTS OF THIS RELEASE
______________________________________________________________________

Security consists of:

  3 binary files containing the code
    o  SecMA.jar
    o  SecMA.dll 
    o  SecMA_g.dll
      
  4 example policy/security files 
    o  java_ex.sec
    o  java_ex.pol
    o  user_ex.sec
    o  user_ex.pol

  1 text file
    readme.sma (this file)
    Located in the [x:\JAVA11] directory

  1 Configuration and Usage Guide
    Guide.html 
    Located in the [x:\JAVA11]\secMA.zip file and directory

  Security API Documentation 
    SecMaDocs.zip
    Located in the [x:\JAVA11]\secMA.zip file and directory 
    
  1 Quickstart File
    qstart.txt 
    Located in the [x:\JAVA11]\sma directory

[x:\JAVA11] is the drive and directory where you installed the 
Developer Kit. By default, JAVA11 is the name of the directory.    

See the "Additional Information" section for information on the 
Configuration and Usage Guide and the Security API documentation.

3.0  ENABLING SECURITY
______________________________________________________________________

To enable Security, complete the following steps:

  1.  Place SecMA.jar file on the classpath before classes.zip. 
      You can do this by executing the following command, 
      before invoking java on the command line.

        set CLASSPATH=[x:\JAVA11]\lib\SecMA.jar;%CLASSPATH%

      [x:\JAVA11] is the drive and directory where you installed 
      the Developer Kit. By default, JAVA11 is the name of the 
      directory.      
        
      Note: Be sure that Security is installed into the Developer
            Kit's directory.

  2.  Rename the following files:

      java_ex.sec     to     java.sec
      java_ex.pol     to     java.pol
      user_ex.sec     to     user.sec
      user_ex.pol     to     user.pol 
  
      Note: The lib\security directory contains the java.sec file 
            that is the standard 1.1 Java security file. It 
            should be backed up before the example files are 
            renamed. If the user has customized the java.sec file 
            with their own settings, these changes must be merged 
            into the new java.sec file.

If you want to check your configuration, see the qstart.txt file in 
the [x:\JAVA11]\sma directory. ([x:\JAVA11] is where you installed 
the Developer Kit.)

3.1  Updating the Property files
______________________________________________________________________

Update the following property files according to the platform you are 
using:

  o  java.sec file
     
     -  policy.url.n values. 
        These properties must be equivalent to the URLs of the policy 
        files you implemented.

  o  user.sec file
     
     -  java.app.class.path
        Location of application classes similar to CLASSPATH format.
     -  java.security.manager
        Set to desired security manager class.

  o  java.pol and user.pol files
 
     Put application or applet specific permissions in these files. 
     Though not required, it is suggested to add permissions to 
     user.policy while leaving java.policy unchanged.

The properties are the minimum settings that need to be changed. See 
the Security Configuration and Usage Guide for more information. 
  
4.0  USING SECURITY
______________________________________________________________________

To use the new security managers and classloaders, an application
needs to be invoked through a special Main class:

  com.ibm.security12.sun.misc.Main

For example, to run the "Glyph" class, type the following at a
command prompt:

  java com.ibm.security12.sun.misc.Main Glyph

Applets need to be invoked by a special AppletViewer class, 
com.ibm.security12.sun.applet.AppletViewer. For example, to run the 
"HelloWorld" applet referred to by "hello.html", use:

  java com.ibm.security12.sun.applet.AppletViewer hello.html

The AppletViewer example is correct as long as "hello.html" resides 
in the same directory that the java command was called. If this is 
not the case, a URL argument in file or HTTP format is needed. For 
example,

  java com.ibm.security12.sun.applet.AppletViewer file:/c:/applets/hello.html

  Note:  For an application or applet to function correctly, the 
         policy and security files in lib\security will need to be 
         configured correctly. See the "Additional Information" 
         section. Also, be sure to comment out each of the security 
         manager references in the user.sec file if you will be 
         running AppletViewer. 
         
         For more information on the user.sec file, see the Security 
         Configuration and UsageGuide.

4.0  ADDITIONAL INFORMATION
______________________________________________________________________

  o  A Configuration and Usage Guide (Guide.htm) and Security API 
     documentation (SecMaDocs.zip) are supplied as part of the 
     Security documentation and are located in the secMA.zip file. 
     If you have not downloaded this file, it can be downloaded from 
     the Developer Kit Web site located at:
     
       http://service.boulder.ibm.com/asd-bin/doc/index.htm

     To access these files, unzip the secMA.zip file. Once you 
     unzip this file, a Security documentation directory named 
     \sma is created.  

     To view the Security API documentation, unzip the SecMaDocs.zip 
     file and go to the following directory and file: 
 
       [x:\JAVA11]\sma\docs\APIs\index.html 
     
  o  Information about the default security files and their entries 
     can be found at the following Sun Web site: 
      
       http://java.sun.com/products/jdk/1.2/docs/guide/security/PolicyFiles.html

  o  An overview of Sun's KeyTool can be found at the following 
     Sun Web site:

       http://java.sun.com/products/jdk/1.2/docs/tooldocs/win32/keytool.html

  o  Information on JarSigner, which generates digital signatures for 
     JAR files and verifies signed JAR files using entries in a 
     keystore file, can be found at the following Sun Web site:

       http://java.sun.com/products/jdk/1.2/docs/tooldocs/win32/jarsigner.html

  o  Before using JarSigner, a JAR file must have been created. The 
     command jar is not part of security, but is part of the 1.1.8 
     Developer Kit package. You can find more information on the jar 
     command at the following Sun Web site:

       http://java.sun.com/products/jdk/1.2/docs/tooldocs/win32/jar.html

  o  Information on PolicyTool, a GUI-based tool that creates and 
     modifies the policy configuration files that define your 
     system's Java security policy can be found at the following Sun 
     Web site:

       http://java.sun.com/products/jdk/1.2/docs/tooldocs/win32/policytool.html

5.0  TRADEMARKS
______________________________________________________________________

The following terms are trademarks of International Business Machines 
Corporation in the U.S., or other countries, or both:

         IBM
         OS/2

Java is a trademark of Sun Microsystems, Inc. in the U.S.
and other countries. The Java technology is owned and exclusively
licensed by Sun Microsystems, Inc.

Other company, product, and service names may be trademarks or
service marks of others.

THIS DOCUMENT IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND. IBM DISCLAIMS ALL WARRANTIES, WHETHER
EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION, THE
IMPLIED WARRANTIES OF FITNESS FOR A PARTICULAR PURPOSE
AND MERCHANTABILITY WITH RESPECT TO THE INFORMATION IN
THIS DOCUMENT. BY FURNISHING THIS DOCUMENT, IBM GRANTS
NO LICENSES TO ANY PATENTS OR COPYRIGHTS.

Copyright (c) 1997, 1999 Sun Microsystems, Inc.
901 San Antonio Rd., Palo Alto, CA 94303 USA.
All rights reserved. 

(c) Copyright IBM Corporation 1999, All rights reserved.
______________________________________________________________________

END-OF-README-FILE
______________________________________________________________________
