/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.security;

import com.sun.jmx.remote.security.FileLoginModule;
import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.remote.JMXAuthenticator;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public final class JMXPluggableAuthenticator
implements JMXAuthenticator {
    private LoginContext loginContext;
    private String username;
    private String password;
    private static final String LOGIN_CONFIG_PROP = "jmx.remote.x.login.config";
    private static final String LOGIN_CONFIG_NAME = "JMXPluggableAuthenticator";
    private static final String PASSWORD_FILE_PROP = "jmx.remote.x.password.file";
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "JMXPluggableAuthenticator");

    public JMXPluggableAuthenticator(Map map) {
        block8: {
            String string = null;
            String string2 = null;
            if (map != null) {
                string = (String)map.get(LOGIN_CONFIG_PROP);
                string2 = (String)map.get(PASSWORD_FILE_PROP);
            }
            try {
                if (string != null) {
                    this.loginContext = new LoginContext(string, new JMXCallbackHandler());
                    break block8;
                }
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkPermission(new AuthPermission("createLoginContext.JMXPluggableAuthenticator"));
                }
                final String string3 = string2;
                try {
                    this.loginContext = AccessController.doPrivileged(new PrivilegedExceptionAction<LoginContext>(){

                        @Override
                        public LoginContext run() throws LoginException {
                            return new LoginContext(JMXPluggableAuthenticator.LOGIN_CONFIG_NAME, null, new JMXCallbackHandler(), new FileLoginConfig(string3));
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (LoginException)privilegedActionException.getException();
                }
            }
            catch (LoginException loginException) {
                JMXPluggableAuthenticator.authenticationFailure("authenticate", loginException);
            }
            catch (SecurityException securityException) {
                JMXPluggableAuthenticator.authenticationFailure("authenticate", securityException);
            }
        }
    }

    public Subject authenticate(Object object) {
        Object object2;
        Object object3;
        if (!(object instanceof String[])) {
            if (object == null) {
                JMXPluggableAuthenticator.authenticationFailure("authenticate", "Credentials required");
            }
            object3 = "Credentials should be String[] instead of " + object.getClass().getName();
            JMXPluggableAuthenticator.authenticationFailure("authenticate", (String)object3);
        }
        if (((String[])(object3 = (String[])object)).length != 2) {
            object2 = "Credentials should have 2 elements not " + ((String[])object3).length;
            JMXPluggableAuthenticator.authenticationFailure("authenticate", (String)object2);
        }
        this.username = object3[0];
        this.password = object3[1];
        if (this.username == null || this.password == null) {
            JMXPluggableAuthenticator.authenticationFailure("authenticate", "Username or password is null");
        }
        try {
            this.loginContext.login();
            object2 = this.loginContext.getSubject();
            AccessController.doPrivileged(new PrivilegedAction<Void>((Subject)object2){
                final /* synthetic */ Subject val$subject;
                {
                    this.val$subject = subject;
                }

                @Override
                public Void run() {
                    this.val$subject.setReadOnly();
                    return null;
                }
            });
            return object2;
        }
        catch (LoginException loginException) {
            JMXPluggableAuthenticator.authenticationFailure("authenticate", loginException);
            return null;
        }
    }

    private static void authenticationFailure(String string, String string2) throws SecurityException {
        String string3 = "Authentication failed! " + string2;
        SecurityException securityException = new SecurityException(string3);
        JMXPluggableAuthenticator.logException(string, string3, securityException);
        throw securityException;
    }

    private static void authenticationFailure(String string, Exception exception) throws SecurityException {
        SecurityException securityException;
        String string2;
        if (exception instanceof SecurityException) {
            string2 = exception.getMessage();
            securityException = (SecurityException)exception;
        } else {
            string2 = "Authentication failed! " + exception.getMessage();
            SecurityException securityException2 = new SecurityException(string2);
            EnvHelp.initCause(securityException2, exception);
            securityException = securityException2;
        }
        JMXPluggableAuthenticator.logException(string, string2, securityException);
        throw securityException;
    }

    private static void logException(String string, String string2, Exception exception) {
        if (logger.traceOn()) {
            logger.trace(string, string2);
        }
        if (logger.debugOn()) {
            logger.debug(string, exception);
        }
    }

    private static class FileLoginConfig
    extends Configuration {
        private static AppConfigurationEntry[] entries;
        private static final String FILE_LOGIN_MODULE;
        private static final String PASSWORD_FILE_OPTION = "passwordFile";

        public FileLoginConfig(String string) {
            Map<String, String> map;
            if (string != null) {
                map = new HashMap(1);
                map.put(PASSWORD_FILE_OPTION, string);
            } else {
                map = Collections.emptyMap();
            }
            entries = new AppConfigurationEntry[]{new AppConfigurationEntry(FILE_LOGIN_MODULE, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, map)};
        }

        public AppConfigurationEntry[] getAppConfigurationEntry(String string) {
            return string.equals(JMXPluggableAuthenticator.LOGIN_CONFIG_NAME) ? entries : null;
        }

        public void refresh() {
        }

        static {
            FILE_LOGIN_MODULE = FileLoginModule.class.getName();
        }
    }

    private final class JMXCallbackHandler
    implements CallbackHandler {
        private JMXCallbackHandler() {
        }

        public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbackArray.length; ++i) {
                if (callbackArray[i] instanceof NameCallback) {
                    ((NameCallback)callbackArray[i]).setName(JMXPluggableAuthenticator.this.username);
                    continue;
                }
                if (callbackArray[i] instanceof PasswordCallback) {
                    ((PasswordCallback)callbackArray[i]).setPassword(JMXPluggableAuthenticator.this.password.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callbackArray[i], "Unrecognized Callback");
            }
        }
    }
}

