/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.List;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Field;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.AWTAccessor;

public abstract class AWTEvent
extends EventObject {
    private static final Logger log = Logger.getLogger("java.awt.AWTEvent");
    private byte[] bdata;
    protected int id;
    protected boolean consumed = false;
    private volatile transient AccessControlContext acc = AccessController.getContext();
    transient boolean focusManagerIsDispatching = false;
    transient boolean isPosted;
    private transient boolean isSystemGenerated;
    public static final long COMPONENT_EVENT_MASK = 1L;
    public static final long CONTAINER_EVENT_MASK = 2L;
    public static final long FOCUS_EVENT_MASK = 4L;
    public static final long KEY_EVENT_MASK = 8L;
    public static final long MOUSE_EVENT_MASK = 16L;
    public static final long MOUSE_MOTION_EVENT_MASK = 32L;
    public static final long WINDOW_EVENT_MASK = 64L;
    public static final long ACTION_EVENT_MASK = 128L;
    public static final long ADJUSTMENT_EVENT_MASK = 256L;
    public static final long ITEM_EVENT_MASK = 512L;
    public static final long TEXT_EVENT_MASK = 1024L;
    public static final long INPUT_METHOD_EVENT_MASK = 2048L;
    static final long INPUT_METHODS_ENABLED_MASK = 4096L;
    public static final long PAINT_EVENT_MASK = 8192L;
    public static final long INVOCATION_EVENT_MASK = 16384L;
    public static final long HIERARCHY_EVENT_MASK = 32768L;
    public static final long HIERARCHY_BOUNDS_EVENT_MASK = 65536L;
    public static final long MOUSE_WHEEL_EVENT_MASK = 131072L;
    public static final long WINDOW_STATE_EVENT_MASK = 262144L;
    public static final long WINDOW_FOCUS_EVENT_MASK = 524288L;
    public static final int RESERVED_ID_MAX = 1999;
    private static Field inputEvent_CanAccessSystemClipboard_Field = null;
    private static final long serialVersionUID = -1825314779160409405L;

    final AccessControlContext getAccessControlContext() {
        if (this.acc == null) {
            throw new SecurityException("AWTEvent is missing AccessControlContext");
        }
        return this.acc;
    }

    private static synchronized Field get_InputEvent_CanAccessSystemClipboard() {
        if (inputEvent_CanAccessSystemClipboard_Field == null) {
            inputEvent_CanAccessSystemClipboard_Field = (Field)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    block4: {
                        Field field = null;
                        try {
                            field = InputEvent.class.getDeclaredField("canAccessSystemClipboard");
                            field.setAccessible(true);
                            return field;
                        }
                        catch (SecurityException securityException) {
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "AWTEvent.get_InputEvent_CanAccessSystemClipboard() got SecurityException ", securityException);
                            }
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            if (!log.isLoggable(Level.FINE)) break block4;
                            log.log(Level.FINE, "AWTEvent.get_InputEvent_CanAccessSystemClipboard() got NoSuchFieldException ", noSuchFieldException);
                        }
                    }
                    return null;
                }
            });
        }
        return inputEvent_CanAccessSystemClipboard_Field;
    }

    private static native void initIDs();

    public AWTEvent(Event event) {
        this(event.target, event.id);
    }

    public AWTEvent(Object object, int n) {
        super(object);
        this.id = n;
        switch (n) {
            case 601: 
            case 701: 
            case 900: 
            case 1001: {
                this.consumed = true;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSource(Object object) {
        if (this.source == object) {
            return;
        }
        Component component = null;
        if (object instanceof Component) {
            component = (Component)object;
            while (component != null && component.peer != null && component.peer instanceof LightweightPeer) {
                component = component.parent;
            }
        }
        AWTEvent aWTEvent = this;
        synchronized (aWTEvent) {
            ComponentPeer componentPeer;
            this.source = object;
            if (component != null && (componentPeer = component.peer) != null) {
                this.nativeSetSource(componentPeer);
            }
        }
    }

    private native void nativeSetSource(ComponentPeer var1);

    public int getID() {
        return this.id;
    }

    public String toString() {
        String string = null;
        if (this.source instanceof Component) {
            string = ((Component)this.source).getName();
        } else if (this.source instanceof MenuComponent) {
            string = ((MenuComponent)this.source).getName();
        }
        return this.getClass().getName() + "[" + this.paramString() + "] on " + (string != null ? string : this.source);
    }

    public String paramString() {
        return "";
    }

    protected void consume() {
        switch (this.id) {
            case 401: 
            case 402: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 507: 
            case 1100: 
            case 1101: {
                this.consumed = true;
                break;
            }
        }
    }

    protected boolean isConsumed() {
        return this.consumed;
    }

    Event convertToOld() {
        Object object = this.getSource();
        int n = this.id;
        switch (this.id) {
            case 401: 
            case 402: {
                int n2;
                KeyEvent keyEvent = (KeyEvent)this;
                if (keyEvent.isActionKey()) {
                    int n3 = n = this.id == 401 ? 403 : 404;
                }
                if ((n2 = keyEvent.getKeyCode()) == 16 || n2 == 17 || n2 == 18) {
                    return null;
                }
                return new Event(object, keyEvent.getWhen(), n, 0, 0, Event.getOldEventKey(keyEvent), keyEvent.getModifiers() & 0xFFFFFFEF);
            }
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: {
                MouseEvent mouseEvent = (MouseEvent)this;
                Event event = new Event(object, mouseEvent.getWhen(), n, mouseEvent.getX(), mouseEvent.getY(), 0, mouseEvent.getModifiers() & 0xFFFFFFEF);
                event.clickCount = mouseEvent.getClickCount();
                return event;
            }
            case 1004: {
                return new Event(object, 1004, null);
            }
            case 1005: {
                return new Event(object, 1005, null);
            }
            case 201: 
            case 203: 
            case 204: {
                return new Event(object, n, null);
            }
            case 100: {
                if (!(object instanceof Frame) && !(object instanceof Dialog)) break;
                Point point = ((Component)object).getLocation();
                return new Event(object, 0L, 205, point.x, point.y, 0, 0);
            }
            case 1001: {
                ActionEvent actionEvent = (ActionEvent)this;
                String string = object instanceof Button ? ((Button)object).getLabel() : (object instanceof MenuItem ? ((MenuItem)object).getLabel() : actionEvent.getActionCommand());
                return new Event(object, 0L, n, 0, 0, 0, actionEvent.getModifiers(), string);
            }
            case 701: {
                Object object2;
                ItemEvent itemEvent = (ItemEvent)this;
                if (object instanceof List) {
                    n = itemEvent.getStateChange() == 1 ? 701 : 702;
                    object2 = itemEvent.getItem();
                } else {
                    n = 1001;
                    object2 = object instanceof Choice ? itemEvent.getItem() : Boolean.valueOf(itemEvent.getStateChange() == 1);
                }
                return new Event(object, n, object2);
            }
            case 601: {
                AdjustmentEvent adjustmentEvent = (AdjustmentEvent)this;
                switch (adjustmentEvent.getAdjustmentType()) {
                    case 1: {
                        n = 602;
                        break;
                    }
                    case 2: {
                        n = 601;
                        break;
                    }
                    case 4: {
                        n = 604;
                        break;
                    }
                    case 3: {
                        n = 603;
                        break;
                    }
                    case 5: {
                        if (adjustmentEvent.getValueIsAdjusting()) {
                            n = 605;
                            break;
                        }
                        n = 607;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                return new Event(object, n, adjustmentEvent.getValue());
            }
        }
        return null;
    }

    void copyPrivateDataInto(AWTEvent aWTEvent) {
        block3: {
            Field field;
            aWTEvent.bdata = this.bdata;
            if (this instanceof InputEvent && aWTEvent instanceof InputEvent && (field = AWTEvent.get_InputEvent_CanAccessSystemClipboard()) != null) {
                try {
                    boolean bl = field.getBoolean(this);
                    field.setBoolean(aWTEvent, bl);
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (!log.isLoggable(Level.FINE)) break block3;
                    log.log(Level.FINE, "AWTEvent.copyPrivateDataInto() got IllegalAccessException ", illegalAccessException);
                }
            }
        }
    }

    void dispatched() {
        block3: {
            Field field;
            if (this instanceof InputEvent && (field = AWTEvent.get_InputEvent_CanAccessSystemClipboard()) != null) {
                try {
                    field.setBoolean(this, false);
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (!log.isLoggable(Level.FINE)) break block3;
                    log.log(Level.FINE, "AWTEvent.dispatched() got IllegalAccessException ", illegalAccessException);
                }
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.acc = AccessController.getContext();
        objectInputStream.defaultReadObject();
    }

    static /* synthetic */ byte[] access$102(AWTEvent aWTEvent, byte[] byArray) {
        aWTEvent.bdata = byArray;
        return byArray;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            AWTEvent.initIDs();
        }
        AWTAccessor.setAWTEventAccessor(new AWTAccessor.AWTEventAccessor(){

            public void setSystemGenerated(AWTEvent aWTEvent) {
                aWTEvent.isSystemGenerated = true;
            }

            public boolean isSystemGenerated(AWTEvent aWTEvent) {
                return aWTEvent.isSystemGenerated;
            }

            public void setPosted(AWTEvent aWTEvent) {
                aWTEvent.isPosted = true;
            }

            public AccessControlContext getAccessControlContext(AWTEvent aWTEvent) {
                return aWTEvent.getAccessControlContext();
            }

            public byte[] getBData(AWTEvent aWTEvent) {
                return aWTEvent.bdata;
            }

            public void setBData(AWTEvent aWTEvent, byte[] byArray) {
                AWTEvent.access$102(aWTEvent, byArray);
            }
        });
    }
}

