/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProcessImpl
extends Process {
    private long handle = 0L;
    private FileDescriptor stdin_fd;
    private FileDescriptor stdout_fd;
    private FileDescriptor stderr_fd;
    private OutputStream stdin_stream;
    private InputStream stdout_stream;
    private InputStream stderr_stream;
    private static final int STILL_ACTIVE = ProcessImpl.getStillActive();

    static Process start(String[] stringArray, Map<String, String> map, String string, boolean bl) throws IOException {
        String string2 = ProcessEnvironment.toEnvironmentBlock(map);
        return new ProcessImpl(stringArray, string2, string, bl);
    }

    private ProcessImpl(String[] stringArray, String string, String string2, boolean bl) throws IOException {
        stringArray[0] = new File(stringArray[0]).getPath();
        StringBuilder stringBuilder = new StringBuilder(80);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3;
            if (i > 0) {
                stringBuilder.append(' ');
            }
            if ((string3 = stringArray[i]).indexOf(32) >= 0 || string3.indexOf(9) >= 0) {
                if (string3.charAt(0) != '\"') {
                    stringBuilder.append('\"');
                    stringBuilder.append(string3);
                    if (string3.endsWith("\\")) {
                        stringBuilder.append("\\");
                    }
                    stringBuilder.append('\"');
                    continue;
                }
                if (string3.endsWith("\"")) {
                    stringBuilder.append(string3);
                    continue;
                }
                throw new IllegalArgumentException();
            }
            stringBuilder.append(string3);
        }
        String string4 = stringBuilder.toString();
        this.stdin_fd = new FileDescriptor();
        this.stdout_fd = new FileDescriptor();
        this.stderr_fd = new FileDescriptor();
        this.handle = ProcessImpl.create(string4, string, string2, bl, this.stdin_fd, this.stdout_fd, this.stderr_fd);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ProcessImpl.this.stdin_stream = new BufferedOutputStream(new FileOutputStream(ProcessImpl.this.stdin_fd));
                ProcessImpl.this.stdout_stream = new BufferedInputStream(new FileInputStream(ProcessImpl.this.stdout_fd));
                ProcessImpl.this.stderr_stream = new FileInputStream(ProcessImpl.this.stderr_fd);
                return null;
            }
        });
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stdin_stream;
    }

    @Override
    public InputStream getInputStream() {
        return this.stdout_stream;
    }

    @Override
    public InputStream getErrorStream() {
        return this.stderr_stream;
    }

    public void finalize() {
        ProcessImpl.closeHandle(this.handle);
    }

    private static native int getStillActive();

    @Override
    public int exitValue() {
        int n = ProcessImpl.getExitCodeProcess(this.handle);
        if (n == STILL_ACTIVE) {
            throw new IllegalThreadStateException("process has not exited");
        }
        return n;
    }

    private static native int getExitCodeProcess(long var0);

    @Override
    public int waitFor() throws InterruptedException {
        ProcessImpl.waitForInterruptibly(this.handle);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.exitValue();
    }

    private static native void waitForInterruptibly(long var0);

    @Override
    public void destroy() {
        ProcessImpl.terminateProcess(this.handle);
    }

    private static native void terminateProcess(long var0);

    private static native long create(String var0, String var1, String var2, boolean var3, FileDescriptor var4, FileDescriptor var5, FileDescriptor var6) throws IOException;

    private static native boolean closeHandle(long var0);
}

