/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTranscoder;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageOutputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageTranscoderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import sun.awt.AppContext;
import sun.security.action.GetPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImageIO {
    private static final IIORegistry theRegistry = IIORegistry.getDefaultInstance();
    private static Method readerFormatNamesMethod;
    private static Method readerFileSuffixesMethod;
    private static Method readerMIMETypesMethod;
    private static Method writerFormatNamesMethod;
    private static Method writerFileSuffixesMethod;
    private static Method writerMIMETypesMethod;

    private ImageIO() {
    }

    public static void scanForPlugins() {
        theRegistry.registerApplicationClasspathSpis();
    }

    private static synchronized CacheInfo getCacheInfo() {
        AppContext appContext = AppContext.getAppContext();
        CacheInfo cacheInfo = (CacheInfo)appContext.get(CacheInfo.class);
        if (cacheInfo == null) {
            cacheInfo = new CacheInfo();
            appContext.put(CacheInfo.class, cacheInfo);
        }
        return cacheInfo;
    }

    private static String getTempDir() {
        GetPropertyAction getPropertyAction = new GetPropertyAction("java.io.tmpdir");
        return AccessController.doPrivileged(getPropertyAction);
    }

    private static boolean hasCachePermission() {
        Boolean bl = ImageIO.getCacheInfo().getHasPermission();
        if (bl != null) {
            return bl;
        }
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                String string;
                File file = ImageIO.getCacheDirectory();
                if (file != null) {
                    string = file.getPath();
                } else {
                    string = ImageIO.getTempDir();
                    if (string == null) {
                        ImageIO.getCacheInfo().setHasPermission(Boolean.FALSE);
                        return false;
                    }
                }
                securityManager.checkWrite(string);
            }
        }
        catch (SecurityException securityException) {
            ImageIO.getCacheInfo().setHasPermission(Boolean.FALSE);
            return false;
        }
        ImageIO.getCacheInfo().setHasPermission(Boolean.TRUE);
        return true;
    }

    public static void setUseCache(boolean bl) {
        ImageIO.getCacheInfo().setUseCache(bl);
    }

    public static boolean getUseCache() {
        return ImageIO.getCacheInfo().getUseCache();
    }

    public static void setCacheDirectory(File file) {
        if (file != null && !file.isDirectory()) {
            throw new IllegalArgumentException("Not a directory!");
        }
        ImageIO.getCacheInfo().setCacheDirectory(file);
        ImageIO.getCacheInfo().setHasPermission(null);
    }

    public static File getCacheDirectory() {
        return ImageIO.getCacheInfo().getCacheDirectory();
    }

    public static ImageInputStream createImageInputStream(Object object) throws IOException {
        boolean bl;
        Iterator<ImageInputStreamSpi> iterator;
        if (object == null) {
            throw new IllegalArgumentException("input == null!");
        }
        try {
            iterator = theRegistry.getServiceProviders(ImageInputStreamSpi.class, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        boolean bl2 = bl = ImageIO.getUseCache() && ImageIO.hasCachePermission();
        while (iterator.hasNext()) {
            ImageInputStreamSpi imageInputStreamSpi = iterator.next();
            if (!imageInputStreamSpi.getInputClass().isInstance(object)) continue;
            try {
                return imageInputStreamSpi.createInputStreamInstance(object, bl, ImageIO.getCacheDirectory());
            }
            catch (IOException iOException) {
                throw new IIOException("Can't create cache file!", iOException);
            }
        }
        return null;
    }

    public static ImageOutputStream createImageOutputStream(Object object) throws IOException {
        boolean bl;
        Iterator<ImageOutputStreamSpi> iterator;
        if (object == null) {
            throw new IllegalArgumentException("output == null!");
        }
        try {
            iterator = theRegistry.getServiceProviders(ImageOutputStreamSpi.class, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        boolean bl2 = bl = ImageIO.getUseCache() && ImageIO.hasCachePermission();
        while (iterator.hasNext()) {
            ImageOutputStreamSpi imageOutputStreamSpi = iterator.next();
            if (!imageOutputStreamSpi.getOutputClass().isInstance(object)) continue;
            try {
                return imageOutputStreamSpi.createOutputStreamInstance(object, bl, ImageIO.getCacheDirectory());
            }
            catch (IOException iOException) {
                throw new IIOException("Can't create cache file!", iOException);
            }
        }
        return null;
    }

    private static <S extends ImageReaderWriterSpi> String[] getReaderWriterInfo(Class<S> clazz, SpiInfo spiInfo) {
        Iterator<S> iterator;
        try {
            iterator = theRegistry.getServiceProviders(clazz, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new String[0];
        }
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            ImageReaderWriterSpi imageReaderWriterSpi = (ImageReaderWriterSpi)iterator.next();
            Collections.addAll(hashSet, spiInfo.info(imageReaderWriterSpi));
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public static String[] getReaderFormatNames() {
        return ImageIO.getReaderWriterInfo(ImageReaderSpi.class, SpiInfo.FORMAT_NAMES);
    }

    public static String[] getReaderMIMETypes() {
        return ImageIO.getReaderWriterInfo(ImageReaderSpi.class, SpiInfo.MIME_TYPES);
    }

    public static String[] getReaderFileSuffixes() {
        return ImageIO.getReaderWriterInfo(ImageReaderSpi.class, SpiInfo.FILE_SUFFIXES);
    }

    public static Iterator<ImageReader> getImageReaders(Object object) {
        Iterator<ImageReaderSpi> iterator;
        if (object == null) {
            throw new IllegalArgumentException("input == null!");
        }
        try {
            iterator = theRegistry.getServiceProviders(ImageReaderSpi.class, new CanDecodeInputFilter(object), true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.emptyList().iterator();
        }
        return new ImageReaderIterator(iterator);
    }

    public static Iterator<ImageReader> getImageReadersByFormatName(String string) {
        Iterator<ImageReaderSpi> iterator;
        if (string == null) {
            throw new IllegalArgumentException("formatName == null!");
        }
        try {
            iterator = theRegistry.getServiceProviders(ImageReaderSpi.class, new ContainsFilter(readerFormatNamesMethod, string), true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.emptyList().iterator();
        }
        return new ImageReaderIterator(iterator);
    }

    public static Iterator<ImageReader> getImageReadersBySuffix(String string) {
        Iterator<ImageReaderSpi> iterator;
        if (string == null) {
            throw new IllegalArgumentException("fileSuffix == null!");
        }
        try {
            iterator = theRegistry.getServiceProviders(ImageReaderSpi.class, new ContainsFilter(readerFileSuffixesMethod, string), true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.emptyList().iterator();
        }
        return new ImageReaderIterator(iterator);
    }

    public static Iterator<ImageReader> getImageReadersByMIMEType(String string) {
        Iterator<ImageReaderSpi> iterator;
        if (string == null) {
            throw new IllegalArgumentException("MIMEType == null!");
        }
        try {
            iterator = theRegistry.getServiceProviders(ImageReaderSpi.class, new ContainsFilter(readerMIMETypesMethod, string), true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.emptyList().iterator();
        }
        return new ImageReaderIterator(iterator);
    }

    public static String[] getWriterFormatNames() {
        return ImageIO.getReaderWriterInfo(ImageWriterSpi.class, SpiInfo.FORMAT_NAMES);
    }

    public static String[] getWriterMIMETypes() {
        return ImageIO.getReaderWriterInfo(ImageWriterSpi.class, SpiInfo.MIME_TYPES);
    }

    public static String[] getWriterFileSuffixes() {
        return ImageIO.getReaderWriterInfo(ImageWriterSpi.class, SpiInfo.FILE_SUFFIXES);
    }

    private static boolean contains(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public static Iterator<ImageWriter> getImageWritersByFormatName(String string) {
        Iterator<ImageWriterSpi> iterator;
        if (string == null) {
            throw new IllegalArgumentException("formatName == null!");
        }
        try {
            iterator = theRegistry.getServiceProviders(ImageWriterSpi.class, new ContainsFilter(writerFormatNamesMethod, string), true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.emptyList().iterator();
        }
        return new ImageWriterIterator(iterator);
    }

    public static Iterator<ImageWriter> getImageWritersBySuffix(String string) {
        Iterator<ImageWriterSpi> iterator;
        if (string == null) {
            throw new IllegalArgumentException("fileSuffix == null!");
        }
        try {
            iterator = theRegistry.getServiceProviders(ImageWriterSpi.class, new ContainsFilter(writerFileSuffixesMethod, string), true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.emptyList().iterator();
        }
        return new ImageWriterIterator(iterator);
    }

    public static Iterator<ImageWriter> getImageWritersByMIMEType(String string) {
        Iterator<ImageWriterSpi> iterator;
        if (string == null) {
            throw new IllegalArgumentException("MIMEType == null!");
        }
        try {
            iterator = theRegistry.getServiceProviders(ImageWriterSpi.class, new ContainsFilter(writerMIMETypesMethod, string), true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.emptyList().iterator();
        }
        return new ImageWriterIterator(iterator);
    }

    public static ImageWriter getImageWriter(ImageReader imageReader) {
        Object object;
        Object object2;
        if (imageReader == null) {
            throw new IllegalArgumentException("reader == null!");
        }
        Object object3 = imageReader.getOriginatingProvider();
        if (object3 == null) {
            try {
                object2 = theRegistry.getServiceProviders(ImageReaderSpi.class, false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
            while (object2.hasNext()) {
                object = (ImageReaderSpi)object2.next();
                if (!((ImageReaderSpi)object).isOwnReader(imageReader)) continue;
                object3 = object;
                break;
            }
            if (object3 == null) {
                return null;
            }
        }
        if ((object2 = ((ImageReaderSpi)object3).getImageWriterSpiNames()) == null) {
            return null;
        }
        object = null;
        try {
            object = Class.forName((String)object2[0], true, ClassLoader.getSystemClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        ImageWriterSpi imageWriterSpi = (ImageWriterSpi)theRegistry.getServiceProviderByClass(object);
        if (imageWriterSpi == null) {
            return null;
        }
        try {
            return imageWriterSpi.createWriterInstance();
        }
        catch (IOException iOException) {
            theRegistry.deregisterServiceProvider(imageWriterSpi, ImageWriterSpi.class);
            return null;
        }
    }

    public static ImageReader getImageReader(ImageWriter imageWriter) {
        Object object;
        Object object2;
        if (imageWriter == null) {
            throw new IllegalArgumentException("writer == null!");
        }
        Object object3 = imageWriter.getOriginatingProvider();
        if (object3 == null) {
            try {
                object2 = theRegistry.getServiceProviders(ImageWriterSpi.class, false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
            while (object2.hasNext()) {
                object = (ImageWriterSpi)object2.next();
                if (!((ImageWriterSpi)object).isOwnWriter(imageWriter)) continue;
                object3 = object;
                break;
            }
            if (object3 == null) {
                return null;
            }
        }
        if ((object2 = ((ImageWriterSpi)object3).getImageReaderSpiNames()) == null) {
            return null;
        }
        object = null;
        try {
            object = Class.forName((String)object2[0], true, ClassLoader.getSystemClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        ImageReaderSpi imageReaderSpi = (ImageReaderSpi)theRegistry.getServiceProviderByClass(object);
        if (imageReaderSpi == null) {
            return null;
        }
        try {
            return imageReaderSpi.createReaderInstance();
        }
        catch (IOException iOException) {
            theRegistry.deregisterServiceProvider(imageReaderSpi, ImageReaderSpi.class);
            return null;
        }
    }

    public static Iterator<ImageWriter> getImageWriters(ImageTypeSpecifier imageTypeSpecifier, String string) {
        Iterator<ImageWriterSpi> iterator;
        if (imageTypeSpecifier == null) {
            throw new IllegalArgumentException("type == null!");
        }
        if (string == null) {
            throw new IllegalArgumentException("formatName == null!");
        }
        try {
            iterator = theRegistry.getServiceProviders(ImageWriterSpi.class, new CanEncodeImageAndFormatFilter(imageTypeSpecifier, string), true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.emptyList().iterator();
        }
        return new ImageWriterIterator(iterator);
    }

    public static Iterator<ImageTranscoder> getImageTranscoders(ImageReader imageReader, ImageWriter imageWriter) {
        Iterator<ImageTranscoderSpi> iterator;
        if (imageReader == null) {
            throw new IllegalArgumentException("reader == null!");
        }
        if (imageWriter == null) {
            throw new IllegalArgumentException("writer == null!");
        }
        ImageReaderSpi imageReaderSpi = imageReader.getOriginatingProvider();
        ImageWriterSpi imageWriterSpi = imageWriter.getOriginatingProvider();
        TranscoderFilter transcoderFilter = new TranscoderFilter(imageReaderSpi, imageWriterSpi);
        try {
            iterator = theRegistry.getServiceProviders(ImageTranscoderSpi.class, transcoderFilter, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.emptyList().iterator();
        }
        return new ImageTranscoderIterator(iterator);
    }

    public static BufferedImage read(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("input == null!");
        }
        if (!file.canRead()) {
            throw new IIOException("Can't read input file!");
        }
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
        if (imageInputStream == null) {
            throw new IIOException("Can't create an ImageInputStream!");
        }
        BufferedImage bufferedImage = ImageIO.read(imageInputStream);
        if (bufferedImage == null) {
            imageInputStream.close();
        }
        return bufferedImage;
    }

    public static BufferedImage read(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("input == null!");
        }
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        BufferedImage bufferedImage = ImageIO.read(imageInputStream);
        if (bufferedImage == null) {
            imageInputStream.close();
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage read(URL uRL) throws IOException {
        BufferedImage bufferedImage;
        if (uRL == null) {
            throw new IllegalArgumentException("input == null!");
        }
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            throw new IIOException("Can't get input stream from URL!", iOException);
        }
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        try {
            bufferedImage = ImageIO.read(imageInputStream);
            if (bufferedImage == null) {
                imageInputStream.close();
            }
        }
        finally {
            inputStream.close();
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage read(ImageInputStream imageInputStream) throws IOException {
        BufferedImage bufferedImage;
        if (imageInputStream == null) {
            throw new IllegalArgumentException("stream == null!");
        }
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
        if (!iterator.hasNext()) {
            return null;
        }
        ImageReader imageReader = iterator.next();
        ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
        imageReader.setInput(imageInputStream, true, true);
        try {
            bufferedImage = imageReader.read(0, imageReadParam);
        }
        finally {
            imageReader.dispose();
            imageInputStream.close();
        }
        return bufferedImage;
    }

    public static boolean write(RenderedImage renderedImage, String string, ImageOutputStream imageOutputStream) throws IOException {
        if (renderedImage == null) {
            throw new IllegalArgumentException("im == null!");
        }
        if (string == null) {
            throw new IllegalArgumentException("formatName == null!");
        }
        if (imageOutputStream == null) {
            throw new IllegalArgumentException("output == null!");
        }
        return ImageIO.doWrite(renderedImage, ImageIO.getWriter(renderedImage, string), imageOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean write(RenderedImage renderedImage, String string, File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("output == null!");
        }
        ImageOutputStream imageOutputStream = null;
        ImageWriter imageWriter = ImageIO.getWriter(renderedImage, string);
        if (imageWriter == null) {
            return false;
        }
        try {
            file.delete();
            imageOutputStream = ImageIO.createImageOutputStream(file);
        }
        catch (IOException iOException) {
            throw new IIOException("Can't create output stream!", iOException);
        }
        try {
            boolean bl = ImageIO.doWrite(renderedImage, imageWriter, imageOutputStream);
            return bl;
        }
        finally {
            imageOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean write(RenderedImage renderedImage, String string, OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("output == null!");
        }
        ImageOutputStream imageOutputStream = null;
        try {
            imageOutputStream = ImageIO.createImageOutputStream(outputStream);
        }
        catch (IOException iOException) {
            throw new IIOException("Can't create output stream!", iOException);
        }
        try {
            boolean bl = ImageIO.doWrite(renderedImage, ImageIO.getWriter(renderedImage, string), imageOutputStream);
            return bl;
        }
        finally {
            imageOutputStream.close();
        }
    }

    private static ImageWriter getWriter(RenderedImage renderedImage, String string) {
        ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromRenderedImage(renderedImage);
        Iterator<ImageWriter> iterator = ImageIO.getImageWriters(imageTypeSpecifier, string);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doWrite(RenderedImage renderedImage, ImageWriter imageWriter, ImageOutputStream imageOutputStream) throws IOException {
        if (imageWriter == null) {
            return false;
        }
        imageWriter.setOutput(imageOutputStream);
        try {
            imageWriter.write(renderedImage);
        }
        finally {
            imageWriter.dispose();
            imageOutputStream.flush();
        }
        return true;
    }

    static {
        try {
            readerFormatNamesMethod = ImageReaderSpi.class.getMethod("getFormatNames", new Class[0]);
            readerFileSuffixesMethod = ImageReaderSpi.class.getMethod("getFileSuffixes", new Class[0]);
            readerMIMETypesMethod = ImageReaderSpi.class.getMethod("getMIMETypes", new Class[0]);
            writerFormatNamesMethod = ImageWriterSpi.class.getMethod("getFormatNames", new Class[0]);
            writerFileSuffixesMethod = ImageWriterSpi.class.getMethod("getFileSuffixes", new Class[0]);
            writerMIMETypesMethod = ImageWriterSpi.class.getMethod("getMIMETypes", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
    }

    static class TranscoderFilter
    implements ServiceRegistry.Filter {
        String readerSpiName;
        String writerSpiName;

        public TranscoderFilter(ImageReaderSpi imageReaderSpi, ImageWriterSpi imageWriterSpi) {
            this.readerSpiName = imageReaderSpi.getClass().getName();
            this.writerSpiName = imageWriterSpi.getClass().getName();
        }

        public boolean filter(Object object) {
            ImageTranscoderSpi imageTranscoderSpi = (ImageTranscoderSpi)object;
            String string = imageTranscoderSpi.getReaderServiceProviderName();
            String string2 = imageTranscoderSpi.getWriterServiceProviderName();
            return string.equals(this.readerSpiName) && string2.equals(this.writerSpiName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ImageTranscoderIterator
    implements Iterator<ImageTranscoder> {
        public Iterator iter;

        public ImageTranscoderIterator(Iterator iterator) {
            this.iter = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public ImageTranscoder next() {
            ImageTranscoderSpi imageTranscoderSpi = null;
            imageTranscoderSpi = (ImageTranscoderSpi)this.iter.next();
            return imageTranscoderSpi.createTranscoderInstance();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ImageWriterIterator
    implements Iterator<ImageWriter> {
        public Iterator iter;

        public ImageWriterIterator(Iterator iterator) {
            this.iter = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public ImageWriter next() {
            ImageWriterSpi imageWriterSpi = null;
            try {
                imageWriterSpi = (ImageWriterSpi)this.iter.next();
                return imageWriterSpi.createWriterInstance();
            }
            catch (IOException iOException) {
                theRegistry.deregisterServiceProvider(imageWriterSpi, ImageWriterSpi.class);
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class ContainsFilter
    implements ServiceRegistry.Filter {
        Method method;
        String name;

        public ContainsFilter(Method method, String string) {
            this.method = method;
            this.name = string;
        }

        public boolean filter(Object object) {
            try {
                return ImageIO.contains((String[])this.method.invoke(object, new Object[0]), this.name);
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    static class CanEncodeImageAndFormatFilter
    implements ServiceRegistry.Filter {
        ImageTypeSpecifier type;
        String formatName;

        public CanEncodeImageAndFormatFilter(ImageTypeSpecifier imageTypeSpecifier, String string) {
            this.type = imageTypeSpecifier;
            this.formatName = string;
        }

        public boolean filter(Object object) {
            ImageWriterSpi imageWriterSpi = (ImageWriterSpi)object;
            return Arrays.asList(imageWriterSpi.getFormatNames()).contains(this.formatName) && imageWriterSpi.canEncodeImage(this.type);
        }
    }

    static class CanDecodeInputFilter
    implements ServiceRegistry.Filter {
        Object input;

        public CanDecodeInputFilter(Object object) {
            this.input = object;
        }

        public boolean filter(Object object) {
            try {
                ImageReaderSpi imageReaderSpi = (ImageReaderSpi)object;
                ImageInputStream imageInputStream = null;
                if (this.input instanceof ImageInputStream) {
                    imageInputStream = (ImageInputStream)this.input;
                }
                boolean bl = false;
                if (imageInputStream != null) {
                    imageInputStream.mark();
                }
                bl = imageReaderSpi.canDecodeInput(this.input);
                if (imageInputStream != null) {
                    imageInputStream.reset();
                }
                return bl;
            }
            catch (IOException iOException) {
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ImageReaderIterator
    implements Iterator<ImageReader> {
        public Iterator iter;

        public ImageReaderIterator(Iterator iterator) {
            this.iter = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public ImageReader next() {
            ImageReaderSpi imageReaderSpi = null;
            try {
                imageReaderSpi = (ImageReaderSpi)this.iter.next();
                return imageReaderSpi.createReaderInstance();
            }
            catch (IOException iOException) {
                theRegistry.deregisterServiceProvider(imageReaderSpi, ImageReaderSpi.class);
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SpiInfo {
        FORMAT_NAMES{

            String[] info(ImageReaderWriterSpi imageReaderWriterSpi) {
                return imageReaderWriterSpi.getFormatNames();
            }
        }
        ,
        MIME_TYPES{

            String[] info(ImageReaderWriterSpi imageReaderWriterSpi) {
                return imageReaderWriterSpi.getMIMETypes();
            }
        }
        ,
        FILE_SUFFIXES{

            String[] info(ImageReaderWriterSpi imageReaderWriterSpi) {
                return imageReaderWriterSpi.getFileSuffixes();
            }
        };


        abstract String[] info(ImageReaderWriterSpi var1);
    }

    static class CacheInfo {
        boolean useCache = true;
        File cacheDirectory = null;
        Boolean hasPermission = null;

        public boolean getUseCache() {
            return this.useCache;
        }

        public void setUseCache(boolean bl) {
            this.useCache = bl;
        }

        public File getCacheDirectory() {
            return this.cacheDirectory;
        }

        public void setCacheDirectory(File file) {
            this.cacheDirectory = file;
        }

        public Boolean getHasPermission() {
            return this.hasPermission;
        }

        public void setHasPermission(Boolean bl) {
            this.hasPermission = bl;
        }
    }
}

