/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.AWTEvent;
import java.awt.Font;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.peer.MenuItemPeer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.windows.WMenuBarPeer;
import sun.awt.windows.WMenuPeer;
import sun.awt.windows.WObjectPeer;
import sun.awt.windows.WToolkit;

class WMenuItemPeer
extends WObjectPeer
implements MenuItemPeer {
    private static final Logger log = Logger.getLogger("sun.awt.WMenuItemPeer");
    String shortcutLabel;
    protected WMenuPeer parent;
    private final boolean isCheckbox;
    private static Font defaultMenuFont;

    private synchronized native void _dispose();

    protected void disposeImpl() {
        WToolkit.targetDisposedPeer(this.target, this);
        this._dispose();
    }

    public void setEnabled(boolean bl) {
        this.enable(bl);
    }

    public void enable() {
        this.enable(true);
    }

    public void disable() {
        this.enable(false);
    }

    public void readShortcutLabel() {
        MenuShortcut menuShortcut;
        WMenuPeer wMenuPeer = this.parent;
        while (wMenuPeer != null && !(wMenuPeer instanceof WMenuBarPeer)) {
            wMenuPeer = wMenuPeer.parent;
        }
        this.shortcutLabel = wMenuPeer instanceof WMenuBarPeer ? ((menuShortcut = ((MenuItem)this.target).getShortcut()) != null ? menuShortcut.toString() : null) : null;
    }

    public void setLabel(String string) {
        this.readShortcutLabel();
        this._setLabel(string);
    }

    public native void _setLabel(String var1);

    protected WMenuItemPeer() {
        this.isCheckbox = false;
    }

    WMenuItemPeer(MenuItem menuItem) {
        this(menuItem, false);
    }

    WMenuItemPeer(MenuItem menuItem, boolean bl) {
        this.target = menuItem;
        this.parent = (WMenuPeer)WToolkit.targetToPeer(menuItem.getParent());
        this.isCheckbox = bl;
        this.create(this.parent);
        this.checkMenuCreation();
        this.readShortcutLabel();
    }

    protected void checkMenuCreation() {
        if (this.pData == 0L) {
            if (this.createError != null) {
                throw this.createError;
            }
            throw new InternalError("couldn't create menu peer");
        }
    }

    void postEvent(AWTEvent aWTEvent) {
        WToolkit.postEvent(WToolkit.targetToAppContext(this.target), aWTEvent);
    }

    native void create(WMenuPeer var1);

    native void enable(boolean var1);

    void handleAction(final long l, final int n) {
        WToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

            public void run() {
                WMenuItemPeer.this.postEvent(new ActionEvent(WMenuItemPeer.this.target, 1001, ((MenuItem)WMenuItemPeer.this.target).getActionCommand(), l, n));
            }
        });
    }

    static Font getDefaultFont() {
        return defaultMenuFont;
    }

    private static native void initIDs();

    public void setFont(Font font) {
    }

    static {
        WMenuItemPeer.initIDs();
        defaultMenuFont = (Font)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle("sun.awt.windows.awtLocalization");
                    return Font.decode(resourceBundle.getString("menuFont"));
                }
                catch (MissingResourceException missingResourceException) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "WMenuItemPeer: " + missingResourceException.getMessage() + ". Using default MenuItem font.", missingResourceException);
                    }
                    return new Font("SanSerif", 0, 11);
                }
            }
        });
    }
}

