/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.d3d;

import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.awt.geom.RoundRectangle2D;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.d3d.D3DContext;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.pipe.LoopPipe;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.ShapeSpanIterator;
import sun.java2d.pipe.SpanIterator;
import sun.java2d.windows.DDRenderer;

public class D3DRenderer
extends DDRenderer {
    native boolean doDrawLineD3D(long var1, long var3, int var5, int var6, int var7, int var8);

    native boolean doDrawRectD3D(long var1, long var3, int var5, int var6, int var7, int var8);

    native boolean doFillRectD3D(long var1, long var3, int var5, int var6, int var7, int var8);

    native void doDrawPoly(long var1, long var3, int var5, int var6, int[] var7, int[] var8, int var9, boolean var10);

    native void devFillSpans(long var1, long var3, SpanIterator var5, long var6, int var8, int var9);

    private long getContext(SunGraphics2D sunGraphics2D) {
        AffineTransform affineTransform = sunGraphics2D.transformState < 3 ? null : sunGraphics2D.transform;
        int n = sunGraphics2D.eargb >>> 24 == 255 ? 1 : 0;
        return D3DContext.getContext(null, sunGraphics2D.surfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.getComposite(), affineTransform, sunGraphics2D.eargb, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLine(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        Object object = D3DContext.LOCK;
        synchronized (object) {
            this.doDrawLineD3D(sunGraphics2D.surfaceData.getNativeOps(), this.getContext(sunGraphics2D), n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3 + sunGraphics2D.transX, n4 + sunGraphics2D.transY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        Object object = D3DContext.LOCK;
        synchronized (object) {
            this.doFillRectD3D(sunGraphics2D.surfaceData.getNativeOps(), this.getContext(sunGraphics2D), sunGraphics2D.transX + n, sunGraphics2D.transY + n2, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        Object object = D3DContext.LOCK;
        synchronized (object) {
            this.doDrawRectD3D(sunGraphics2D.surfaceData.getNativeOps(), this.getContext(sunGraphics2D), n + sunGraphics2D.transX, sunGraphics2D.transY + n2, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPolyline(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        Object object = D3DContext.LOCK;
        synchronized (object) {
            this.doDrawPoly(sunGraphics2D.surfaceData.getNativeOps(), this.getContext(sunGraphics2D), sunGraphics2D.transX, sunGraphics2D.transY, nArray, nArray2, n, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        Object object = D3DContext.LOCK;
        synchronized (object) {
            this.doDrawPoly(sunGraphics2D.surfaceData.getNativeOps(), this.getContext(sunGraphics2D), sunGraphics2D.transX, sunGraphics2D.transY, nArray, nArray2, n, true);
        }
    }

    public void drawRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(sunGraphics2D, new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6));
    }

    public void drawOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.draw(sunGraphics2D, new Ellipse2D.Float(n, n2, n3, n4));
    }

    public void drawArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(sunGraphics2D, new Arc2D.Float(n, n2, n3, n4, n5, n6, 0));
    }

    public void fillRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(sunGraphics2D, new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6));
    }

    public void fillOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.fill(sunGraphics2D, new Ellipse2D.Float(n, n2, n3, n4));
    }

    public void fillArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(sunGraphics2D, new Arc2D.Float(n, n2, n3, n4, n5, n6, 2));
    }

    public void fillPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        this.fill(sunGraphics2D, new Polygon(nArray, nArray2, n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(SunGraphics2D sunGraphics2D, Shape shape) {
        block19: {
            if (sunGraphics2D.strokeState == 0) {
                if (shape instanceof Polygon) {
                    Polygon polygon = (Polygon)shape;
                    this.drawPolygon(sunGraphics2D, polygon.xpoints, polygon.ypoints, polygon.npoints);
                    return;
                }
                PathIterator pathIterator = shape.getPathIterator(null, 0.5);
                Polygon polygon = new Polygon();
                float[] fArray = new float[2];
                while (!pathIterator.isDone()) {
                    switch (pathIterator.currentSegment(fArray)) {
                        case 0: {
                            if (polygon.npoints > 1) {
                                this.drawPolyline(sunGraphics2D, polygon.xpoints, polygon.ypoints, polygon.npoints);
                            }
                            polygon.reset();
                            polygon.addPoint((int)Math.floor(fArray[0]), (int)Math.floor(fArray[1]));
                            break;
                        }
                        case 1: {
                            if (polygon.npoints == 0) {
                                throw new IllegalPathStateException("missing initial moveto in path definition");
                            }
                            polygon.addPoint((int)Math.floor(fArray[0]), (int)Math.floor(fArray[1]));
                            break;
                        }
                        case 4: {
                            if (polygon.npoints <= 0) break;
                            polygon.addPoint(polygon.xpoints[0], polygon.ypoints[0]);
                            break;
                        }
                        default: {
                            throw new IllegalPathStateException("path not flattened");
                        }
                    }
                    pathIterator.next();
                }
                if (polygon.npoints > 1) {
                    this.drawPolyline(sunGraphics2D, polygon.xpoints, polygon.ypoints, polygon.npoints);
                }
            } else {
                if (sunGraphics2D.strokeState < 3) {
                    ShapeSpanIterator shapeSpanIterator = LoopPipe.getStrokeSpans(sunGraphics2D, shape);
                    try {
                        Object object = D3DContext.LOCK;
                        synchronized (object) {
                            int n = sunGraphics2D.eargb >>> 24 == 255 ? 1 : 0;
                            long l = D3DContext.getContext(null, sunGraphics2D.surfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.getComposite(), null, sunGraphics2D.eargb, n);
                            this.devFillSpans(sunGraphics2D.surfaceData.getNativeOps(), l, shapeSpanIterator, shapeSpanIterator.getNativeIterator(), 0, 0);
                            break block19;
                        }
                    }
                    finally {
                        shapeSpanIterator.dispose();
                    }
                }
                this.fill(sunGraphics2D, sunGraphics2D.stroke.createStrokedShape(shape));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fill(SunGraphics2D sunGraphics2D, Shape shape) {
        int n;
        int n2;
        AffineTransform affineTransform;
        if (sunGraphics2D.transformState < 3) {
            affineTransform = null;
            n2 = sunGraphics2D.transX;
            n = sunGraphics2D.transY;
        } else {
            affineTransform = sunGraphics2D.transform;
            n = 0;
            n2 = 0;
        }
        ShapeSpanIterator shapeSpanIterator = LoopPipe.getFillSSI(sunGraphics2D);
        try {
            Region region = sunGraphics2D.getCompClip();
            shapeSpanIterator.setOutputAreaXYXY(region.getLoX() - n2, region.getLoY() - n, region.getHiX() - n2, region.getHiY() - n);
            shapeSpanIterator.appendPath(shape.getPathIterator(affineTransform));
            Object object = D3DContext.LOCK;
            synchronized (object) {
                int n3 = sunGraphics2D.eargb >>> 24 == 255 ? 1 : 0;
                long l = D3DContext.getContext(null, sunGraphics2D.surfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.getComposite(), null, sunGraphics2D.eargb, n3);
                this.devFillSpans(sunGraphics2D.surfaceData.getNativeOps(), l, shapeSpanIterator, shapeSpanIterator.getNativeIterator(), n2, n);
            }
        }
        finally {
            shapeSpanIterator.dispose();
        }
    }

    D3DRenderer traceWrapD3D() {
        return new Tracer();
    }

    private class Tracer
    extends D3DRenderer {
        private Tracer() {
        }

        public void drawLine(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
            GraphicsPrimitive.tracePrimitive("D3DDrawLine");
            super.drawLine(sunGraphics2D, n, n2, n3, n4);
        }

        public void drawRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
            GraphicsPrimitive.tracePrimitive("D3DDrawRect");
            super.drawRect(sunGraphics2D, n, n2, n3, n4);
        }

        public void drawPolyline(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
            GraphicsPrimitive.tracePrimitive("D3DDrawPolyline");
            super.drawPolyline(sunGraphics2D, nArray, nArray2, n);
        }

        public void drawPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
            GraphicsPrimitive.tracePrimitive("D3DDrawPolygon");
            super.drawPolygon(sunGraphics2D, nArray, nArray2, n);
        }

        public void fillRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
            GraphicsPrimitive.tracePrimitive("D3DFillRect");
            super.fillRect(sunGraphics2D, n, n2, n3, n4);
        }

        void devFillSpans(long l, long l2, SpanIterator spanIterator, long l3, int n, int n2) {
            GraphicsPrimitive.tracePrimitive("D3DFillSpans");
            super.devFillSpans(l, l2, spanIterator, l3, n, n2);
        }

        public void devCopyArea(SurfaceData surfaceData, int n, int n2, int n3, int n4, int n5, int n6) {
            GraphicsPrimitive.tracePrimitive("DXCopyArea");
            super.devCopyArea(surfaceData, n, n2, n3, n4, n5, n6);
        }
    }
}

