/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pisces;

import java.io.PrintStream;

public final class PiscesCache {
    int bboxX0;
    int bboxY0;
    int bboxX1;
    int bboxY1;
    byte[] rowAARLE;
    int alphaRLELength;
    int[] rowOffsetsRLE;
    int[] minTouched;
    int alphaRows;
    private static final float ROWAA_RLE_FACTOR = 1.5f;
    private static final float TOUCHED_FACTOR = 1.5f;
    private static final int MIN_TOUCHED_LEN = 64;

    private PiscesCache() {
    }

    public static PiscesCache createInstance() {
        return new PiscesCache();
    }

    private void reallocRowAARLE(int n) {
        if (this.rowAARLE == null) {
            this.rowAARLE = new byte[n];
        } else if (this.rowAARLE.length < n) {
            int n2 = Math.max(n, (int)((float)this.rowAARLE.length * 1.5f));
            byte[] byArray = new byte[n2];
            System.arraycopy(this.rowAARLE, 0, byArray, 0, this.rowAARLE.length);
            this.rowAARLE = byArray;
        }
    }

    private void reallocRowInfo(int n) {
        if (this.minTouched == null) {
            int n2 = Math.max(n, 64);
            this.minTouched = new int[n2];
            this.rowOffsetsRLE = new int[n2];
        } else if (this.minTouched.length < n) {
            int n3 = Math.max(n, (int)((float)this.minTouched.length * 1.5f));
            int[] nArray = new int[n3];
            int[] nArray2 = new int[n3];
            System.arraycopy(this.minTouched, 0, nArray, 0, this.alphaRows);
            System.arraycopy(this.rowOffsetsRLE, 0, nArray2, 0, this.alphaRows);
            this.minTouched = nArray;
            this.rowOffsetsRLE = nArray2;
        }
    }

    void addRLERun(byte by, int n) {
        this.reallocRowAARLE(this.alphaRLELength + 2);
        this.rowAARLE[this.alphaRLELength++] = by;
        this.rowAARLE[this.alphaRLELength++] = (byte)n;
    }

    void startRow(int n, int n2, int n3) {
        if (this.alphaRows == 0) {
            this.bboxY0 = n;
            this.bboxY1 = n + 1;
            this.bboxX0 = n2;
            this.bboxX1 = n3 + 1;
        } else {
            if (this.bboxX0 > n2) {
                this.bboxX0 = n2;
            }
            if (this.bboxX1 < n3 + 1) {
                this.bboxX1 = n3 + 1;
            }
            while (this.bboxY1++ < n) {
                this.reallocRowInfo(this.alphaRows + 1);
                this.minTouched[this.alphaRows] = 0;
                this.rowOffsetsRLE[this.alphaRows] = this.alphaRLELength - 2;
                ++this.alphaRows;
            }
        }
        this.reallocRowInfo(this.alphaRows + 1);
        this.minTouched[this.alphaRows] = n2;
        this.rowOffsetsRLE[this.alphaRows] = this.alphaRLELength;
        ++this.alphaRows;
    }

    public synchronized void dispose() {
        this.rowAARLE = null;
        this.alphaRLELength = 0;
        this.minTouched = null;
        this.rowOffsetsRLE = null;
        this.alphaRows = 0;
        this.bboxY1 = 0;
        this.bboxX1 = 0;
        this.bboxY0 = 0;
        this.bboxX0 = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            int n;
            printStream.println("bbox = [" + this.bboxX0 + ", " + this.bboxY0 + " => " + this.bboxX1 + ", " + this.bboxY1 + "]");
            printStream.println("alphRLELength = " + this.alphaRLELength);
            for (n = this.bboxY0; n < this.bboxY1; ++n) {
                int n2 = n - this.bboxY0;
                printStream.println("row[" + n2 + "] == {" + "minX = " + this.minTouched[n2] + ", off = " + this.rowOffsetsRLE[n2] + "}");
            }
            for (n = 0; n < this.alphaRLELength; n += 2) {
                printStream.println("rle[" + n + "] = " + (this.rowAARLE[n + 1] & 0xFF) + " of " + (this.rowAARLE[n] & 0xFF));
            }
        }
    }
}

