/* CASSAMP2 2.0               */

/* This command file illustrates the use of the /S2 parameter on SEMAINT     */
/* in relation to the installation of a Service Pak other than an OS/2       */
/* Service Pak.                                                              */

/* Specifically, this command file installs OS/2 2.1, an OS/2 2.1 Service    */
/* Pak, LS 3.0, and an LS 3.0 Service Pak in that order.                     */

/* It is important to note the following program definitions:                */
/*                                                                           */
/* OS/2 2.1 Maintenance A and LAPS Maintenance                               */
/* SEMAINT - x.n.statevar is set to ''.  This is done because these          */
/*   and     definitions of SEMAINT and MPTS are run more than once in this  */
/* MPTS.EXE  scenario.  If these definitions of SEMAINT and MPTS.EXE are     */
/*           given state variables, they would not run the second time they  */
/*           they are called.                                                */

/* OS/2 2.1 Maintenance B                                                    */
/* SEMAINT - The /S2 parameter was provided to apply service pak fixes to    */
/*           the maintenance system being created so that the system will    */
/*           boot properly after FSERVICE applies service to LS 3.0.         */

/* OS/2 2.1 Service Pak XR06200 and LS 3.0 Service pak IP07045               */
/* FSERVICE - The /t: parameter was provided to this program in both         */
/*            definitions since both will need to restore backups of         */
/*            CONFIG.SYS and STARTUP.CMD.  They will both also need to       */
/*            request a callback in order to clean up the service directory. */

/*---------------------------------------------------*/
/*         DO NOT MODIFY THE NEXT EIGHT LINES        */
/*---------------------------------------------------*/

parse ARG client logfile additional

QUEUE_REBOOT = 0
CALL_AGAIN = 0

Call AddDLLFunctions

x.0.instprog = ''
x.0.rspdir   = ''
x.0.statevar = 'CAS_STATE'
x.0.default  = ''


/*---------------------------------------------------*/
/*             MODIFICATIONS START HERE              */
/*---------------------------------------------------*/


/*****************************************************/
/*                 SRVATTCH SECTION                  */
/*****************************************************/

/* 'SRVATTCH z: \\SERVER1\ALIAS' */                             /* Additional SRVATTCHs can be placed here*/

/* 'SRVATTCH x: SERVER2'         */                             /* They can be placed before specific     */
                                                                /* RunInstall statements too if you only  */
                                                                /* want to attach to a special server     */
                                                                /* right before a specific install.       */

/*****************************************************/
/*                 VARIABLES SECTION                 */
/*****************************************************/

/*---------------------------------------------------*/
/*         DO NOT REMOVE THE NEXT FIVE LINES         */
/*              (They may be modified)               */
/*---------------------------------------------------*/

bootdrive = 'c:'                                                /* Boot Drive                             */
configsys = bootdrive || '\CONFIG.SYS'                          /* Fully qualified path to CONFIG.SYS     */
maintdir  = bootdrive || '\SERVICE'                             /* Maintenance directory, refrenced by    */
                                                                /*   SEMAINT, SEINST, LAPS, and FSERVICE. */
exepath   = 'X:\EXE\V210'                                       /* Path to executable directory on server */
dllpath   = 'X:\DLL\V210'                                       /* Paths to the DLL directories on server */

/*---------------------------------------------------*/
/* The next four lines are included to make it       */
/* easier to change the version of OS/2 2.x that is  */
/* to be installed.                                  */
/*                                                   */
/* These variables are referenced in the product     */
/* data sections for SEINST and SEMAINT.             */
/*---------------------------------------------------*/

os2dir  = 'OS2V21'                                              /* Name of OS/2 2.1 directories         */
os2img  = 'X:\IMG\' || os2dir                                   /* - product image directory            */
os2rsp  = 'X:\RSP\' || os2dir                                   /* - response file directory            */
os2log  = 'X:\LOG\' || os2dir                                   /* - log file directory                 */


/*****************************************************/
/*               PRODUCT DATA SECTION                */
/*****************************************************/

x.seinst = 1                                                    /* structure index                      */
x.1.name='OS/2 2.1'                                             /* product name                         */
x.1.statevar = 'CAS_' || x.1.name                               /* state variable name                  */
x.1.instprog = EXEPATH'\seinst',                                /* fully qualified install program name */
               ' /b:'BOOTDRIVE,                                 /* - bootdrive                          */
               ' /s:'OS2IMG,                                    /* - source directory                   */
               ' /t:'MAINTDIR,                                  /* - service directory                  */
               '/l1:'OS2LOG'\'client'.log',                     /* - log file                           */
               ' /r:'                                           /* - response file flag (auto selection)*/
x.1.rspdir   = OS2RSP                                           /* response file directory              */
x.1.default  = 'minfmat.rsp'                                    /* default response file name           */

x.semaintA = 2                                                  /* structure index                      */
x.2.name='OS/2 2.1 Maintenance A'                               /* product name                         */
x.2.statevar = ''                                               /* state variable name                  */
x.2.instprog = EXEPATH'\semaint',                               /* fully qualified install program name */
                ' /s:'OS2IMG,                                   /* - source directory                   */
                ' /t:'MAINTDIR,                                 /* - target directory                   */
                ' /b:'BOOTDRIVE,                                /* - target boot drive (not necessarily current) */
                '/l1:'OS2LOG'\'client'.log'                     /* - log file                           */
x.2.rspdir   = ''                                               /* no auto selection                    */
x.2.default  = ''

x.semaintB = 3                                                  /* structure index                      */
x.3.name='OS/2 2.1 Maintenance B'                               /* product name                         */
x.3.statevar = 'CAS_' || x.3.name                               /* state variable name                  */
x.3.instprog = EXEPATH'\semaint',                               /* fully qualified install program name */
                ' /s:'OS2IMG,                                   /* - source directory                   */
                ' /s2:x:\csd\os2v21\xr06200',                   /* - OS/2 service pak directory         */
                ' /t:'MAINTDIR,                                 /* - target directory                   */
                ' /b:'BOOTDRIVE,                                /* - target boot drive (not necessarily current) */
                '/l1:'OS2LOG'\'CLIENT'.log'                     /* - log file                           */
x.3.rspdir   = ''                                               /* no auto selection                    */
x.3.default  = ''

x.laps_prep = 4                                                 /* structure index                      */
x.4.name='LAPS Maintnenace'                                     /* product name                         */
x.4.statevar = ''                                               /* state variable name                  */
x.4.instprog = 'x:\img\laps\mpts',                              /* fully qualified install program name */
                ' /e:prep',                                     /* - prep installation                  */
                ' /s:x:\img\laps',                              /* - source directory                   */
                ' /t:'MAINTDIR,                                 /* - target directory                   */
                '/tu:'BOOTDRIVE,                                /* - location of config.sys             */
                '/l1:x:\log\laps\'client'.log',                 /* - log file                           */
                ' /r:x:\rsp\laps\lapsrsp.rsp'                   /* - response file                      */
x.4.rspdir   = ''                                               /* no auto selection                    */
x.4.default  = ''

x.laps = 5                                                      /* structure index                      */
x.5.name='LAPS'                                                 /* product name                         */
x.5.statevar = 'CAS_' || x.5.name                               /* state variable name                  */
x.5.instprog = 'x:\img\laps\mpts',                              /* fully qualified install program name */
               ' /e:maint',                                     /* - maintenance installation           */
               ' /s:x:\img\laps',                               /* - source directory                   */
               ' /t:'BOOTDRIVE'\',                              /* - target directory                   */
               '/l1:x:\log\laps\'client'.log',                  /* - log file                           */
               ' /r:'                                           /* - response file flag (auto selection)*/
x.5.rspdir   = 'x:\rsp\laps'                                    /* response file directory              */
x.5.default  = 'lapsrsp.rsp'                                    /* default response file name           */

x.laninstr = 6                                                  /* structure index                      */
x.6.name='LAN Services 3.0'                                     /* product name                         */
x.6.statevar = 'CAS_' || x.6.name                               /* state variable name                  */
x.6.instprog = 'x:\img\ls30\laninstr',                          /* fully qualified install program name */
               ' /req',                                         /* - install a requester                */
               ' /l1:x:\log\ls30\'client'.l1',                  /* - error log file                     */
               ' /l2:x:\log\ls30\'client'.l2',                  /* - history log file                   */
               ' /r:'                                           /* - response file flag (auto selection)*/
x.6.rspdir   = 'x:\rsp\ls30'                                    /* response file directory              */
x.6.default  = 'req.rsp'                                        /* default response file name           */

x.thinifs = 7                                                   /* structure index                      */
x.7.name='SRVIFS Requester'                                     /* product name                         */
x.7.statevar = ''                                               /* state variable name                  */
x.7.instprog = 'x:\img\srvifs\thinifs',                         /* fully qualified install program name */
               '  /s:x:\img\srvifs',                            /* - source directory                   */
               '  /t:'BOOTDRIVE'\srvifsrq',                     /* - target directory                   */
               ' /tu:'BOOTDRIVE'\',                             /* - config.sys location                */
               ' /l1:x:\log\srvifs\'client'.log',               /* - log file                           */
               ' /req:*',                                       /* - random requester name              */
               ' /srv:server1',                                 /* - server name                        */
               ' /d:x'                                          /* - remote drive identifier            */
x.7.rspdir   = ''                                               /* no auto selection                    */
x.7.default  = ''

x.ifsdel = 8                                                    /* structure index                      */
x.8.name='SRVIFS Delete'                                        /* product name                         */
x.8.statevar = ''                                               /* state variable name                  */
x.8.instprog = 'x:\img\srvifs\ifsdel',                          /* fully qualified install program name */
               ' /t:'BOOTDRIVE'\srvifsrq',                      /* - target directory                   */
               '/tu:'BOOTDRIVE                                  /* - config.sys location                */
x.8.rspdir   = ''                                               /* no auto selection                    */
x.8.default  = ''

x.casinstl = 9                                                  /* structure index                               */
x.9.name='LAN CID Utility'                                      /* product name                                  */
x.9.statevar = ''                                               /* state variable name                           */
x.9.instprog = 'x:\img\lcu\casinstl',                           /* fully qualified install program name          */
               ' /cmd:x:\client',                               /* - location of .cmd files (passed to casagent) */
               ' /tu:'BOOTDRIVE,                                /* - config.sys location (boot drive)            */
               ' /pl:'DLLPATH,                                  /* - string to add to libpath                    */
               ' /pa:x:\img\lcu',                               /* - workstation's path to LCU code on server    */
               ' /l1:x:\log\lcu\'client'.log',                  /* - CASINSTL log file                           */
               ' /l2:x:\log\lcu\SRVIFS_REQ.log',                /* - CASAGENT log file                           */
               ' /req:'client                                   /* - LCU client name                             */
x.9.rspdir   = ''                                               /* no auto selection                             */
x.9.default  = ''

x.casdelet = 10                                                 /* structure index                      */
x.10.name='LAN CID Utility Delete'                              /* product name                         */
x.10.statevar = ''                                              /* state variable name                  */
x.10.instprog = 'x:\img\lcu\casdelet',                          /* fully qualified install program name */
                '/pl:'DLLPATH,                                  /* - string to delete from libpath      */
                '/tu:'BOOTDRIVE                                 /* - config.sys location (boot drive)   */
x.10.rspdir   = ''                                              /* no auto selection                    */
x.10.default  = ''

x.os221csd = 11                                                 /* structure index                      */
x.11.name='OS/2 2.1 Service Pak XR06200'                        /* product name                         */
x.11.statevar = 'CAS_' || x.11.name                             /* state variable name                  */
x.11.instprog = 'x:\csd\os2v21\xr06200\fservice',               /* fully qualified install program name */
               ' /t:'MAINTDIR,                                  /* - service directory                  */
               ' /s:x:\csd\os2v21\xr06200',                     /* - source directory                   */
               ' /l1:x:\log\csd\os2v21\'client'.log',           /* - error log file                     */
               ' /r:'                                           /* - response file flag (auto selection)*/
x.11.rspdir   = 'x:\rsp\csd\os2v21'                             /* response file directory              */
x.11.default  = 'default.rsp'                                   /* default response file name           */

x.ls30csd = 12                                                  /* structure index                      */
x.12.name='LAN Services 3.0 Service Pak IP07045'                /* product name                         */
x.12.statevar = 'CAS_' || x.12.name                             /* state variable name                  */
x.12.instprog = 'x:\csd\ls30\ip07045\fservice',                 /* fully qualified install program name */
               ' /t:'MAINTDIR,                                  /* - service directory                  */
               ' /s:x:\csd\ls30\ip07045',                       /* - source directory                   */
               ' /l1:x:\log\csd\ls30\'client'.log',             /* - error log file                     */
               ' /r:'                                           /* - response file flag (auto selection)*/
x.12.rspdir   = 'x:\rsp\csd\ls30'                               /* response file directory              */
x.12.default  = 'default.rsp'                                   /* default response file name           */

/*---------------------------------------------------*/
/*         NUMBER OF PROGRAMS SET UP IN THE          */
/*               PRODUCT DATA SECTION                */
/*---------------------------------------------------*/

NUM_INSTALL_PROGS = 12


/*---------------------------------------------------*/
/*       DO NOT MODIFY OR REMOVE THE NEXT LINE       */
/*---------------------------------------------------*/

OVERALL_STATE = GetEnvironmentVars()


/*****************************************************/
/*                  INSTALL SECTION                  */
/*****************************************************/

Do Forever
  Select
    when OVERALL_STATE = 0 then do
      if BootDriveIsDiskette()   == YES    then iterate         /* Check if booted from diskette*/
                                                                /*  if it was, then goto state 1*/
      if RunInstall(x.semaintA)  == BAD_RC then exit            /* Install maintenance system   */
      if RunInstall(x.laps_prep) == BAD_RC then exit            /* Install LAPS prep system     */
      if RunInstall(x.thinifs)   == BAD_RC then exit            /* Install SRVIFS requester     */
      if RunInstall(x.casinstl)  == BAD_RC then exit            /* Install LCU                  */
      Call CheckBoot                                            /* Reboot if it was requested   */
    end
    when OVERALL_STATE = 1 then do
      if RunInstall(x.seinst)   == BAD_RC then exit             /* Install operating system     */
      if RunInstall(x.laps)     == BAD_RC then exit             /* Install LAPS                 */
      if RunInstall(x.thinifs)  == BAD_RC then exit             /* Install SRVIFS requester     */
      if RunInstall(x.casinstl) == BAD_RC then exit             /* Install LCU                  */
      Call CheckBoot                                            /* Reboot if it was requested   */
    end
    when OVERALL_STATE = 2 then do
      if RunInstall(x.semaintA)  == BAD_RC then exit            /* Install maintenance system   */
      if RunInstall(x.laps_prep) == BAD_RC then exit            /* Install LAPS prep system     */
      if RunInstall(x.thinifs)   == BAD_RC then exit            /* Install SRVIFS requester     */
      if RunInstall(x.casinstl)  == BAD_RC then exit            /* Install LCU                  */
      Call CheckBoot                                            /* Reboot if it was requested   */
    end
    when OVERALL_STATE = 3 then do
      if RunInstall(x.os221csd) == BAD_RC then exit             /* Install OS/2 Service Pak     */
      Call CheckBoot
    end
    when OVERALL_STATE = 4 then do
      if RunInstall(x.laninstr) == BAD_RC then exit             /* Install LS                   */
      Call CheckBoot                                            /* Reboot if it was requested   */
    end
    when OVERALL_STATE = 5 then do
      if RunInstall(x.semaintB)  == BAD_RC then exit            /* Install maintenance system   */
      if RunInstall(x.laps_prep) == BAD_RC then exit            /* Install LAPS prep system     */
      if RunInstall(x.thinifs)   == BAD_RC then exit            /* Install SRVIFS requester     */
      if RunInstall(x.casinstl)  == BAD_RC then exit            /* Install LCU                  */
      Call CheckBoot                                            /* Reboot if it was requested   */
    end
    when OVERALL_STATE = 6 then do
      if RunInstall(x.ls30csd)  == BAD_RC then exit             /* Install LS Service Pak       */
      Call CheckBoot                                            /* Reboot if it was requested   */
    end
    when OVERALL_STATE = 7 then do
      if RunInstall(x.ifsdel)   == BAD_RC then exit             /* Delete SRVIFS requester      */
      if RunInstall(x.casdelet) == BAD_RC then exit             /* Delete LCU                   */
      Call Reboot                                               /* Reboot                       */
    end
  end
end
exit


/*************************************************************/
/*         DO NOT MODIFY ANY CODE BELOW THIS LINE !!!        */
/*************************************************************/

RunInstall: procedure expose x. queue_reboot call_again configsys logfile client OVERALL_STATE
  parse arg index, new_state, other
  install = SetEnvironmentVar(x.index.statevar)
  if install == YES then do
    state = value('REMOTE_INSTALL_STATE',,'OS2ENVIRONMENT')     /* check   REMOTE_INSTALL_STATE */
    if state <> 0 then
      rc2 = LogMessage(75, x.index.name, state, logfile)        /* log an install starting msg  */
    else
      rc2 = LogMessage(72, x.index.name, '', logfile)           /* log an install starting msg  */

    install_prog = 'CMD /C ' || strip(x.index.instprog)         /* build the command string     */

                                                /* If automatic responst file selection was     */
                                                /* indicated, then get the response file name   */
                                                /* and append it to the command string.         */
    if x.index.default <> '' then do
      response_file = DetermineResponseFile(x.index.rspdir, client,
                                            , x.index.default, x.index.name,
                                            , logfile)
      if response_file == '' then exit
      install_prog = install_prog || response_file
    end

    install_prog                                                /* Execute the install program  */

    state = value(x.index.statevar,,'OS2ENVIRONMENT')           /* Get the current install state*/
                                                                /* for this install program from*/
                                                                /* the environment.             */

                                                /* Check the return code and set the global     */
                                                /* variables accordingly.                       */

    parse value ProcessReturnCode(rc, state, QUEUE_REBOOT, CALL_AGAIN, logfile),
           with rc ',' state ',' QUEUE_REBOOT ',' CALL_AGAIN

    rc2 = value(x.index.statevar, state, 'OS2ENVIRONMENT')      /* Set the new install state for*/
                                                                /* this install program.        */

                                                /* Put the install state into the CONFIG.SYS,   */
                                                /* if this action was unsuccessful, then exit.  */

    if PutStateVar(x.index.statevar, state, configsys, logfile) <> 0 then exit

    if rc == GOOD_RC then do
      if pos('\SEMAINT', translate(install_prog)) <> 0 then     /* If the install program was   */
        Call PreserveStartupCmd(install_prog)                   /* SEMAINT, then make sure      */
                                                                /* STARTUP.CMD won't be copied  */
                                                                /* over when SEINST runs.       */

      rc2 = LogMessage(70, x.index.name, '', logfile)           /* log an install successful msg*/
      return GOOD_RC                                            /* return a good return code    */
    end

    else do
      rc2 = LogMessage(71, x.index.name, '', logfile)           /* log an install failed msg    */
      if (new_state <> '') then                                 /* If a new state was requested,*/
                                                                /* then set OVERALL_STATE to the*/
        rc2 = SetState(new_state, 'RunInstall', 2)              /* new state.                   */

      return BAD_RC                                             /* return a bad return code     */
    end
  end
  return GOOD_RC


/*************************************************************/
PreserveStartupCmd: procedure

  parse upper arg string, other

  if pos('/T:', string) <> 0 then                               /* Determine if there is a      */
    findvalue = '/T:'                                           /* target parameter.  If there  */
  else                                                          /* is none, return.             */
    if pos('-T:',string) <> 0 then
      findvalue = '-T:'
    else
      return 0

  remain = substr(string, pos(findvalue, string) + 3)           /* Get the value of the target  */
                                                                /* parameter.                   */
  blank = pos(' ', remain)

  if (blank <> 0) then
    param = substr(remain, 1, blank-1)
  else
    param = remain
                                                /* Erase startup.lcu in the target directory,  */
                                                /* then rename startup.s13 to startup.lcu      */

  'if exist ' param || '\startup.lcu erase  ' param || '\startup.lcu'
  'if exist ' param || '\startup.s13 rename ' param || '\startup.s13 *.lcu'

  return 0

/*************************************************************/
GetEnvironmentVars: procedure expose X. NUM_INSTALL_PROGS


  OVERALL_STATE = value(x.0.statevar,,'OS2ENVIRONMENT')         /* Get the overall install state */
                                                                /* from the environment.         */

  if OVERALL_STATE == '' then do                                /* If the overall install state  */
    OVERALL_STATE = 0                                           /* has not been set yet, reset   */
    do I=0 to NUM_INSTALL_PROGS by 1                            /* all the state vars to 0.      */
      if x.I.statevar <> '' then
        rc = value(x.I.statevar,'0','OS2ENVIRONMENT')
    end
  end

  return OVERALL_STATE


/*************************************************************/
SetEnvironmentVar: procedure
  parse arg env_string, other
  if env_string == '' then do                                   /* If the install program has   */
                                                                /* no state variable, then ...  */

    rc = value('REMOTE_INSTALL_STATE','0','OS2ENVIRONMENT')     /* Set the REMOTE_INSTALL_STATE */
                                                                /* to 0 so that the program     */
                                                                /* being run can know that is   */
                                                                /* being run in an unattended   */
                                                                /* environment.                 */

    return YES                                                  /* return install=yes           */

  end

  state = value(env_string,,'OS2ENVIRONMENT')                   /* Otherwise, get the value of  */
                                                                /* the state variable from the  */
                                                                /* environment.                 */

  if state <> '' then do                                        /* If the state variable exists */

    rc = value('REMOTE_INSTALL_STATE',state,'OS2ENVIRONMENT')   /* Set the REMOTE_INSTALL_STATE */
                                                                /* environment variable to the  */
                                                                /* value of the state variable. */

    return YES                                                  /* return install=yes           */
  end
  else                                                          /* Otherwise,                   */
    return NO                                                   /* return install=no            */


/*************************************************************/
BootDriveIsDiskette:

  if IsBootDriveRemovable() == 1 then do                        /* If the drive booted from is  */
                                                                /* a diskette drive, then set   */
    rc2 = SetState(OVERALL_STATE+1)                             /* the OVERALL_STATE to the     */
                                                                /* requested value.             */
    return 'YES'

  end

  else                                                          /* else the machine was booted  */
                                                                /* from the hardfile.           */
    return 'NO'

/*************************************************************/
BootDriveIsFixedDisk:

  if IsBootDriveRemovable() == 0 then do                        /* If the drive booted from is  */
                                                                /* a fixed disk, then set       */
    rc2 = SetState(OVERALL_STATE+1)                             /* the OVERALL_STATE to the     */
                                                                /* requested value.             */
    return 'YES'

  end

  else                                                          /* else the machine was booted  */
                                                                /* from a diskette.             */
    return 'NO'

/*************************************************************/
SetState:
  parse arg new_state, proc_name, param_num, other

    if datatype(new_state, number) <> 1 then do                 /* If the new state requested is*/
                                                                /* not numeric, then log an     */
      if proc_name <> '' then                                   /* error.                       */
        LogMessage(63, proc_name, param_num, logfile)
      else
        LogMessage(63, 'SetState', 1, logfile)

      exit
    end

    OVERALL_STATE = new_state                                   /* Set the OVERALL_STATE to the */
                                                                /* new state requested.         */

    rc = value(x.0.statevar, new_state, 'OS2ENVIRONMENT')       /* Save the OVERALL_STATE in the*/
                                                                /* environment.                 */
    return 'NO_ERROR'


/*************************************************************/
SaveStates:

  do I=0 to NUM_INSTALL_PROGS by 1            /* Put the install states into the CONFIG.SYS,  */
    if x.I.statevar <> '' then                /* if this action was unsuccessful, then exit.  */

      if PutStateVar(x.I.statevar, value(x.I.statevar,,'OS2ENVIRONMENT'),
                     , configsys, logfile) <> 0 then exit
  end

  return

/*************************************************************/
RebootAndGotoState:
  parse arg new_state, other

  rc2 = SetState(new_state, 'RebootAndGotoState', 1)           /* Set the state to go to in    */
                                                               /* OVERALL_STATE.               */

  Call SaveStates                                              /* Save the environment vars    */

  Call Reboot                                                  /* Reboot the machine           */

  return


/*************************************************************/
CheckBoot:
  if QUEUE_REBOOT <> 0 then do                                  /* If a reboot has been queued  */
                                                                /* by an install program ...    */

    if CALL_AGAIN == 0 then                                     /* If no install programs want  */
                                                                /* to be recalled ...           */

      rc = SetState(OVERALL_STATE+1)                            /* Increment the overall state  */
                                                                /* variable.                    */

    Call SaveStates                                             /* Save the environment vars    */

    Call Reboot                                                 /* Reboot the machine           */

  end

  else                                                          /* Otherwise, increment the     */
    rc = SetState(OVERALL_STATE+1)                              /* state variable and go on.    */

  return


/*************************************************************/
Reboot:
  bootdrive

  rc = value('OS2_SHELL', bootdrive || '\OS2\CMD.EXE', 'OS2ENVIRONMENT')
  rc = value('COMSPEC',   bootdrive || '\OS2\CMD.EXE', 'OS2ENVIRONMENT')

  'cls'
  rc = AskRemoveDiskIfFloppy()

  pathlen = length(exepath)                                     /* Get length of exepath        */
  posslash = lastpos("\",strip(exepath))                        /* Determine the last occurcnce */
                                                                /*   of '\' in exepath          */

  if posslash = pathlen then                                    /* If '\' is the last character */

    cmdline = exepath || 'SETBOOT /IBD:' || bootdrive           /* Then append 'SETBOOT'        */

  else

    cmdline = exepath || '\SETBOOT /IBD:' || bootdrive          /* Else append '\SETBOOT'       */

  LogMessage(74, '', '', logfile)                               /* Log a message indicating     */
                                                                /* reboot.                      */
  cmdline

  LogMessage(73, 'SETBOOT', '', logfile)                        /* If the code gets to here, the*/
                                                                /* reboot failed.  Log a message*/
  exit                                                          /* and exit.                    */

  return


/*************************************************************/
AddDLLFunctions:
  Call RxFuncAdd 'ProcessReturnCode',     'CASAGENT', 'PROCESSRETURNCODE'
  Call RxFuncAdd 'DetermineResponseFile', 'CASAGENT', 'DETERMINERESPONSEFILE'
  Call RxFuncAdd 'PutStateVar',           'CASAGENT', 'PUTSTATEVAR'
  Call RxFuncAdd 'LogMessage',            'CASAGENT', 'GETANDLOGMESSAGE'
  Call RxFuncAdd 'AskRemoveDiskIfFloppy', 'CASAGENT', 'ASKREMOVEDISKIFFLOPPY'
  Call RxFuncAdd 'IsBootDriveRemovable',  'CASAGENT', 'ISBOOTDRIVEREMOVABLE'
  Call RxFuncAdd 'GetOS2Version',         'CASAGENT', 'GETOS2VERSION'
  Call RxFuncAdd 'SetCIDType',            'CASAGENT', 'SETCIDTYPE'

  return
