/*********************************************************************/
/*                                                                   */
/* SNMP-DPI - SNMP Distributed Programming Interface                 */
/*                                                                   */
/*   May 1991 - Version 1.0  - SNMP-DPI Version 1.0 (RFC1228)        */
/*                             Created by IBM Research.              */
/*   Feb 1992 - Version 1.1  - Allow enterpriseID to be passed with  */
/*                             a (enterprise specific) trap          */
/*                           - allow multiple variables to be passed */
/*                           - Use 4 octets (INTEGER from RFC1157)   */
/*                             for generic and specific type.        */
/*                                                                   */
/* Copyright None                                                    */
/*                                                                   */
/* snmp_dpi.h   -  SNMP_DPI include file                             */
/*                                                                   */
/*********************************************************************/

/* SNMP_DPI codes from RFC 1228 */
#define SNMP_DPI_GET        1
#define SNMP_DPI_GET_NEXT   2
#define SNMP_DPI_SET        3
#define SNMP_DPI_TRAP       4
#define SNMP_DPI_RESPONSE   5
#define SNMP_DPI_REGISTER   6

#define SNMP_DPI_PROTOCOL   2
#define SNMP_DPI_VERSION    1
#define SNMP_DPI_RELEASE    1    /* enhancements to trap processing */

/* SNMP error codes from RFC 1157 (1098, 1067) */
#define SNMP_NO_ERROR       0
#define SNMP_TOO_BIG        1
#define SNMP_NO_SUCH_NAME   2
#define SNMP_BAD_VALUE      3
#define SNMP_READ_ONLY      4
#define SNMP_GEN_ERR        5

/* SNMP_DPI variable types from RFC 1228 */
#define SNMP_TYPE_TEXT      0       /* textual representation */
#define SNMP_TYPE_NUMBER    (128|1) /* number */
#define SNMP_TYPE_STRING    2       /* text string */
#define SNMP_TYPE_OBJECT    3       /* object identifier */
#define SNMP_TYPE_EMPTY     4       /* no value */
#define SNMP_TYPE_INTERNET  (128|5) /* internet address */
#define SNMP_TYPE_COUNTER   (128|6) /* counter */
#define SNMP_TYPE_GAUGE     (128|7) /* gauge */
#define SNMP_TYPE_TICKS     (128|8) /* time ticks (1/100ths second) */
#define SNMP_TYPE_MASK      0x7f    /* mask for type */

struct dpi_get_packet {
  char  *object_id;
};

struct dpi_next_packet {
  char  *object_id;
  char  *group_id;
};

struct dpi_set_packet {
  char                 *object_id;
  unsigned char         type;
  unsigned short        value_len;
  char                  *value;
  struct dpi_set_packet *next;
};

struct dpi_resp_packet {
  unsigned char            ret_code;
  struct dpi_set_packet   *ret_data;
};

struct dpi_trap_packet {
  long int                 generic;    /* long must be 4 bytes long */
  long int                 specific;
  struct dpi_set_packet   *info;
  char                    *enterprise;
};

struct snmp_dpi_hdr {
  unsigned char  proto_major;
  unsigned char  proto_minor;
  unsigned char  proto_release;

  unsigned char  packet_type;
  union {
     struct dpi_get_packet   *dpi_get;
     struct dpi_next_packet  *dpi_next;
     struct dpi_set_packet   *dpi_set;
     struct dpi_resp_packet  *dpi_response;
     struct dpi_trap_packet  *dpi_trap;
  } packet_body;
};

#if defined(_NO_PROTO)             /* prototypes for classic K&R C */

extern void                    DPIdebug();
extern struct snmp_dpi_hdr     *pDPIpacket();
extern void                     fDPIparse();
extern unsigned char           *mkMIBquery();
extern unsigned char           *mkDPIregister();
extern unsigned char           *mkDPIresponse();
extern unsigned char           *mkDPItrap();
extern unsigned char           *mkDPItrape();
extern struct dpi_set_packet   *mkDPIset();
extern struct dpi_set_packet   *mkDPIlist();

#else /* _NO_PROTO */              /* ANSI C/C++ prototypes */

#if defined(__cplusplus)           /* allow C++ to use ANSI C Headers */
extern "C" {
#endif /* __cplusplus */

void                    DPIdebug(int onoff);
struct snmp_dpi_hdr     *pDPIpacket(unsigned char *packet);
void                     fDPIparse(struct snmp_dpi_hdr *hdr);
unsigned char           *mkMIBquery(int cmd, char *oid_name,
                             char *group_oid, int type, int len,
                             char *value);
unsigned char           *mkDPIregister(char *oid_name);
unsigned char           *mkDPIresponse(int ret_code,
                             struct dpi_set_packet *value_list);
unsigned char           *mkDPItrap(int generic, int specific,
                             struct dpi_set_packet *value_list);
unsigned char           *mkDPItrape(long int generic, long int specific,
                             struct dpi_set_packet *value_list,
                             char *enterprise);
struct dpi_set_packet   *mkDPIset(char *oid_name, int type,
                             int len, void *value);

struct dpi_set_packet   *mkDPIlist(struct dpi_set_packet *packet,
                             char *oid_name, int type,
                             int len, void *value);

#if defined(__cplusplus)           /* close up the C++  scope */
}
#endif /* __cplusplus) */

#endif /* _NO_PROTO */
