/*--------------------------------------------------------------------------*/
/*                                                                          */
/*        OS/2 2.1 / WARP REX Driver for IBM TCP/IP version 2.0 / IAK       */
/*                                                                          */
/*                                ANNEX.CMD                                 */
/*                                                                          */
/*            ..................................................            */
/*                                                                          */
/* Sample attachment script for dialing into a Xylogics Annex terminal      */
/* server in order to establish a SLIP connection.  This script should be   */
/* specified on page 1 in the Login Script field for connections via SlipPM */
/* or using the -connect option if executing slip directly.                 */
/*                                                                          */
/*        NOTE: This file is supplied as a sample connection script, and    */
/*              does not constitute the endorsement of a particular         */
/*              Internet provider on the part of IBM.                       */
/*              Internet providers periodically change their connection     */
/*              procedures; please refer to the latest information provided */
/*              by the service provider.                                    */
/*                                                                          */
/*              This script may be modified to suit the needs of the user   */
/*              and is written to process dialogs similar to those          */
/*              used by many Annex type service providers.                  */
/*                                                                          */
/* The script parameters specify the command to send to the modem to dial   */
/* the remote site and the username/password combination to use to log into */
/* the terminal server.  If any of the parameters are omitted, or are       */
/* specified as an asterix (*), the script will prompt for them (Refer      */
/* to caveate below).  This is most useful with the password parameter to   */
/* avoid storing the password in a text file on the disk.                   */
/*                                                                          */
/* For example, the following might be used in SlipPM:                      */
/*              Login Script: annex.cmd atdt999-9999 loginid password       */
/*                                                                          */
/* which would then feed the "atdt999-9999" command to the modem, followed  */
/* by the login id and password once the connection is established.         */
/*                                                                          */
/* From slip directly the annex script supports:                            */
/*              -connect "annex.cmd atdt999-9999 loginid *"                 */
/*                                                                          */
/* which would cause annex.cmd to initially prompt for the password. It     */
/* would then feed the "atdt999-9999" command to the modem, and when the    */
/* Annex answered, it would use "loginid" as a username and the password    */
/* specified.                                                               */
/*                                                                          */
/* NOTE: You must pass the phone number, and both login id and password     */
/*       to annex.cmd from the Dialer.  The Dialer will NOT allow for the   */
/*       input of a phone number, login or password from the keyboard.      */
/*            - - - - - - - - - - - - - - - - - - - - - - - - -             */
/*                                                                          */
/* When the script runs, it is automatically passed the interface name for  */
/* the interface it is running on as the first argument, followed by the    */
/* user arguments.                                                          */
/*                                                                          */
/* The script sends the dial string to the modem and then logs into the     */
/* terminal server using the username/password.  It then issues the SLIP    */
/* command to start SLIP, and parses the resulting output to determine the  */
/* appropriate addresses to use.  Lastly, it issues ifconfig and route      */
/* commands to configure the OS/2 system appropriately.  Note that the      */
/* configuration assumes a class C netmask for the SLIP interface.          */
/*                                                                          */
/*--------------------------------------------------------------------------*/

parse arg interface , dialcmd username password

/*--------------------------------------------------------------------------*/
/*                   Initialization and Main Script Code                    */
/*--------------------------------------------------------------------------*/

/* Set some definitions for easier COM strings */
cr='0d'x
crlf='0d0a'x

say ''
say 'ANNEX - SLIP ANNEX Cybergate Example Connection Script ',
    '(interface' interface')'

/* Prompt for missing information */
if dialcmd = '' then do
   call charout , 'Dial Command: '
   parse pull dialcmd
end
if username = '' | username = '*' then do
   call charout , 'User Name: '
   parse pull username
end
else do
   say 'User:' username
end
if password = '' | password = '*' then do
   call charout , 'Password: '
   password = readpass()
end

/* Flush any stuff left over from previous COM activity */
call flush_receive

/* Reset the modem here */
/* You may need to customize this for your modem make and model */
call lineout , 'Reset modem...'
call send 'AT&F' || cr
call waitfor 'OK', 5 ; call flush_receive 'echo'
 if RC = 1 then do
    call lineout , 'Modem not resetting... Trying again'
    call send '+++'
    call waitfor 'OK'
    call send 'ATHZ' || cr
    call waitfor 'OK', 3
  end

/* Dial the remote server */
call charout , 'Now Dialing...'

/* Wait for connection */
call send dialcmd || cr
call waitfor 'CONNECT' ; call waitfor crlf

/* Handle login.  We wait for standard strings, and then flush anything */
/* else to take care of trailing spaces, etc..                          */
/* call send cr */
call waitfor 'CyberGate>' ; call flush_receive 'echo'
call send 'SLIP' || cr
call waitfor 'Username:' ; call flush_receive 'echo'
call send username || cr
call waitfor 'Password:' ; call flush_receive 'echo'
call send password || cr

/* Parse the results of the SLIP command to determine our address. */
/* We use the "waitfor_buffer" variable from the waitfor routine   */
/* to parse the stuff we get from the Annex after waiting for an   */
/* appropriate point in the data stream.                           */
call waitfor 'Your address is' 
parse var waitfor_buffer . 'Annex address is' a '.' b '.' c '.' d '.' .
annex_address = a||'.'||b||'.'||c||'.'||d

call waitfor crlf 
parse var waitfor_buffer  a '.' b '.' c '.' d '.' .
os2_address = a||'.'||b||'.'||c||'.'||d

/* Flush anything else */
call flush_receive 'echo'

/* Now configure this host for the appropriate address, */
/* and for a default route through the Annex.           */

say 'SLIP Connection Established'
say 'Configuring local address =' os2_address ', Annex =' annex_address

'ifconfig sl0' os2_address annex_address 'netmask 255.255.255.0'
'route add default' annex_address '1'

/* All done */
exit 0


/*--------------------------------------------------------------------------*/
/*                            send ( sendstring)                            */
/*..........................................................................*/
/*                                                                          */
/* Routine to send a character string off to the modem.                     */
/*                                                                          */
/*--------------------------------------------------------------------------*/

send:

   parse arg sendstring
   call slip_com_output interface , sendstring

   return


/*--------------------------------------------------------------------------*/
/*                    waitfor ( waitstring , [timeout] )                    */
/*..........................................................................*/
/*                                                                          */
/* Waits for the supplied string to show up in the COM input.  All input    */
/* from the time this function is called until the string shows up in the   */
/* input is accumulated in the "waitfor_buffer" variable.                   */
/*                                                                          */
/* If timeout is specified, it says how long to wait if data stops showing  */
/* up on the COM port (in seconds).                                                         */
/*                                                                          */
/*--------------------------------------------------------------------------*/

waitfor:

   parse arg waitstring , timeout

   if timeout = '' then
     timeout = 5000    /* L O N G   delay if not specified */
   waitfor_buffer = '' ; done = -1; curpos = 1
   ORI_TIME=TIME('E')

   if (remain_buffer = 'REMAIN_BUFFER') then do
      remain_buffer = ''
   end

   do while (done = -1)
      if (remain_buffer \= '') then do
         line = remain_buffer
         remain_buffer = ''
       end
       else do
         line = slip_com_input(interface,,10)
      end
      waitfor_buffer = waitfor_buffer || line
      index = pos(waitstring,waitfor_buffer)
      if (index > 0) then do
         remain_buffer = substr(waitfor_buffer,index+length(waitstring))
         waitfor_buffer = delstr(waitfor_buffer,index+length(waitstring))
         done = 0
      end
      call charout , substr(waitfor_buffer,curpos)
      curpos = length(waitfor_buffer)+1
      if ((done \= 0) & (TIME('E')>timeout)) then do
        call lineout , ' WAITFOR: timed out '
        done = 1
       end
   end
   timeout=0
   RC=done
 return RC



/*--------------------------------------------------------------------------*/
/*                               readpass ()                                */
/*..........................................................................*/
/*                                                                          */
/* Routine used to read a password from the user without echoing the        */
/* password to the screen.                                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

readpass:

  answer = ''
  do until key = cr
    key = slip_getch()
    if key \= cr then do
      answer = answer || key
    end
  end
  say ''
  return answer


/*--------------------------------------------------------------------------*/
/*                             flush_receive ()                             */
/*..........................................................................*/
/*                                                                          */
/* Routine to flush any pending characters to be read from the COM port.    */
/* Reads everything it can until nothing new shows up for 100ms, at which   */
/* point it returns.                                                        */
/*                                                                          */
/* The optional echo argument, if 1, says to echo flushed information.      */
/*                                                                          */
/*--------------------------------------------------------------------------*/

flush_receive:

   parse arg echo

   /* If echoing the flush - take care of waitfor remaining buffer */
   if (echo \= '') & (length(remain_buffer) > 0) then do
      call charout , remain_buffer
      remain_buffer = ''
   end

   /* Eat anything left in the modem or COM buffers */
   /* Stop when nothing new appears for 100ms.      */

   do until line = ''
     line = slip_com_input(interface,,100)
     if echo \= '' then
        call charout , line
   end

   return
