/**************************************************************************/
/* REXX Procedure to remove the annoying dot from the UK version of       */
/* OS/2 Warp. As I'd suspected earlier, the dot has nothing to do         */
/* with OS2LOGO (which can only be changed via a utility on Devcon 6)     */
/* The annoying dot is in fact in OS2LDR.MSG and consitutes the tail end  */
/* of a copyright message that does not apply in the UK                   */
/* The script edits OS2LDR.MSG at offset 4181 decimal changing            */
/*the dot (2E) to a space (20).. If you want to be smart you can just use */
/*PATCH instead... Enjoy! That dot was driving me nuts!                   */
/* This shouldn't affect anything except the dot, but in any case I am    */
/* not liable, there is no warranty caveat wotsit etc etc                 */
/**************************************************************************/
call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs
Call SysCls
/* define variable even if you don't need to under REXX */
Continue=0
if SysOS2Ver()<>'2.30' then /* Warp doesnt return as 3.0 !*/
do
    say 'This does not seem to be OS/2 Warp 3.0'
    say 'Are you *sure* you wish to apply this patch? Y/N?'
    parse pull Response
    If Response<>'Y' then exit
end
Say 'Found OS/2 Warp Version 3.0'
LocalDrives=SysDriveMap(,LOCAL)
FoundOS2LDR=0
DO LoopCounter=1 to WORDS(LocalDrives)
NextLDR=WORD(LocalDrives,LoopCounter)'\OS2LDR.MSG'
rc=SysFileTree(NextLDR,'Results','F','*****','**---')
 if Results.0=1 then
    DO
      FoundOS2LDR=LoopCounter
      LoopCounter=WORDS(LocalDrives)
    END
end
if FoundOS2LDR=0 then
DO
   SAY "I couldn't find OS2LDR.MSG for some strange reason"
   SAY  'no idea what to do. quitting'
    EXIT
END
else
    SAY 'OS2LDR.MSG found on Drive' WORD(LocalDrives,FoundOS2LDR)
    SAY 'Read Only, System and Hidden attributes removed'
rc= CHAROUT(NextLDR,' ',4181)
if rc=0 then
DO
say 'Dot Exterminated'
Src=CHAROUT(NextLDR)
rc=SysFileTree(NextLDR,'Results','F','*****','+*+++')
say 'Read Only, Hidden & System attributes restored for OS2LDR.MSG'
say 'Reboot to see no dot :-)'
say ''
Say 'Compliments of:'
say ''
say '..Peter Kay, OS/2 Programmer, OS/2 Power Editor...........'
say '. e-mail: P.J.KAY@ITI.SALFORD.AC.UK                      .'
say '..........................................................'
END
else
say 'Unknown error - try running this program again'

